$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
        });
        driver.defineSteps([]);
        driver.start();
    });
});

$(document).ready(async function () {
    $("#btnConsultar").on("click", async function () {
        await buscarDados();
    });

    async function buscarDados() {
        try {
            $.LoadingOverlay("show");

            const objetoPesquisa = {
                tabela: "WHATSAPP",
                camposSelect: ["ID", "TELEFONE", "ID_SESSAO", "DT_ENVIO", "ENVIADO", "DT_CADASTRO", "TELA", "USUARIO", "CAMPO_CHAVE", "TIPO_ARQ", "NOME_ARQIMG"],
                where: [`1=1`],
                orderBy: ['ID DESC'],
            };

            const response = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON=${JSON.stringify(objetoPesquisa)}`,
                null
            );
            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            }

            if ($.fn.DataTable.isDataTable('#tabelaMensagens')) {
                $('#tabelaMensagens').DataTable().destroy();
                $('#tabelaMensagens').empty();
            };

            $("#tabelaMensagens").DataTable({
                destroy: true,
                search: false,
                searching: false,
                serverside: false,
                paging: true,
                lengthChange: false,
                order: true,
                autoWidth: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },

                autoWidth: true,
                data: jsonStr.RESULT[0],
                columns: [
                    {
                        data: "ID",
                    },
                    {
                        data: "TELEFONE",
                    },
                    {
                        data: "ID_SESSAO",
                    },
                    {
                        data: "DT_ENVIO",
                    },
                    {
                        data: "DT_CADASTRO",
                    },
                    {
                        data: "ENVIADO",
                    },
                    {
                        data: "TELA",
                    },
                    {
                        data: "USUARIO",
                    },
                    {
                        data: "CAMPO_CHAVE",
                    },
                    {
                        data: "TIPO_ARQ",
                    },
                    {
                        data: "NOME_ARQIMG",
                    },
                ],
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            if ((data != '') && (data != null) && (data != undefined)) {
                                return new Intl.DateTimeFormat("pt-BR").format(
                                    new Date(`${data.split(" ")[0]} 23:59:59`)
                                );
                            } else {
                                return ''
                            }
                        },
                        targets: [3, 4]
                    },
                    {
                        targets: [5], render: function (data, type, row) {
                          if (data == 'E') {
                            return 'Erro'
                          } else if (data == 'N') {
                            return 'Não Enviado'
                          } else if (data == 'S') {
                            return 'Enviado'
                          } else {
                            return data
                          }
                        }
                      },
                ]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    };

    buscarDados();
});
