$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relatorioTitulosRecebidos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioTitulosRecebidos: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioTitulosRecebidos: novasColunas }))

      $('#tabelaRelTitulos').DataTable().columns().visible(true);
      $('#tabelaRelTitulos').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divTabelaVendas',
        popover: {
          title: 'Tabela Títulos Recebidos',
          description: 'Aqui, após clicar em consultar ficam os dados das duplicatas filtradas.',
          position: 'bottom'
        }
      },
      {
        element: '#buttonColVis',
        popover: {
          title: 'Configurar colunas visíveis ',
          description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
          position: 'right'
        }
      },
      {
        element: '#buttonExcel',
        popover: {
          title: 'Botão Exportar',
          description: 'Clique aqui para exportar a tabela em CSV.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  preencheOrdenacaoTela('TitulosRecebidos');

  componenteFiltro('classe', true);
  componenteFiltro('banco', true);
  componenteFiltro('situacao', true);
  componenteFiltro('historico', true);
  componenteFiltro('conta', true);

  $('#txtClienteConsulta').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtRepresentanteConsulta').autocompleta(3, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where":["ativo = 'S'"]}`);
  $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao"], "where": null}`);
  $('#txtCaixa').autocompleta(1, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
  $('#txtMoedaConsulta').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $('#btn-ClienteConsulta').pesquisa_serverside(['#txtClienteConsulta'], ['CODCLI'], ['NOME'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
  $('#btn-RepresentanteConsulta').pesquisa_array(['#txtRepresentanteConsulta'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"], "where": ["ativo = 'S'"]}`, 'Pesquisa Representante', 'represen');
  $('#btnMoeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao"]}', 'Pesquisa Moeda', 'MOEDA');
  $('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}', 'Pesquisa Tabela', 'CAIXA_LOJA');
  $("#btn-MoedaConsulta").pesquisa('#txtMoedaConsulta', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"]}`, 'Pesquisa Moeda', 'MOEDA');

  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });

  $('#btn-limpa-Caixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#btn-limpa-ClienteConsulta').on('click', function () {
    $('#txtClienteConsulta').val('');
  });
  $('#btn-limpa-Moeda').on('click', function () {
    $('#divNSU').addClass('d-none');
    $('#txtMoeda').val('');
  });
  $('#btn-limpa-RepresentanteConsulta').on('click', function () {
    $('#txtRepresentanteConsulta').val('');
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btn-limpa-MoedaConsulta').on('click', async function () {
    $('#txtMoedaConsulta').val('');
  });

  if (await apenasClientesVinculadosAoRepresentante()) {
    bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentanteConsulta', '#btn-RepresentanteConsulta', '#btn-limpa-RepresentanteConsulta');
  }

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtNumero').val('');
    $('#txtClienteConsulta').val('');
    if (!$('#txtRepresentanteConsulta').attr('disabled')) {
      $("#txtRepresentanteConsulta").val("");
    }
    $('#txtDataEmiI').val('1200-01-01');
    $('#txtDataEmiF').val('2500-12-31');
    $('#txtVenctoI').val('1200-01-01');
    $('#txtVenctoF').val('2500-12-31');
    $('#txtPagtoI').val('1200-01-01');
    $('#txtPagtoF').val('2500-12-31');
    $('#Status').val('');
    $('#txtMoedaConsulta').val('');
    $('#txtClasse').empty().trigger('change');
    $('#txtBanco').empty().trigger('change');
    $('#txtSituacao').empty().trigger('change');
    $('#txtHistorico').empty().trigger('change');
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const sClasse = await formataListas($('#txtClasse').val().toString());
    const sBanco = await formataListas($('#txtBanco').val().toString());
    const sSituacao = await formataListas($('#txtSituacao').val().toString());
    const sHistorico = await formataListas($('#txtHistorico').val().toString());
    const sConta = await formataListas($('#txtConta').val().toString());
    const sNumero = $('#txtNumero').val();
    const sDataEmiI = $('#txtDataEmiI').val();
    const sDataEmiF = $('#txtDataEmiF').val();
    const sDataVenctoI = $('#txtVenctoI').val();
    const sDataVenctoF = $('#txtVenctoF').val();
    const sDataPagtoI = $('#txtPagtoI').val();
    const sDataPagtoF = $('#txtPagtoF').val();
    const sCliente = pegaChave('#txtClienteConsulta');
    const sRepresentante = pegaChave('#txtRepresentanteConsulta');
    const sEmp = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const sMoeda = pegaChave('#txtMoedaConsulta');
    const sStatus = $('#Status').val();
    const retorno = `NUMERO=${sNumero}` +
      `&DTPAGTOI=${sDataPagtoI}` +
      `&DTPAGTOF=${sDataPagtoF}` +
      `&DTEMISSAOI=${sDataEmiI}` +
      `&DTEMISSAOF=${sDataEmiF}` +
      `&DTVENCIMENTOI=${sDataVenctoI}` +
      `&DTVENCIMENTOF=${sDataVenctoF}` +
      `&STATUS=${sStatus}` +
      `&CLIENTE=${sCliente}` +
      `&MOEDA=${sMoeda}` +
      `&REPRESENTANTE=${sRepresentante}` +
      `&CLASSE=${sClasse}` +
      `&BANCO=${sBanco}` +
      `&SITUACAO=${sSituacao}` +
      `&HISTORICO=${sHistorico}` +
      `&CONTA=${sConta}` +
      `&EMPRESAS_FILTRO=${sEmp}`;
    return retorno;
  }

  retornaHintRelatorio('btnImprimir', 'reltitulosrecebidos')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/reltitulosrecebidos?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=TitulosRecebidos&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('TitulosRecebidos');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'TitulosRecebidos');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($("#txtOrdem option").toArray().length > 0) {
        retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
      }
      try {
        let dataSetCols = [];

        const url = '/sisplan/impressao/v1/consultareltitulosrecebidos?';
        const filtros = await retornaFiltros();
        const response = await requisicao('GET', url, filtros, null, 6000000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          $('#txtDataEmiI').val('1200-01-01');
          $('#txtDataEmiF').val('2500-12-31');
          $('#txtVenctoI').val('1200-01-01');
          $('#txtVenctoF').val('2500-12-31');
          $('#txtPagtoI').val('1200-01-01');
          $('#txtPagtoF').val('2500-12-31');
          $('#txtClienteConsulta').val('');
          $('#txtRepresentanteConsulta').val('');
          $('#Status').val('');
          $('#txtMoedaConsulta').val('');
          $('#txtClasse').empty().trigger('change');
          $('#txtBanco').empty().trigger('change');
          $('#txtSituacao').empty().trigger('change');
          $('#txtHistorico').empty().trigger('change');
          $(`#tabelaRelTitulos`).DataTable().clear().draw(false);
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaRelTitulos').DataTable({
          destroy: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "colReorder": true,
          "data": jsonStr,
          "columns": dataSetCols,
          columnDefs: [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              "targets": [3, 4, 18, 19, 20, 21, 23, 24, 25, 29],
              "className": 'pr-4 text-right'
            },
            {
              "targets": [22],
              "className": 'pr-4 text-right'
            },
            {
              targets: colunas.relatorioTitulosRecebidos ?? [],
              visible: false,
            },
          ],
        });
        $($('#tabelaRelTitulos').find('th')[10]).prop('title', '(Quantidade Vendida / Sell In)  * 100');

        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaRelTitulos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelTitulos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
        $('#buttonExcel').prop('title', 'Exportar');

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultareltitulosrecebidos?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Títulos Recebidos', '#tabelaRelTitulos');
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelTitulos').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relatorioTitulosRecebidos).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelTitulos').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relatorioTitulosRecebidos ?? [])
  })
});