$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para Imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#buttonColVis',
        popover: {
          title: 'Configurar colunas visíveis ',
          description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
          position: 'right'
        }
      },
      {
        element: '#buttonExcel',
        popover: {
          title: 'Botão Exportar',
          description: 'Clique aqui para exportar a tabela em CSV.',
          position: 'right'
        }
      },
      ]);
      driver.start();
    });
  });

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relatorioMoeda == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioMoeda: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioMoeda: novasColunas }))

      $('#tabelaRelMoeda').DataTable().columns().visible(true);
      $('#tabelaRelMoeda').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  const empId = getCookie('emp_id');

  preencheOrdenacaoTela('RelMoeda');

  limparFiltros();

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show')
  });

  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtCaixaECF').autocompleta(1, `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CAIXA CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}', 'Pesquisa de Cliente');
  $('#btnVendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Vendedor', 'represen');
  // $('#btnVendedor').pesquisa_serverside(['#txtVendedor'], ['CODREP'], ['NOME'], '{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where" : ["ativo = 'S'"]}', 'Pesquisa de Vendedor');
  $('#btnCaixaECF').pesquisa('#txtCaixaECF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":["CODIGO", "DESCRICAO"]}`, 'Pesquisa Caixa', 'CAIXA_LOJA');
  $('#btnMoeda').pesquisa('#txtMoeda', 'MOEDA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE MOEDA", "DESCRICAO"]}`, 'Pesquisa Moeda', 'MOEDA');

  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimpaVendedor').on('click', function () {
    $('#txtVendedor').val('');
  });

  $('#btnLimpaCaixaECF').on('click', function () {
    $('#txtCaixaECF').val('');
  });

  $('#btnLimpaMoeda').on('click', function () {
    $('#txtMoeda').val('');
  });

  retornaHintRelatorio('btnImprimir', 'RelMoeda')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelmoeda?`;
        const filtros = await preencheFiltros();
        const ordem = `&TELA_ORDENACAO=RelMoeda&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelMoeda');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelMoeda');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', function () {
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
    if ($.fn.DataTable.isDataTable("#tabelaRelMoeda")) {
      if ($('#tabelaRelMoeda').DataTable().rows().count() > 0) {
        $("#tabelaRelMoeda").DataTable().destroy();
        $("#tabelaRelMoeda").empty();
      }
    }
    consultaMoeda();
  });

  async function preencheFiltros() {
    const sEmissaoDe = $('#dtEmissaoDe').val();
    const sEmissaoAte = $('#dtEmissaoAte').val();
    const sCliente = pegaChave('#txtCliente');
    const sVendedor = pegaChave('#txtVendedor');
    const sCaixaECF = pegaChave('#txtCaixaECF');
    const sMoeda = pegaChave('#txtMoeda');
    const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    if ($('#radioTodosOP').prop('checked')) {
      sRadioOP = 0;
    }
    if ($('#radioSimOP').prop('checked')) {
      sRadioOP = 1;
    }
    if ($('#radioNaoOP').prop('checked')) {
      sRadioOP = 2;
    }

    if ($('#radioTodosNFCE').prop('checked')) {
      sRadioNFCE = 0;
    }

    if ($('#radioSimNFCE').prop('checked')) {
      sRadioNFCE = 1;
    }

    if ($('#radioNaoNFCE').prop('checked')) {
      sRadioNFCE = 2;
    }
    const retorno =
      `CLIENTE=${sCliente}` +
      `&VENDEDOR=${sVendedor}` +
      `&CAIXAECF=${sCaixaECF}` +
      `&EMISSAODE=${sEmissaoDe}` +
      `&EMISSAOATE=${sEmissaoAte}` +
      `&EMP_IDS=${listaEmpIds}` +
      `&RADIOOP=${sRadioOP}` +
      `&RADIONFCE=${sRadioNFCE}` +
      `&MOEDA=${sMoeda}`;

    return retorno;
  }

  async function consultaMoeda(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      try {
        dataSetCols = [];
        const url = `/sisplan/impressao/v1/consultarelmoeda?`
        const Filtros = await preencheFiltros();
        const response = await requisicao("GET", url, Filtros, '', 30000);


        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta("Nenhum registro encontrado!");
          $("#txtMeta").val();
          if ($.fn.DataTable.isDataTable('#tabelaRelMoeda')) {
            $('#tabelaRelMoeda').DataTable().destroy();
            $('#tabelaRelMoeda').empty();
          }
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
          dataSetCols.push({
            title: k,
            data: k,
          });
        });

        let indiceValor;

        for (let i = 0; i < keys.length; i++) {
          if (keys[i] == 'VALOR') {
            indiceValor = i;
          }
        }

        $("#tabelaRelMoeda").DataTable({
          destroy: true,
          filter: false,
          info: true,
          sort: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          "colReorder": true,
          data: jsonStr,
          columns: dataSetCols,
          "columnDefs": [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-br', {
                  style: 'currency',
                  currency: 'BRL'
                });
              },
              "targets": +indiceValor,
              "className": 'pr-4 text-right'
            },
            {
              render(data) {
                return parseFloat(data).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              targets: [3, 4, 5, 6, 7, 8, 9, 12, 15],
              "className": 'pr-4 text-right'
            },
            {
              targets: [13],
              "className": 'pr-4 text-right'
            },
            {
              targets: colunas.relatorioMoeda ?? [],
              visible: false,
            },
          ],
        });

        $.LoadingOverlay("hide");
        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaRelMoeda_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelMoeda_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = `/sisplan/impressao/v1/consultarelmoeda?`
          const filtros = await preencheFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Moeda', '#tabelaRelMoeda');
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelMoeda').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relatorioMoeda).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelMoeda').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relatorioMoeda ?? [])
  })
});