$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relFaturamento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relFaturamento: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relFaturamento: novasColunas }))

      $('#tabelaRelFaturamento').DataTable().columns().visible(true);
      $('#tabelaRelFaturamento').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  addTutorial();
  preencheOrdenacaoTela('RelFaturamento');
  addPesquisaAutocompleta();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    limpaFiltros();
  });

  retornaHintRelatorio('btnImprimir', 'RelFaturamento')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relfaturamento?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelFaturamento&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelFaturamento');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelFaturamento');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1], true)
    }
    try {
      let dataSetCols = [];
      const url = '/sisplan/impressao/v1/consultarelfaturamento?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        limpaFiltros();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      criaDataTablePadrao('#tabelaRelFaturamento', true, true, true, true, true, false, false, jsonStr, dataSetCols, [], [], [], [4], '', 2, 'buttonColVis', 'buttonExcel', true, [], [11]);

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelfaturamento?';
        const filtros = await retornaFiltros();

        await exportaCSV(url, filtros, false, null, 'Relatório de Faturamento', '#tabelaRelFaturamento');
      });


      $('#tabelaRelFaturamento').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relFaturamento).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      // $('#tabelaRelFaturamento').DataTable().columns(colunas.relFaturamento ?? []).visible(false);
      // adicionaColunas(dataSetCols, colunas.relFaturamento ?? [])

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelFaturamento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relFaturamento ?? [])
  })

  function limpaFiltros() {
    $('#dtEmissaoDe').val('');
    $('#dtEmissaoAte').val('');
    $('#dtSaidaDe').val('');
    $('#dtSaidaAte').val('');
    $('#txtCliente').val('');
    $('#txtPedido').val('');
    $('#txtRepresentante').val('');
    $('#txtNatureza').val('');
    $('#selectNotas').val('').change();
    $('#selectDuplicatas').val('').change();
  }

  async function retornaFiltros() {
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    const retorno =
      `EMISSAODE=${$('#dtEmissaoDe').val()}` +
      `&EMISSAOATE=${$('#dtEmissaoAte').val()}` +
      `&SAIDADE=${$('#dtSaidaDe').val()}` +
      `&SAIDAATE=${$('#dtSaidaAte').val()}` +
      `&CODCLI=${await formataListas($('#txtCliente').val().toString())}` +
      `&PEDIDO=${await formataListas($('#txtPedido').val().toString())}` +
      `&CODIGO=${await formataListas($('#txtProduto').val().toString())}` +
      `&CODREP=${await formataListas($('#txtRepresentante').val().toString())}` +
      `&NATUREZA=${await formataListas($('#txtNatureza').val().toString())}` +
      `&IMPRESSO=${$('#selectNotas').val()}` +
      `&CODFUN=${await formataListas($('#txtFuncionario').val().toString())}` +
      `&OPERACAO=${await formataListas($('#txtOperacao').val().toString())}` +
      `&DUPLICATAS=${$('#selectDuplicatas').val()}` +
      `&ETIQUETA=${etiqueta}` +
      `&EMPRESAS=${empresas}`
    return retorno;
  }

  function addTutorial() {
    $('#tutorial').on('click', function () {
      $(document).ready(async function () {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false
        });
        driver.defineSteps([{
          element: '#btnFiltros',
          popover: {
            title: 'Botão Filtros',
            description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
            position: 'right'
          }
        },
        {
          element: '#btnImprimir',
          popover: {
            title: 'Botão Imprimir',
            description: 'Clique aqui para imprimir um relatório.',
            position: 'right'
          }
        },
        {
          element: '#tabelaRelFaturamento',
          popover: {
            title: 'Tabela Notas',
            description: 'Aqui, após clicar em consultar ficam os dados das notas filtradas.',
            position: 'bottom'
          }
        }
        ]);
        driver.start();
      });
    });
  }

  function addPesquisaAutocompleta() {
    componenteFiltro('cliente', true, true);
    componenteFiltro('pedido', true, true);
    componenteFiltro('representante', true, true);
    componenteFiltro('funcionario', true, true);
    componenteFiltro('produto', true, true);
    componenteFiltro('etiqueta', true, true);
    componenteFiltro('natureza', true, true);
    componenteFiltro('operacao', true, true);
  }
});