$(document).ready(async function () {


    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relEstoqueMat == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueMat: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoqueMat: novasColunas }))

            $('#tabelaEstoqueB2B').DataTable().columns().visible(true);
            // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

            $('#tabelaEstoqueB2B').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })


    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para imprimir um relatório.',
                    position: 'right'
                }
            }
            ]);
            driver.start();
        });
    });


    await preencheOrdenacaoTela('RelEstoqueMatB2B');

    limparFiltros(true);

    // const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

    // const filtroDeposito = await buscaDepositoEmpresaUsuario();

    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('depositoUsuario', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('colecao', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('unidade', true);


    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#cbMostrarOC').on('click', async function () {
        $('#cbContemEstoque').prop('checked', false)
    })
    $('#cbContemEstoque').on('click', async function () {
        $('#cbMostrarOC').prop('checked', false)
    })

    async function retornaFiltros() {
        const depositosInformados = await formataListas($('#txtDepositoUsuario').val().toString())
        const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));

        const codigo = await formataListas($('#txtMaterial').val().toString());
        const deposito = depositosInformados != '' ? depositosInformados : depositosEmpresaLogada;
        const qualidade = await formataListas($('#txtQualidade').val().toString());
        const grupo = await formataListas($('#txtGrupoMA').val().toString());
        const subgrupo = await formataListas($('#txtSubGrupo').val().toString());
        const cor = await formataListas($('#txtCor').val().toString());
        const unidade = await formataListas($('#txtUnidade').val().toString());
        const colecao = await formataListas($('#txtColecao').val().toString());
        const retorno = `&CODIGO=${codigo}` +
            `&DEPOSITO=${deposito}` +
            `&QUALIDADE=${qualidade}` +
            `&GRUPO=${grupo}` +
            `&SUBGRUPO=${subgrupo}` +
            `&COR=${cor}` +
            `&UNIDADE=${unidade}` +
            `&COLECAO=${colecao}` +
            `&CONTEMESTOQUE=${$('#cbContemEstoque').prop('checked')}` +
            `&MOSTRAOC=${$('#cbMostrarOC').prop('checked')}` +
            `&REGIAO=${pegaChave(await CopiaParametro('PEDIDOB2B', 3))}`;
        return retorno;
    };

    retornaHintRelatorio('btnImprimir', 'RelEstoqueMatB2B')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/estoqueb2b?`;
                const filtros = await retornaFiltros();
                const ordem = `&TELA_ORDENACAO=RelEstoqueMatB2B&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoqueMatB2B');
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'POST', 1000000, false, 'RelEstoqueMatB2B');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnConsultar').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            if ($("#txtOrdem option").toArray().length > 0) {
                retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
            }
            try {
                let dataSetCols = [];
                const url = '/sisplan/impressao/v1/estoqueb2b?'
                const filtros = await retornaFiltros();
                const response = await requisicao('GET', url, filtros, '');

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();


                if (jsonStr.length == 0) {
                    msgAlerta('Nenhum registro encontrado!');
                    if ($.fn.DataTable.isDataTable('#tabelaEstoqueB2B')) {
                        $('#tabelaEstoqueB2B').DataTable().clear().draw(false);
                    }
                    return;
                }

                if (response.status != 200) {
                    console.error(jsonStr.mensagem);
                    return;
                }
                const data = jsonStr.map((result) => {
                    const color = result.RGB.match(/(\d{3})/g).join('-').split('-');
                    return {
                        ...result,
                        RGB: `<div class="corRGB" style="background-color: RGB(${color[0]},${color[1]}, ${color[2]}); width: 60px; height: 25px;"></div>`,
                    }
                })

                let keys = Object.keys(data[0]);

                keys.forEach(k => {
                    dataSetCols.push({
                        'title': k,
                        'data': k
                    });
                });

                if ($.fn.DataTable.isDataTable('#tabelaEstoqueB2B')) {
                    $("#tabelaEstoqueB2B").DataTable().destroy();
                    $("#tabelaEstoqueB2B").empty();
                }

                $('#tabelaEstoqueB2B').DataTable({
                    destroy: true,
                    order: true,
                    language: {
                        sEmptyTable: 'Nenhum registro encontrado',
                        sInfo: '_TOTAL_ registros',
                        sInfoEmpty: ' 0 registros',
                        sInfoFiltered: '(Filtrados de _MAX_ registros)',
                        sInfoPostFix: '',
                        sInfoThousands: '.',
                        sLengthMenu: '_MENU_ resultados',
                        sLoadingRecords: 'Carregando...',
                        sProcessing: 'Processando...',
                        sZeroRecords: 'Nenhum registro encontrado',
                        sSearch: 'Pesquisar',
                        oPaginate: {
                            sNext: 'Próximo',
                            sPrevious: 'Anterior',
                            sFirst: 'Primeiro',
                            sLast: 'Último',
                        },
                        oAria: {
                            sSortAscending: ': Ordenar colunas de forma ascendente',
                            sSortDescending: ': Ordenar colunas de forma descendente',
                        },
                    },
                    autoWidth: true,
                    "colReorder": true,
                    "data": data,
                    "columns": dataSetCols,
                    "columnDefs": [
                        {
                            render: function (data, type, row) {
                                if (row.COM1 > 0) {
                                    return `<span title="Número: ${row.NUMERO_1} - ${row.DT_ENTREGA_1}">${data}</span>`

                                } else {
                                    return data;
                                }
                            },
                            targets: 11,
                        },
                        {
                            render: function (data, type, row) {
                                if (row.COM2 > 0) {
                                    return `<span title="Número: ${row.NUMERO_2} - ${row.DT_ENTREGA_2}">${data}</span>`

                                } else {
                                    return data;
                                }
                            },
                            targets: 12,
                        },
                        {
                            render: function (data, type, row) {
                                if (row.COM3 > 0) {
                                    return `<span title="Número: ${row.NUMERO_3} - ${row.DT_ENTREGA_3}">${data}</span>`

                                } else {
                                    return data;
                                }
                            },
                            targets: 13,
                        }

                    ],

                });
                $('#tabelaEstoqueB2B').DataTable().columns().every(function () {
                    let nomeColuna = this.header().textContent.trim();
                    let colunasOcultas = ['DT_ENTREGA_1', 'DT_ENTREGA_2', 'DT_ENTREGA_3', 'NUMERO_1', 'NUMERO_2', 'NUMERO_3'];
                    if (colunasOcultas.includes(nomeColuna)) {
                        this.visible(false);
                    }
                });

                $('#tabelaEstoqueB2B_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaEstoqueB2B_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });


                $('#tabelaEstoqueB2B td').on('click', async function () {
                    const table = $('#tabelaEstoqueB2B').DataTable();
                    const data = table.row($(this).parents('tr')).data();
                    const columnIndex = table.column(this).index();
                    const columnName = table.row($(this).parents('tr')).init().columns[columnIndex].data;

                    await criaModalInformativos(data, columnName);
                });

                $('#buttonExcel').on('click', async function () {
                    const filtros = await retornaFiltros();
                    const item = 'M';
                    const params = `CODIGO=${filtros.codigo}&DEPOSITO=${filtros.deposito}&COR=${filtros.cor}&COLECAO=${filtros.colecao}&GRUPO=${filtros.grupo}&QUALIDADE=${filtros.qualidade}&TIPOITEM=${item}&CONTEMESTOQUE=${$('#cbContemEstoque').prop('checked')}&SUBGRUPO=${filtros.subGrupo}&UNIDADE=${filtros.unidade}&`;
                    const url = `/sisplan/impressao/v1/estoqueb2b?`;

                    await exportaCSV(url, params, false, null, 'Relatório de Estoque de Material', '#tabelaRelEstoqueMatb2b');
                })

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

                $('#tabelaEstoqueB2B').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.relEstoqueMat).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                )

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
            $('#modal-filtros').modal('hide');
        }
    });

    async function criaModalInformativos(data, nomeColuna) {
        if ($.fn.DataTable.isDataTable('#tabelaInformativo')) {
            $('#tabelaInformativo').empty();
            $('#tabelaInformativo').DataTable().destroy();
        }

        let jsonStr = '';
        const colunasData = [1, 2, 3];
        if ((nomeColuna == 'CARTEIRA') || (nomeColuna === 'CARTEIRA_COMP')) {
            const camposSelect = [
                "PEDIDO.NUMERO",
                "PEDIDO.DT_EMISSAO DATA_EMISSAO",
                "PEDIDO.DT_FATURA DATA_FATURA",
                "PEDIDO.ENTREGA DATA_ENTREGA",
                "PEDIDO.CODCLI",
                "ENTIDADE.NOME CLIENTE",
                "PEDIDO.CODREP",
                "REPRESEN.NOME REPRESENTANTE",
                "PEDIDO.STATUS CODIGO_STATUS",
                "SITPROD.DESCRICAO DESCRICAO_STATUS",
                "PED_ITEN.QTDE_ORIG QUANTIDADE",
                "PED_ITEN.QTDE_ORIG - PED_ITEN.QTDE_F QTDE_EXPEDIDA",
                "PED_ITEN.PRECO VALOR_UNITARIO",
                "(PED_ITEN.PRECO * PED_ITEN.QTDE) VALOR_TOTAL",
            ]

            const depositos = $('table th:contains("EST_")').map(function () {
                const numeroDeposito = $(this).text().match(/(\d+)/)[1];
                return numeroDeposito;
            }).get().join(',');

            const where = [
                `PED_ITEN.CODIGO  = '${data.CODIGO}'`,
                `PED_ITEN.COR  = '${data.COR}'`,
                `PED_ITEN.DEPOSITO  IN (${await formataListas(depositos)})`,
                "PED_ITEN.QTDE > 0"
            ]

            const leftjoin = [{
                tabela: "PED_ITEN",
                condicao: "PEDIDO.NUMERO = PED_ITEN.NUMERO"
            }, {
                tabela: "ENTIDADE",
                condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
            }, {
                tabela: "REPRESEN",
                condicao: "REPRESEN.CODREP = PEDIDO.CODREP"
            }, {
                tabela: "SITPROD",
                condicao: "SITPROD.CODIGO = PEDIDO.STATUS"
            }
            ]

            if (nomeColuna === 'CARTEIRA_COMP') {
                where.push(`PEDIDO.PED_CLI <> ''`)
                camposSelect.push('COMPRA.NUMERO ORDEM_COMPRA ')
                camposSelect.push('COMPRA.DT_ENTREGA ENTREGA_COMPRA')
                leftjoin.push({
                    tabela: "COMPRA",
                    condicao: "COMPRA.NUMERO = PEDIDO.PED_CLI"
                })

                colunasData.push(15)
            }

            const pesquisa = {
                tabela: 'PEDIDO',
                camposSelect,
                leftjoin,
                where
            }

            jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        }
        if ((jsonStr === '') || (jsonStr.length === 0)) {
            return;
        }

        const keys = Object.keys(jsonStr[0]);
        const dataSetCols = [];

        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        };

        $('#tabelaInformativo').DataTable({
            language: {
                sEmptyTable: 'Nenhum registro encontrado',
                sInfo: '_TOTAL_ registros',
                sInfoEmpty: ' 0 registros',
                sInfoFiltered: '(Filtrados de _MAX_ registros)',
                sInfoPostFix: '',
                sInfoThousands: '.',
                sLengthMenu: '_MENU_ resultados',
                sLoadingRecords: 'Carregando...',
                sProcessing: 'Processando...',
                sZeroRecords: 'Nenhum registro encontrado',
                sSearch: 'Pesquisar',
                oPaginate: {
                    sNext: 'Próximo',
                    sPrevious: 'Anterior',
                    sFirst: 'Primeiro',
                    sLast: 'Último',
                },
                oAria: {
                    sSortAscending: ': Ordenar colunas de forma ascendente',
                    sSortDescending: ': Ordenar colunas de forma descendente',
                },
            },
            autoWidth: true,
            "colReorder": true,
            "data": jsonStr,
            "columns": dataSetCols,
            "columnDefs": [
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: colunasData,
                },
            ],
        });

        $('#modal-informativo').modal('show');
    }

    $('#tabelaEstoqueB2B td').on('click', async function () {
        const table = $('#tabelaEstoqueB2B').DataTable();
        const data = table.row($(this).parents('tr')).data();
        const columnIndex = table.column(this).index();
        const columnName = table.row($(this).parents('tr')).init().columns[columnIndex].data;

        await criaModalInformativos(data, columnName);
    });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaEstoqueB2B').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relEstoqueMat ?? [])
    })
});