$(document).ready(async function () {
  addPesquisaAutocompleta();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relClasseGer == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relClasseGer: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relClasseGer: novasColunas }))

      $('#tabelaDados').DataTable().columns().visible(true);

      $('#tabelaDados').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltrosRel',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  let modalAberto = false;
  let listaOrdenacao = [];

  $('#btnFiltrosRel').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimpaFiltros').on('click', function () {
    limpaFiltros();
  });

  $('#btnConsultar').on('click', async function () {
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
    await fazConsulta();
    $('#modal-filtros').modal('hide');

  });

  await preencheOrdenacaoTela('RelClasseGer');

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaDados')) {
      $("#tabelaDados").DataTable().destroy();
      $("#tabelaDados").empty();
    }
    try {
      dataSetCols = [];
      $.LoadingOverlay('show');

      const url = `/sisplan/impressao/v1/relclasseger?`;
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`, '', 360000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtMeta").val();
        if ($.fn.DataTable.isDataTable('#tabelaDados')) {
          $('#tabelaDados').DataTable().destroy();
          $('#tabelaDados').empty();
        }
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        msgAlerta("Nenhum registro encontrado!");
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      $('#tabelaDados').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetCols,
        data: jsonStr,
        columnDefs: [
          {
            targets: 0,
            // searchable: false
          },
          {
            "render": function (data) {
              if (data !== null && data !== undefined && !isNaN(data)) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              } else {
                return '0,00';
              }
            },
            "targets": [12, 13, 14, 20, 21, 23, 24, 25, 27],
            "className": 'pr-4 text-right'
          },
          {
            "targets": [39],
            "className": 'pr-4 text-right'
          }
        ]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaDados_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaDados_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#tabelaDados th').on('click', function () {
        listaOrdenacao = adicionaOrdenacao(
          retornaDataSrcColuna($('#tabelaDados'), $(this)),
          listaOrdenacao
        );
      });

      $('#buttonExcel').on('click', async function () {
        const url = `/sisplan/impressao/v1/relclasseger?`;
        const filtros = await retornaFiltros();
        await exportaCSV(url, filtros + `&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`, false, null, 'Relatório de Classe Gerencial', '#tabelaDados');
      })

      $('#tabelaDados').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relClasseGer).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaDados').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relClasseGer ?? [])
  })

  $('#btnCarregaEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  retornaHintRelatorio('btnImprimir', 'ClasseGerPadrao')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const filtros = await retornaFiltros();
        let url = `/sisplan/impressao/v1/relclasseGer?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
        const ordem = `&TELA_ORDENACAO=RelClasseGer&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelClasseGer');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, "POST", 100000, false, 'relclasseger');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function retornaFiltros() {
    const empresasFiltradas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    const empresasFiltradasFormatadas = await formataListas(empresasFiltradas.toString());
    const status = $('input[name="radioStatus"]:checked').val();
    const filtro = $('input[name="radioFiltro"]:checked').val();
    const statusduplicatas = $('input[name="radioDuplicatas"]:checked').val();
    const ap = $('#cbTipoAp').prop('checked');
    const antecipacao = $('#cbTipoAnte').prop('checked');
    const orcamento = $('#cbTipoOrc').prop('checked');
    const cheque = $('#cbTipoCh').prop('checked');
    const totalpormes = $('#cbTotPorMes').prop('checked');
    const venctoini = $('#dtVencimentoDe').val();
    const venctofim = $('#dtVencimentoAte').val();
    const emiini = $('#dtEmissaoDe').val();
    const emifim = $('#dtEmissaoAte').val();
    const entini = $('#dtEntradaDe').val();
    const entfim = $('#dtEntradaAte').val();
    const pagtoini = $('#dtPagamentoDe').val();
    const pagtofim = $('#dtPagamentoAte').val();
    const compini = $('#dtCompetenciaDe').val();
    const compfim = $('#dtCompetenciaAte').val();
    const digini = $('#dtDigitacaoDe').val();
    const digfim = $('#dtDigitacaoAte').val();
    const contini = $('#dtContabilDe').val();
    const contfim = $('#dtContabilAte').val();
    const histini = pegaChave('#txtHistoricoDe');
    const histfim = pegaChave('#txtHistoricoAte');
    const classegerini = pegaChave('#txtClasseGerDe');
    const classegerfim = pegaChave('#txtClasseGerAte');
    const consfornecedor = $('#cbConsideraFornecedor').prop('checked');
    const conscentrocusto = $('#cbConsideraCCusto').prop('checked');
    const consbanco = $('#cbConsideraBanco').prop('checked');
    const consmoeda = $('#cbConsideraMoeda').prop('checked');
    const conshistorico = $('#cbConsideraHistorico').prop('checked');
    const conssituacao = $('#cbConsideraSituacao').prop('checked');
    const consclasse = $('#cbConsideraClasse').prop('checked');
    const consconta = $('#cbConsideraConta').prop('checked');
    const fornecedor = await formataListas($('#txtFornecedor').val().toString());
    const centrocusto = await formataListas($('#txtCentroCusto').val().toString());
    const banco = await formataListas($('#txtBanco').val().toString());
    const moeda = await formataListas($('#txtMoeda').val().toString());
    const historico = await formataListas($('#txtHistorico').val().toString());
    const situacao = await formataListas($('#txtSituacao').val().toString());
    const classe = await formataListas($('#txtClasse').val().toString());
    const conta = await formataListas($('#txtConta').val().toString());

    const filtros =
      `EMPRESAS_FILTRO=${empresasFiltradasFormatadas}
      &STATUS=${status}
      &FILTRO=${filtro}
      &STATUS_DUPLICATAS=${statusduplicatas}
      &AP=${ap}
      &ANTECIPACAO=${antecipacao}
      &ORCAMENTO=${orcamento}
      &CHEQUE=${cheque}
      &TOTAL_POR_MES=${totalpormes}
      &VENCTO_INI=${venctoini}
      &VENCTO_FIM=${venctofim}
      &EMI_INI=${emiini}
      &EMI_FIM=${emifim}
      &ENT_INI=${entini}
      &ENT_FIM=${entfim}
      &PAGTO_INI=${pagtoini}
      &PAGTO_FIM=${pagtofim}
      &COMP_INI=${compini}
      &COMP_FIM=${compfim}
      &DIG_INI=${digini}
      &DIG_FIM=${digfim}
      &CONT_INI=${contini}
      &CONT_FIM=${contfim}
      &HIST_INI=${histini}
      &HIST_FIM=${histfim}
      &CLASSE_GER_INI=${classegerini}
      &CLASSE_GER_FIM=${classegerfim}
      &CONS_FORNECEDOR=${consfornecedor}
      &CONS_CENTRO_CUSTO=${conscentrocusto}
      &CONS_BANCO=${consbanco}
      &CONS_MOEDA=${consmoeda}
      &CONS_HISTORICO=${conshistorico}
      &CONS_SITUACAO=${conssituacao}
      &CONS_CLASSE=${consclasse}
      &CONS_CONTA=${consconta}
      &FORNECEDOR=${fornecedor}
      &CENTRO_CUSTO=${centrocusto}
      &BANCO=${banco}
      &MOEDA=${moeda}
      &HISTORICO=${historico}
      &SITUACAO=${situacao}
      &CLASSE=${classe}
      &CONTA=${conta}
      &ORDERBY=${listaOrdenacao}`;

    return filtros;
  };

  function limpaFiltros() {
    $('#txtFornecedor').empty().trigger('change');
    $('#txtCentroCusto').empty().trigger('change');
    $('#txtBanco').empty().trigger('change');
    $('#txtMoeda').empty().trigger('change');
    $('#txtHistorico').empty().trigger('change');
    $('#txtSituacao').empty().trigger('change');
    $('#txtClasse').empty().trigger('change');
    $('#txtConta').empty().trigger('change');

    $('#txtHistoricoDe').val('');
    $('#txtHistoricoAte').val('');
    $('#txtClasseGerDe').val('');
    $('#txtClasseGerAte').val('');

    $('#rdStatusTodas').prop('checked', true);
    $('#rdFiltroTodos').prop('checked', true);
    $('#rdDupTodas').prop('checked', true);
    $('#cbTipoAp').prop('checked', false);
    $('#cbTipoAnte').prop('checked', false);
    $('#cbTipoOrc').prop('checked', false);
    $('#cbTipoCh').prop('checked', false);
    $('#cbConsCustoFiltrado').prop('checked', false);
    $('#cbTotPorMes').prop('checked', false);

    $('#dtVencimentoDe').val('1200-01-01');
    $('#dtVencimentoAte').val('2500-12-31');
    $('#dtEmissaoDe').val('1200-01-01');
    $('#dtEmissaoAte').val('2500-12-31');
    $('#dtEntradaDe').val('1200-01-01');
    $('#dtEntradaAte').val('2500-12-31');
    $('#dtPagamentoDe').val('1200-01-01');
    $('#dtPagamentoAte').val('2500-12-31');
    $('#dtCompetenciaDe').val('1200-01-01');
    $('#dtCompetenciaAte').val('2500-12-31');
    $('#dtDigitacaoDe').val('1200-01-01');
    $('#dtDigitacaoAte').val('2500-12-31');
    $('#dtContabilDe').val('1200-01-01');
    $('#dtContabilAte').val('2500-12-31');
  }

  function addPesquisaAutocompleta() {
    $('#txtHistoricoDe').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO CHAVE", "DESCRICAO"], "where": null }`, [], [], []);
    $('#btnHistoricoDe').pesquisa_serverside(["#txtHistoricoDe"], ["HISTORICO"], ["DESCRICAO"], `{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, "Pesquisa Histórico");
    $('#btnLimpaHistoricoDe').on('click', function () { $('#txtHistoricoDe').val(''); });

    $('#txtHistoricoAte').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO CHAVE", "DESCRICAO"], "where": null }`, [], [], []);
    $('#btnHistoricoAte').pesquisa_serverside(["#txtHistoricoAte"], ["HISTORICO"], ["DESCRICAO"], `{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, "Pesquisa Histórico");
    $('#btnLimpaHistoricoAte').on('click', function () { $('#txtHistoricoAte').val(''); });

    $('#txtClasseGerDe').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO CHAVE", "DESCRICAO"], "where": null }`, [], [], []);
    $('#btnClasseGerDe').pesquisa_serverside(["#txtClasseGerDe"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Classe Gerencial");
    $('#btnLimpaClasseGerDe').on('click', function () { $('#txtClasseGerDe').val(''); });

    $('#txtClasseGerAte').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO CHAVE", "DESCRICAO"], "where": null }`, [], [], []);
    $('#btnClasseGerAte').pesquisa_serverside(["#txtClasseGerAte"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Classe Gerencial");
    $('#btnLimpaClasseGerAte').on('click', function () { $('#txtClasseGerAte').val(''); });

    componenteFiltro('fornecedor', true);
    componenteFiltro('centroCusto', true);
    componenteFiltro('banco', true);
    componenteFiltro('moeda', true, false);
    componenteFiltro('historico', true);
    componenteFiltro('situacao', true);
    componenteFiltro('classe', true);
    componenteFiltro('conta', true);
  };

})













































