<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Comparativo Anual</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.252.11.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.252.11.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" href="dist/css/custom.css?versao=3.252.11.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.252.11.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.252.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.252.11.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.252.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.252.11.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.252.11.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.252.11.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.252.11.1">
  <style>
    .form-check {
      margin-left: 8px;
      margin-bottom: 10px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 0.5em 0 0.5rem !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      border-radius: 3px !important;
    }

    #modal-filtros .modal-dialog {
      max-width: none !important;
      max-height: none !important;
      margin: 0 !important;
      height: 100vh !important;
      padding: 0 !important;
    }

    #modal-filtros .modal-dialog {
      max-width: none !important;
      margin: 0 !important;
      height: 100vh !important;
      padding: 0 !important;
    }

    #modal-filtros .modal-content {
      top: 5%;
      left: 5%;
      max-height: none !important;
      max-width: none !important;
      height: 95vh !important;
      width: 90%;
      padding: 0 !important;
    }

    .table.dataTable tbody td,
    th {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <div id="driver-page-overlay" class="d-none"></div>
    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-8 flex">
                <h1 class="m-0 text-dark">Relatório de Análise de Fluxo de Caixa</h1>
                <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                  <i class="fas fa-question-circle"></i></button>
                <button id="show-content" class="show-content" style="margin-left:8px;">
                  <i class="fa fa-comment-dots" class="icone" style="font-size: 16px;"></i>
                  <span class="texto">Informativo</span>
                </button>
              </div>
              <div class="col-sm-4">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="./index">Início</a></li>
                  <li class="breadcrumb-item active">Relatório de Análise de Fluxo de Caixa</li>
                </ol>
              </div>
            </div>
          </div>
          <div class="col-sm-12 mb-3">
            <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
            <button class="btn btn-danger btn-sisp" id="btnImprimir"><span style="color: white!important;" class="fas fa-print"></span> Imprimir</button>
          </div>
          <div class="card-body pt-1">
            <div class="card" id="tourRelatorioMeta">
              <div class="row d-flex justify-content-center" style="margin-top: 20px;">
                <div class="col-11" id="chart">
                  <table id="tabelas" class="table table-sm table-select table-hover" width="100%"></table>
                </div>
              </div>
              <div class="col-sm-12 table-responsive card-body pt-2 pb-2">
                <nav>
                  <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
                    <a class="nav-link abaLink" id="tabContas" data-toggle="tab" href="#divContas" role="tab" aria-controls="divContas" aria-selected="true">Contas</a>
                    <a class="nav-link abaLink active" id="tabAnalise" data-toggle="tab" href="#divAnalise" role="tab" aria-controls="divAnalise" aria-selected="false">Analise</a>
                    <a class="nav-link abaLink" id="tabDetalha" data-toggle="tab" href="#divDetalha" role="tab" aria-controls="divDetalha" aria-selected="false">Detalhamento</a>
                    <a class="nav-link abaLink disabled" id="tabResumo" data-toggle="tab" href="#divResumo" role="tab" aria-controls="divResumo" aria-selected="false">Resumo</a>
                    <a class="nav-link abaLink" id="tabAgrupamento" data-toggle="tab" href="#divAgrupamento" role="tab" aria-controls="divAgrupamento" aria-selected="false">Agrupamento</a>
                  </div>
                </nav>
              </div>
              <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane fade" id="divContas" role="tabpanel" aria-labelledby="tabContas">
                  <div class="card-body">
                    <div class="card">
                      <div class="col-sm-12 table-responsive card-body">

                        <table id="tabelaContas" class="table table-sm table-select table-hover" width="100%"></table>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade show active" id="divAnalise" role="tabpanel" aria-labelledby="tabAnalise">
                  <div class="card-body">
                    <div class="card">
                      <div class="col-sm-12 table-responsive card-body">
                        <table id="tabelaAnalise" class="table table-sm table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                      <div class="flex justify-content-between d-none mt-4" id="totalizadoresAnalise">
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotReceber">Receber</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotReceber" class="form-control">
                          </div>
                        </div>
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotChequeRec">Cheque Rec.</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotChequeRec" class="form-control">
                          </div>
                        </div>
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotPedidos">Pedidos</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotPedidos" class="form-control">
                          </div>
                        </div>
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotPagar">Pagar</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotPagar" class="form-control">
                          </div>
                        </div>
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotChequePag">Cheque pag.</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotChequePag" class="form-control">
                          </div>
                        </div>
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotSaidas">Saídas</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotSaidas" class="form-control">
                          </div>
                        </div>
                        <div style="width: 14% !important">
                          <label data-error="wrong" data-success="right" for="txtTotEntradas">Entradas</label>
                          <div class="input-group">
                            <input type="number" data-selecionado="false" value='0' disabled class="input-default focus form-control maskDecimais" id="txtTotEntradas" class="form-control">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade" id="divDetalha" role="tabpanel" aria-labelledby="tabDetalha">
                  <div class="card-body">
                    <div class="card">
                      <div class="col-sm-12 table-responsive card-body">
                        <table id="tabelaDetalha" class="table table-sm table-select table-hover" width="100%">
                        </table>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade" id="divResumo" role="tabpanel" aria-labelledby="tabResumo">
                  <div class="card-body">
                    <div class="card">
                      <div class="col-sm-12 table-responsive card-body">
                        <div class="row">
                          <div class="col-9" class="ml-4">
                            <fieldset class="form border-Field p-0">
                              <legend class="textoBorda mb-0 pb-0">Resumido por:</legend>
                              <div class="form-row mb-2">
                                <div class="radio-group form-radio icheck-primary ml-2">
                                  <input type="radio" value="0" name="rgResumo" checked id="rdEntidade"><label for="rdEntidade" class="container">Entidade</label>
                                </div>
                                <div class="radio-group form-radio icheck-primary">
                                  <input type="radio" value="1" name="rgResumo" id="rdContaTitulo"><label for="rdContaTitulo" class="container">Conta Título/ Classe Ger.</label>
                                </div>
                                <div class="radio-group form-radio icheck-primary">
                                  <input type="radio" value="2" name="rgResumo" id="rdClasseGer"><label for="rdClasseGer" class="container">Classe Gerencial</label>
                                </div>
                                <div class="radio-group form-radio icheck-primary">
                                  <input type="radio" value="3" name="rgResumo" id="rdDataEntidade"><label for="rdDataEntidade" class="container">Data/ Entidade</label>
                                </div>
                                <div class="radio-group form-radio icheck-primary">
                                  <input type="radio" value="4" name="rgResumo" id="rdLancamento"><label for="rdLancamento" class="container">Lancamento</label>
                                </div>
                                <div class="radio-group form-radio icheck-primary">
                                  <input type="radio" value="5" name="rgResumo" id="rdDocumento"><label for="rdDocumento" class="container">Documento</label>
                                </div>
                                <div class="radio-group form-radio icheck-primary ml-2">
                                  <input type="radio" value="6" name="rgResumo" id="rdEstrutura"><label for="rdEstrutura" class="container">Estrutura/ CLasse Ger.</label>
                                </div>
                              </div>
                            </fieldset>
                          </div>
                          <div class="col-3" class="ml-4">
                            <fieldset class="form border-Field p-0">
                              <legend class="textoBorda mb-0 pb-0">Resumo do Receber/Pagar:</legend>
                              <div class="form-row mb-2">
                                <!-- <div class="radio-group form-radio icheck-primary ml-2">
                                  <input type="radio" value="0" name="rgBusca" id="rdRegistroPosicionado"><label for="rdRegistroPosicionado" class="container">Registro Posicionado</label>
                                </div> -->
                                <div class="radio-group form-radio icheck-primary ml-2">
                                  <input type="radio" value="1" name="rgBusca" checked id="rdTodosPeríodos"><label for="rdTodosPeríodos" class="container">Todos os períodos</label>
                                </div>
                              </div>
                            </fieldset>
                          </div>
                        </div>
                        <table id="tabelaResumo" class="table table-sm table-select table-hover" width="100%">
                        </table>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade" id="divAgrupamento" role="tabpanel" aria-labelledby="tabAgrupamento">
                  <div class="card-body">
                    <div class="card">
                      <div class="col-sm-12 table-responsive card-body">
                        <fieldset class="form border-Field p-0">
                          <legend class="textoBorda mb-0 pb-0">Resumido por:</legend>
                          <div class="form-row mb-2">
                            <div class="radio-group form-radio icheck-primary ml-2">
                              <input type="radio" value="0" name="rgAgrupa" checked id="rdCodigoCliente"><label for="rdCodigoCliente" class="container">Código Cliente/ Fornecedor</label>
                            </div>
                            <div class="radio-group form-radio icheck-primary">
                              <input type="radio" value="1" name="rgAgrupa" id="rdConta"><label for="rdConta" class="container">Conta</label>
                            </div>
                            <div class="radio-group form-radio icheck-primary">
                              <input type="radio" value="2" name="rgAgrupa" id="rdCodigoSituacao"><label for="rdCodigoSituacao" class="container">Código Situação</label>
                            </div>
                            <div class="radio-group form-radio icheck-primary">
                              <input type="radio" value="3" name="rgAgrupa" id="rdBanco"><label for="rdBanco" class="container">Banco</label>
                            </div>
                            <div class="radio-group form-radio icheck-primary">
                              <input type="radio" value="4" name="rgAgrupa" id="rdCodigoRepresentante"><label for="rdCodigoRepresentante" class="container">Código Representante</label>
                            </div>
                          </div>
                        </fieldset>
                        <table id="tabelaAgrupamento" class="table table-sm table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="form-group col-md-10 col-12 col-sm-12 mb-0">
                <fieldset class="form border-Field p-0">
                  <legend class="textoBorda pb-0 mb-0">Opções</legend>
                  <div class="form-row mb-2">
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" type="checkbox" checked id="cbReceber"> <label for="cbReceber">Receber</label>
                    </div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class=" form-check-input mb-0" type="checkbox" checked id="cbPagar"> <label for="cbPagar">Pagar</label>
                    </div>
                    <div class="ml-2" style="border-right: 1px solid var(--font-color)"></div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" type="checkbox" checked id="cbChequesReceber"> <label for="cbChequesReceber">Cheques Receber</label>
                    </div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" type="checkbox" checked id="cbChequesPagar"> <label for="cbChequesPagar">Cheques Pagar</label>
                    </div>
                    <div class="ml-2" style="border-right: 1px solid var(--font-color)"></div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" type="checkbox" checked id="cbComissao"> <label for="cbComissao">Comissões</label>
                    </div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" type="checkbox" checked id="cbCompras"> <label for="cbCompras">Compras</label>
                    </div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" type="checkbox" checked id="cbVendas"> <label for="cbVendas">Vendas</label>
                    </div>
                    <div class="ml-2" style="border-right: 1px solid var(--font-color)"></div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" value='prevRec' name="cbManipulaTabela" type="checkbox" id="cbProvisaoReceber"> <label for="cbProvisaoReceber">Provisão Receber</label>
                    </div>
                    <div class="form-check mb-0 pb-0 icheck-primary">
                      <input class="form-check-input mb-0" value='prevPag' name="cbManipulaTabela" type="checkbox" id="cbProvisaoPagar"> <label for="cbProvisaoPagar">Provisão Pagar</label>
                    </div>
                  </div>
                </fieldset>
              </div>
              <div class="col-md-2 col-12 mt-2 p-1 mb-3 mb-md-0">
                <button class="btn btn-danger btn-sisp w-100" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
              </div>
              <div class="form-group col-md-12 col-12 mb-0 flex">
                <div style="width: 31% !important">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda mb-0 pb-0">Análise</legend>
                    <div class="form-row mb-2">
                      <div class="radio-group form-radio icheck-primary ml-2">
                        <input type="radio" value="0" checked name="analise" id="rdMensal"><label for="rdMensal" class="container">Mensal</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value=" 1" name="analise" id="rdPeriodo"><label for="rdPeriodo" class="container">Período</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="2" name="analise" id="rdDiaria">
                        <label for="rdDiaria" class="container">Diaria</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div style="width: 33% !important" class="ml-4">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda mb-0 pb-0">Ped. Liberado</legend>
                    <div class="form-row mb-2">
                      <div class="radio-group form-radio icheck-primary ml-2">
                        <input type="radio" value="0" name="pedidoLiberado" checked id="rdTodosPed"><label for="rdTodosPed" class="container">Todos</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="1" name="pedidoLiberado" id="rdComercial"><label for="rdComercial" class="container">Comercial</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="2" name="pedidoLiberado" id="rdFinanceiro"><label for="rdFinanceiro" class="container">Financeiro</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="3" name="pedidoLiberado" id="rdAmbos"><label for="rdAmbos" class="container">Ambos</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div style="width: 33% !important" class="ml-4">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda mb-0 pb-0">Status AP</legend>
                    <div class="form-row mb-2">
                      <div class="radio-group form-radio icheck-primary ml-2">
                        <input type="radio" value="0" name="statusAP" checked id="rdTodasAP"><label for="rdTodasAP" class="container">Todas</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="1" name="statusAP" id="rdBloqueada"><label for="rdBloqueada" class="container">Bloqueada</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="2" name="statusAP" id="rdAnalise"><label for="rdAnalise" class="container">Em Analise</label>
                      </div>
                      <div class="radio-group form-radio icheck-primary">
                        <input type="radio" value="3" name="statusAP" id="rdLiberada"><label for="rdLiberada" class="container">Liberada</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
              </div>
              <div class="form-row col-12 pl-3">
                <div class="col-6">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda pb-0 mb-0">Período</legend>
                    <div class="col-md-6 col-12 form-group">
                      <div class="">
                        <label for="">De:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="1200-01-01" max="2500-12-31" class="input-default focus form-control validate" id="dtPeriodoDe" name="PeriodoDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6 col-12 form-group">
                      <div class="">
                        <label for="dtEmifim">Até:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="2500-12-01" max="2500-12-31" class="input-default focus form-control validate" id="dtPeriodoAte" name="PeriodoAte">
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="col-6">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda pb-0 mb-0">Período Comissões</legend>
                    <div class="col-md-6 col-12 form-group">
                      <div class="">
                        <label for="">De:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="1200-01-01" max="2500-12-31" class="input-default focus form-control validate" id="dtPeriodoComissaoDe" name="PediodoComissaoDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6 col-12 form-group">
                      <div class="">
                        <label for="dtEmifim">Até:</label>
                        <div class="relative">
                          <input type="date" max="2500-12-31" value="2500-12-01" max="2500-12-31" class="input-default focus form-control validate" id="dtPeriodoComissaoAte" name="PeriodoComissaoAte">
                        </div>
                      </div>
                    </div>
                  </fieldset>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtSituacao">Situacao:
                  <sub class="mb-3" style="font-size:80%;">(Receber/ Pagar)</sub>
                </label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtSituacao" name="txtSituacao" multiple="multiple">
                  </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSituacao" name="btnSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSituacao" name="btnLimpaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtClasse">Classe:
                  <sub class="mb-3" style="font-size:80%;">(Receber/ Pagar)</sub>
                </label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtClasse" name="txtClasse" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClasse" name="btnClasse" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaClasse" name="btnLimpaClasse" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtStatus">Descons. Status:
                  <sub class="mb-3" style="font-size:80%;">(Status Pedido)</sub>
                </label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtStatus" name="txtStatus" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnStatus" name="btnStatus" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaStatus" name="btnLimpaStatus" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtBanco">Banco Receber:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtBanco" name="txtBanco" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaBanco" name="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtTipoVenda">Tipo Venda:
                </label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtTipoVenda" name="txtTipoVenda" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnTipoVenda" name="btnTipoVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaTipoVenda" name="btnLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtMoeda">Moeda:
                  <sub class="mb-3" style="font-size:80%;">(Receber/ Pagar)</sub>
                </label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtMoeda" name="txtMoeda" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaMoeda" name="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtHistorico">Histórico:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtHistorico" name="txtHistorico" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaHistorico" name="btnLimpaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtConta">Conta: </label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtConta" name="txtConta" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaConta" name="btnLimpaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../modais.php');
  include_once('../../informativo.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.252.11.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.252.11.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.252.11.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.252.11.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.252.11.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.252.11.1"></script>
  <script src="dist/js/sisplan.js?versao=3.252.11.1"></script>
  <script src="utils/funcoes.js?versao=3.252.11.1"></script>
  <script src="utils/cookies.js?versao=3.252.11.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.252.11.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.252.11.1"></script>
  <script src="dist/js/jquery.inputmask.js"></script>
  <script src="dist/js/driver.min.js?versao=3.252.11.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.252.11.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.252.11.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.252.11.1"></script>
  <script type="text/javascript" src="config.js?versao=3.252.11.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.252.11.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELANALISEFLUXO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relanalisefluxo/relanalisefluxo.js?versao=3.252.11.1`;
      insereJavaScriptPagina(sArquivo);


    });
  </script>
</body>

</html>