<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Prospecção</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.252.11.1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.252.11.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.252.11.1" />
    <link href='dist/css/bootstrap.min.css?versao=3.252.11.1'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.252.11.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.252.11.1">
    <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.252.11.1">
    <link rel="stylesheet" type="text/css" href="dist/css/responsive.bootstrap.min.css?versao=3.252.11.1">
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="dist/css/cadastro.css?versao=3.252.11.1">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.252.11.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.252.11.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.252.11.1">
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.252.11.1">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }

        .form-group {
            margin-bottom: 5px;
        }

        .icheck-primary {
            margin-top: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        include_once('../../../menu.php');
        ?>
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 col-md-8 col-lg-6 flex">
                            <h1 class="m-0 text-dark">Prospecção</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6 col-md-4 col-lg-6">
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid" id="tabelaProspeccaoTutorial">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp" id="btnNovaProspeccao"><span class="fas fa-plus"></span> Incluir</button>
                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <h5>Lista de Prospecção</h5>
                            <table id="tabelaProspeccao" class="table table-sm table-select table-hover" style="white-space: nowrap;" width="100%">
                                <thead>
                                    <tr></tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="modal-content" id="modalBody">
                            <div class="modal-header">
                                <h4 class="modal-title">Filtros</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-lg-auto col-md-auto col-auto mt-0">
                                        <fieldset class="form border-Field p-0">
                                            <legend class="textoBorda pb-0 mb-0">Status</legend>
                                            <div class="d-flex">
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdStatusTodos" checked name="rdFiltroStatus" value="0"><label class="labelCheck" for="rdStatusTodos">Todos</label></div>
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdStatusProsp" name="rdFiltroStatus" value="1"><label class="labelCheck" for="rdStatusProsp">Em Prospecção</label></div>
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdStatusSemCont" name="rdFiltroStatus" value="2"><label class="labelCheck" for="rdStatusSemCont">Sem Contato</label></div>
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdStatusSemInt" name="rdFiltroStatus" value="3"><label class="labelCheck" for="rdStatusSemInt">Sem Interesse</label></div>
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdStatusSemOrc" name="rdFiltroStatus" value="4"><label class="labelCheck" for="rdStatusSemOrc">Sem Orçamento</label></div>
                                                <div class="icheck-primary"><input type="radio" id="rdStatusSatisfeito" name="rdFiltroStatus" value="5"><label class="labelCheck" for="rdStatusSatisfeito">Satisfeito</label></div>
                                        </fieldset>
                                    </div>
                                    <div class="col-lg-auto col-md-auto col-auto mt-0">
                                        <fieldset class="form border-Field p-0">
                                            <legend class="textoBorda pb-0 mb-0">Entidade</legend>
                                            <div class="d-flex">
                                                <div class="icheck-primary mr-2"><input type="radio" id="rdEntTodos" checked name="rdFiltroEntidade" value="0"><label class="labelCheck" for="rdEntTodos">Todos</label></div>
                                                <div class="icheck-primary mr-2"><input type="radio" id="rdEntCad" name="rdFiltroEntidade" value="1"><label class="labelCheck" for="rdEntCad">Cadastrado</label></div>
                                                <div class="icheck-primary" style="margin-right: 5px !important;"><input type="radio" id="rdEntSemCad" name="rdFiltroEntidade" value="2"><label class="labelCheck" for="rdEntSemCad">Sem Cadastro</label></div>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-auto col-md-auto col-6">
                                        <fieldset class="form border-Field p-0">
                                            <legend class="textoBorda pb-0 mb-0">Forma Contato</legend>
                                            <div class="form-row justify-content-center">
                                                <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="TODOS" id="cbTodos"><label class="labelCheck" for="cbTodos"> Todos</label></div>
                                                <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="LIGACAO" id="cbLigacao"><label class="labelCheck" for="cbLigacao"> Ligação</label></div>
                                                <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="EMAIL" id="cbEmail"><label class="labelCheck" for="cbEmail"> E-mail</label></div>
                                                <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="VISITA" id="cbVisita"><label class="labelCheck" for="cbVisita"> Visita</label></div>
                                                <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="WHATS" id="cbWhatsapp"><label class="labelCheck" for="cbWhatsapp">WhatsApp</label></div>
                                                <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="OUTROS" id="cbOutros"><label class="labelCheck" for="cbOutros"> Outros</label></div>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-lg-auto col-md-auto col-3 mt-0">
                                        <fieldset class="form border-Field p-0">
                                            <legend class="textoBorda pb-0 mb-0">Tipo Pessoa</legend>
                                            <div class="d-flex">
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdPessoaTodos" checked name="rdFiltroPessoa" value="0"><label class="labelCheck" for="rdPessoaTodos">Todos</label></div>
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdPessoaFisica" name="rdFiltroPessoa" value="1"><label class="labelCheck" for="rdPessoaFisica">Física</label></div>
                                                <div class="icheck-primary"><input type="radio" id="rdPessoaJuridica" name="rdFiltroPessoa" value="2"><label class="labelCheck" for="rdPessoaJuridica">Jurídica</label></div>
                                        </fieldset>
                                    </div>
                                    <div class="col-lg-auto col-md-auto col-auto mt-0 pr-0">
                                        <fieldset class="form border-Field p-0">
                                            <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                                            <div class="d-flex">
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdTipoTodos" checked name="rdFiltroTipo" value="0"><label class="labelCheck" for="rdTipoTodos">Todos</label></div>
                                                <div class="icheck-primary mr-3"><input type="radio" id="rdTipoAtivo" name="rdFiltroTipo" value="1"><label class="labelCheck" for="rdTipoAtivo">Ativo</label></div>
                                                <div class="icheck-primary"><input type="radio" id="rdTipoReceptivo" name="rdFiltroTipo" value="2"><label class="labelCheck" for="rdTipoReceptivo">Receptivo</label></div>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 col-md-auto col-3 d-flex mb-3 mb-lg-0 pl-0">
                                        <div class="col-6">
                                            <label for="txtPosicaoDe">Cadastro de:</label>
                                            <div class="relative">
                                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtCadastroDe" name="CadastroDe">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <label for="txtPosicaoAte">Até:</label>
                                            <div class="relative">
                                                <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtCadastroAte" name="CadastroAte">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-auto col-3 d-flex mb-3 mb-lg-0 pl-0">
                                        <div class="col-6">
                                            <label for="txtPosicaoDe">Retorno de:</label>
                                            <div class="relative">
                                                <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtRetornoDe" name="RetornoDe">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <label for="txtPosicaoAte">Até:</label>
                                            <div class="relative">
                                                <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtRetornoAte" name="RetornoAte">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-auto col-3 d-flex mb-3 mb-lg-0 pl-0">
                                        <div class="group-default form-group col-md-auto col-6 col-lg-6 ">
                                            <label for="">Estado: </label>
                                            <div class="relative">
                                                <select name="" id="txtEstado" value="" class="form-group input-default">
                                                    <option value="" selected></option>
                                                    <option value="AC">AC</option>
                                                    <option value="AL">AL</option>
                                                    <option value="AM">AM</option>
                                                    <option value="AP">AP</option>
                                                    <option value="BA">BA</option>
                                                    <option value="CE">CE</option>
                                                    <option value="DF">DF</option>
                                                    <option value="ES">ES</option>
                                                    <option value="GO">GO</option>
                                                    <option value="MA">MA</option>
                                                    <option value="MG">MG</option>
                                                    <option value="MS">MS</option>
                                                    <option value="MT">MT</option>
                                                    <option value="PA">PA</option>
                                                    <option value="PB">PB</option>
                                                    <option value="PE">PE</option>
                                                    <option value="PI">PI</option>
                                                    <option value="PR">PR</option>
                                                    <option value="RJ">RJ</option>
                                                    <option value="RN">RN</option>
                                                    <option value="RO">RO</option>
                                                    <option value="RR">RR</option>
                                                    <option value="RS">RS</option>
                                                    <option value="SC">SC</option>
                                                    <option value="SE">SE</option>
                                                    <option value="SP">SP</option>
                                                    <option value="TO">TO</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="group-default form-group col-md-auto col-6 col-lg-6">
                                            <label for="">Origem do Lead: </label>
                                            <div class="relative">
                                                <select name="" id="txtOrigem" value="" class="form-group input-default">
                                                    <option value="0" selected></option>
                                                    <option value="1">Redes Sociais</option>
                                                    <option value="2">Indicação</option>
                                                    <option value="3">Prospecção Ativa</option>
                                                    <option value="4">Google</option>
                                                    <option value="5">Formulário</option>
                                                    <option value="6">Eventos</option>
                                                    <option value="7">Outros</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código:</label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtCodigo" name="txtCodigo" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnCodigo" name="btnCodigo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnACodigo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtCliente">Cliente:</label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnACliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtRazaoSocial">Razão Social:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtRazaoSocial" name="txtRazaoSocial" placeholder="Razão Social">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnARazaoSocial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtFantasia">Fantasia:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtFantasia" name="txtFantasia" placeholder="Fantasia">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnAFantasia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtCNPJ">CNPJ/CPF:</label>
                                        <div class="input-group">
                                            <input type="text" placeholder="CPF / CNPJ" class="input-default focus form-control" id="txtCNPJ" name="txtCNPJ">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnACNPJ" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtInscricao">Inscrição:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtInscricao" name="txtInscricao" placeholder="Inscrição">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnAInscricao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtCidade">Cidade:</label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtCidade" name="txtCidade" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnCidade" name="btnCidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnACidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtBairro">Bairro:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtBairro" name="txtBairro" placeholder="Bairro">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnABairro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmail">Email:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtEmail" name="txtEmail" placeholder="Email">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnAEmail" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtUsuario">Usuário:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtUsuario" name="txtUsuario" placeholder="Usuário">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnUsuario" name="btnUsuario" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnAUsuario" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtRepresentante">Representante:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" placeholder="Representante">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnARepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtRamoAtividade">Ramo Atividade:</label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtRamoAtividade" name="txtRamoAtividade" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnRamoAtividade" name="btnRamoAtividade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnARamoAtividade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12 col-12 form-group pr-3">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Observação:</label>
                                        <div class="input-group">
                                            <textarea class="input-default focus form-control create" id="txtObs" name="txtObs" placeholder="Observação" rows="3" cols="50" style="resize: none;"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <div class="row">
                                    <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                                    <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script type="text/javascript" src="config.js?versao=3.252.11.1"></script>
    <script src="plugins/jquery/jquery.min.js?versao=3.252.11.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.252.11.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.252.11.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.252.11.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.252.11.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.252.11.1"></script>
    <script src="dist/js/sisplan.js?versao=3.252.11.1"></script>
    <script src="utils/funcoes.js?versao=3.252.11.1"></script>
    <script src="utils/cookies.js?versao=3.252.11.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.252.11.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.252.11.1"></script>
    <script src="dist/js/driver.min.js?versao=3.252.11.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.252.11.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.252.11.1"></script>
    <script src="dist/js/jquery.mask.min.js?versao=3.252.11.1"></script>
    <script src="dist/js/jquery.maskMoney.min.js?versao=3.252.11.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('PROSPECCAO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/prospeccao/acesso_prospeccao/acesso_prospeccao.js?versao=3.252.11.1`;
            insereJavaScriptPagina(sArquivo);
        });
    </script>
</body>

</html>