$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de um pedido.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir os pedidos filtrados.',
          position: 'right'
        }
      },
      {
        element: '#tabelaPedido',
        popover: {
          title: 'Tabela Pedidos',
          description: 'Aqui estão os dados dos pedidos cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  document.addEventListener('keydown', (event) => {
    const keyName = event.key;
    if (keyName === 'F3') {
      event.preventDefault();
      window.location.href = `${BASE_URI}/pedidosB2B/create`
    } else if (keyName === 'F2') {
      event.preventDefault();
      parent.abrirEmNovaAbaIFrame('Cliente', `${BASE_URI}/cliente`);
    } else if (keyName === 'F6') {
      event.preventDefault();
      parent.abrirEmNovaAbaIFrame('Preços B2B', `${BASE_URI}/precosb2b`);
    } else if (keyName === 'F7') {
      event.preventDefault();
      parent.abrirEmNovaAbaIFrame('Relatório de Estoque B2B', `${BASE_URI}/relestoquematb2b`);
    }
  });

  var options = {
    series: [],
    labels: [],
    chart: {
      type: 'pie',
      sparkline: {
        enabled: true
      }
    },
    stroke: {
      width: 1
    },
    tooltip: {
      fixed: {
        enabled: false
      },
    }
  };

  var optionFaturados = options

  let sCodrepUsuario = await buscaCodrepUsuario();
  const parametrosB2B = await BuscaParametrosPedidoB2B();

  if (sCodrepUsuario == '') {
    msgAlerta('Usuário não pertence a um squad e está sem representante vinculado ao cadastro de usuário!');
    return;
  }

  let sEmpID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)) : [getCookie('emp_id')];

  setarDataAtual('txtDataEmiDe', true);
  setarDataAtual('txtDataFaturaDe', true);
  await consultarDados();

  criaTabelas();
  addPesquisaAutocompleta();

  $('#btnInfoPedCarteira').on('click', async function () {
    window.event.preventDefault();
    await carregaDadosPedidosCarteira();
  });

  $('#btnInfoPedFaturados').on('click', async function () {
    window.event.preventDefault();
    optionFaturados = options
    optionFaturados.labels = []
    optionFaturados.series = []
    await carregaDadosPedidosFaturados();
    await carregaDadosPedidosDevolvidos();

    $('#chartPedidosFaturados').empty();
    // optionGraficoPedidosCarteira.series[0].data = arrDadosGrafico;
    var chart = new ApexCharts(document.querySelector("#chartPedidosFaturados"), optionFaturados);
    chart.render();
  });

  $('#btnInfoPrevComissao').on('click', async function () {
    window.event.preventDefault();
    // await carregaDadosPrevComissao();
  });

  $('#btnInfoMixProdutos').on('click', async function () {
    window.event.preventDefault();
    await carregaDadosMixProdutos();

    $('#modal-mix-produtos').modal('show');
  });

  $('#btnInfoAdmCarteira').on('click', async function () {
    window.event.preventDefault();
    await carregaDadosAdmCarteira();

    $('#modal-adm-carteira').modal('show');
  });

  $('#btnInfoAberturaClientes').on('click', async function () {
    window.event.preventDefault();
    await carregaDadosAberturaClientes();
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnAtendimentoPendente').on('click', async function () {
    $('#modal-atendimentosPendentes').modal('show');
    $('#tabelaAtendimentosPendente').DataTable().rows().remove().draw(false);
    await carregaAtendimentosPendente();
  });

  $('#atalhoClienteTour').on('click', function () {
    parent.abrirEmNovaAbaIFrame('Cliente', `${BASE_URI}/cliente`);
  });
  $('#atalhoPrecoTour').on('click', function () {
    parent.abrirEmNovaAbaIFrame('Preços B2B', `${BASE_URI}/precosb2b`);
  });
  $('#atalhoEstoqueTour').on('click', function () {
    parent.abrirEmNovaAbaIFrame('Relatório de Estoque B2B', `${BASE_URI}/relestoquematb2b`);
  });

  $('#btnPreVenda').on('click', function () {
    if (parent.document.querySelector('body').classList.contains('iframe-mode-fullscreen')) {
      window.location.href = "pedidosb2b/create";
      return;
    } else {
      parent.document.querySelector('#abrirTelaCheia > i').classList.remove('fa-expand');
      parent.document.querySelector('#abrirTelaCheia > i').classList.add('fa-compress');
      parent.document.querySelector('#rodape').setAttribute('style', 'width:100vw; margin-left: 0px !important;');
      window.location.href = "pedidosb2b/create";
      parent.adicionarTelaCheia();
    }
  });


  $('#btnLimparFiltros').on('click', async function () {
    $('#txtPedidoConsulta').val('');
    $('#txtListaPedidos').val('');
    $('#txtClienteConsulta').val('');
    $('#txtRepresentanteConsulta').val('');
    $('#txtTabPrecoConsulta').val('');
    $('#txtColecaoConsulta').val('');
    $('#txtGrupoPedConsulta').val('');
    $('#txtGrupoProdConsulta').val('');
    $('#txtTipoProdConsulta').val('');
    $("#txtDataEmiDe").val("1200-01-01");
    $("#txtDataEntregaDe").val("1200-01-01");
    $("#txtDataFaturaDe").val("1200-01-01");
    $("#txtDataSaidaDe").val("1200-01-01");
    $("#txtDataEmiAte").val("2500-12-01");
    $("#txtDataEntregaAte").val("2500-12-01");
    $("#txtDataFaturaAte").val("2500-12-01");
    $("#txtDataSaidaAte").val("2500-12-01");
    $('#txtBloqFinConsulta').val('');
    $('#txtBloqComConsulta').val('');
    $('#txtSituacaoConsulta').val('');
    $('#txtStatusConsulta').val('');
  });

  $('#txtSituacao').on('focusout', async function () {
    const contaCor = await buscaValor('TABSIT', 'GERA_CONTACOR', 'CODIGO', pegaChave(this));
    $('#cbNaoLancaCc').prop('checked', contaCor.GERA_CONTACOR == 'S');
  });

  $('#tabelaAtendimentosPendente').on('click', '#btn-abrir-pedido', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaAtendimentosPendente').DataTable().row($(this).parents('tr')).data();
      parent.removerTelaCheia();
      parent.adicionarTelaCheia();
      window.location.href = `${BASE_URI}/pedidosb2b/${data.NUMERO_ATENDIMENTO}`;
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $(`#btnConsultar`).on('click', async function () {
    await consultarDados();
  });

  $('#tabelaPedido').on('click', '#btn-enviar-wpp', async function () {
    event.preventDefault();
    $.LoadingOverlay("show");
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const cliente = data.CLIENTE;
      const valor = data.VALOR;

      if (cliente.indexOf('CONSUMIDOR FINAL') >= 0) {
        msgAlerta('Não é possível enviar WhatsApp para Consumidor Final.');
        return;
      }

      const codcli = cliente.substr(0, cliente.indexOf('-') - 1);
      const nome = cliente.split(' - ')[1];
      const numero = await getWhatsapp(codcli);
      if (numero == '') {
        msgAlerta('Número de telefone do cliente inválido, verifique o cadastro.');
        return;
      }
      await enviarPedidoWpp(data.PEDIDO, numero, nome, valor, "<?php echo BASE_URI; ?>", "PEDIDOB2B");
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  await preencheOrdenacaoTela('RelPedidoA')

  $('#tabelaPedido').on('click', '#btn-imprimir-pedido', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/acesso_pedido?`;
      const ordem = `&TELA_ORDENACAO=RelPedidoA&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;

      const filtros = `NUMERO=${data.PEDIDO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function enviarPedidoWpp(sPedido, telefone, nome, valor, sUrl, tela) {
    try {
      const url = `/sisplan/impressao/v1/acesso_pedido?NUMERO=${sPedido}&INDIVIDUAL=S`;
      try {
        if (telefone == '') {
          return;
        }
        const arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RelPedidoA');
        const valorFormatado = new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor);
        const parametrosMensagem = [`PEDIDO: ${sPedido}`, `EMP_ID: ${getCookie("emp_id")}`];
        const objMsgWpp = [{ CELULAR: telefone, PARAMETROSMENSAGEM: parametrosMensagem.toString(), MENSAGEMPERSONALIZADA: "" }];
        let mensagemPersonalizada = await retornaMsgPersonalizadaWpp(tela, objMsgWpp);
        mensagemPersonalizada = decodeEmoticonsMensagem(mensagemPersonalizada, true);
        const mensagem = `$OLA$ *${nome}*! \r\nObrigado por comprar conosco 🙌 Você efetuou uma compra no valor de *${valorFormatado}*\r\nSegue abaixo uma cópia do relatório do pedido *${sPedido}*. \r\nTenha um ótimo dia 😊🎉`;
        const anexosMensagemPersonalizada = await retornaAnexoMsgPersonalizada(tela);
        const anexos = anexosMensagemPersonalizada.map((anexos) => { return anexos.caminhoArquivo });
        if (arquivo != undefined) {
          const enviaArq = await enviarMensagem(telefone, mensagemPersonalizada != "" ? mensagemPersonalizada : mensagem, 'Pedido_WEB', sPedido);
          const enviaMsg = await enviarMensagem(telefone, '', 'Pedido_WEB', sPedido, true, arquivo, anexos);
          
        if (enviaArq && enviaMsg) {
          toastr.success("Mensagem enviada com sucesso!", "Confirmação", {
            toastClass: "success",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.reload()
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
        };
        await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
    }
  }

  function retornaWhereFiltros() {
    const usuarioSisplan = getCookie('cod_usuario') === '0000'
    let where = '';
    where = pegaChave('#txtListaPedidos') != '' ? ` AND PEDIDO.NUMERO IN (${$('#txtListaPedidos').val()})` : '';
    where += pegaChave('#txtClienteConsulta') != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtClienteConsulta')}'` : '';
    where += pegaChave('#txtTabPrecoConsulta') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabPrecoConsulta')}'` : '';
    where += pegaChave('#txtColecaoConsulta') != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecaoConsulta')}'` : '';
    where += pegaChave('#txtStatusConsulta') != '' ? ` AND PEDIDO.STATUS = '${pegaChave('#txtStatusConsulta')}'` : '';
    where += pegaChave('#txtGrupoPedConsulta') != '' ? ` AND PEDIDO.GRUPO = '${pegaChave('#txtGrupoPedConsulta')}'` : '';
    where += pegaChave('#txtGrupoProdConsulta') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtGrupoProdConsulta')}'` : '';
    where += pegaChave('#txtTipoProdConsulta') != '' ? ` AND PRODUTO.TIPO = '${pegaChave('#txtTipoProdConsulta')}'` : '';
    where += pegaChave('#txtBloqComConsulta') != '' ? ` AND PEDIDO.BLOQUEIO = '${pegaChave('#txtBloqComConsulta')}'` : '';
    where += pegaChave('#txtBloqFinConsulta') != '' ? ` AND PEDIDO.FINANCEIRO = '${pegaChave('#txtBloqFinConsulta')}'` : '';
    where += pegaChave('#txtSituacaoConsulta') == 'P' ? ` AND PED_ITEN.QTDE > 0` : pegaChave('#txtSituacaoConsulta') == 'F' ? ` AND PED_ITEN.QTDE_F > 0` : ``;
    where += ` AND PEDIDO.EMP_ID IN (${sEmpID})`

    if (usuarioSisplan) {
      if (pegaChave('#txtRepresentanteConsulta') != '') {
        where += pegaChave('#txtRepresentanteConsulta') != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentanteConsulta')}'` : '';
      }
    } else {
      where += ` AND PEDIDO.CODREP IN (${sCodrepUsuario})`
    }

    if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
      where += ` and PEDIDO.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and PEDIDO.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
    }
    if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
      where += ` and PEDIDO.ENTREGA >= '${$("#txtDataEntregaDe").val()}' and PEDIDO.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
    }
    if ($("#txtDataFaturaDe").val() != "01-01-1200" || $$("#txtDataFaturaAte").val() != "01-12-2500") {
      where += ` and PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' and PEDIDO.DT_FATURA <= '${$("#txtDataFaturaAte").val()}'`;
    }
    if ($("#txtDataSaidaDe").val() != "01-01-1200" || $$("#txtDataSaidaAte").val() != "01-12-2500") {
      where += ` and PEDIDO.DT_SAIDA >= '${$("#txtDataSaidaDe").val()}' and PEDIDO.DT_SAIDA <= '${$("#txtDataSaidaAte").val()}'`;
    }

    return where
  }

  async function carregaDadosAberturaClientes() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const data = new Date();
      const dataFormatada = `${data.getFullYear()}-${String(data.getMonth() + 1).padStart(2, '0')}-${String(data.getDate()).padStart(2, '0')}`;
      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'ENTIDADE.CODCLI',
          'ENTIDADE.NOME',
        ],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
        ],
        where: [`1=1 AND PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_FATURA >= '${$('#txtDataEmiDe').val()}'  AND PEDIDO.DT_FATURA <= '${dataFormatada}' AND (PED_ITEN.QTDE_F * PED_ITEN.PRECO) > 0`],
        groupBy: [
          "ENTIDADE.CODCLI",
          "ENTIDADE.NOME",
        ],
        having: ['COUNT(ENTIDADE.CODCLI) = 1'],
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaTabelaCardsAcesso('tabelaPrevisaoComissao', dataSetCols, jsonStr, [], []);

      $('#modal-previsao-comissao').modal('show');

      setTimeout(() => { $("#tabelaPrevisaoComissao").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosAdmCarteira() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const data = new Date();
      const dataFormatada = `${data.getFullYear()}-${String(data.getMonth() + 1).padStart(2, '0')}-${String(data.getDate()).padStart(2, '0')}`;
      const primeiroDiaMes = `${data.getFullYear()}-${String(data.getMonth() + 1).padStart(2, '0')}-01`;
      let optionGraficoCarteira = options;

      let dadosAtendidos = [];
      let dadosNaoAtendidos = [];

      const pesquisaParam = {
        tabela: "ENTIDADE",
        camposSelectSubSelect: [
          'CODCLI',
          'NOME',
          'CIDADE',
          'UF',
          'DT_FATURA',
          'VAL_FATURA VAL_ULT_FATURA',
          'DT_EMISSAO',
          'VAL_PEDIDO VAL_ULT_PEDIDO'
        ],
        camposSelect: [
          'ENTIDADE.CODCLI',
          'ENTIDADE.NOME',
          'CIDADE.NOME AS CIDADE',
          'CIDADE.COD_UF AS UF',
          'PEDIDO.DT_FATURA',
          '(PED_ITEN.QTDE_F * PED_ITEN.PRECO) AS VAL_FATURA',
          'PEDIDO2.DT_EMISSAO',
          '((PED_ITEN2.QTDE_F [SOMA] PED_ITEN2.QTDE) * PED_ITEN2.PRECO) AS VAL_PEDIDO',
          'ROW_NUMBER() OVER (PARTITION BY ENTIDADE.CODCLI ORDER BY PEDIDO.DT_FATURA DESC, PEDIDO2.DT_EMISSAO DESC) AS ROWNUM'
        ],
        leftJoin: [
          { tabela: 'CADCEP', condicao: 'CADCEP.CEP = ENTIDADE.CEP' },
          { tabela: 'CIDADE', condicao: 'CIDADE.CODIGO = CADCEP.CODMUN' },
          { tabela: 'PEDIDO', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'PEDIDO', alias: 'PEDIDO2', condicao: 'PEDIDO2.CODCLI = ENTIDADE.CODCLI' },
          { tabela: 'PED_ITEN', alias: 'PED_ITEN2', condicao: 'PED_ITEN2.NUMERO = PEDIDO2.NUMERO' },
        ],
        where: [`ENTIDADE.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' AND PEDIDO.DT_FATURA <= '${dataFormatada}' AND (PED_ITEN.QTDE_F * PED_ITEN.PRECO) > 0`],
        whereSubSelect: ['ROWNUM = 1'],
        orderBy: ['DT_FATURA DESC']
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      jsonStr.map(item => {
        if (item.DT_FATURA > primeiroDiaMes) {
          dadosAtendidos.push(item);
        } else {
          dadosNaoAtendidos.push(item);
        }
      });

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaTabelaCardsAcesso('tabelaAdmCarteiraAtendidos', dataSetCols, dadosAtendidos, [4, 6], [5, 7], 5);
      criaTabelaCardsAcesso('tabelaAdmCarteiraNaoAtendidos', dataSetCols, dadosNaoAtendidos, [4, 6], [5, 7], 5);
      optionGraficoCarteira.series = []
      optionGraficoCarteira.labels = []
      const dadosPorCidade = [];

      dadosAtendidos.forEach(obj => {
        const qtdeCidade = dadosAtendidos.filter((cidade) => obj.CIDADE == cidade.CIDADE).length;

        if (dadosPorCidade.filter((cidade) => obj.CIDADE == cidade).length == 0) {
          dadosPorCidade.push(obj.CIDADE);
          optionGraficoCarteira.series.push(qtdeCidade)
        }

      });

      optionGraficoCarteira.labels = dadosPorCidade

      // GRAFICO
      $('#chartAdmCarteira').empty();

      // optionGraficoCarteira.series[0].data = arrDadosGrafico;
      var chart = new ApexCharts(document.querySelector("#chartAdmCarteira"), optionGraficoCarteira);
      chart.render();
      // FIM GRAFICO


      const totalCarteira = await retornaTotalCarteiraCliente();

      $('#txt_adm_carteira').html(`${dadosAtendidos.length} de ${totalCarteira}`)

      setTimeout(() => { $("#tabelaAdmCarteiraAtendidos").DataTable().columns.adjust().draw(false); }, 300);
      setTimeout(() => { $("#tabelaAdmCarteiraNaoAtendidos").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosMixProdutos() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: "PED_ITEN",
        camposSelectSubSelect: [
          'CODIGO',
          'DESCRICAO',
          'UNIDADE',
          'SUM(QTDE) QTDE_TOTAL',
          'SUM(VTOTAL) VAL_TOTAL'
        ],
        camposSelect: [
          'PED_ITEN.CODIGO',
          'MATERIAL.DESCRICAO',
          'MATERIAL.UNIDADE',
          'PED_ITEN.QTDE',
          'SUM(PED_ITEN.QTDE * PED_ITEN.PRECO) VTOTAL'
        ],
        leftJoin: [
          { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' },
        ],
        where: [`PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PED_ITEN.QTDE > 0`],
        groupBy: ['PED_ITEN.CODIGO, MATERIAL.DESCRICAO, MATERIAL.UNIDADE, PED_ITEN.QTDE'],
        groupBySubSelect: ['CODIGO', 'DESCRICAO', 'UNIDADE'],
        orderBy: ['VAL_TOTAL DESC']
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      $('#txt_mix_produtos').html(jsonStr.length)
      let optionMixProdutos = options;
      optionMixProdutos.series = []
      optionMixProdutos.labels = []
      const dadosItens = [];

      jsonStr.forEach(obj => {
        const serie = jsonStr.filter((json) => obj.CODIGO == json.CODIGO).length;

        if (dadosItens.filter((desc) => obj.DESCRICAO == desc).length == 0) {
          dadosItens.push(obj.DESCRICAO);
          optionMixProdutos.series.push(obj.QTDE_TOTAL)
        }

      });

      optionMixProdutos.labels = dadosItens

      // GRAFICO
      $('#chartMixProd').empty();

      // optionMixProdutos.series[0].data = arrDadosGrafico;
      var chart = new ApexCharts(document.querySelector("#chartMixProd"), optionMixProdutos);
      chart.render();
      // FIM GRAFICO

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaTabelaCardsAcesso('tabelaMixProdutos', dataSetCols, jsonStr, [], [4]);


      setTimeout(() => { $("#tabelaMixProdutos").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosPrevComissao() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO',
          'NOTA.EMP_ID',
          'NOTAITEN.FATURA',
          'PEDIDO.DT_FATURA',
          'PEDIDO.CODCLI',
          'ENTIDADE.NOME',
          'SUM(PED_ITEN.QTDE * PED_ITEN.PRECO) VALOR_PENDENTE',
          `CASE WHEN NATUREZA.TIPO = 'V' THEN 'VENDA' ELSE 'DEVOLUÇÃO' END TIPO`,
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'NOTAITEN', condicao: 'NOTAITEN.PEDIDO = PED_ITEN.NUMERO AND NOTAITEN.CODIGO = PED_ITEN.CODIGO AND NOTAITEN.COR = PED_ITEN.COR AND NOTAITEN.TAMANHO = PED_ITEN.TAM' },
          { tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' },
          { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = NOTA.NATUREZA' },
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
        ],
        where: [`PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PED_ITEN.QTDE_F > 0 AND PED_ITEN.PRECO > 0`],
        groupBy: [
          "PEDIDO.NUMERO",
          "NOTA.EMP_ID",
          "NOTAITEN.FATURA",
          "PEDIDO.DT_FATURA",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "NATUREZA.TIPO",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaTabelaCardsAcesso('tabelaPrevisaoComissao', dataSetCols, jsonStr, [3], [6]);

      $('#modal-previsao-comissao').modal('show');

      setTimeout(() => { $("#tabelaPrevisaoComissao").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosPedidosFaturados() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO',
          'NOTA.EMP_ID',
          'NOTAITEN.FATURA',
          'PEDIDO.DT_FATURA',
          'PEDIDO.CODCLI',
          'ENTIDADE.NOME',
          'SUM(PED_ITEN.QTDE_F * PED_ITEN.PRECO) VALOR_FATURADO',
          `CASE WHEN NATUREZA.TIPO = 'V' THEN 'VENDA' ELSE 'DEVOLUÇÃO' END TIPO`,
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'NOTAITEN', condicao: 'NOTAITEN.PEDIDO = PED_ITEN.NUMERO AND NOTAITEN.CODIGO = PED_ITEN.CODIGO AND NOTAITEN.COR = PED_ITEN.COR AND NOTAITEN.TAMANHO = PED_ITEN.TAM' },
          { tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' },
          { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = NOTA.NATUREZA' },
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
        ],
        where: [`PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PED_ITEN.QTDE_F > 0 AND PED_ITEN.PRECO > 0`],
        groupBy: [
          "PEDIDO.NUMERO",
          "NOTA.EMP_ID",
          "NOTAITEN.FATURA",
          "PEDIDO.DT_FATURA",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "NATUREZA.TIPO",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      optionFaturados.labels.push('FATURADO');
      optionFaturados.series.push(jsonStr.reduce((total, valor) => total + valor.VALOR_FATURADO, 0))

      criaTabelaCardsAcesso('tabelaPedidosFaturados', dataSetCols, jsonStr, [3], [6], 5);

      $('#modal-pedidos-faturados').modal('show');

      setTimeout(() => { $("#tabelaPedidosFaturados").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosPedidosDevolvidos() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO',
          'NOTA.EMP_ID',
          'NOTAITEN.FATURA',
          'PEDIDO.DT_FATURA',
          'PEDIDO.CODCLI',
          'ENTIDADE.NOME',
          'SUM(PED_ITEN.QTDE_F * PED_ITEN.PRECO) VALOR_FATURADO',
          `CASE WHEN NATUREZA.TIPO = 'V' THEN 'VENDA' ELSE 'DEVOLUÇÃO' END TIPO`,
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'NOTAITEN', condicao: 'NOTAITEN.PEDIDO = PED_ITEN.NUMERO AND NOTAITEN.CODIGO = PED_ITEN.CODIGO AND NOTAITEN.COR = PED_ITEN.COR AND NOTAITEN.TAMANHO = PED_ITEN.TAM' },
          { tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' },
          { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = NOTA.NATUREZA' },
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
        ],
        where: [`PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PED_ITEN.QTDE_F > 0 AND PED_ITEN.PRECO > 0 AND NATUREZA.TIPO = 'D'`],
        groupBy: [
          "PEDIDO.NUMERO",
          "NOTA.EMP_ID",
          "NOTAITEN.FATURA",
          "PEDIDO.DT_FATURA",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "NATUREZA.TIPO",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      optionFaturados.labels.push('DEVOLVIDO');
      optionFaturados.series.push(jsonStr.reduce((total, valor) => total + valor.VALOR_FATURADO, 0))
      criaTabelaCardsAcesso('tabelaPedidosDevolvidos', dataSetCols, jsonStr, [3], [6], 5);

      $('#modal-pedidos-faturados').modal('show');

      setTimeout(() => { $("#tabelaPedidosDevolvidos").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaDadosPedidosCarteira() {
    if (sCodrepUsuario == '') {
      msgAlerta('Usuário não possui um representante vinculado, favor verificar.');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO',
          'PEDIDO.CODCLI',
          'ENTIDADE.NOME',
          'SITPROD.DESCRICAO STATUS',
          'TIPO.ID_TIPO',
          'TIPO.DESCRICAO TIPO_VENDA',
          'PEDIDO.DT_EMISSAO',
          'PEDIDO.DT_FATURA',
          'PEDIDO.ENTREGA',
          'SUM(PED_ITEN.QTDE * PED_ITEN.PRECO) VALOR_PENDENTE'
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
          { tabela: 'SITPROD', condicao: 'SITPROD.CODIGO = PEDIDO.STATUS' },
          { tabela: 'TIPO', condicao: 'TIPO.ID_TIPO = PEDIDO.ID_TIPO' },
        ],
        where: [`PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PED_ITEN.QTDE > 0 AND PED_ITEN.PRECO > 0`],
        groupBy: [
          "PEDIDO.NUMERO",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "SITPROD.DESCRICAO",
          "TIPO.ID_TIPO",
          "TIPO.DESCRICAO",
          "PEDIDO.DT_EMISSAO",
          "PEDIDO.DT_FATURA",
          "PEDIDO.ENTREGA",
        ]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      let dataSetCols = [];

      for (var k in keys) {
        if (keys[k] != 'ID_TIPO') {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        }
      };

      let optionGraficoPedidosCarteira = options;
      optionGraficoPedidosCarteira.series = []
      optionGraficoPedidosCarteira.labels = []
      const labelsTipoVenda = [];

      jsonStr.forEach(obj => {
        const separadoTipo = jsonStr.filter((json) => obj.ID_TIPO == json.ID_TIPO);
        if (labelsTipoVenda.filter((tipos) => obj.TIPO_VENDA == tipos).length == 0) {
          labelsTipoVenda.push(obj.TIPO_VENDA);
          optionGraficoPedidosCarteira.series.push(separadoTipo.reduce((total, valor) => total + valor.VALOR_PENDENTE, 0))
        }
      });

      optionGraficoPedidosCarteira.labels = labelsTipoVenda

      // GRAFICO
      $('#chartPedidosCarteira').empty();

      // optionGraficoPedidosCarteira.series[0].data = arrDadosGrafico;
      var chart = new ApexCharts(document.querySelector("#chartPedidosCarteira"), optionGraficoPedidosCarteira);
      chart.render();

      criaTabelaCardsAcesso('tabelaPedidosCarteira', dataSetCols, jsonStr, [5, 6, 7], [8], 5);

      $('#modal-pedidos-carteira').modal('show');

      setTimeout(() => { $("#tabelaPedidosCarteira").DataTable().columns.adjust().draw(false); }, 300);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function criaTabelaCardsAcesso(sId, columns, data, arrData, arrDinheiro, qtdeLinhas = 10) {
    $('#' + sId).DataTable({
      filter: false,
      info: false,
      destroy: true,
      autoWidth: true,
      pageLength: qtdeLinhas,
      "colReorder": true,
      dom: 'Bfrtip',
      buttons: [{
        "extend": 'excel',
        "text": '<i class="fas fa-file-excel"></i>',
        "className": 'btn btn-primary btn-sm buttonExcel',
        "title": `Pedidos Carteira Vendedor`
      },
      {
        alignment: "center",
        "extend": 'pdf',
        "text": '<i class="fas fa-file-pdf"></i>',
        "className": 'btn btn-secondary btn-sm buttonColVis',
        customize: function (doc) {
          doc.styles.tableBodyEven.alignment = 'center';
          doc.styles.tableBodyOdd.alignment = 'center';
          doc.content[1].table.widths =
            Array(doc.content[1].table.body[0].length + 1).join('*').split('');
        },
        "title": `Pedidos Carteira Vendedor`
      }
      ],
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar (geral): ",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "data": data,
      "columns": columns,
      "columnDefs": [
        {
          render: render = function (data, type, row) {
            // alert(navigator['userAgent'])
            let isIE = function () {
              if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
                return true;
              }
              return false;

            };
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            }
            x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;

          },
          targets: arrData,
        },
        {
          render(data) {
            return parseFloat(data).toLocaleString("pt-br", {
              style: "currency",
              currency: "BRL",
            });
          },
          targets: arrDinheiro,
        },
      ]
    });
  };

  async function consultarDados() {
    try {

      if (sCodrepUsuario == '') {
        msgAlerta('Usuário não pertence a um squad e sem representante vinculado ao cadastro de usuário!');
        return;
      }

      $.LoadingOverlay('show');
      let dataSetCols = [];
      let separador = "' - '";
      const where = retornaWhereFiltros();

      const pesquisaParam = {
        tabela: "PEDIDO",
        camposSelect: [
          'PEDIDO.NUMERO PEDIDO',
          `PEDIDO.CODCLI|| ${separador}||ENTIDADE.NOME CLIENTE`,
          'PEDIDO.DT_EMISSAO',
          'SITPROD.DESCRICAO STATUS',
          'TIPO.DESCRICAO TIPO_VENDA',
          'SUM((PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_F) * PED_ITEN.PRECO) VALOR',
          'PEDIDO.ENTREGA DT_ENTREGA',
          'PEDIDO.DT_FATURA',
        ],
        leftJoin: [
          { tabela: 'PED_ITEN', condicao: `PED_ITEN.NUMERO = PEDIDO.NUMERO` },
          { tabela: 'ENTIDADE', condicao: `PEDIDO.CODCLI = ENTIDADE.CODCLI` },
          { tabela: 'SITPROD', condicao: `SITPROD.CODIGO = PEDIDO.STATUS` },
          { tabela: 'TIPO', condicao: `PEDIDO.ID_TIPO = TIPO.ID_TIPO` },
        ],
        where: [`1=1 ${where}`],
        groupBy: [
          "PEDIDO.NUMERO",
          "PEDIDO.CODCLI",
          "ENTIDADE.NOME",
          "PEDIDO.DT_EMISSAO",
          "SITPROD.DESCRICAO",
          "TIPO.DESCRICAO",
          "PEDIDO.ENTREGA",
          "PEDIDO.DT_FATURA",
        ],
        orderBy: ['PEDIDO.DT_EMISSAO ASC']
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!')
        return;
      }

      const keys = Object.keys(jsonStr[0]);

      for (let k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      dataSetCols[0].render = function (data, type, row) {
        return retornaBotaoOpcoes(row.PEDIDO);
      }

      criaTabelaCardsAcesso('tabelaPedido', dataSetCols, jsonStr, [2, 6, 7], [5]);
      $('.sorting_asc').trigger('click')
      await carregaDadosMixProdutos();
      await carregaDadosAdmCarteira();
      await buscaPedidosEmCarteira();
      await buscaPedidosFaturados();
      await buscaAberturaClientes();
      // await buscaPrevisaoComissao();

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  };

  async function carregaAtendimentosPendente() {
    async function listaPedidosNaoSalvos() {
      try {
        const response = await fetch(`busca_arquivosPedido.php`, {
          method: 'GET',
          body: null,
        },);
        const listasArquivo = await response.json();
        return listasArquivo;
      } catch (error) {
        return;
      }
    }

    async function retornaPedidosNaoSalvos(arquivos) {
      let myHeaders = new Headers();
      myHeaders.append('pragma', 'no-cache');
      myHeaders.append('cache-control', 'no-cache');
      const pedidos = await Promise.all(arquivos.map(async (arquivo) => {
        const response = await fetch(arquivo, {
          headers: myHeaders,
          method: 'GET',
          body: null,
        })
        const json = await response.json()
        return json
      }))
      return pedidos
    }
    const atendimentosNaoSalvos = await listaPedidosNaoSalvos();
    const objetosAtendimentos = await retornaPedidosNaoSalvos(atendimentosNaoSalvos);

    objetosAtendimentos.forEach((atendimento) => {
      $('#tabelaAtendimentosPendente').DataTable().row.add({
        NUMERO_ATENDIMENTO: atendimento.numeroAtendimento,
        VENDEDOR: `${atendimento.vendedor} - ${atendimento.nome_Vendedor}`,
        CLIENTE: `${atendimento.cliente.codCli} - ${atendimento.cliente.nome_Consumidor}`,
        OBSERVACAO: atendimento.observacao,
        OPCOES: retornaBotaoAtendimentosPendentes()
      }).draw(false);
    });
  }

  async function buscaPedidosEmCarteira() {
    const pesquisaParam = {
      tabela: "PEDIDO",
      camposSelect: [
        "SUM(CAST(PED_ITEN.QTDE AS NUMERIC(10,4)) * CAST(PED_ITEN.PRECO AS NUMERIC(10,4))) TOTAL_EM_CARTEIRA",
      ],
      leftJoin: [
        { tabela: 'PED_ITEN', alias: "PED_ITEN", condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
      ],
      where: [`PED_ITEN.QTDE > 0 AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PEDIDO.CODREP IN (${sCodrepUsuario})`]
    }
    if (!sCodrepUsuario) {
      return;
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr[0].TOTAL_EM_CARTEIRA) return

    $('#txt_pedidos_carteira').html(jsonStr[0].TOTAL_EM_CARTEIRA.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }));
  };

  async function buscaPedidosFaturados() {
    const data = new Date();
    const dataFormatada = `${data.getFullYear()}-${String(data.getMonth() + 1).padStart(2, '0')}-${String(data.getDate()).padStart(2, '0')}`;
    const pesquisaParam = {
      tabela: "PEDIDO",
      camposSelect: [
        'SUM(PED_ITEN.QTDE_F * PED_ITEN.PRECO) TOTAL_FATURADO',
      ],
      leftJoin: [
        { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' },
        { tabela: 'NOTAITEN', condicao: 'NOTAITEN.PEDIDO = PED_ITEN.NUMERO AND NOTAITEN.CODIGO = PED_ITEN.CODIGO AND NOTAITEN.COR = PED_ITEN.COR AND NOTAITEN.TAMANHO = PED_ITEN.TAM' },
        { tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' },
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = NOTA.NATUREZA' },
        { tabela: 'ENTIDADE', condicao: 'PEDIDO.CODCLI = ENTIDADE.CODCLI' },
      ],
      where: [`PEDIDO.CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}'  AND PEDIDO.DT_FATURA <= '${dataFormatada}' AND PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PED_ITEN.QTDE_F > 0 AND PED_ITEN.PRECO > 0`],
    };
    if (!sCodrepUsuario) return;
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr[0].TOTAL_FATURADO) return

    $('#txt_pedidos_faturados').html(TruncaDecimaisNova(2, jsonStr[0].TOTAL_FATURADO).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }));
  };

  async function buscaPrevisaoComissao() {
    const pesquisaParam = {
      tabela: "PEDIDO",
      camposSelect: [
        `REPRESEN.COMISSAO, SUM(CAST(PED_ITEN.QTDE_F AS NUMERIC(10,4)) * CAST(PED_ITEN.PRECO AS NUMERIC(10,4))) AS TOTAL_CARTEIRA`,
      ],
      camposSelectSubSelect: [
        `SUM((TOTAL_CARTEIRA * COMISSAO) /100) COMISSAO_PREVISTA`
      ],
      leftJoin: [
        { tabela: 'PED_ITEN', alias: 'PED_ITEN', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
        { tabela: 'REPRESEN', alias: 'REPRESEN', condicao: 'PEDIDO.CODREP = REPRESEN.CODREP' }
      ],
      groupBy: ["REPRESEN.COMISSAO"],
      where: [` PEDIDO.DT_EMISSAO >= '${$('#txtDataEmiDe').val()}' AND PEDIDO.CODREP IN (${sCodrepUsuario}) AND PED_ITEN.QTDE_F > 0 AND PED_ITEN.PRECO > 0`],
    }
    if (!sCodrepUsuario) return;
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr[0].COMISSAO_PREVISTA) return

    $('#txt_previsao_comissao').html((jsonStr[0].COMISSAO_PREVISTA).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }));
  };

  async function buscaMixDeProdutos() {
    const pesquisaParam = {
      tabela: "PED_ITEN",
      camposSelect: [
        `COUNT(DISTINCT CODIGO) MIX_PRODUTOS`,
      ],
      leftJoin: [
        { tabela: 'PEDIDO', alias: 'PEDIDO', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' }
      ],
      where: [`1=1 AND PEDIDO.DT_FATURA >= '${$('#txtDataEmiDe').val()}'`]
    }
    if (!sCodrepUsuario) return;
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr[0].MIX_PRODUTOS) return

    $('#txt_mix_produtos').html(jsonStr[0].MIX_PRODUTOS);
  };

  async function retornaTotalCarteiraCliente() {
    const pesquisaParam = {
      tabela: "ENTIDADE",
      camposSelect: [
        `COUNT(CODCLI) TOTAL_CLIENTES`,
      ],
      where: [`CODREP IN (${sCodrepUsuario})`]
    }

    if (!sCodrepUsuario) return;
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (!jsonStr[0].TOTAL_CLIENTES) {
      return 0
    }

    return jsonStr[0].TOTAL_CLIENTES
  };

  async function buscaAberturaClientes() {
    const data = new Date();
    const dataFormatada = `${data.getFullYear()}-${String(data.getMonth() + 1).padStart(2, '0')}-${String(data.getDate()).padStart(2, '0')}`;
    const pesquisaParam = {
      tabela: "PEDIDO",
      camposSelect: [
        `CODCLI, COUNT(CODCLI) CLIENTES`,
      ],
      leftJoin: [{ tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO.NUMERO' }],
      camposSelectSubSelect: [
        `COUNT(CLIENTES) CLIENTES_NOVOS`
      ],
      groupBy: ["CODCLI"],
      where: [`CODREP IN (${sCodrepUsuario}) AND PEDIDO.DT_FATURA >= '${$('#txtDataEmiDe').val()}' AND PEDIDO.DT_FATURA <= '${dataFormatada}' AND (PED_ITEN.QTDE_F * PED_ITEN.PRECO) > 0`],
      whereSubSelect: [`CLIENTES = 1`]
    }
    if (!sCodrepUsuario) return;
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr[0].CLIENTES_NOVOS) return

    $('#txt_abertura_clientes').html(jsonStr[0].CLIENTES_NOVOS);
  };


  


  function retornaFiltros(sNumero = '') {
    const numero = $('#txtListaPedidos').val();
    const codcli = pegaChave('#txtClienteConsulta');
    const codrep = pegaChave('#txtRepresentanteConsulta');
    const tab_pre = pegaChave('#txtTabPrecoConsulta');
    const colecao = pegaChave('#txtColecaoConsulta');
    const grupo_ped = pegaChave('#txtGrupoPedConsulta');
    const grupo_prod = pegaChave('#txtGrupoProdConsulta');
    const tipo = pegaChave('#txtTipoProdConsulta');
    const bloqueio = pegaChave('#txtBloqComConsulta');
    const financeiro = pegaChave('#txtBloqFinConsulta');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();
    const entregaDe = $("#txtDataEntregaDe").val();
    const entregaAte = $("#txtDataEntregaAte").val();
    const faturaDe = $("#txtDataFaturaDe").val();
    const faturaAte = $("#txtDataFaturaAte").val();
    const saidaDe = $("#txtDataSaidaDe").val();
    const saidaAte = $("#txtDataSaidaAte").val();
    const status = pegaChave('#txtStatusConsulta');

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&CODCLI=${codcli}` +
      `&CODREP=${codrep}` +
      `&TAB_PRE=${tab_pre}` +
      `&COLECAO=${colecao}` +
      `&PEDIDOGRUPO=${grupo_ped}` +
      `&PRODUTOGRUPO=${grupo_prod}` +
      `&TIPO=${tipo}` +
      `&BLOQUEIO=${bloqueio}` +
      `&FINANCEIRO=${financeiro}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&ENTREGADE=${entregaDe}` +
      `&ENTREGAATE=${entregaAte}` +
      `&FATURADE=${faturaDe}` +
      `&FATURAATE=${faturaAte}` +
      `&SAIDADE=${saidaDe}` +
      `&SAIDAATE=${saidaAte}` +
      `&STATUS=${status}` +
      `&EMP_ID=${sEmpID}`;

    return filtros;
  };

  function retornaBotaoAtendimentosPendentes() {
    const retorno = /*html*/`
        <div style="text-align:center;">
          <div class="dropdown">
            <button class="btn btn-info btn-sm dropdown-toggle btnOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Opções
            </button>
            <div class="dropdown-menu">
              <a id="btn-abrir-pedido" class="dropdown-item">Editar</a>
              <a id="btn-mostrar-itens" class="dropdown-item">Mostrar Itens</a>
            </div>
          </div>
        </div>
    `
    return retorno;
  };

  function retornaBotaoOpcoes(numero_pedido) {
    const habilitado = parametrosB2B[9].VALOR == '1' ? `style="pointer-events: none; opacity: 0.5;"` : '';
    const retorno = /*html*/`
      <div style="text-align:center;">
        <div class="dropdown">
          <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                ${numero_pedido}
          </button>
          <div class="dropdown-menu">
            <a id="btn-imprimir-pedido" class="dropdown-item">Imprimir</a>
            <a id="btn-enviar-wpp" class="dropdown-item" href="">Enviar WhatsApp</a>
            <a id="btn-editar-pedido" class="dropdown-item" ${habilitado}>Editar</a>
            <a id="btn-editar-entrega" class="dropdown-item">Editar Entrega</a>
          </div>
        </div>
      </div>
    `
    return retorno;
  };

  function criaTabelas() {
    $('#tabelaAtendimentosPendente').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "columns": dataSetColsAtendimentosPendentes,
      "columnDefs": [
        {
          "targets": [0],
          "width": '80px'
        },
        {
          "targets": [4],
          "width": '100px'
        }
      ]
    });
  };

  $('#txtPedidoConsulta').on('blur', function () {
    let pedido = $('#txtPedidoConsulta').val();
    if (pedido.includes("[")) {
      pedido = pegaChave($('#txtPedidoConsulta'));
    } else {
      pedido = $('#txtPedidoConsulta').val();
    }
    pedido = pedido.replace('\w', '');
    const listaPedidos = $('#txtListaPedidos').val();
    if (pedido == '') {
      return;
    }
    $('#txtListaPedidos').val((listaPedidos == '') ? `'${pedido}'` : `${listaPedidos},'${pedido}'`);
    $('#txtPedidoConsulta').val('');
    $('#txtPedidoConsulta').focus();
  });

  $('#txtPedidoConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtPedidoConsulta').trigger('blur');
      $('#txtPedidoConsulta').focus();
    }
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  function addPesquisaAutocompleta() {
    $("#btn-PedidoConsulta").pesquisa_serverside(["#txtPedidoConsulta"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI", "PED_CLI" ], "where":["EMP_ID IN (${sEmpID})"]}`, "Pesquisa Pedido");

    $('#btn-limpa-PedidoConsulta').on('click', function () {
      $('#txtListaPedidos').val('');
    });

    $("#txtClienteConsulta").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"]}`);
    $("#btn-ClienteConsulta").pesquisa_serverside(["#txtClienteConsulta"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Cliente");
    $('#btn-limpa-ClienteConsulta').on('click', function () { $('#txtClienteConsulta').val(''); });

    $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
    $('#btn-limpa-condicao').on('click', function () {
      $('#txtCondicaoDePagamento').val('');
      $('#txtNrParcelas').val('1');
    });

    $("#txtRepresentanteConsulta").autocompleta(2, `JSON={ "tabela":"REPRESEN", "camposSelect":["REPRESEN.CODREP CHAVE, REPRESEN.NOME DESCRICAO"]}`);
    $("#btn-RepresentanteConsulta").pesquisa_serverside(["#txtRepresentanteConsulta"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ]}`, "Pesquisa Representante");
    $('#btn-limpa-RepresentanteConsulta').on('click', function () { $('#txtRepresentanteConsulta').val(''); });

    $("#txtTabPrecoConsulta").autocompleta(2, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO.REGIAO CHAVE, REGIAO.DESCRICAO"]}`);
    $("#btn-TabPrecoConsulta").pesquisa_serverside(["#txtTabPrecoConsulta"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ]}`, "Pesquisa Tabela de Preço");
    $('#btn-limpa-TabPrecoConsulta').on('click', function () { $('#txtTabPrecoConsulta').val(''); });

    $("#txtColecaoConsulta").autocompleta(2, `JSON={ "tabela":"COLECAO", "camposSelect":["COLECAO.CODIGO CHAVE, COLECAO.DESCRICAO"]}`);
    $("#btn-ColecaoConsulta").pesquisa_serverside(["#txtColecaoConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Coleção");
    $('#btn-limpa-ColecaoConsulta').on('click', function () { $('#txtColecaoConsulta').val(''); });

    $("#txtGrupoPedConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PED", "camposSelect":["GRUPO_PED.CODIGO CHAVE, GRUPO_PED.DESCRICAO"]}`);
    $("#btn-GrupoPedConsulta").pesquisa_serverside(["#txtGrupoPedConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Pedido");
    $('#btn-limpa-GrupoPedConsulta').on('click', function () { $('#txtGrupoPedConsulta').val(''); });

    $("#txtGrupoProdConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["GRUPO_PA.CODIGO CHAVE, GRUPO_PA.DESCRICAO"]}`);
    $("#btn-GrupoProdConsulta").pesquisa_serverside(["#txtGrupoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Produto");
    $('#btn-limpa-GrupoProdConsulta').on('click', function () { $('#txtGrupoProdConsulta').val(''); });

    $("#txtTipoProdConsulta").autocompleta(2, `JSON={ "tabela":"CAD_TIPO_PROD", "camposSelect":["CAD_TIPO_PROD.CODIGO CHAVE, CAD_TIPO_PROD.DESCRICAO"]}`);
    $("#btn-TipoProdConsulta").pesquisa_serverside(["#txtTipoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CAD_TIPO_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Tipo Produto");
    $('#btn-limpa-TipoProdConsulta').on('click', function () { $('#txtTipoProdConsulta').val(''); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Moeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btn-limpa-Moeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-Historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-ClasseGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-ClasseGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-Situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-Banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-Banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtConta").autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}', "Pesquisa Conta", "cadconta");
    $("#btn-limpa-Conta").on("click", function () { $("#txtConta").val(""); });

    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });

    $('#txtStatusConsulta').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-StatusConsulta').pesquisa('#txtStatusConsulta', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-StatusConsulta').on('click', function () { $('#txtStatusConsulta').val('') });
  };

});