$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
        });
        driver.defineSteps([

        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const queryString = window.location.href;
    const parametros = queryString.split('/');
    const data = parametros[parametros.length - 1];

    let bAlteracao = false;
    let bInclusaoAnexo = false;
    let objTela = {};

    if (!$('#menu_pedidosb2b').hasClass('d-none')) {
        $('#txtTela').append($('<option>', {
            value: "PEDIDOB2B",
            text: 'PEDIDO B2B'
        }));
    }

    $("#txtTela").on("change", function () {
        $.LoadingOverlay("show");
        try {
            retornaInfosTela();
            montaDivOpcoes();
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnGravar").on("click", async function () {
        $("#btnGravar").prop("disabled", true);
        $.LoadingOverlay("show");
        try {
            await gravarMensagem();
        } finally {
            $("#btnGravar").prop("disabled", false);
            $.LoadingOverlay("hide");
        }
    })

    $("#btnVoltar").on("click", function () {
        window.location.href = `${BASE_URI}/msg_whatsapp`;
    })

    $("#btnTestar").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            if (bAlteracao) {
                throw msgAlerta("Alterações foram feitas na mensagem ou no SQL, necessário gravar para realizar a ação!");
            }

            await testarMensagem();
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnConfirmarValores").on("click", async function () {
        const tela = $("#txtTela").val().toString();
        const parametrosMensagem = [];
        $(".divValor").toArray().forEach(elemento => {
            const campo = $(elemento).find("label").html();
            const val = pegaChave($(elemento).find("input"));
            if (val == "") {
                throw msgAlerta(`Necessário informar um valor para o campo ${campo}.`);
            }
            parametrosMensagem.push(`${campo}: ${val}`);
        });
        const objMsgWpp = [{ CELULAR: 'teste', PARAMETROSMENSAGEM: parametrosMensagem.toString(), MENSAGEMPERSONALIZADA: "" }];
        let mensagem = await retornaMsgPersonalizadaWpp(tela, objMsgWpp, false);
        mensagem = decodeEmoticonsMensagem(mensagem, true);
        if (mensagem != "") {
            msgAlerta(mensagem);
        }
    })

    $("#btnExemplo").on("click", function () {
        montaExemplo();
    })

    $("#txtMensagem").on("change", function () {
        bAlteracao = true;
    })

    $("#txtSQL").on("change", function () {
        bAlteracao = true;
    })

    $("#btnAnexo").on("click", async function () {
        const tela = $("#txtTela").val().toString();
        const id_mensagem = $("#txtID").val();
        if (tela == "") {
            throw msgAlerta("Necessário informar uma tela para adicionar um anexo.")
        }

        if (id_mensagem == "") {
            throw msgAlerta("Não é possível adicionar um anexo à mensagem antes de gravá-la.")
        }

        $("#modalAnexoMsgPersonalizada").modal("show");
    })

    $("#btnIncluirAnexo").on("click", function () {
        modoInclusao(true);
    })

    $("#btnGravarAnexo").on("click", async function () {
        $("#btnGravarAnexo").prop("disabled", true);
        $.LoadingOverlay("show");
        try {
            if (await gravarAnexo()) {
                modoInclusao(false);
            }
        } finally {
            $.LoadingOverlay("hide");
            $("#btnGravarAnexo").prop("disabled", false);
        }
    })

    $("#btnCancelarAnexo").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            $("#tabelaAnexo").DataTable().clear().draw(false);
            await consultaAnexos();
            modoInclusao(false);
            $("#mdModalUpload").val("");
        } finally {
            $.LoadingOverlay("hide");
        }
        
    })

    $("#modalAnexoMsgPersonalizada").on("show.bs.modal", async function () {
        $.LoadingOverlay("show");
        try {
            const tela = $("#txtTela").val().toString();
            $("#txtTituloAnexo").html(tela);
            $("#tabelaAnexo").DataTable().clear().draw(false);
            await consultaAnexos();
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#modalAnexoMsgPersonalizada").on("shown.bs.modal", function () {
        $("#tabelaAnexo").DataTable().columns.adjust().draw(false);
    })

    $('button[name="btnFecharAnexo"]').on("click", function () {
        if (bInclusaoAnexo) {
            throw msgAlerta("Necessário sair do modo de inclusão");
        }
        $("#modalAnexoMsgPersonalizada").modal("hide");
    })

    $("#mdModalUpload").on("change", async function () {
        $.LoadingOverlay("show");
        try {
            const nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
            const terminologiaBase64 = retornaTerminologiaBase64(nomeAnexo);
            if (terminologiaBase64 == "") {
                throw msgAlerta(`O arquivo ${nomeAnexo} tem um tipo não suportado, os tipos de arquivos aceitos são: .png, .jpg, .jpeg, .mp4, .pdf, .doc, .docx, .xlsx, .xls, .gif, .txt`);
            }
            $("#txtArquivo").val(nomeAnexo);
    
            const dadosArquivo = document.querySelector('#mdModalUpload').files[0].type;
            const idTag = ajustaExibicaoTipoArquivo(dadosArquivo);
    
            const fileAnexo = document.querySelector('#mdModalUpload').files[0];
            const readerAnexo = new FileReader();
            readerAnexo.onloadend = function () {
                const baseStringAnexo = readerAnexo.result;
                if (idTag != "") {
                    $(idTag).attr('src', baseStringAnexo);
                }
                adicionaRegistroTabelaAnexo(nomeAnexo, baseStringAnexo)
            };
            await readerAnexo.readAsDataURL(fileAnexo);
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnAddArquivo").on("click", function () {
        $("#mdModalUpload").trigger("click");
    })

    async function iniciaTela() {
        $('#txtTela').select2({
            placeholder: "Selecione ou digite uma nova opção",
            tags: true,
            allowClear: true,
            language: {
                maximumSelected: function (limit) {
                    return "Você pode selecionar apenas uma tela";
                },
                noResults: function () {
                    return ''
                }
            },
            maximumSelectionLength: 1,
        });

        const dataSetCols = [{title: "ARQUIVO", data: "ARQUIVO"}, 
                             {title: "BASE64", data: "BASE64"},
                             {title: "AÇÕES", data: "ACOES"}];
  
        criaDataTablePadrao('#tabelaAnexo', false, false, false, false, true, true, false, null, dataSetCols, [1]);

        if (data != "create") {
            $('#txtID').val(data);
            const dados = await buscaDados(data);
            if (dados.length > 0) {
                preencheCampos(dados[0]);
                return;
            }
        }

    }

    async function gravarMensagem() {
        const id = $('#txtID').val() == '' ? await RetornaProximo("ID", "MSGWHATSAPPWEB", "ID", 2) : $('#txtID').val();
        const tela = $("#txtTela").val().toString();
        let mensagem = $("#txtMensagem").val();
        const SQL = $("#txtSQL").val();

        if (tela == "") {
            throw msgAlerta("Necessário informar a tela para prosseguir!");
        }

        if (mensagem == "") {
            throw msgAlerta("Necessário informar uma mensagem para prosseguir!");
        }

        if (mensagem.indexOf('$OLA$') == -1) {
            throw msgAlerta('Necessário a saudação da mensagem ser exatamente "$OLA$" para prosseguir.')
        }

        mensagem = encodeEmoticonsMensagem(mensagem);

        const response = await requisicao("POST", "/sisplan/config_whatsapp/v1/salvarmensagem?", "", `ID=${id}&TELA=${tela}&MENSAGEM=${encodeURIComponent(mensagem)}&SQL=${encodeURIComponent(SQL)}`, 120000);

        if (!response) {
            throw msgAlerta("Não foi possível cadastrar a mensagem, verifique!");
        }

        if (response.status != 200) {
            throw msgAlerta("Não foi possível cadastrar a mensagem, verifique!");
        }

        criaMensagemSucesso("Mensagem cadastrada com sucesso", () => { window.location.href = `${BASE_URI}/msg_whatsapp` });

    }

    async function buscaDados(id) {
        const pesquisa = {
            tabela: "MSGWHATSAPPWEB",
            camposSelect: ["TELA", "MENSAGEM", "SQL"],
            where: [`ID = ${id}`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr;

    }

    function preencheCampos(dados) {
        $("#txtTela").val(dados.TELA).trigger("change");
        dados.MENSAGEM = dados.MENSAGEM.replaceAll('&#013;', '\r\n');
        dados.MENSAGEM = decodeEmoticonsMensagem(dados.MENSAGEM);
        $("#txtMensagem").val(dados.MENSAGEM);
        $("#txtSQL").val(dados.SQL.replaceAll('&#013;', '\r\n'));
    }

    async function testarMensagem() {
        const id = $("#txtID").val();
        const tela = $("#txtTela").val().toString();
        let mensagem = $("#txtMensagem").val();
        const sql = $("#txtSQL").val();

        if (id == "") {
            throw msgAlerta("Não é possível testar com uma configuração nova, grave as alterações para prosseguir!");
        }

        if (tela == "") {
            throw msgAlerta("Necessário informar uma tela para prosseguir!");
        }

        if (mensagem == "") {
            throw msgAlerta("Necessário informar uma mensagem para prosseguir!");
        }

        if (sql != "") {
            montaModalValores();
            $("#modalValores").modal("show");
        } else {
            msgAlerta(mensagem);
        }
    }

    function montaModalValores() {
        let html = ""
        objTela.camposChave.forEach((campo, index) => {
            html += `<div class="divValor">
                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtValor${campo}">${campo}</label>
                        <div class="input-group">
                            <input type="text" class="input-default focus form-control" aria-describedby="ufError" id="txtValor${campo}" name="txtValor${campo}" class="form-control" placeholder="${campo}">
                            <div class="input-group-append">
                                 <button class="btn bg-danger" id="btnValor${campo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                 <button class="btn bg-danger" id="btnLimpaValor${campo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                             </div>
                        </div>
                    </div>`
        });
        $("#bodyModalValores").html(html);

        objTela.autocompleta.forEach(autocompleta => {
            eval(autocompleta);
        })
        objTela.pesquisa.forEach(pesquisa => {
            eval(pesquisa);
        })
        objTela.limpaCampo.forEach(limpaCampo => {
            eval(limpaCampo);
        })
    }

    function retornaInfosTela() {
        switch ($("#txtTela").val().toString()) {
            case "VENDA":
                objTela.camposChave = ["VENDA", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorVENDA").autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`);',
                    '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorVENDA").pesquisa("#txtValorVENDA", "CODVEN", "CLIENTE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "ENTIDADE.NOME CLIENTE"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`, "Pesquisa Venda", "VENDA");',
                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");'];
                objTela.limpaCampo = ['$("#btnLimpaValorVENDA").on("click", function () { $("#txtValorVENDA").val(""); });',
                    '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;
            case "DEVOLUCAO":
                objTela.camposChave = ["VENDA", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorVENDA").autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`);',
                    '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorVENDA").pesquisa("#txtValorVENDA", "CODVEN", "CLIENTE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "ENTIDADE.NOME CLIENTE"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`, "Pesquisa Venda", "VENDA");',
                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");'];
                objTela.limpaCampo = ['$("#btnLimpaValorVENDA").on("click", function () { $("#txtValorVENDA").val(""); });',
                    '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;
            case "RELANIVERSARIO":
                objTela.camposChave = ["CODCLI", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorCODCLI").autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"]}`);',
                    '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorCODCLI").pesquisa("#txtValorCODCLI", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Cliente", "ENTIDADE");',
                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "EMPRESA");'];
                objTela.limpaCampo = ['$("#btnLimpaValorCODCLI").on("click", function () { $("#txtValorCODCLI").val(""); });',
                    '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;
            case "PEDIDOB2B":
                objTela.camposChave = ["PEDIDO", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorPEDIDO").autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}]}`);',
                    '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorPEDIDO").pesquisa("#txtValorPEDIDO", "NUMERO", "CLIENTE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME CLIENTE"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}]}`, "Pesquisa Pedido", "PEDIDO");',
                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");'];
                objTela.limpaCampo = ['$("#btnLimpaValorPEDIDO").on("click", function () { $("#txtValorPEDIDO").val(""); });',
                    '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;
            case "ATENDIMENTO_FINALIZADO":
                objTela.camposChave = ["CODCLI", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorCODCLI").autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"]}`);',
                    '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorCODCLI").pesquisa("#txtValorCODCLI", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Cliente", "ENTIDADE");',
                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "EMPRESA");'];
                objTela.limpaCampo = ['$("#btnLimpaValorCODCLI").on("click", function () { $("#txtValorCODCLI").val(""); });',
                    '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;

        }
    }

    function montaDivOpcoes() {
        let html = "Opções disponíveis para se utilizar no SQL:<br>";
        objTela.camposChave.forEach(campo => {
            html += `   :${campo}   ->   Irá substituir o campo ":${campo}" dentro do SQL, pelo(a) ${campo} em questão. <br>`
        })
        $("#divOpcoes").html(html);
    }

    function montaExemplo() {
        $("#txtTela").val("VENDA").trigger("change");
        $("#txtMensagem").val("Olá #NOME_CLIENTE#! Obrigado por comprar na nossa loja, sua compra no valor de R$#VALOR#, na condição de pagamento #DESC_MOEDA# foi finalizada com sucesso.");
        $("#txtSQL").val(`SELECT
        ENTIDADE.NOME AS NOME_CLIENTE, 
        VENDA.VALOR AS VALOR,
        MOEDA.DESCRICAO AS DESC_MOEDA 
        FROM [VENDA] VENDA
        LEFT JOIN [ENTIDADE] ENTIDADE ON ENTIDADE.CODCLI = VENDA.CODCLI
        LEFT JOIN [CONDIVENDA] CONDIVENDA ON CONDIVENDA.CDVENDA = VENDA.CODVEN
        LEFT JOIN [MOEDA] MOEDA ON MOEDA.CODMOE = CONDIVENDA.CDMOEDA
        WHERE VENDA.CODVEN = :VENDA`);
        msgAlerta("Atenção, o exemplo montado é específico para a tela de VENDA!");
    }

    async function gravarAnexo() {
        const data = $("#tabelaAnexo").DataTable().data().toArray();
        const tela = $("#txtTela").val().toString();
        try {

            if (data.length == 0) {
                throw msgAlerta("Necessário adicionar algum registro para realizar a ação.");
            }

            const url = `/sisplan/config_whatsapp/v1/salvaranexosmensagem?`
            const response = await requisicao('POST', url, `TELA=${tela}`, JSON.stringify({ LISTAANEXOSMSGWHATSAPPWEB: data }), 90000);

            if (!response) {
                msgAlerta("Não foi possivel gravar o anexo");
                return false;
            }

            if (response.status == 413) {
                msgAlerta("Um ou mais arquivos selecionados ultrapassam o tamanho limite para envio. Caso queira aumentar o limite, entre em contato com o Suporte da Sisplan!");
                return false;
            } else if (response.status != 200) {
                msgAlerta("Não foi possivel gravar o anexo");
                return false;
            }

            return true;

        } catch (error) {
            console.error(error);
            msgAlerta("Não foi possivel gravar o anexo");
            return false;
        }
    }

    function modoInclusao(ativa) {
        if (ativa) {
            $("#btnGravarAnexo").removeClass("d-none");
            $("#btnCancelarAnexo").removeClass("d-none");
            $("#btnIncluirAnexo").addClass("d-none");
            $("#btnAddArquivo").prop("disabled", false);
            bInclusaoAnexo = true;
        } else {
            $("#btnGravarAnexo").addClass("d-none");
            $("#btnCancelarAnexo").addClass("d-none");
            $("#btnIncluirAnexo").removeClass("d-none");
            $("#btnAddArquivo").prop("disabled", true);
            bInclusaoAnexo = false;
        }
    }

    async function adicionaRegistroTabelaAnexo(nomeArquivo, base64) {
        const obj = {
            ARQUIVO: nomeArquivo,
            BASE64: base64,
            ACOES: retornaBotaoOpcoes()
        }
        $("#tabelaAnexo").DataTable().row.add(obj).draw(false);

        const countRows = $("#tabelaAnexo").DataTable().rows().count() - 1;
        $("#tabelaAnexo").dataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaAnexo tbody tr")[countRows]).addClass("selected");

        $("#tabelaAnexo tbody").off("click", "tr");
        $("#tabelaAnexo tbody").on("click", "tr", async function () {
            $("#tabelaAnexo").dataTable().$("tr.selected").removeClass("selected");
            $(this).addClass("selected");
            const data = $('#tabelaAnexo').DataTable().row($(this)).data();
            const arquivo = data.ARQUIVO;
            const base64 = data.BASE64;
            alteraInformacoesTela(arquivo, base64);
        });

        $("#tabelaAnexo").off("click", "#btnDownload");
        $('#tabelaAnexo').on('click', '#btnDownload', async function () {
            $.LoadingOverlay("show");
            try {
                const data = $("#tabelaAnexo").DataTable().row($(this).parents("tr")).data();
                $("#anchorDownload").attr("href", data.BASE64);
                $("#anchorDownload").attr("download", data.ARQUIVO);
                $("#btnDownloadTrigger").trigger("click");
            } finally {
                $.LoadingOverlay("hide");
            }
        });
        
        $("#tabelaAnexo").off("click", "#btnExcluir");
        $('#tabelaAnexo').on('click', '#btnExcluir', async function () {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const nomeArquivo = $("#tabelaAnexo").DataTable().row($(this).closest("tr")).data().ARQUIVO;
                if (await excluirAnexo(nomeArquivo)) {
                    $("#txtArquivo").val("");
                    $("#idVideo").attr("src", "");
                    $("#imgAnexo").attr("src", "");
                    $("#idVideo").css("opacity", 0);
                    $("#imgAnexo").css("opacity", 0);
                    $("#tabelaAnexo").DataTable().row($(this).closest("tr")).remove().draw(false);
                }
            });
        });

    }

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
          '    <a href="" id="anchorDownload" download><button class="botaoOpcoes pr-2 d-none" id="btnDownloadTrigger" type="button"><span class="fas fa-download" style="color:green"></span></button></a>' +
          '    <button class="botaoOpcoes pr-2" id="btnDownload" class="botaoOpcoes" type="button"><span class="fas fa-download" style="color:green"></span></button> ' +
          '    <button class="botaoOpcoes pl-2" id="btnExcluir" class="botaoOpcoes" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
          '   </div>';
    };

    function alteraInformacoesTela(arquivo, base64) {
        const tipoArquivo = base64.split(";")[0].split(":")[1];
        const idTag = ajustaExibicaoTipoArquivo(tipoArquivo);
        $("#txtArquivo").val(arquivo);
        if (idTag != "") {
            $(idTag).attr('src', base64);
        }
    }

    function ajustaExibicaoTipoArquivo(tipoArquivo) {
        let idTag = "";
        campoImagemVisivel();
        if (tipoArquivo.slice(0, 5) == 'video' || tipoArquivo.slice(0, 5) == 'audio') {
            idTag = '#idVideo'
            $('#imgAnexo').addClass('d-none');
            $('#idVideo').removeClass('d-none');
            $('#idVideo').attr('type', 'video/mp4');
        } else if (tipoArquivo.slice(0, 5) == 'image') {
            idTag = '#imgAnexo'
            $('#imgAnexo').removeClass('d-none');
            $('#idVideo').addClass('d-none');
        } else {
            $('#imgAnexo').removeClass('d-none');
            $('#idVideo').addClass('d-none');
            $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }

        return idTag;
        
    }

    async function consultaAnexos() {
        const tela = $("#txtTela").val().toString();  
        const anexosMsgWhatsapp = await retornaAnexoMsgPersonalizada(tela);

        if (anexosMsgWhatsapp.length > 0) {
            anexosMsgWhatsapp.forEach(anexo => {
                const terminologiaBase64 = retornaTerminologiaBase64(anexo.arquivo);
                if (terminologiaBase64 != "") {
                    adicionaRegistroTabelaAnexo(anexo.arquivo, terminologiaBase64+anexo.base64);                    
                } else {
                    msgAlerta(`O arquivo ${anexo.arquivo} tem um tipo não suportado, os tipos de arquivos aceitos são: .png, .jpg, .jpeg, .mp4, .pdf, .doc, .docx, .xlsx, .xls, .gif, .txt`);
                }
            })
            $($("#tabelaAnexo tbody tr")[0]).trigger("click");
        } else {
            $("#txtArquivo").val("");
            $("#idVideo").attr("src", "");
            $("#imgAnexo").attr("src", "");
            $("#idVideo").css("opacity", 0);
            $("#imgAnexo").css("opacity", 0);
        }
    }

    async function excluirAnexo(nomeArquivo) {
        const tela = $("#txtTela").val().toString();
        try {

            const url = `/sisplan/config_whatsapp/v1/excluiranexosmensagem?`
            const response = await requisicao('DELETE', url, `TELA=${tela}&NOME_ARQUIVO=${nomeArquivo}`);

            if (!response) {
                msgAlerta("Não foi possivel excluir o anexo");
                return false;
            }

            if (response.status != 200) {
                msgAlerta("Não foi possivel excluir o anexo");
                return false;
            }

            return true;

        } catch (error) {
            console.error(error);
            msgAlerta("Não foi possivel excluir o anexo");
            return false;
        }
    }

    function campoImagemVisivel() {       
        $("#idVideo").css("opacity", 1);
        $("#imgAnexo").css("opacity", 1);
    }

    await iniciaTela();

});
