$('#tutorial').on('click', function () {
	$(document).ready(async function () {
		const driver = new Driver({
			doneBtnText: 'Sair',
			closeBtnText: 'Fechar',
			nextBtnText: 'Próximo',
			prevBtnText: 'Anterior',
			allowClose: false,
		});
		driver.defineSteps([
			{
				element: '#txtEmpresa',
				popover: {
					title: 'Botões',
					description: 'Aqui estão os botões do caixa, onde você poderá filtrar sua busca, imprimir um relatório, fazer uma sangria ou um suprimento.',
					position: 'bottom'
				}
			},
			{
				element: '#tourlancamentosmanuais',
				popover: {
					title: 'Lançamentos Manuais',
					description: 'Aqui você poderá ver e criar lançamentos manuais para o caixa.',
					position: 'top'
				}
			},
			{
				element: '#caixatour',
				popover: {
					title: 'Dados Caixa',
					description: 'Aqui você poderá verificar os valores de cada moeda, sendo possível adicionar o valor de troco nas moedas que possuem essa opção.',
					position: 'top'
				}
			},
			{
				element: '#btnGravarTransferencia',
				popover: {
					title: 'Botão Fechar Caixa',
					description: 'Clicando aqui você efetua o fechamento de caixa, após verificar os dados do passo anterior.',
					position: 'left'
				}
			}
		]);
		//iniciar tour
		driver.start();
	});
});

$(document).ready(async function () {
	let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

	if (colunas == null || colunas.tabelaItens == undefined) {
		localStorage.setItem(
			"colunasInvisiveisRelatorios",
			JSON.stringify({ ...colunas, tabelaItens: [] })
		);
		colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
	}

	$("#btnConfirmarColunas").on("click", async function () {
		try {
			$.LoadingOverlay("show");

			const novasColunas = retornaNovasColunasInvisiveis();

			localStorage.setItem(
				"colunasInvisiveisRelatorios",
				JSON.stringify({ ...colunas, tabelaItens: novasColunas })
			);

			$("#tabelaItens").DataTable().columns().visible(true);

			$("#tabelaItens")
				.DataTable()
				.columns()
				.every(function () {
					if (novasColunas.indexOf(this.dataSrc()) != -1) {
						this.visible(false);
					}
				});
		} finally {
			$.LoadingOverlay("hide");
			$("#modal-ColunasVisiveis").modal("hide");
		}
	});

	let bRFID = false;
	let barraNaoEncontrada = [];
	const bApenasBarraLog = parametrosVenda[46] == 3;
	const utilizaBarraLog = parametrosSistema[0].VALOR != 0;
	const bloqNatureza = await CopiaParametro('FATURAMENTO', 13) == '1';
	const tabelaPadrao = await CopiaParametro('VENDA', 2)
	await carregaValoresPadroes();
	$("#txtNaturezaNFE").prop('disabled', bloqNatureza);
	let numeroDocNota = ''

	let codigoMovimentoSaida = '';
	let codigoMovimentoEntrada = '';

	async function carregaTipoTransferencia() {
		const pesquisaParam = {
			tabela: 'TABBAI',
			camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
			where: [`ATIVO = 'S'`],
		}
		const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

		let entrada = '';
		let saida = '';

		jsonStr.forEach(tipoEntradaSaida => {
			if (tipoEntradaSaida.TIPO) {
				if (tipoEntradaSaida.TIPO.charAt(19) === 'S') { //Saida Loja
					saida += saida ? `,'${tipoEntradaSaida.CODIGO}'` : `'${tipoEntradaSaida.CODIGO}'`;
				}
				if (tipoEntradaSaida.TIPO.charAt(18) === 'S') { //Entrada Loja
					entrada += entrada ? `,'${tipoEntradaSaida.CODIGO}'` : `'${tipoEntradaSaida.CODIGO}'`;
				}
			}
		});

		codigoMovimentoSaida = saida;
		codigoMovimentoEntrada = entrada;
	}

	await carregaTipoTransferencia();

	const tipoBanco = await retornaDatabase();
	setarDataAtual('dtEnvioDe')
	setarDataAtual('dtEnvioAte')
	setarDataAtual('dtDe')
	setarDataAtual('dtAte')

	insereValor('#txtEmpresaEntrada', getCookie('emp_id'), { tabela: 'EMPRESA', campoBusca: 'EMP_FANTASIA', campoWhere: 'EMP_ID', valorWhere: getCookie('emp_id') })

	// componenteFiltro('depositoUsuario', false, false, 'DepositoSaida')
	// componenteFiltro('empresa', false, false, 'EmpresaSaida')
	componenteFiltro('depositoUsuario', false, false, 'DepositoEntrada')

	const columnsEnvio = [
		// { "data": "ID", "title": "Id" },
		{ "data": "CODIGO2", "title": "Código2" },
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "DESCRICAO", "title": "Descrição" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "DESC_COR", "title": "Desc_Cor" },
		// { "data": "TAM", "title": "Tamanho" },
		{ "data": "QUALIDADE", "title": "Qualidade" },
		{ "data": "ESTOQUE", "title": "Estoque" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "LOTE", "title": "Lote" },
		// { "data": "EAN13", "title": "EAN13" },
		// { "data": "BARRA28", "title": "BARRA28" },
		// { "data": "BARRA_LOG", "title": "BarraLog" },
		// { "data": "EPC", "title": "EPC" },
		// { "data": "VALOR", "title": "Valor" },
		{ "data": "DT_FAB", "title": "Data de Fabricação" },
		{ "data": "LOTE_INTERNO", "title": "Lote Interno" },
		{ "data": "TONALIDADE", "title": "Tonalidade" },
		{ "data": "OBS", "title": "Observação" },
		{ "data": "BARRA", "title": "Barra" },
		{ "data": "DT_VAL", "title": "Data de Validade" },
		{ "data": "PESO_BRUTO", "title": "Peso Bruto" },
	]

	const columnsNotas = [
		{ "data": "SEL", "title": "Sel" },
		{ "data": "DOCUMENTO", "title": "Documento Envio" },
		{ "data": "STATUS", "title": "Status" },
		{ "data": "USUARIO", "title": "Usuário" },
		{ "data": "DATA_HORA", "title": "Data" },
		{ "data": "NOTA_FISCAL", "title": "Nota Fiscal" },
		{ "data": "SERIE", "title": "Serie" },
		{ "data": "VOLUMES", "title": "Volumes" },
		{ "data": "DEPOSITO", "title": "Depóstio" },
		{ "data": "EMP_ENVIO", "title": "Empresa Envio" },
		{ "data": "EMP_RECEB", "title": "Empresa Receb." },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde Conferida" },
		{ "data": "QTDE_PENDENTE", "title": "Qtde Pendente" },
		{ "data": "QTDE_CANC", "title": "Qtde Cancelada" },
		{ "data": "QTDE_REJEITADA", "title": "Qtde Rejeitada" },
		{ "data": "IMPRESSO", "title": "Status do Envio" },
		{ "data": "CONFERIDA", "title": "Status da Conferência" },
	]

	const columnsNotasEnviadas = [
		{ "data": "STATUS", "title": "Status" },
		{ "data": "DOCUMENTO", "title": "Documento" },
		{ "data": "USUARIO", "title": "Usuário" },
		{ "data": "DATA_HORA", "title": "Data" },
		{ "data": "NOTA_FISCAL", "title": "Nota Fiscal" },
		{ "data": "SERIE", "title": "Serie" },
		{ "data": "EMP_RECEB", "title": "Emp_receb" },
		{ "data": "VOLUMES", "title": "Volumes" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde Conferida" },
		{ "data": "QTDE_CANC", "title": "Qtde Cancelada" },
		{ "data": "QTDE_REJEITADA", "title": "Qtde Rejeitada" },
		{ "data": "CONFERIDA", "title": "Status Conferência" },
		{ "data": "LANCAMENTO", "title": "Lançamento" },
		{ "data": "IMPRESSO", "title": "Status do Envio" },
	]

	const columnsItens = [
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "CODIGO2", "title": "Código2" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "QUALIDADE", "title": "Qualidade" },
		{ "data": "LOTE", "title": "Lote" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde_Conferida" },
		{ "data": "QTDE_PENDENTE", "title": "Qtde_Pendente" },
		{ "data": "NUMERO", "title": "Numero" },
		{ "data": "TIPO_CONF", "title": "Tipo da Conferência" },
		{ "data": "DT_FAB", "title": "Data de Fabricação" },
		{ "data": "LOTE_INTERNO", "title": "Lote Interno" },
		{ "data": "TONALIDADE", "title": "Tonalidade" },
		{ "data": "OBS", "title": "Observação" },
		{ "data": "BARRA", "title": "Barra" },
		{ "data": "DT_VAL", "title": "Data de Validade" },
		{ "data": "PESO_BRUTO", "title": "Peso Bruto" },
		{ "data": "DOCUMENTO", "title": "Documento Envio" },
		{ "data": "CUSTO", "title": "Custo" },
	]

	const columnsVisualizarItens = [
		{ "data": "ID", "title": "Id" },
		{ "data": "CODIGO", "title": "Código" },
		{ "data": "COR", "title": "Cor" },
		{ "data": "TAM", "title": "Tamanho" },
		{ "data": "QUALIDADE", "title": "Qualidade" },
		{ "data": "TONALIDADE", "title": "Tonalidade" },
		{ "data": "LOTE_INTERNO", "title": "Lote Interno" },
		{ "data": "DT_FAB", "title": "Data de Fabricação" },
		{ "data": "LOTE", "title": "Lote" },
		{ "data": "BARRA", "title": "Barra" },
		{ "data": "QTDE", "title": "Qtde" },
		{ "data": "QTDE_CONFERIDA", "title": "Qtde_Conferida" },
		{ "data": "QTDE_PENDENTE", "title": "Qtde_Pendente" },
		{ "data": "QTDE_CANC", "title": "Qtde_Cancelada" },
		{ "data": "QTDE_REJEITADA", "title": "Qtde_Rejeitada" },
		{ "data": "PESO_BRUTO", "title": "Peso Bruto" },
		{ "data": "DOCTO_E", "title": "Documento Entrada" },
		{ "data": "USUARIO_CONF", "title": "Usuário Conf." },
		{ "data": "DT_ENTRADA", "title": "Data Entrada" },
		{ "data": "TIPO_CONF", "title": "Tipo da Conferência" },
		{ "data": "DEPOSITO_E", "title": "Depósito Entrada" },
	]

	if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
		console.log("enumerateDevices() not supported.");
	} else {
		encontraCamera();
	}

	var backCamID;

	function encontraCamera() {
		navigator.mediaDevices.enumerateDevices()
			.then(function (devices) {
				devices.forEach(function (device) {
					if (device.kind == "videoinput" && device.label.match(/back/) != null) {
						backCamID = device.deviceId;
					}
				});
			})
			.catch(function (err) {
				console.log(err.name + ": " + err.message);
			});

		if (typeof (backCamID) == "undefined") {
			console.log("back camera not found.");
		}
	}

	function iniciaCamera() {
		if (!navigator.mediaDevices) {
			navigator.mediaDevices.getUserMedia({
				video: true
			}.then(function (stream) {
				console.log('forçado inicio da câmera')
			}))
		}
		Quagga.init({
			locate: false,
			numOfWorkers: 2,
			inputStream: {
				name: "Live",
				type: "LiveStream",
				target: document.querySelector('#cam'),
				constraints: {
					//  width: '100%',
					//  height: '100%',
					//  facingMode: "environment"
					deviceId: backCamID
				},
				area: {
					// update area if its small mobile
					top: "32%",
					right: "10%",
					left: "10%",
					bottom: "32%"
				}
			},
			decoder: {
				readers: ["code_128_reader"]
			},
		}, function (err) {
			if (err) {
				msgAlertaSemConfirmacao('Nenhum dispositivo com câmera encontrado para realizar a bipagem, verifique!', 'modalCamera');
				return;
			} else {

				fixiOSVideo();

				if (typeof resolve === "function") {
					resolve.call(this);
				}
			}
			console.log("Initialization finished. Ready to start");
			Quagga.start();
		});

	}


	Quagga.onDetected(({
		codeResult
	}) => {
		const regexBarra = /[^/\\a-zA-Z0-9]/;
		if (regexBarra.test(codeResult.code)) {
			return;
		}

		if (isValidCode(codeResult)) {
			Quagga.stop();
			$('#txtBarra').val(codeResult.code).trigger('blur');
			$('#modalCamera').modal('hide');
		}

		Quagga.lastScannedCode = codeResult.code;

	});

	Quagga.onProcessed((result) => {
		const drawingCtx = Quagga.canvas.ctx.overlay;

		clearDrow();

		if (result) {
			if (result.boxes) {
				if (!Quagga.drowBox) {
					Quagga.drowBox = result.boxes[0];
				}

				Quagga.ImageDebug.drawPath(Quagga.drowBox, {
					x: 0,
					y: 1
				}, drawingCtx, {
					color: "green",
					lineWidth: 3
				});
			}

			const currentTime = Date.now();

			if (!Quagga.lastDetectingTime) {
				Quagga.lastDetectingTime = currentTime;
			}

			if (result.codeResult) {
				Quagga.lastDetectingTime = currentTime;
			} else if ((currentTime - Quagga.lastDetectingTime) / 1000 >= 2) {
				Quagga.lastDetectingTime = currentTime;
			}

			if (result.codeResult && result.codeResult.code) {
				Quagga.ImageDebug.drawPath(
					result.line, {
					x: "x",
					y: "y"
				},
					drawingCtx, {
					color: "red",
					lineWidth: 3
				}
				);
			}
		}
	});

	function clearDrow() {
		const drawingCtx = Quagga.canvas.ctx.overlay;
		const drawingCanvas = Quagga.canvas.dom.overlay;

		drawingCtx.clearRect(0, 0, parseInt(drawingCanvas.width), parseInt(drawingCanvas.height));
	}

	function fixiOSVideo() {
		const videoElement = Quagga.canvas.dom.overlay.parentElement.querySelector("video");

		setTimeout(() => {
			videoElement.play();
		}, 10);
	}

	function isValidCode({
		decodedCodes
	}) {
		const errors = decodedCodes.filter((x) => x.error !== undefined).map((y) => y.error); // TODO: use reduce
		const median = getMedian(errors);

		return median < 0.8;
	}

	function getMedian(arr) {
		const sorted = [...arr].sort((a, b) => a - b);
		const half = Math.floor(sorted.length / 2);

		if (arr.length % 2 === 1) {
			return arr[half];
		}

		return (arr[half - 1] + arr[half]) / 2;
	}

	$('#modalCamera').on('hidden.bs.modal', function () {
		Quagga.stop();
	});


	$('#btnCamera').on('click', function () {
		if (getCookie('protocolo') == 'http') {
			msgAlerta('Funcionalidade não habilitada, entre em contato com o Suporte da Sisplan!');
			return;
		}
		$('#modalCamera').modal('show');
		iniciaCamera();
	});

	$("#txtEmpresaRecebimento").autocompleta(3, `JSON={"tabela": "EMPRESA", "camposSelect": ["EMP_ID CHAVE", "EMP_FANTASIA DESCRICAO"], "where": ["EMP_ID <> (${getCookie('emp_id')})"]}`, [], [], []);
	$('#btnEmpresaRecebimento').pesquisa_serverside(['#txtEmpresaRecebimento'], ['EMP_ID'], ['EMP_FANTASIA'], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA"], "where": ["EMP_ID <> ${getCookie('emp_id')}"]}`, 'Pesquisa de Empresa');
	$('#btnLimpaEmpresaRecebimento').on('click', function () {
		$('#txtEmpresaRecebimento').val('')
	})

	$("#txtEmpresaEnvio").autocompleta(3, `JSON={"tabela": "EMPRESA", "camposSelect": ["EMP_ID CHAVE", "EMP_FANTASIA DESCRICAO"], "where": ["EMP_ID <> (${getCookie('emp_id')})"]}`, [], [], []);
	$('#btnEmpresaEnvio').pesquisa_serverside(['#txtEmpresaEnvio'], ['EMP_ID'], ['EMP_FANTASIA'], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA", "EMP_CNPJ"], "where": ["EMP_ID <> ${getCookie('emp_id')}"]}`, 'Pesquisa de Empresa');
	$('#btnLimpaEmpresaEnvio').on('click', function () {
		$('#txtEmpresaEnvio').val('')
	})

	$("#txtCor").autocompleta(1, `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], []);
	$("#txtQualidade").autocompleta(1, `JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, [], [], []);
	$("#txtEmpresaSaida").autocompleta(3, `JSON={"tabela": "EMPRESA", "camposSelect": ["EMP_ID CHAVE", "EMP_FANTASIA DESCRICAO"], "where": ["EMP_ID <> (${getCookie('emp_id')})"]}`, [], [], []);
	$("#txtTipoMovEntrada").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": ["CODIGO IN (${codigoMovimentoEntrada})"]}`);
	$("#txtTipoMovSaida").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": ["CODIGO IN (${codigoMovimentoSaida})"]}`);

	$("#btnCor").pesquisa_array(["#txtCor"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}', "Pesquisa Cor", "cadcor");
	$("#btnQualidade").pesquisa_array(["#txtQualidade"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}', "Pesquisa Qualidade", "tabqul");
	$('#btnEmpresaSaida').pesquisa_serverside(['#txtEmpresaSaida'], ['EMP_ID'], ['EMP_FANTASIA'], `{"tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_FANTASIA", "EMP_CNPJ"], "where": ["EMP_ID <> ${getCookie('emp_id')}"]}`, 'Pesquisa de Empresa');

	$('#btnNotaFiscalPesquisa').pesquisa_serverside(['#txtNotaFiscalPesquisa', '#txtNotaFiscalPesquisaDescInv'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{"tabela": "NOTA", "camposSelect": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"], "leftJoin": [{"tabela": "NF_CONF_ENTRA", "condicao": "NF_CONF_ENTRA.NUMERO = NOTA.FATURA"}], "where": ["NF_CONF_ENTRA.EMP_ID_ORIGEM = ${getCookie('emp_id')}", "NF_CONF_ENTRA.NUMERO = NOTA.FATURA"], "groupBy": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"]}`, "Pesquisa Nota", '', [true, true]);
	$('#btnLimpaNotaFiscalPesquisa').on('click', function () {
		$('#txtNotaFiscalPesquisa').val('')
	});

	$('#btnNotaFiscalPesquisaConf').pesquisa_serverside(['#txtNotaFiscalPesquisaConf', '#txtNotaFiscalPesquisaDescInv'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{"tabela": "NOTA", "camposSelect": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"], "leftJoin": [{"tabela": "NF_CONF_ENTRA", "condicao": "NF_CONF_ENTRA.NUMERO = NOTA.FATURA"}], "where": ["NF_CONF_ENTRA.EMP_ID = ${getCookie('emp_id')}","NF_CONF_ENTRA.NUMERO = NOTA.FATURA"], "groupBy": ["NOTA.FATURA", "NOTA.SERIE", "NF_CONF_ENTRA.CONFERIDA", "NF_CONF_ENTRA.IMPRESSO"]}`, "Pesquisa Nota", '', [true, true]);
	$('#btnLimpaNotaFiscalPesquisaConf').on('click', function () {
		$('#txtNotaFiscalPesquisaConf').val('')
	});

	$('#btnTipoMovEntrada').on('click', function () {
		if (!codigoMovimentoEntrada) {
			msgErro('Não existe Tipo Movimento Entrada cadastrada como Entrada Loja na tela "Tipo Baixa" para essa consulta.');
			return;
		}

		$('#btnTipoMovEntrada').pesquisa_array(['#txtTipoMovEntrada'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoMovimentoEntrada})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
	});

	$('#btnTipoMov').on('click', function () {
		if (!codigoMovimentoSaida) {
			msgErro('Não existe Tipo Movimento Saída cadastrada como Saída Loja na tela "Tipo Baixa" para essa consulta.');
			return;
		}

		$('#btnTipoMov').pesquisa_array(['#txtTipoMovSaida'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoMovimentoSaida})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
	});

	$("#btnLimpaMaterial").on("click", function () {
		$("#txtMaterial").val("");
	});

	$("#btnLimpaCor").on("click", function () {
		$("#txtCor").val("");
	});

	$("#btnLimpaLote").on("click", function () {
		$("#txtLote").val("");
	});

	$("#btnLimpaQualidade").on("click", function () {
		$("#txtQualidade").val("");
	});

	$('#btnLimparTipoMovEntrada').on('click', function () {
		$('#txtTipoMovEntrada').val('')
	})

	$('#btnLimparTipoMov').on('click', function () {
		$('#txtTipoMovSaida').val('')
	})

	$('#btnLimpaEmpresaSaida').on('click', function () {
		$('#txtEmpresaSaida').val('')
	})

	$('#txtNatureza').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
	$('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"], "where": [], "innerjoin": [{"tabela": "EMPRESA", "condicao": "EMPRESA.EMP_CNPJ = ENTIDADE.CNPJ"}] }`);
	$("#txtOperacao").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);

	$('#btnCliente').pesquisa_serverside(['#txtCliente'], ['ENTIDADE.CODCLI'], ['ENTIDADE.NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "ENTIDADE.CNPJ"], "where": null, "innerjoin": [{"tabela": "EMPRESA", "condicao": "EMPRESA.EMP_CNPJ = ENTIDADE.CNPJ"}]}', 'Pesquisa de Cliente');
	$('#btnNatureza').pesquisa('#txtNatureza', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
	$("#btnOperacao").pesquisa("#txtOperacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Operação", "oper_fiscal");

	$('#btnLimpaCliente').on('click', function () {
		$('#txtCliente').val('')
	})
	$('#btnLimpaNatureza').on('click', function () {
		$('#txtNatureza').val('')
	})
	$('#btnLimpaOperacao').on('click', function () {
		$('#txtOperacao').val('')
	})

	let filtroDeposito;
	let depositos;
	filtroDeposito = await buscaDepositoEmpresaUsuario();
	depositos = `(${filtroDeposito})`;
	filtroDeposito = filtroDeposito == '' ? null : `CODIGO IN (${filtroDeposito})`;

	$("#txtDepositoSaida").autocompleta(
		1,
		`JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["${filtroDeposito}"]}`,
		[],
		[],
		[],
		() => {
			if ($('#txtDepositoSaida').val()) {
				$('.controlaDisabled').attr('disabled', false)
				$('.controlaDepositoSaida').attr('disabled', true)
			}
			rotinaSaidaDeposito()
		}
	);

	$("#btnDepositoSaida").pesquisa_array(
		["#txtDepositoSaida"],
		["CHAVE"],
		["DESCRICAO"],
		`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["${filtroDeposito}"]}`,
		"Pesquisa Depósito",
		"DEPOSITO",
		() => {
			if ($('#txtDepositoSaida').val()) {
				$('.controlaDisabled').attr('disabled', false)
				$('.controlaDepositoSaida').attr('disabled', true)
			}
			rotinaSaidaDeposito()
		}
	);

	$('#btnLimpaDepositoSaida').on('click', function () {
		$('#txtDepositoSaida').val('');
	})

	$("#CampoConferenciaQtde").hide();

	criaDataTable()
	async function criaDataTable(data = [], data2 = [], data3 = [], data4 = [], data5 = []) {
		$('#tabelaNotas').DataTable({
			searching: false,
			ordering: true,
			paging: false,
			info: true,
			destroy: true,
			colReorder: true,
			pageLength: 5,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data,
			"columns": columnsNotas,
			"columnDefs": []
		});

		$('#tabelaItens').DataTable({
			order: false,
			info: false,
			destroy: true,
			searching: false,
			lengthChange: false,
			paging: false,
			pageLength: 10,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"columnDefs": [{
				targets: [9, 10, 11, 12, 13, 14, 15, 18],
				visible: false
			},],
			"autoWidth": true,
			"data": data2,
			"columns": columnsItens,
		});

		const colunasInvisiveis = JSON.parse(
			localStorage.getItem("colunasInvisiveisRelatorios")
		);

		$("#tabelaItens")
			.DataTable()
			.columns()
			.every(function () {
				if (
					colunasInvisiveis.tabelaItens.indexOf(this.dataSrc()) != -1
				) {
					this.visible(false);
				}
			});

		$('#tabelaEnvio').DataTable({
			searching: false,
			paging: false,
			pageLength: 5,
			destroy: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data3,
			"columns": columnsEnvio,
			"columnDefs": [
				{
					targets: [9, 10, 11, 12, 13, 14, 15],
					visible: false
				}
			]
		});

		$('#tabelaNotasEnviadas').DataTable({
			ordering: true,
			searching: false,
			paging: false,
			info: true,
			destroy: true,
			colReorder: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data4,
			"columns": columnsNotasEnviadas,
			"columnDefs": []
		});

		$('#tabelaVisualizarItens').DataTable({
			scrollX: true,
			ordering: true,
			searching: false,
			paging: false,
			info: true,
			destroy: true,
			colReorder: true,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": data5,
			"columns": columnsVisualizarItens,
			"columnDefs": []
		});
	}

	function retornaBotaoOpcoesEnviadas(sDocumento) {
		var retorno = '<div style="text-align:center;"> ' +
			'    <div class="dropdown" width="200px!important"> ' +
			'       <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
			'         ' + sDocumento + ' ' +
			'       </button> ' +
			'       <div class="dropdown-menu dropDownVenda" style="z-index: 999999; max-height: 380px !important; min-heigth: 380px !important; overflow-y: scroll; scrollbar-color: var(--drop-down-theme);min-width: 200px !important"> ' +
			'          <a id="btnVisualizarItensEnviadas" class="dropdown-item" href="#"><i class="fas fa-search"></i> Visualizar Itens</a>' +
			'          <a id="btnImprimirEnviadas" class="dropdown-item" href="#"><i class="fas fa-print"></i> Imprimir</a>' +
			'          <a id="btnGerarNfeEnvio" class="dropdown-item" href="#"><i class="fas fa-clipboard-list"></i> Gerar Nfe Envio</a>' +
			'          <a id="btnCancelarEnvio" class="dropdown-item" href="#"><i class="far fa-times-circle"></i> Cancelar Envio</a>' +
			'       </div>' +
			'   </div>' +
			'</div>';

		return retorno;
	}


	$("#tabelaNotasEnviadas").on("click", "#btnImprimirEnviadas", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		await imprimirTransferencia(table.DOCUMENTO);
	});

	$("#tabelaNotasEnviadas").on("click", "#btnVisualizarItensEnviadas", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		buscaDadosVisualizarItens(table.DOCUMENTO)
		$('#modalVisualizarItens').modal('show');
	});

	async function buscaEmpresaDestino(empId) {

		let sWhere = ''
		sWhere += ` AND EMPRESA.EMP_ID = ${empId}`

		const sql = {
			camposSelect: [
				"ENTIDADE.CODCLI",
				"ENTIDADE.NOME",
			],
			tabela: "ENTIDADE",
			innerJoin: [
				{
					tabela: "EMPRESA",
					condicao: "ENTIDADE.CNPJ = EMPRESA.EMP_CNPJ",
				},
			],
			where: [`1=1 ${sWhere}`]
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		return { codcli: dados[0].CODCLI, nome: dados[0].NOME }
	}

	$("#tabelaNotasEnviadas").on("click", "#btnGerarNfeEnvio", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		if (table.NOTA_FISCAL) {
			throw msgAlerta('Já existe uma nota fiscal para esta transfarência, impossível continuar.')
		}
		if (table.IMPRESSO === 'C') {
			throw msgAlerta('Documento já está cancelado, impossível continuar.')
		}

		const { codcli, nome } = await buscaEmpresaDestino(table.EMP_RECEB.split(' ')[0]);
		insereValor('#txtCliente', codcli, nome);
		$('#txtCliente').attr('disabled', true)
		$('#btnCliente').attr('disabled', true)
		$('#btnLimpaCliente').attr('disabled', true)

		const operacao = (await buscaValor('TABPADRAO', 'VALOR', `TABELA = 'TRANSF_MERCADORIAS' AND CAMPO`, 'OPERACAO')).VALOR
		insereValor('#txtOperacao', operacao, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: operacao });
		if (operacao) {
			$('#txtNatureza').attr('disabled', true)
			$('#btnNatureza').attr('disabled', true)
			$('#btnLimpaNatureza').attr('disabled', true)
		} else {
			$('#txtNatureza').attr('disabled', false)
			$('#btnNatureza').attr('disabled', false)
			$('#btnLimpaNatureza').attr('disabled', false)
		}
		numeroDocNota = table.DOCUMENTO;
		$('#modalFaturarTransferencia').modal('show')
	});

	$("#tabelaNotasEnviadas").on("click", "#btnCancelarEnvio", async function () {
		const table = $('#tabelaNotasEnviadas').DataTable().row($(this).parents("tr")).data();
		if (table.IMPRESSO === 'C') {
			throw msgAlerta('Documento já está cancelado, impossível cancelar.')
		}
		if (table.QTDE_CONFERIDA > 0) {
			throw msgAlerta('Já existe quantidades conferidas para esse documento, impossível cancelar.')
		}
		if (table.NOTA_FISCAL) {
			if ((await buscaValor('NOTA', 'IMPRESSO', 'FATURA', table.NOTA_FISCAL)).IMPRESSO !== 'C') {
				throw msgAlerta('Existe uma nota fiscal vinculada a esta transferência. Você precisa cancelar a nota para prosseguir.')
			}
		}
		await cancelaEnvio(table.LANCAMENTO);
	});

	function retornaBotaoOpcoesNotas(sDocumento) {
		var retorno = '<div style="text-align:center;"> ' +
			'    <div class="dropdown" width="200px!important"> ' +
			'       <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
			'         ' + sDocumento + ' ' +
			'       </button> ' +
			'       <div class="dropdown-menu dropDownVenda" style="z-index: 999999; max-height: 380px !important; min-heigth: 380px !important; overflow-y: scroll; scrollbar-color: var(--drop-down-theme);min-width: 200px !important;top:-50px !important"> ' +
			'       <a id="btnVisualizarItensNotas" class="dropdown-item" href="#"><i class="fas fa-search"></i> Visualizar Itens</a>' +
			'       <a id="btnImprimirNotas" class="dropdown-item" href="#"><i class="fas fa-print"></i> Imprimir</a>' +
			'       </div>' +
			'   </div>' +
			'</div>';

		return retorno;
	}

	$("#tabelaNotas").on("click", "#btnImprimirNotas", async function () {
		const table = $('#tabelaNotas').DataTable().row($(this).parents("tr")).data();
		await imprimirTransferencia(table.DOCUMENTO);
	});

	$("#tabelaNotas").on("click", "#btnVisualizarItensNotas", async function () {
		const table = $('#tabelaNotas').DataTable().row($(this).parents("tr")).data();
		buscaDadosVisualizarItens(table.DOCUMENTO)
		$('#modalVisualizarItens').modal('show');
	});

	async function buscaDadosVisualizarItens(docto) {
		if ($.fn.DataTable.isDataTable('#tabelaVisualizarItens')) {
			$('#tabelaVisualizarItens').DataTable().destroy();
			$('#tabelaVisualizarItens').empty();
		};

		let sWhere = ''
		sWhere += ` AND NF_CONF_ENTRA.DOCTO_S = ${docto}`
		const separador = "' - '"
		const sql = {
			camposSelect: [
				"NF_CONF_ENTRA.ID",
				`MATERIAL.CODIGO || ${separador} || MATERIAL.DESCRICAO CODIGO`,
				`CADCOR.COR  || ${separador} || CADCOR.DESCRICAO COR`,
				"NF_CONF_ENTRA.TAM",
				"NF_CONF_ENTRA.QUALIDADE",
				"NF_CONF_ENTRA.TONALIDADE",
				"NF_CONF_ENTRA.LOTE_INTERNO",
				"NF_CONF_ENTRA.DT_FAB",
				"NF_CONF_ENTRA.LOTE",
				"NF_CONF_ENTRA.BARRA",
				"NF_CONF_ENTRA.QTDE",
				"NF_CONF_ENTRA.QTDE_CONFERIDA",
				"NF_CONF_ENTRA.QTDE_REJEITADA",
				"NF_CONF_ENTRA.QTDE_CANC",
				"SUM(NF_CONF_ENTRA.QTDE - NF_CONF_ENTRA.QTDE_CONFERIDA - NF_CONF_ENTRA.QTDE_CANC - NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_PENDENTE",
				"NF_CONF_ENTRA.PESO_BRUTO",
				"NF_CONF_ENTRA.DOCTO_E",
				"ACESSO_USUARIOS.NOME USUARIO_CONF",
				"NF_CONF_ENTRA.DT_ENTRADA",
				"NF_CONF_ENTRA.TIPO_CONF",
				"DEPOSITO.CODIGO DEPOSITO_E",
			],
			tabela: "NF_CONF_ENTRA",
			leftJoin: [
				{
					tabela: "MATERIAL",
					condicao: "NF_CONF_ENTRA.ID_MATERIAL = MATERIAL.ID_MAT",
				},
				{
					tabela: "CADCOR",
					condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID_COR",
				},
				{
					tabela: "DEPOSITO",
					condicao: "DEPOSITO.ID = NF_CONF_ENTRA.ID_DEP_E",
				},
				{
					tabela: "ACESSO_USUARIOS",
					condicao: "ACESSO_USUARIOS.ID = NF_CONF_ENTRA.ID_ACE_USU_CONF",
				},
			],
			where: [`1=1 ${sWhere}`],
			groupBy: [
				"NF_CONF_ENTRA.ID",
				"MATERIAL.CODIGO",
				"MATERIAL.DESCRICAO",
				"CADCOR.COR",
				"CADCOR.DESCRICAO",
				"NF_CONF_ENTRA.TAM",
				"NF_CONF_ENTRA.QUALIDADE",
				"NF_CONF_ENTRA.TONALIDADE",
				"NF_CONF_ENTRA.LOTE_INTERNO",
				"NF_CONF_ENTRA.DT_FAB",
				"NF_CONF_ENTRA.LOTE",
				"NF_CONF_ENTRA.BARRA",
				"NF_CONF_ENTRA.QTDE",
				"NF_CONF_ENTRA.QTDE_CONFERIDA",
				"NF_CONF_ENTRA.QTDE_REJEITADA",
				"NF_CONF_ENTRA.QTDE_CANC",
				"NF_CONF_ENTRA.PESO_BRUTO",
				"NF_CONF_ENTRA.DOCTO_E",
				"ACESSO_USUARIOS.NOME",
				"NF_CONF_ENTRA.DT_ENTRADA",
				"NF_CONF_ENTRA.TIPO_CONF",
				"DEPOSITO.CODIGO",
			]
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		$('#tabelaVisualizarItens').DataTable({
			paging: false,
			info: false,
			searching: true,
			lengthChange: false,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": dados,
			"columns": columnsVisualizarItens,
			// scrollY: true,
			// scrollX: true,
			// scrollCollapse: true,
			// select: {
			// 	style: 'single',
			// 	toggleable: true,
			// },
			"columnDefs": [
				{
					type: 'date-br',
					targets: [7, 16],
					render: function (data) {
						if (data != undefined && data != '') {
							x = data.slice(0, 10).split('-');
							hora = data.split(' ')[1]
							if (x[2]) {
								return `${x[2]}/${x[1]}/${x[0]}`
							} else {
								return `${x} ${hora} `;
							}
						} else {
							return ''
						}
					}
				},
			],
		});
	}

	async function imprimirTransferencia(sDocumento) {
		try {
			$.LoadingOverlay('show');

			url = `/sisplan/impressao/v1/transfmercadorias?`;
			const bImprimeAutomatico = await verificaImprimirAutomatico('TransfMercadorias');
			arquivo = await GeraRelatorio(`${url}&DOCUMENTO=${sDocumento}`, "POST", 15000, false, 'TransfMercadorias');
			if (arquivo != undefined && arquivo != "") {
				if (!bImprimeAutomatico) {
					window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
				}
				await limparRelatorios();
			}

		} catch (error) {
			console.log(error)
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	function atualizaVolumes() {
		const quantidade = $('#tabelaEnvio').DataTable().data().length
		$('#txtQuantidadeVolumes').val(quantidade)
	}

	function atualizaQuantidade() {
		let quantidadeTotal = 0;

		$('.txtQtdeIt').each(function () {
			const valor = parseFloat($(this).val()) || 0;
			quantidadeTotal += valor;
		});
		$('#txtQuantidadeItens').val(TruncaDecimaisNova(2, quantidadeTotal));
	}

	async function cancelaEnvio(sLancamento) {
		$.LoadingOverlay('show')
		try {
			const sCodBaixa = (await buscaValor('TABPADRAO', 'VALOR', `TABELA = 'TRANSF_MERCADORIAS' AND CAMPO`, 'COD_BAIXA_CANC_ENVIO')).VALOR ?? ''
			const response = await requisicao('PUT',
				`/sisplan/estoque/v1/transferenciamercadorias?`,
				`LANCAMENTO=${sLancamento}&COD_BAIXA=${sCodBaixa}&COD_USUARIO=${getCookie('cod_usuario')}`
			);

			if (!response) {
				return;
			}

			if (response.status != 200) {
				const jsonStr = response.json();
				msgErro(jsonStr.mensagem);
				return;
			}

			toastr.success(
				'Cancelamento de envio efetuado com sucesso!',
				'Confirmação', {
				toastClass: 'alert',
				iconClasses: {
					error: 'alert-error',
					info: 'alert-info',
					success: 'alert-success',
					warning: 'alert-warning'
				},
				positionClass: "toast-top-center",
				progressBar: true,
				timeOut: 3000,
				fadeOut: 1000,
				onHidden() {
					$('#btnConsultarEnviadas').trigger('click')
					$.LoadingOverlay('hide')
				}
			},
			).css({
				"margin-top": "20%",
				width: "500px",
				"max-width": "500px"
			});

		} catch (error) {
			console.error(error);
			$.LoadingOverlay('hide')
		}
	}

	async function adicionaRegistroGrid() {
		const barra = $("#txtBarra").val();
		const codigoCorLote = barra.split('*');
		const codigo = pegaChave("#txtMaterial");
		const deposito = pegaChave("#txtDepositoSaida");
		const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno') === 'true';

		if (!deposito) {
			throw msgAlerta('É necessário informar um depósito, verifique!')
		}

		let dadosSelect = retornaSQL('BARRA', estornaQuantidade);

		let retornoSelect = await retornaJsonPesquisaPadrao(
			JSON.stringify(dadosSelect)
		);

		if (!retornoSelect) {
			if (codigoCorLote.length == 3) {
				dadosSelect = retornaSQLCodigoCorLote(codigoCorLote, deposito);
				retornoSelect = await retornaJsonPesquisaPadrao(
					JSON.stringify(dadosSelect)
				);

				if (!retornoSelect) {
					msgAlerta("Material não encontrado, verifique");
					return;
				}
			} else {
				dadosSelect = retornaSQL('LOTE', estornaQuantidade);

				retornoSelect = await retornaJsonPesquisaPadrao(
					JSON.stringify(dadosSelect)
				);

				if ((!retornoSelect) || (retornoSelect.length === 0)) {
					msgAlerta("Material não encontrado, verifique");
					return;
				}
			}
		}

		if (retornoSelect.length === 0) {
			if (codigoCorLote.length == 3) {
				dadosSelect = retornaSQLCodigoCorLote(codigoCorLote, deposito);
				retornoSelect = await retornaJsonPesquisaPadrao(
					JSON.stringify(dadosSelect)
				);

				if (retornoSelect.length === 0) {
					msgAlerta("Material não encontrado ou sem estoque disponível, verifique");
					return;
				}
			} else {
				dadosSelect = retornaSQL('LOTE', estornaQuantidade);

				retornoSelect = await retornaJsonPesquisaPadrao(
					JSON.stringify(dadosSelect)
				);

				if ((!retornoSelect) || (retornoSelect.length === 0)) {
					msgAlerta("Material não encontrado ou sem estoque disponível, verifique");
					return;
				}
			}
		}

		limpaCampos();
		const total = $("#tabelaEnvio").DataTable().data().length;

		retornoSelect.map(async (item, i) => {
			let colunaLote = item.LOTE;
			if (item.LOTE === '000000') {
				colunaLote = `
					<div style="display: flex; align-items: center;">
					<span>${item.LOTE}</span>
						<div class="divBtnOpcoes" style="background:var(--primary-color); border:none !important; padding: 6px 7px; margin-left: 60px !important;">
							<button class="botaoOpcoes" id="btn-excluir${i}" class="botaoOpcoes" type="button"><span class="fas fa-trash-alt" style="color:white !important"></span></button>
						</div>
				  </div>`;
			}

			const dados = {
				// ID: 0,
				CODIGO: item.CODIGO,
				DESCRICAO: item.DESCRICAO,
				COR: item.COR,
				DESC_COR: item.DESC_COR,
				// TAM: 'tam',
				QUALIDADE: item.QUALIDADE,
				LOTE: colunaLote,
				// EAN13: 'ean13',
				// BARRA28: 'barra28',
				// BARRA_LOG: 'barra_log',
				// EPC: 'epc',
				ESTOQUE: item.QTDE,
				QTDE: item.QTDE,
				CODIGO2: item.CODIGO2,
				// VALOR: item.VALOR,
				DT_FAB: item.DT_FAB,
				LOTE_INTERNO: item.LOTE_INTERNO,
				TONALIDADE: item.TONALIDADE,
				OBS: item.OBS,
				BARRA: item.BARRA,
				DT_VAL: item.DT_VAL,
				PESO_BRUTO: item.PESO_BRUTO,
			};

			if (dados.ESTOQUE === 0 && !estornaQuantidade) {
				msgAlerta("Quantidade em estoque insuficiente, verifique");
				return;
			}

			const indexItem = $("#tabelaEnvio")
				.DataTable()
				.data()
				.toArray()
				.findIndex(
					(item) =>
						item.CODIGO === dados.CODIGO && item.COR === dados.COR && item.LOTE === dados.LOTE && item.QUALIDADE === dados.QUALIDADE
				);
			if (indexItem == -1 && estornaQuantidade && codigo == '') {
				msgAlerta('Nenhum item para estornar!');
			} else if (indexItem === -1) {
				dados.QTDE = `<div class="flex"><input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${dados.ESTOQUE}">`
				// dados.QTDE = `<div class="flex"><input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${barra != '' ? dados.ESTOQUE : '0'}">`
				// + `<i class="ml-2 fas fa-check checkAlimentaQtdeTotal acaoIcon" style="font-size: 18px; margin-top: 8px !important;"></i></div>`

				$("#tabelaEnvio").DataTable().row.add(dados).draw(false);
				if (item.LOTE === '000000') {
					$(`#btn-excluir${i}`).on('click', function () {
						const rowIndex = $("#tabelaEnvio")
							.DataTable()
							.row($(this).closest('tr'))
							.index();

						if (rowIndex !== undefined) {
							$("#tabelaEnvio").DataTable().row(rowIndex).remove().draw(false);
						}
						atualizaVolumes()
						atualizaQuantidade()
					});
				}
				$(`#tabelaEnvio tbody tr:eq(${total})`).click();
			} else {
				let data = $("#tabelaEnvio").DataTable().row(indexItem).data();

				const quant = estornaQuantidade && codigo == '' ? parseFloat($('.txtQtdeIt').eq(indexItem).val()) - dados.ESTOQUE : parseFloat($('.txtQtdeIt').eq(indexItem).val()) + dados.ESTOQUE;

				if (data.ESTOQUE < quant) {
					msgAlerta("Quantidade excedida, verifique");
					return;
				}
				if (quant < 0) {
					msgAlerta("Quantidade não pode ser negativa, verifique");
					return;
				}

				if (estornaQuantidade && codigo == '') {
					$('#tabelaEnvio').DataTable().row(indexItem).remove().draw(false);
				} else {

					data.QTDE = `<input type="text" class="input-default focus form-control text-right txtQtdeIt" value="${dados.ESTOQUE}">`

					$('#tabelaEnvio').DataTable().row(indexItem).data(data).draw(false).order([[1, 'asc']]);
					if (item.LOTE === '000000') {
						$(`#btn-excluir${i}`).on('click', function () {
							const rowIndex = $("#tabelaEnvio")
								.DataTable()
								.row($(this).closest('tr'))
								.index();

							if (rowIndex !== undefined) {
								$("#tabelaEnvio").DataTable().row(rowIndex).remove().draw(false);
							}
						});
					}

				}

			};
		})
		$('#tabelaEnvio').DataTable().rows().data().draw(false).order([[1, 'asc']]);
		$('.txtQtdeIt').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 6
		});

		$("#tabelaEnvio").DataTable().columns.adjust().draw(false);
		VerificaQuantidadeBipada();
		calculaQuantidadeTotalNovoItem()

		$('.txtQtdeIt').on('blur', function () {
			const input = $(this);
			const table = $("#tabelaEnvio").DataTable();

			const index = $(this).parents()[1]._DT_CellIndex.row
			const dados = table.data().toArray()[index];

			if ($(this).val() === '') {
				$(this).val(0)
			}
			let qtdeTot = parseFloat(input.val()) || 0;

			if (qtdeTot > dados.ESTOQUE) {
				//TRATAR PARA QUANTIDADE MAIOR QUE EXISTE
				$(this).val(dados.ESTOQUE)
				$(this).attr('value', dados.ESTOQUE)
				msgAlerta('Quantidade excedida, verifique!')
				return
			} else if (qtdeTot === 0) {
				//ATUALIZAR CAMPO PARA QTDE = 0 
				$(this).val(0)
				$(this).attr('value', 0)
			} else if (qtdeTot < 0) {
				$(this).val(0)
				$(this).attr('value', 0)
				msgAlerta('Quantidade não pode ser menor que 0, verifique!')
			} else {
				//ATUALIZAR PARA A QUANTIDADE QUE ESTOU COLOCANDO
				$(this).val(qtdeTot)
				$(this).attr('value', qtdeTot)
			}

			VerificaQuantidadeBipada();
			calculaQuantidadeTotalNovoItem()
		});
	}

	$("#txtDocumento").on("blur", async function () {
		try {
			$.LoadingOverlay("show");
			if ($(this).val() == "") {
				const docto = await RetornaProximo("NUM_DOCTO", "MAT_MOV", "NUM_DOCTO", "6");
				insereValor("#txtDocumento", docto);
				$(this).attr("disabled", $(this).val() != "");
			}
		} finally {
			$.LoadingOverlay("hide");
		}
	});

	$("#tabRecebimento").on("click", async function () {
		try {
			$.LoadingOverlay("show");
			await buscaDocumentoEntrada()
		} finally {
			$.LoadingOverlay("hide");
		}
	});

	async function buscaDocumentoEntrada() {
		if ($('#txtDocumentoEntrada').val() == "") {
			const docto = await RetornaProximo("NUM_DOCTO", "MAT_MOV", "NUM_DOCTO", "6");
			insereValor("#txtDocumentoEntrada", docto);
			$('#txtDocumentoEntrada').attr("disabled", $('#txtDocumentoEntrada').val() != "");
		}
	}

	$("#txtBarra").on("blur", async function () {
		if ($(this).val() !== "") {
			await adicionaRegistroGrid();
			limpaCampos();
			$("#txtBarra").focus();
		}
		atualizaVolumes()
		atualizaQuantidade()
	});

	$("#btnConsultar").on("click", async function () {
		if (pegaChave('#txtMaterial') == '') {
			msgAlerta('Necessário informar um material para adicionar ao grid.');
			return;
		}

		await adicionaRegistroGrid();
		$("#txtMaterial").focus();
		atualizaVolumes()
		atualizaQuantidade()
	});

	rotinaSaidaDeposito();
	rotinaSaidaMaterial();
	rotinaSaidaCor();
	rotinaSaidaLote();
	rotinaSaidaQualidade();

	function rotinaSaidaMaterial() {
		$("#txtMaterial").on("blur", async function () {
			$("#txtCor").autocompleta(
				1,
				`JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [MAT_ITEN] WHERE CODIGO='${pegaChave(
					"#txtMaterial"
				)}')"]}`,
				[],
				[],
				[],
			);

			$("#btnCor").pesquisa_array(
				["#txtCor"],
				["CHAVE"],
				["DESCRICAO"],
				`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [MAT_ITEN] WHERE CODIGO='${pegaChave(
					"#txtMaterial"
				)}')"]}`,
				"Pesquisa Cor",
				"cadcor",
			);

			rotinaSaidaCor();
		});
	}

	function rotinaSaidaDeposito() {
		setTimeout(() => {
			const sDeposito = pegaChave("#txtDepositoSaida");

			$("#txtMaterial").autocompleta(
				1,
				`JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela":"MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}], "where": ["MAT_ITEN.DEPOSITO = '${sDeposito}' AND MAT_ITEN.QTDE > 0"], "groupBy": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]}`,
				[],
				[],
				[],
			);

			$('#btnMaterial').pesquisa_serverside(['#txtMaterial'], ['MATERIAL.CODIGO'], ['MATERIAL.DESCRICAO'], `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MATERIAL.CODIGO2"], "leftJoin": [{"tabela":"MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}], "where": ["MAT_ITEN.DEPOSITO = '${sDeposito}' AND MAT_ITEN.QTDE > 0"], "groupBy": ["MATERIAL.CODIGO", "MATERIAL.CODIGO2", "MATERIAL.DESCRICAO"]}`, 'Pesquisa de Material');

			rotinaSaidaMaterial()
		}, 500)
	}

	function rotinaSaidaCor() {
		$("#txtCor").on("blur", function () {
			const sCodigo = pegaChave("#txtMaterial");
			const sCor = pegaChave("#txtCor");
			const sDeposito = pegaChave("#txtDepositoSaida");

			$("#txtQualidade").autocompleta(
				1,
				`JSON={"tabela": "MAT_ITEN", "camposSelect": ["QUALIDADE CHAVE", "QUALIDADE DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}'"], "groupBy": ["QUALIDADE"]}`,
				[],
				[],
				[],
				// () => habilitaProximoCampo("#txtLote")
			);
			$("#btnQualidade").pesquisa_array(
				["#txtQualidade"],
				["CHAVE"],
				["DESCRICAO"],
				`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MAT_ITEN", "camposSelect": ["QUALIDADE CHAVE", "QUALIDADE DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}'"], "groupBy": ["QUALIDADE"]}`,
				"Pesquisa Qualidade",
				"MAT_ITEN",
				// () => habilitaProximoCampo("#txtLote")
			)

			rotinaSaidaQualidade()
		});
	}

	function rotinaSaidaLote() { }

	function rotinaSaidaQualidade() {
		$("#txtQualidade").on("blur", function () {
			const sCodigo = pegaChave("#txtMaterial");
			const sCor = pegaChave("#txtCor");
			const sDeposito = pegaChave("#txtDepositoSaida");
			const sQualidade = pegaChave("#txtQualidade");

			$("#txtLote").autocompleta(
				1,
				`JSON={"tabela": "MAT_ITEN", "camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND QUALIDADE = '${sQualidade}' AND QTDE > 0"]}`,
				[],
				[],
				[],
			);
			$("#btnLote").pesquisa_array(
				["#txtLote"],
				["CHAVE"],
				["DESCRICAO"],
				`/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MAT_ITEN", "camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND QUALIDADE = '${sQualidade}' AND QTDE > 0"]}`,
				"Pesquisa Lote",
				"MAT_ITEN",
			);
		});
	}

	$("#btnConsultar").on("keypress", async function () {
		$("#btnConsultar").trigger("click");
	});

	function limpaCampos() {
		$("#txtMaterial").val("");
		$("#txtCor").val("");
		$("#txtLote").val("");
		$("#txtQualidade").val("");
		$("#txtBarra").val("");
	}

	function VerificaQuantidadeBipada() {
		let QuantidadeBipada = 0;
		const tabelaItens = $("#tabelaItens").DataTable().data();
		for (let i = 0; i < tabelaItens.length; i++) {
			QuantidadeBipada = parseFloat(QuantidadeBipada) + (!parseFloat($('.txtQtdeItens').eq(i).val()) ? tabelaItens[i].QTDE_CONFERIDA : parseFloat($('.txtQtdeItens').eq(i).val()));
		}
		$("#txtQuantidadeBipada").val(TruncaDecimaisNova(2, QuantidadeBipada));
	}

	function atualizaVolumesConferidos() {
		const dados = $('#tabelaItens').DataTable().data().toArray();
		const volumes = dados.reduce((acc, item) => {
			return acc + (item.QTDE_CONFERIDA > 0 ? 1 : 0);
		}, 0);
		$('#txtVolumesConferidos').val(volumes);
	}

	function VerificaQuantidadePendente() {
		let QuantidadePendente = 0
		const tabelaItens = $("#tabelaItens").DataTable().data();
		for (let i = 0; i < tabelaItens.length; i++) {
			QuantidadePendente = parseFloat(QuantidadePendente) + tabelaItens[i].QTDE_PENDENTE;
		}
		$("#txtQuantidadePendente").val(TruncaDecimaisNova(2, QuantidadePendente));
	}

	function atualizaVolumesPendentes() {
		const dados = $('#tabelaItens').DataTable().data().toArray();
		const VolumesPendentes = dados.reduce((acc, item) => {
			return acc + (item.QTDE_CONFERIDA === 0 ? 1 : 0);
		}, 0);

		$("#txtVolumesPendentes").val(VolumesPendentes);
	}

	$("#txtBarra").on("keydown", async function (event) {
		if (event.key == "Enter") {
			$("#txtBarra").trigger("blur");
			$("#txtBarra").focus();
		}
	});

	$('#btnGravarTransferencia').on('click', async function () {
		try {
			if (!$('#txtEmpresaSaida').val()) {
				throw msgAlerta('Empresa de destino não informada. É necessário a empresa que irá receber a nota, verifique!')
			}
			if ($('#tabelaEnvio').DataTable().data().length == 0) {
				throw msgAlerta('Nenhum item para ser transferido, verifique!')
			}
			if (!$('#txtTipoMovSaida').val()) {
				throw msgAlerta('Necessário inserir um tipo de movimentação!')
			}
			$('#btnGravarTransferencia').prop('disabled', true);
			$.LoadingOverlay('show');
			try {
				await gravarMovimentacao();

			} catch (error) {
				console.error(error);
			}

		} finally {
			$('#btnGravarTransferencia').prop('disabled', false);
			$.LoadingOverlay('hide');
		}
	});

	function retornaTabelaSaida() {
		const tabela = $('#tabelaEnvio').DataTable().rows().data().toArray()

		const objetoMovimentacao = tabela.map((item, i) => {
			return {
				DOCTO: $('#txtDocumento').val(),
				NUM_DOCTO: $('#txtDocumento').val(),
				CODIGO: item.CODIGO,
				COR: item.COR,
				QUALIDADE: item.QUALIDADE,
				QTDE: $('.txtQtdeIt').eq(i).val(),
				LOTE: $(item.LOTE).find('span').text().trim() !== '' ? $(item.LOTE).find('span').text().trim() : item.LOTE,
				DEPOSITO: pegaChave('#txtDepositoSaida'),
				CODBAIXA: pegaChave('#txtTipoMovSaida'),
				DT_FAB: item.DT_FAB,
				LOTE_INTERNO: item.LOTE_INTERNO,
				TONALIDADE: item.TONALIDADE,
				OBS: item.OBS,
				BARRA: item.BARRA,
				DT_VAL: item.DT_VAL,
				PESO_BRUTO: item.PESO_BRUTO,
			}
		})

		return objetoMovimentacao;
	}

	async function gravarMovimentacao(nfe = false) {
		try {
			const objeto = retornaTabelaSaida();
			const body = {
				materiais: objeto
			}
			const response = await requisicao('POST',
				`/sisplan/estoque/v1/transferenciamercadorias?`,
				`TIPO=SAIDA&EMP_DESTINO=${pegaChave('#txtEmpresaSaida')}`,
				JSON.stringify(body)
			);

			if (response.status != 200) {
				const jsonStr = await response.json();
				msgErro(jsonStr.mensagem);
				return;
			}

			await imprimirTransferencia($('#txtDocumento').val())

			toastr.success(
				'Saída de mercadoria efetuada com sucesso!',
				'Confirmação', {
				toastClass: 'alert',
				iconClasses: {
					error: 'alert-error',
					info: 'alert-info',
					success: 'alert-success',
					warning: 'alert-warning'
				},
				positionClass: "toast-top-center",
				progressBar: true,
				timeOut: 3000,
				fadeOut: 1000,
				onHidden() {
					if (nfe) {
						faturaNFe()
					}
					window.location.href = `${BASE_URI}/mercadorias`;
				}
			},

			).css({
				"margin-top": "20%",
				width: "500px",
				"max-width": "500px"
			});

		} catch (error) {
			console.error(error);
			window.location.href = `${BASE_URI}/mercadorias`;
		}
	}

	function calculaQuantidadeTotalNovoItem() {
		try {
			let quantidadeTotal = 0
			$('.txtQtdeIt').toArray().forEach((e) => {
				quantidadeTotal += parseFloat($(e).val())
			})

			quantidadeTotal = parseFloat(quantidadeTotal)

			if (isNaN(quantidadeTotal)) {
				$('#txtQtdeNovoItem').val(0)
				return
			}

			const quantidadeTotalFormatada = quantidadeTotal.toFixed(6)

			$('#txtQtdeNovoItem').val(quantidadeTotalFormatada)
		} catch (error) {
			console.error(error)
			$('#txtQtdeNovoItem').val(0)
		}
	}

	await buscaNotas()
	async function buscaNotas(statusConf = '', statusEnvio = '') {
		let sWhere = ''
		let sWhereSubSelect = ''

		sWhere += ` AND NF_CONF_ENTRA.EMP_ID = ${getCookie('emp_id')}`;
		if (statusConf === 'R') {
			sWhereSubSelect += statusConf ? ` AND QTDE_REJEITADA > 0` : '';
		} else {
			sWhere += statusConf ? ` AND NF_CONF_ENTRA.CONFERIDA = '${statusConf}'` : '';
		}
		sWhere += statusEnvio ? ` AND NF_CONF_ENTRA.IMPRESSO = '${statusEnvio}'` : '';

		if (tipoBanco == 'ORACLE') {
			sWhere += $('#dtDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= TO_TIMESTAMP('${$('#dtDe').val()} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
			sWhere += $('#dtAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= TO_TIMESTAMP('${$('#dtAte').val()} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
		} else {
			sWhere += $('#dtDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= '${$('#dtDe').val()}'` : '';
			sWhere += $('#dtAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= '${$('#dtAte').val()}'` : '';
		}
		sWhere += pegaChave('#txtEmpresaEnvio') ? ` AND NF_CONF_ENTRA.EMP_ID_ORIGEM = '${pegaChave('#txtEmpresaEnvio')}'` : '';

		sWhere += $('#txtDocumentoPesquisaConf').val() ? ` AND NF_CONF_ENTRA.DOCTO_S = '${$('#txtDocumentoPesquisaConf').val()}'` : '';
		sWhere += $('#txtNotaFiscalPesquisaConf').val() ? ` AND NF_CONF_ENTRA.NUMERO = '${$('#txtNotaFiscalPesquisaConf').val()}'` : '';

		const separador = "' - '"
		const sql = {
			camposSelectSubSelect: ['*'],
			camposSelect: [
				"'' SEL",
				"0 STATUS",
				"NF_CONF_ENTRA.DOCTO_S DOCUMENTO",
				"NF_CONF_ENTRA.USUARIO",
				"MAX(NF_CONF_ENTRA.DT_SAIDA) DATA_HORA",
				"NF_CONF_ENTRA.NUMERO NOTA_FISCAL",
				"NF_CONF_ENTRA.SERIE",
				"COUNT(NF_CONF_ENTRA.DOCTO_S) VOLUMES",
				`DEPOSITO.CODIGO || ${separador} || DEPOSITO.DESCRICAO DEPOSITO`,
				`NF_CONF_ENTRA.EMP_ID_ORIGEM || ${separador} || EMPRESA_ORIGEM.EMP_FANTASIA EMP_ENVIO`,
				`NF_CONF_ENTRA.EMP_ID || ${separador}  || EMPRESA_DESTINO.EMP_FANTASIA EMP_RECEB`,
				"SUM(NF_CONF_ENTRA.QTDE) QTDE",
				"SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) QTDE_CONFERIDA",
				"SUM(NF_CONF_ENTRA.QTDE - NF_CONF_ENTRA.QTDE_CONFERIDA - NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_PENDENTE",
				"SUM(NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_REJEITADA",
				"SUM(NF_CONF_ENTRA.QTDE_CANC) QTDE_CANC",
				"NF_CONF_ENTRA.CONFERIDA",
				"NF_CONF_ENTRA.IMPRESSO",
			],
			tabela: "NF_CONF_ENTRA",
			leftJoin: [
				{
					tabela: "MATERIAL",
					condicao: "NF_CONF_ENTRA.ID_MATERIAL = MATERIAL.ID_MAT",
				},
				{
					tabela: "CADCOR",
					condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID_COR",
				},
				{
					tabela: "EMPRESA",
					alias: "EMPRESA_ORIGEM",
					condicao: "EMPRESA_ORIGEM.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM",
				},
				{
					tabela: "EMPRESA",
					alias: "EMPRESA_DESTINO",
					condicao: "EMPRESA_DESTINO.EMP_ID = NF_CONF_ENTRA.EMP_ID",
				},
				{
					tabela: "DEPOSITO",
					condicao: "DEPOSITO.ID = NF_CONF_ENTRA.ID_DEP_S",
				},
			],
			groupBy: [
				"NF_CONF_ENTRA.DOCTO_S",
				"NF_CONF_ENTRA.NUMERO",
				"NF_CONF_ENTRA.USUARIO",
				"NF_CONF_ENTRA.SERIE",
				"NF_CONF_ENTRA.EMP_ID_ORIGEM",
				"EMPRESA_ORIGEM.EMP_FANTASIA",
				"NF_CONF_ENTRA.EMP_ID",
				"EMPRESA_DESTINO.EMP_FANTASIA",
				"DEPOSITO.CODIGO",
				"DEPOSITO.DESCRICAO",
				"NF_CONF_ENTRA.IMPRESSO",
				"NF_CONF_ENTRA.CONFERIDA",
			],
			where: [`1=1 ${sWhere}`],
			whereSubSelect: [`1=1 ${sWhereSubSelect}`],
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		$('#tabelaNotas').DataTable({
			order: [1, 'desc'],
			searching: false,
			ordering: true,
			paging: true,
			info: true,
			destroy: true,
			colReorder: true,
			pageLength: 5,
			lengthChange: false,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": dados,
			"columns": columnsNotas,
			"columnDefs": [
				{
					targets: [0], render: function (_data, _type, _row, meta) {
						return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${_row.IMPRESSO === 'C' ? 'disabled' : _row.CONFERIDA === 'R' || _row.CONFERIDA === 'S' ? 'disabled' : ''} id="check_col_${meta.row}_row_${meta.col}" class="checkSel">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
					},
				},
				{
					render(data, type, row) {
						return retornaBotaoOpcoesNotas(row.DOCUMENTO);
					},
					targets: 1,
				},
				{
					type: 'date-br',
					targets: [4],
					render: function (data) {
						if (data != undefined && data != '') {
							x = data.slice(0, 10).split('-');
							hora = data.split(' ')[1]
							if (x[2]) {
								return `${x[2]}/${x[1]}/${x[0]}`
							} else {
								return `${x} ${hora} `;
							}
						} else {
							return ''
						}
					}
				},
			],
			rowCallback: function (row, data) {
				if ($('td:eq(16)', row).text() === 'C') {
					$('td:eq(16)', row).text('Cancelado')
					$('td:eq(16)', row).css('color', 'red');
				}
				if ($('td:eq(16)', row).text() === 'S') {
					$('td:eq(16)', row).text('Enviado')
				}
				if ($(`td:eq(17)`, row).text() === 'F') {
					$(`td:eq(17)`, row).text('Parcial')
				}
				if ($(`td:eq(17)`, row).text() === 'S') {
					$(`td:eq(17)`, row).text('Conferida')
				}
				if ($(`td:eq(17)`, row).text() === 'P') {
					$(`td:eq(17)`, row).text('Pendente')
				}
				if ($(`td:eq(17)`, row).text() === 'R') {
					$(`td:eq(17)`, row).text('Rejeitada')
				}

				if (data.CONFERIDA === 'R') {
					$(row).css('color', 'red');
				} else if (data.CONFERIDA === 'F') {
					$(row).css('color', 'var(--linhaAmarela)');
				} else if (data.CONFERIDA === 'S') {
					$(row).css('color', 'green');
				}
			}
		});

		let registrosSelecionados = [];
		$('#tabelaNotas').DataTable().on('click', ".checkSel", async function () {
			const dados = $('#tabelaNotas').DataTable().rows($(this).closest('tr').index()).data().toArray();
			if (!$(this).prop('checked')) {
				registrosSelecionados = registrosSelecionados.filter(cod => (cod[1] != dados[0][1]));
				$($(this).closest('tr')).removeClass('selected');
			} else {
				$($(this).closest('tr')).addClass('selected');
			}
		});
	}

	$('#btnConsultarEnviadas').on('click', async function () {
		const statusEnvio = $('#txtStatusEnvioE').val()
		const statusConf = $('#txtStatusConfE').val()
		await buscaNotasEnviadas(statusConf, statusEnvio)
	})

	$('#btnConsultarEnviadas').trigger('click')
	async function buscaNotasEnviadas(statusConf = '', statusEnvio = '') {
		if ($.fn.DataTable.isDataTable('#tabelaNotasEnviadas')) {
			$('#tabelaNotasEnviadas').DataTable().destroy();
			$('#tabelaNotasEnviadas').empty();
		};

		let sWhere = ''

		sWhere += ` AND NF_CONF_ENTRA.EMP_ID_ORIGEM = ${getCookie('emp_id')}`;
		if (tipoBanco == 'ORACLE') {
			sWhere += $('#dtEnvioDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= TO_TIMESTAMP('${$('#dtEnvioDe').val()} 00:00:00', 'YYYY-MM-DD HH24:MI:SS')` : '';
			sWhere += $('#dtEnvioAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= TO_TIMESTAMP('${$('#dtEnvioAte').val()} 23:59:59', 'YYYY-MM-DD HH24:MI:SS')` : '';
		} else {
			sWhere += $('#dtEnvioDe').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA >= '${$('#dtEnvioDe').val()}'` : '';
			sWhere += $('#dtEnvioAte').val() != '' ? ` AND NF_CONF_ENTRA.DT_SAIDA <= '${$('#dtEnvioAte').val()}'` : '';
		}
		sWhere += $('#txtDocumentoPesquisa').val() ? ` AND NF_CONF_ENTRA.DOCTO_S = '${$('#txtDocumentoPesquisa').val()}'` : '';
		sWhere += $('#txtNotaFiscalPesquisa').val() ? ` AND NF_CONF_ENTRA.NUMERO = '${$('#txtNotaFiscalPesquisa').val()}'` : '';
		sWhere += pegaChave('#txtEmpresaRecebimento') ? ` AND NF_CONF_ENTRA.EMP_ID = '${pegaChave('#txtEmpresaRecebimento')}'` : '';

		if (statusConf === 'R') {
			sWhere += statusConf ? ` AND NF_CONF_ENTRA.QTDE_REJEITADA > 0` : '';
		} else {
			sWhere += statusConf ? ` AND NF_CONF_ENTRA.CONFERIDA = '${statusConf}'` : '';
		}
		sWhere += statusEnvio ? ` AND NF_CONF_ENTRA.IMPRESSO = '${statusEnvio}'` : '';

		const separador = "' - '"
		const sql = {
			camposSelect: [
				"0 STATUS",
				"NF_CONF_ENTRA.DOCTO_S DOCUMENTO",
				"NF_CONF_ENTRA.USUARIO",
				"MAX(NF_CONF_ENTRA.DT_SAIDA) DATA_HORA",
				"NF_CONF_ENTRA.NUMERO NOTA_FISCAL",
				"COUNT(NF_CONF_ENTRA.DOCTO_S) VOLUMES",
				"NF_CONF_ENTRA.SERIE",
				`NF_CONF_ENTRA.EMP_ID || ${separador}  || EMPRESA_DESTINO.EMP_FANTASIA EMP_RECEB`,
				"SUM(NF_CONF_ENTRA.QTDE) QTDE",
				"SUM(NF_CONF_ENTRA.QTDE_CONFERIDA) QTDE_CONFERIDA",
				"SUM(NF_CONF_ENTRA.QTDE - NF_CONF_ENTRA.QTDE_CONFERIDA) QTDE_PENDENTE",
				"SUM(NF_CONF_ENTRA.QTDE_REJEITADA) QTDE_REJEITADA",
				"SUM(NF_CONF_ENTRA.QTDE_CANC) QTDE_CANC",
				"NF_CONF_ENTRA.CONFERIDA",
				"MAT_MOV.LANCAMENTO",
				"NF_CONF_ENTRA.IMPRESSO",
			],
			tabela: "NF_CONF_ENTRA",
			leftJoin: [
				{
					tabela: "MATERIAL",
					condicao: "NF_CONF_ENTRA.ID_MATERIAL = MATERIAL.ID_MAT",
				},
				{
					tabela: "CADCOR",
					condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID_COR",
				},
				{
					tabela: "MAT_MOV",
					condicao: "NF_CONF_ENTRA.LOTE = MAT_MOV.LOTE AND MAT_MOV.CODIGO = MATERIAL.CODIGO AND MAT_MOV.COR = CADCOR.COR AND NF_CONF_ENTRA.QUALIDADE = MAT_MOV.QUALIDADE AND NF_CONF_ENTRA.DOCTO_S = MAT_MOV.NUM_DOCTO AND MAT_MOV.OPERACAO = 'S'",
				},
				{
					tabela: "EMPRESA",
					alias: "EMPRESA_DESTINO",
					condicao: "EMPRESA_DESTINO.EMP_ID = NF_CONF_ENTRA.EMP_ID",
				},
			],
			groupBy: [
				"NF_CONF_ENTRA.DOCTO_S",
				"NF_CONF_ENTRA.NUMERO",
				"NF_CONF_ENTRA.USUARIO",
				"NF_CONF_ENTRA.SERIE",
				"NF_CONF_ENTRA.EMP_ID",
				"EMPRESA_DESTINO.EMP_FANTASIA",
				"NF_CONF_ENTRA.EMP_ID_ORIGEM",
				"NF_CONF_ENTRA.CONFERIDA",
				"MAT_MOV.LANCAMENTO",
				"NF_CONF_ENTRA.IMPRESSO",
			],
			where: [`1=1 ${sWhere}`],
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		$('#tabelaNotasEnviadas').DataTable({
			order: [1, 'desc'],
			searching: false,
			ordering: true,
			paging: true,
			info: true,
			destroy: true,
			colReorder: true,
			pageLength: 5,
			lengthChange: false,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": dados,
			"columns": columnsNotasEnviadas,
			"columnDefs": [
				{
					visible: false,
					targets: 13
				},
				{
					type: 'date-br',
					targets: [3],
					render: function (data) {
						if (data != undefined && data != '') {
							x = data.slice(0, 10).split('-');
							hora = data.split(' ')[1]
							if (x[2]) {
								return `${x[2]}/${x[1]}/${x[0]}`
							} else {
								return `${x} ${hora} `;
							}
						} else {
							return ''
						}
					}
				},
				{
					render(data, type, row) {
						return retornaBotaoOpcoesEnviadas(row.DOCUMENTO);
					},
					targets: 1,
				}
			],
			rowCallback: function (row, data) {
				if ($('td:eq(12)', row).text() === 'F') {
					$('td:eq(12)', row).text('Parcial')
				}
				if ($('td:eq(12)', row).text() === 'S') {
					$('td:eq(12)', row).text('Conferida')
				}
				if ($('td:eq(12)', row).text() === 'P') {
					$('td:eq(12)', row).text('Pendente')
				}
				if ($('td:eq(12)', row).text() === 'R') {
					$('td:eq(12)', row).text('Rejeitada')
				}
				if ($('td:eq(13)', row).text() !== 'C') {
					$('td:eq(13)', row).text('Enviado')
				}
				if ($('td:eq(13)', row).text() === 'C') {
					$('td:eq(13)', row).text('Cancelado')
					$('td:eq(13)', row).css('color', 'red');
				}
				if (data.CONFERIDA === 'R') {
					$(row).css('color', 'red');
				} else if (data.CONFERIDA === 'F') {
					$(row).css('color', 'var(--linhaAmarela)');
				} else if (data.CONFERIDA === 'S') {
					$(row).css('color', 'green');
				}
			}
		});
	}

	function retornaSQL(sCampo = 'BARRA', estorno = false) {
		const codigo = pegaChave("#txtMaterial");
		const deposito = pegaChave("#txtDepositoSaida");
		const cor = pegaChave("#txtCor");
		const lote = $('#txtBarra').val().trim() != '' ? $('#txtBarra').val().trim() : pegaChave("#txtLote").trim() != '' ? pegaChave("#txtLote").trim() : '';
		const qual = pegaChave("#txtQualidade");
		let having = ''

		let sWhere = '';
		sWhere += codigo ? ` AND MAT_ITEN.CODIGO = '${codigo}'` : ''
		sWhere += cor ? ` AND MAT_ITEN.COR = '${cor}'` : ''
		sWhere += lote ? ` AND MAT_ITEN.LOTE = '${lote}'` : ''
		sWhere += qual ? ` AND MAT_ITEN.QUALIDADE = '${qual}'` : ''
		sWhere += deposito ? ` AND MAT_ITEN.DEPOSITO = '${deposito}'` : ''
		if (!estorno) {
			having = "SUM(MAT_ITEN.QTDE) > 0"
		}

		return {
			camposSelect: [
				"MAT_ITEN.CODIGO",
				"MATERIAL.DESCRICAO",
				"MAT_ITEN.COR",
				"CADCOR.DESCRICAO DESC_COR",
				"MAT_ITEN.LOTE",
				"MAT_ITEN.QUALIDADE",
				"MAT_ITEN.LARGURA",
				"MAT_ITEN.GRAMATURA",
				"SUM(MAT_ITEN.QTDE) QTDE",
				"MATERIAL.UNIDADE",
				"MATERIAL.CODIGO2",
				"MAT_ITEN.DT_FAB",
				"MAT_ITEN.LOTE_INTERNO",
				"MAT_ITEN.TONALIDADE",
				"MAT_ITEN.OBS",
				"MAT_ITEN.BARRA",
				"MAT_ITEN.DT_VAL",
				"MAT_ITEN.PESO_BRUTO",
			],
			tabela: "MAT_ITEN",
			leftJoin: [
				{
					tabela: "MATERIAL",
					condicao: "MATERIAL.CODIGO = MAT_ITEN.CODIGO",
				},
				{
					tabela: "CADCOR",
					condicao: "CADCOR.COR = MAT_ITEN.COR",
				},
			],
			where: [`1=1 ${sWhere}`],
			groupBy: [
				"MATERIAL.CODIGO2",
				"MAT_ITEN.CODIGO",
				"MATERIAL.DESCRICAO",
				"MAT_ITEN.COR",
				"CADCOR.DESCRICAO",
				"MAT_ITEN.LOTE",
				"MAT_ITEN.QUALIDADE",
				"MAT_ITEN.LARGURA",
				"MAT_ITEN.GRAMATURA",
				"MATERIAL.UNIDADE",
				"MAT_ITEN.DT_FAB",
				"MAT_ITEN.LOTE_INTERNO",
				"MAT_ITEN.TONALIDADE",
				"MAT_ITEN.OBS",
				"MAT_ITEN.BARRA",
				"MAT_ITEN.DT_VAL",
				"MAT_ITEN.PESO_BRUTO",
			],

			having: [having],
		};
	}

	$('#btnMenosOuMais').on('click', function () {
		const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
		$('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
		$('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
		$('#txtBarra').focus();
		$('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
		if (estaComoEstorno) {
			$('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
		} else {
			$('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus');
		}
	});

	$('#check_todos').on('change', function () {
		$('.campoSel').prop('checked', $('#check_todos').prop('checked'));
		if ($('#check_todos').prop('checked')) {
			$('.campoSel').addClass('selecionado');
		} else {
			$('.campoSel').removeClass('selecionado');
		}
	});

	async function conferirItens() {
		if ($.fn.DataTable.isDataTable('#tabelaItens')) {
			$('#tabelaItens').DataTable().destroy();
			$('#tabelaItens').empty();
		};

		let registrosSelecionados = [];

		$('#tabelaNotas').DataTable().rows('.selected').every(function (rowIdx, tableLoop, rowLoop) {
			const dadosLinha = this.data();
			registrosSelecionados.push(dadosLinha.DOCUMENTO);
		});

		if (registrosSelecionados.length == 0) {
			throw msgAlerta('Nenhum documento selecionado para conferência, verifique!')
		}
		const numeros = await formataListas(registrosSelecionados.toString());

		let sWhere = ''
		sWhere += ` AND NF_CONF_ENTRA.QTDE_CONFERIDA <> NF_CONF_ENTRA.QTDE`;
		sWhere += ` AND NF_CONF_ENTRA.DOCTO_S IN (${numeros})`

		const separador = "' - '"

		const sql = {
			camposSelect: [
				"NF_CONF_ENTRA.DOCTO_S DOCUMENTO",
				`MATERIAL.CODIGO || ${separador} || MATERIAL.DESCRICAO CODIGO`,
				`MATERIAL.CODIGO2`,
				`CADCOR.COR || ${separador} || CADCOR.DESCRICAO COR`,
				"NF_CONF_ENTRA.QUALIDADE",
				"NF_CONF_ENTRA.LOTE",
				"NF_CONF_ENTRA.QTDE",
				"NF_CONF_ENTRA.QTDE_CONFERIDA",
				"NF_CONF_ENTRA.DOCTO_S NUMERO",
				"'' TIPO_CONF",
				"NF_CONF_ENTRA.DT_FAB",
				"NF_CONF_ENTRA.LOTE_INTERNO",
				"NF_CONF_ENTRA.TONALIDADE",
				"NF_CONF_ENTRA.OBS",
				"NF_CONF_ENTRA.BARRA",
				"NF_CONF_ENTRA.DT_VAL",
				"NF_CONF_ENTRA.PESO_BRUTO",
				"NF_CONF_ENTRA.VALOR CUSTO",
			],
			tabela: "NF_CONF_ENTRA",
			leftJoin: [
				{
					tabela: "MATERIAL",
					condicao: "NF_CONF_ENTRA.ID_MATERIAL = MATERIAL.ID_MAT",
				},
				{
					tabela: "CADCOR",
					condicao: "NF_CONF_ENTRA.ID_COR = CADCOR.ID_COR",
				},
			],
			where: [`1=1 ${sWhere}`],
			orderBy: ['NF_CONF_ENTRA.DOCTO_S ASC']
		};

		const dados = await retornaJsonPesquisaPadrao(JSON.stringify(sql));

		dados.map((item) => {
			return item.QTDE_PENDENTE = item.QTDE - item.QTDE_CONFERIDA
		})

		$('#tabelaItens').DataTable({
			order: [8, 'asc'],
			info: false,
			destroy: true,
			searching: false,
			lengthChange: false,
			paging: false,
			pageLength: 6,
			ordering: false,
			sort: false,
			"language": {
				"sEmptyTable": "Nenhum registro encontrado",
				"sInfo": "_TOTAL_ registros",
				"sInfoEmpty": " 0 registros",
				"sInfoFiltered": "(Filtrados de _MAX_ registros)",
				"sInfoPostFix": "",
				"sInfoThousands": ".",
				"sLengthMenu": "_MENU_ resultados",
				"sLoadingRecords": "Carregando...",
				"sProcessing": "Processando...",
				"sZeroRecords": "Nenhum registro encontrado",
				"sSearch": "Pesquisar",
				"oPaginate": {
					"sNext": "Próximo",
					"sPrevious": "Anterior",
					"sFirst": "Primeiro",
					"sLast": "Último"
				},
				"oAria": {
					"sSortAscending": ": Ordenar colunas de forma ascendente",
					"sSortDescending": ": Ordenar colunas de forma descendente"
				}
			},
			"autoWidth": true,
			"data": dados,
			"columns": columnsItens,
			"columnDefs": [
				{
					targets: [9, 10, 11, 12, 13, 14, 15, 18],
					visible: false
				},
				{
					targets: [6],
					render(data, type, row, meta) {
						if (row.LOTE == '000000' && $('#selectConferencia').val() !== 'ConfTudo') {
							return '<div class="">' +
								`<span>${data}</span>` +
								`<i class="ml-2 fas fa-check adicionaQtdePesquisaMaterial acaoIcon" id="adicionaQtdePesquisaMaterial${meta.row}" style="font-size: 18px; margin-top: 0 !important;"></i>` +
								'</div>';
						} else {
							return data
						}
					}
				},
			],
			rowCallback: async function (row, data) {
				if ($('#selectConferencia').val()) {
					let indexColuna = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');
					if (indexColuna === -1) {
						indexColuna = 6
					}
					let colunaConferida = $(`td:eq(${indexColuna})`, row);
					let colunaTipoConferencia = $(row).find('td').eq(9);

					colunaTipoConferencia.text($('#selectConferencia').val() || 'N/A');

					let table = $('#tabelaItens').DataTable();
					let rowData = table.row(row).data();
					rowData.TIPO_CONF = $('#selectConferencia').val();

					table.row(row).data(rowData);

					switch ($('#selectConferencia').val()) {
						case 'ConfTudo':
							$(row).css('background-color', 'green');
							colunaConferida.css('color', 'var(--font-color)').text(data.QTDE);
							data.QTDE_CONFERIDA = data.QTDE;
							data.QTDE_PENDENTE = 0;
							const table = $('#tabelaItens').DataTable();
							table.row(row).data(data);
							break;

						case 'Rejeitar':
							$(row).css({
								'background-color': 'red',
								'text-decoration': 'line-through'
							}).addClass('no-click');
							colunaConferida.css('color', 'var(--font-color)');
							break;

						case 'ConfManual':
							colunaConferida.css('display', 'flex');
							colunaConferida.empty().append(
								$('<input>', {
									type: 'text',
									min: 0,
									class: 'input-default focus form-control text-right txtQtdeItens',
									value: data.QTDE_CONFERIDA || '0',
									change: function () {
										if (data.QTDE_CONFERIDA > data.QTDE) {
											msgAlerta('Quantidade excedida, verifique!')
										}
										data.QTDE_CONFERIDA = $(this).val();
										rowData.QTDE_CONFERIDA = $(this).val()
									},
								}).css({
									width: '90%',
									'box-sizing': 'border-box'
								}),
								$('<span>', {
									type: 'button',
									min: 0,
									class: 'fas fa-check adicionaQtdePesquisaMaterial acaoIcon mt-2 ml-2 pt-1',
									value: data.QTDE_CONFERIDA || '0',
									change: function () {
										data.QTDE_CONFERIDA = $(this).val();
										rowData.QTDE_CONFERIDA = $(this).val()
									}
								}).css({
									width: '10%',
									'box-sizing': 'border-box'
								})
							);
							break;

						case 'ConfBipando':
							break;
					}
				}
			},
		});

		const colunasInvisiveis = JSON.parse(
			localStorage.getItem("colunasInvisiveisRelatorios")
		);

		$("#tabelaItens_wrapper").prepend(
			'<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>'
		);

		$("#buttonColVisItens").on("click", async function () {
			$.LoadingOverlay("show");
			$("#modal-ColunasVisiveis").modal("show");
			$.LoadingOverlay("hide");
		});

		$("#buttonColVisItens").prop("title", "Configurar colunas");

		$("#tabelaItens")
			.DataTable()
			.columns()
			.every(function () {
				if (
					colunasInvisiveis.tabelaItens.indexOf(this.dataSrc()) != -1
				) {
					this.visible(false);
				}
			});

		$('.txtQtdeItens').on('blur', function () {
			try {
				const indexColumnPend = encontraIndexColuna('tabelaItens', 'Qtde_Pendente');
				const index = $(this).parents()[1]._DT_RowIndex
				if ($(this).val() === '') {
					$(this).val(0)
				}
				if ($(this).val() < '0') {
					$(this).val(0)
				}
				let qtdeTot = 0;
				const dados = $("#tabelaItens").DataTable().data().toArray()[index]
				qtdeTot = $('.txtQtdeItens').eq(index).val() == '' ? 0 : parseFloat($('.txtQtdeItens').eq(index).val());
				let linha = $('#tabelaItens').DataTable().row('.selected');

				if (qtdeTot > dados.QTDE) {

					//TRATAR PARA QUANTIDADE MAIOR QUE EXISTE
					// $(this).val(dados.QTDE)
					$($('.txtQtdeItens')[index]).val(0)
					$($('.txtQtdeItens')[index]).attr('value', 0)
					dados.QTDE_CONFERIDA = 0
					linha.cell(linha.index(), indexColumnPend).data(dados.QTDE).draw(false);
					return msgAlerta('Quantidade excedida, verifique!')
				} else if (qtdeTot === 0) {

					//ATUALIZAR CAMPO PARA QTDE = 0 
					$($('.txtQtdeItens')[index]).val(0)
					$($('.txtQtdeItens')[index]).attr('value', 0)
					dados.QTDE_CONFERIDA = 0
					linha.cell(linha.index(), indexColumnPend).data(dados.QTDE).draw(false);
				} else if (qtdeTot < 0) {

					$($('.txtQtdeItens')[index]).val(0)
					$($('.txtQtdeItens')[index]).attr('value', 0)
					dados.QTDE_CONFERIDA = 0
					linha.cell(linha.index(), indexColumnPend).data(dados.QTDE).draw();
					return msgAlerta('Quantidade não pode ser menor que 0, verifique!')
				} else if (qtdeTot > 0 && qtdeTot < dados.QTDE) {

					$($('.txtQtdeItens')[index]).val(qtdeTot)
					$($('.txtQtdeItens')[index]).attr('value', qtdeTot)
					dados.QTDE_CONFERIDA = qtdeTot
					linha.cell(linha.index(), indexColumnPend).data(TruncaDecimaisNova(2, (dados.QTDE - qtdeTot))).draw(false);
				} else if (qtdeTot > 0 && qtdeTot === dados.QTDE) {

					$($('.txtQtdeItens')[index]).val(qtdeTot)
					$($('.txtQtdeItens')[index]).attr('value', qtdeTot)
					dados.QTDE_CONFERIDA = qtdeTot
					linha.cell(linha.index(), indexColumnPend).data(TruncaDecimaisNova(2, (dados.QTDE - qtdeTot))).draw(false);
				}
			} catch (error) {
				console.log(error)
			} finally {
				blurQtdeItens()
				$('.txtQtdeItens').maskMoney({
					decimal: '.',
					thousands: '',
					precision: 6
				});
				VerificaQuantidadeBipada()
				atualizaVolumesConferidos()
				atualizaVolumesPendentes()
				VerificaQuantidadePendente()
			}
		});

		blurQtdeItens()

		$("#modal-ColunasVisiveis").on("show.bs.modal", function () {
			const cols = [];

			let colunasInvisiveis = JSON.parse(
				localStorage.getItem("colunasInvisiveisRelatorios")
			);

			$("#tabelaItens")
				.DataTable()
				.columns()
				.every(function () {
					cols.push({
						title: $(this.header()).text(),
						data: this.dataSrc(),
					});
				});
			adicionaColunas(cols, colunasInvisiveis.tabelaItens ?? [], ['QTDE', 'QTDE_CONFERIDA', 'QTDE_PENDENTE'], ['NUMERO', 'TIPO_CONF', 'DT_FAB', 'LOTE_INTERNO', 'TONALIDADE', 'OBS', 'BARRA', 'DT_VAL', 'PESO_BRUTO', 'CUSTO']);
		});

		$('.txtQtdeItens').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 6
		});

		$("#tabelaItens tbody").on("click", "tr", async function () {
			$("#tabelaItens tbody tr td")[0].click();
			$("#tabelaItens tbody tr.selected").removeClass("selected");
			$(this).addClass("selected");
		});

		eventoCliqueCheckTabelaItens()

		VerificaQuantidadeBipada()
		atualizaVolumesConferidos()
		atualizaVolumesPendentes()
		VerificaQuantidadePendente()
	}

	function blurQtdeItens() {
		$('.txtQtdeItens').on('blur', function () {
			try {
				const indexColumnPend = encontraIndexColuna('tabelaItens', 'Qtde_Pendente');
				const index = $(this).parents()[1]._DT_RowIndex
				if ($(this).val() == '') {
					$(this).val(0)
				}
				if ($(this).val() < '0') {
					$(this).val(0)
				}

				let qtdeTot = 0;
				const dados = $("#tabelaItens").DataTable().data().toArray()[index]
				qtdeTot = $('.txtQtdeItens').eq(index).val() == '' ? 0 : parseFloat($('.txtQtdeItens').eq(index).val());
				let linha = $('#tabelaItens').DataTable().row('.selected');
				if (qtdeTot > dados.QTDE) {

					//TRATAR PARA QUANTIDADE MAIOR QUE EXISTE
					$($('.txtQtdeItens')[index]).val(0)
					$($('.txtQtdeItens')[index]).attr('value', 0)
					dados.QTDE_CONFERIDA = 0
					linha.cell(linha.index(), indexColumnPend).data(dados.QTDE).draw(false);
					return msgAlerta('Quantidade excedida, verifique!')
				} else if (qtdeTot === 0) {

					//ATUALIZAR CAMPO PARA QTDE = 0
					$($('.txtQtdeItens')[index]).val(0)
					$($('.txtQtdeItens')[index]).attr('value', 0)
					dados.QTDE_CONFERIDA = 0
					linha.cell(linha.index(), indexColumnPend).data(dados.QTDE).draw(false);
				} else if (qtdeTot < 0) {

					$($('.txtQtdeItens')[index]).val(0)
					$($('.txtQtdeItens')[index]).attr('value', 0)
					dados.QTDE_CONFERIDA = 0
					linha.cell(linha.index(), indexColumnPend).data(dados.QTDE).draw(false);
					return msgAlerta('Quantidade não pode ser menor que 0, verifique!')
				} else if (qtdeTot > 0 && qtdeTot < dados.QTDE) {

					//ATUALIZAR PARA A QUANTIDADE QUE ESTOU COLOCANDO
					$($('.txtQtdeItens')[index]).val(qtdeTot)
					$($('.txtQtdeItens')[index]).attr('value', qtdeTot)
					dados.QTDE_CONFERIDA = qtdeTot
					linha.cell(linha.index(), indexColumnPend).data(TruncaDecimaisNova(2, (dados.QTDE - qtdeTot))).draw(false);
				} else if (qtdeTot > 0 && qtdeTot === dados.QTDE) {

					$($('.txtQtdeItens')[index]).val(qtdeTot)
					$($('.txtQtdeItens')[index]).attr('value', qtdeTot)
					dados.QTDE_CONFERIDA = qtdeTot
					linha.cell(linha.index(), indexColumnPend).data(TruncaDecimaisNova(2, (dados.QTDE - qtdeTot))).draw(false);
				}
			} catch (error) {
				console.log(error)
			} finally {
				blurQtdeItens()
				$('.txtQtdeItens').maskMoney({
					decimal: '.',
					thousands: '',
					precision: 6
				});
				VerificaQuantidadeBipada()
				atualizaVolumesConferidos()
				atualizaVolumesPendentes()
				VerificaQuantidadePendente()
			}
		});
	}

	function adicionaColunas(colunas, invisiveis, desabilitadas = [], checkedPadrao = []) {
		$('#colunasInvisiveis').html('');
		colunas.forEach((coluna, i) => {
			$('#colunasInvisiveis').html(`
            ${$('#colunasInvisiveis').html()}
            <label htmlFor="txt${coluna.data}" class="col-3 labelColunasInvisiveis icheck-primary" title='Coluna ${coluna.title}'>
                <input ${desabilitadas.includes(coluna.data) ? 'disabled readonly' : ''} ${checkedPadrao.includes(coluna.data) ? 'disabled readonly checked' : ''} type="checkbox" value=${i} name="txt${coluna.data}" id="txt${coluna.data}" />
                <label for="txt${coluna.data}">${coluna.title}</label>
            </label>
        `);
			if (invisiveis) {
				if (invisiveis.filter((invisivel) => invisivel == coluna.data)[0] == coluna.data) {
					$(`#txt${coluna.data}`).attr('checked', true);
				}
			}
		});
	}

	$('.txtQtdeItens').maskMoney({
		decimal: '.',
		thousands: '',
		precision: 6
	});

	$('#btnConferir').on('click', async function () {
		$('#txtQuantidadeBipada').val(0)
		$('#txtVolumesConferidos').val(0)

		if ($('#selectConferencia').val() !== 'ConfBipando') {
			$('#CampoConferencia').addClass('d-none')
		} else {
			$('#CampoConferencia').removeClass('d-none')
		}
		if ($('#selectConferencia').val() === 'ConfTudo') {
			await senhaSupervisor('Existem itens selecionados com a opção "Conferir Tudo", coloque a senha de supervisor para poder continuar!',
				async () => conferirItens()
			)
		} else {
			await conferirItens()
		}
	})

	if (await CopiaParametro('VENDA', 44) == 1) {
		$('#PesquisabarraProduto').show();
	} else {
		$('#PesquisabarraProduto').hide();
	}

	// async function VerificaQuantidade() {
	// 	const quantidade = $("#tabelaItens")
	// 		.DataTable()
	// 		.column(5, {})
	// 		.data()
	// 		.sum();
	// 	$('#txtQuantidadeBipada').val(+TruncaDecimaisNova(2, quantidade));
	// }

	async function BarraEncontrada(barraBipada) {
		const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');

		if (barraBipada != "") {
			const dados = $("#tabelaItens").DataTable().rows().data().toArray();

			const ebarralog = await retornaBarraLogLida(barraBipada) == "barra_log";

			if (!ebarralog && bApenasBarraLog) {
				msgAlerta('Barra log não encontrada, impossível continuar!');
				return;
			}

			let sBarraBipada = barraBipada;
			if (ebarralog) {
				sBarraBipada = await extraiBarra28(sBarraBipada);
			}
			let qtde = ebarralog ? 1 : (pegaValor('#txtQuantidade') > 0 ? parseFloat(pegaValor('#txtQuantidade')) : 1);
			let indiceEncontrado;
			// if ($("#radioProduto").prop("checked")) {
			// 	indiceEncontrado = dados.findIndex(
			// 		(item) =>
			// 			(item[5] == sBarraBipada ||
			// 				item[6] == sBarraBipada ||
			// 				item[7] == sBarraBipada ||
			// 				(item[6] == sBarraBipada.substr(0, 6) && ebarralog)) && ((estornaQuantidade == 'true') || (item[10] < item[4]))
			// 	);
			// } else 
			// {
			indiceEncontrado = dados.findIndex(
				(item) =>
					// item.BARRA == sBarraBipada ||
					item.LOTE == sBarraBipada
			);
			// }

			if (indiceEncontrado !== -1) {
				if ((!$("#radioProduto").prop("checked")) && (!estornaQuantidade)) {
					msgAlerta('Barra já lida, impossível continuar.');
					return;
				}
				const dadosItem = $("#tabelaItens")
					.DataTable()
					.row(indiceEncontrado)
					.data();

				if (dadosItem.QTDE_PENDENTE === 0) {
					return msgAlerta('Lote já foi conferido, impossível continuar!')
				}

				switch (dadosItem.TIPO_CONF) {
					case 'Rejeitar': {
						$('#txtConferencia').val('')
						throw msgAlerta('Nota previamente rejeitada, impossível continuar!')
					}
					case 'ConfManual': {
						$('#txtConferencia').val('')
						throw msgAlerta('Nota previamente configurada para conferir manualmente, impossível continuar!')
					}
					case 'ConfTudo': {
						$('#txtConferencia').val('')
						throw msgAlerta('Nota previamente conferida, impossível continuar')
					}
				}

				if (!$("#radioProduto").prop("checked")) {
					qtde = dadosItem.QTDE_PENDENTE;
				}
				const barraBipada = false;

				if (utilizaBarraLog) {
					if ((!(estornaQuantidade == 'true')) && (await barraJaEstaBipada($('#txtConferencia').val(), estornaQuantidade == 'true'))) {
						return;
					}

					await adicionaBarraBipada(
						{
							codigo: dadosItem.CODIGO,
							cor: dadosItem.COR,
							tam: dadosItem.TAM,
							barra: $('#txtConferencia').val(),
						}
					);
				}

				if (((dadosItem.QTDE_CONFERIDA + qtde) <= dadosItem.QTDE) && estornaQuantidade == 'false') {
					$('#txtQuantidade').val('1');
					dadosItem.QTDE_CONFERIDA += qtde;
					dadosItem.QTDE_PENDENTE -= qtde;
					SomAlerta(BASE_URI, false);
				} else if (((dadosItem.QTDE_CONFERIDA - qtde) >= 0) && estornaQuantidade == 'true') {
					$('#txtQuantidade').val('1');
					dadosItem.QTDE_CONFERIDA -= qtde;
					estornaBarraBipada($('#txtConferencia').val());
					SomAlerta(BASE_URI, false);
				} else if (dadosItem.QTDE_CONFERIDA == 0 && estornaQuantidade == 'true') {
					$('#txtQuantidade').val('1');
					msgAlerta(`Item ${dadosItem.CODIGO} do lote: ${dadosItem.LOTE} sem quantidade para estornar, verifique!`);
					estornaBarraBipada($('#txtConferencia').val());
					SomAlerta(BASE_URI, true);
				} else {
					$('#txtQuantidade').val('1');
					SomAlerta(BASE_URI, true);
					msgAlerta(
						`Quantidade total do item: ${dadosItem.CODIGO} e lote: ${dadosItem.LOTE} já conferida`,
						null,
						null,
						() => {
							$("#txtConferencia").focus();
							if (bRFID) {
								bRFIDAbort = true;
								zeraQtdeConf();
							}
						}
					);
					$("#txtConferencia").val("");
				}

				if (!barraBipada) {
					$('#txtQuantidade').val('1');
					$("#tabelaItens")
						.DataTable()
						.row(indiceEncontrado)
						.data(dadosItem);
					$($("#tabelaItens tbody tr")[indiceEncontrado]).click();
				}

				$("#txtConferencia").val("");
				$("#txtConferencia").focus();
				// await VerificaQuantidade();
				VerificaQuantidadeBipada();

				const cellIndex = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');

				if (dadosItem.QTDE > dadosItem.QTDE_CONFERIDA) {
					$('#tabelaItens .selected')[0].cells[cellIndex].style.color = 'red';
				} else {
					$('#tabelaItens .selected')[0].cells[cellIndex].style.color = 'var(--font-color)';
					$('#tabelaItens .selected').css('background-color', 'green');
					$("#tabelaItens tbody tr.selected").removeClass("selected");
				}

				const table = $('#tabelaItens').DataTable()
				const rowNode = table.row(indiceEncontrado).node()
				$(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })

			} else {
				$('#txtQuantidade').val('1');
				SomAlerta(BASE_URI, true);
				if (!bRFID) {
					msgAlerta("Nenhuma barra localizada", null, null, () => {
						$("#txtConferencia").focus();
					});
				} else {
					bRFIDAbort = true;
					if ($("#txtConferencia").val() != '') {
						barraNaoEncontrada.push($("#txtConferencia").val());
					}
					$("#txtConferencia").focus();
					$("#txtConferencia").val("");
					return false;
				}
				$("#txtConferencia").val("");
			}

		}
	}

	function encontraIndexColuna(tableId, title) {
		const headers = $(`#${tableId} th`);

		const targetHeader = headers.filter((index, header) => {
			return $(header).css('display') !== 'none' && header.innerText === title;
		});

		return targetHeader.length > 0 ? targetHeader.index() : -1;
	}

	function eventoCliqueCheckTabelaItens() {
		$("#tabelaItens").on("click", ".adicionaQtdePesquisaMaterial", async function () {
			try {
				const indexColumn = encontraIndexColuna('tabelaItens', 'Qtde_Conferida');

				const $linha = $(this).closest('tr').index();

				const index = $("#tabelaItens tbody tr.selected").index()
				const linha = $("#tabelaItens").DataTable().rows(index).data()[0]
				if (linha.QTDE_CONFERIDA > linha.QTDE) {
					msgAlerta("Quantidade excedida, verifique");
					return;
				} else if (linha.QTDE_CONFERIDA == linha.QTDE) {
					linha.QTDE_CONFERIDA = TruncaDecimaisNova(2, (linha.QTDE_CONFERIDA - linha.QTDE))
					linha.QTDE_PENDENTE = TruncaDecimaisNova(2, (linha.QTDE_PENDENTE + linha.QTDE))

					$('#tabelaItens').DataTable().row(index).data(linha).draw(false);
					$('#tabelaItens .selected')[0].cells[indexColumn].style.color = 'var(--font-color)';
					$("#tabelaItens tbody tr.selected").css("background-color", 'transparent')
					$("#tabelaItens tbody tr.selected").removeClass("selected");

				} else if (linha.QTDE > 0) {
					linha.QTDE_CONFERIDA = (TruncaDecimaisNova(2, linha.QTDE_CONFERIDA) + linha.QTDE_PENDENTE)
					linha.QTDE_PENDENTE = TruncaDecimaisNova(2, (linha.QTDE - linha.QTDE_CONFERIDA))

					$('#tabelaItens').DataTable().row(index).data(linha).draw(false);
					$('#tabelaItens .selected')[0].cells[indexColumn].style.color = 'var(--font-color)';
					$("#tabelaItens tbody tr.selected").css("background-color", 'green')
					$("#tabelaItens tbody tr.selected").removeClass("selected");
				}
			} catch (error) {
				console.log(error)
			} finally {
				blurQtdeItens()
				$('.txtQtdeItens').maskMoney({
					decimal: '.',
					thousands: '',
					precision: 6
				});

				VerificaQuantidadeBipada()
				atualizaVolumesConferidos()
				atualizaVolumesPendentes()
				VerificaQuantidadePendente()
			}
		});
	}

	async function LocalizaBarraGrid() {
		const barraBipada = $("#txtConferencia").val().trim();
		await BarraEncontrada(barraBipada);
	}

	$("#txtConferencia").on("blur", async function () {
		if ($(this).val() == '000000') {
			throw msgAlerta(`Você não pode bipar um lote padrão: 000000. Para isso, use a opção de conferir (✓) ao lado da quantidade na lista de itens`)
		}
		await LocalizaBarraGrid();
		atualizaVolumesConferidos()
		atualizaVolumesPendentes()
		VerificaQuantidadePendente()
	});

	$("#txtConferencia").on("keydown", async function (event) {
		if (event.key == "Enter") {
			$("#txtConferencia").trigger("blur");
		}
	});

	function retornaTipoConf(item) {
		if (item.TIPO_CONF === 'Rejeitar') {
			return 'R'
		} else {
			return 'S'
		}
	}

	function retornaTabelaEntrada() {
		const tabela = $('#tabelaItens').DataTable().rows().data().toArray()

		const objetoConferencia = tabela.map((item, i) => {
			return {
				NUM_DOCTO: $('#txtDocumentoEntrada').val(),
				DOCTO: item.NUMERO,
				CODIGO: item.CODIGO.split(' ')[0],
				COR: item.COR.split(' ')[0],
				QUALIDADE: item.QUALIDADE,
				QTDE: $('#selectConferencia').val() === 'Rejeitar' ? 0 : item.QTDE_CONFERIDA,
				QTDE_REJEITADA: $('#selectConferencia').val() === 'Rejeitar' ? item.QTDE_PENDENTE : 0,
				LOTE: item.LOTE,
				DEPOSITO: pegaChave('#txtDepositoEntrada'),
				CODBAIXA: pegaChave('#txtTipoMovEntrada'),
				IDEMPRESA: pegaChave('#txtEmpresaEntrada'),
				CONFERIDA: retornaTipoConf(item),
				DT_FAB: item.DT_FAB,
				LOTE_INTERNO: item.LOTE_INTERNO,
				TONALIDADE: item.TONALIDADE,
				OBS: item.OBS,
				BARRA: item.BARRA,
				DT_VAL: item.DT_VAL,
				PESO_BRUTO: item.PESO_BRUTO,
				CUSTO: item.CUSTO,
			}
		}).filter(item => item)

		const totalPorDocumento = {};
		const conferidaPorDocumento = {};

		tabela.forEach(item => {
			const numero = item.NUMERO;
			const quantidade = item.QTDE;

			if (totalPorDocumento[numero]) {
				totalPorDocumento[numero] += parseFloat(quantidade);
			} else {
				totalPorDocumento[numero] = parseFloat(quantidade);
			}
		});

		tabela.forEach(item => {
			const numero = item.NUMERO;
			const quantidade = item.QTDE_CONFERIDA;

			if (conferidaPorDocumento[numero]) {
				conferidaPorDocumento[numero] += parseFloat(quantidade);
			} else {
				conferidaPorDocumento[numero] = parseFloat(quantidade);
			}
		});

		objetoConferencia.forEach(conf => {
			const numero = conf.DOCTO;
			const quantidadeTotal = parseFloat(totalPorDocumento[numero]) || 0;
			const conferidaTotal = parseFloat(conferidaPorDocumento[numero]) || 0;

			if (quantidadeTotal > conferidaTotal && conferidaTotal != 0 && conf.CONFERIDA !== 'R') {
				conf.CONFERIDA = "F";
			} else if (conferidaTotal === 0 && $('#selectConferencia').val() === 'Rejeitar') {
				conf.CONFERIDA = 'R'
			} else if (conferidaTotal === 0) {
				conf.CONFERIDA = 'P'
			}
		});

		return objetoConferencia;
	}

	async function gravarConferencia() {
		try {
			if ($('#selectConferencia').val() !== 'Rejeitar') {
				if (!$('#txtDepositoEntrada').val()) {
					return msgAlerta('Necessário informar um depósito de entrada, verifique!')
				}
			}
			if (!$('#txtTipoMovEntrada').val()) {
				return msgAlerta('Necessário informar um tipo de movimento, verifique!')
			}
			const objeto = retornaTabelaEntrada();
			const body = {
				materiais: objeto
			}
			const response = await requisicao('POST',
				`/sisplan/estoque/v1/transferenciamercadorias?`,
				`TIPO=ENTRADA&COD_USUARIO=${getCookie('cod_usuario')}&TIPO_CONF=${$('#selectConferencia').val()}`,
				JSON.stringify(body)
			);
			if (!response) {
				return;
			}

			if (response.status != 200) {
				const jsonStr = response.json();
				msgErro(jsonStr.mensagem);
				return;
			}

			toastr.success(
				'Entrada de mercadoria efetuada com sucesso!',
				'Confirmação', {
				toastClass: 'alert',
				iconClasses: {
					error: 'alert-error',
					info: 'alert-info',
					success: 'alert-success',
					warning: 'alert-warning'
				},
				positionClass: "toast-top-center",
				progressBar: true,
				timeOut: 3000,
				fadeOut: 1000,
				onHidden() {
					if ($.fn.DataTable.isDataTable('#tabelaItens')) {
						$('#tabelaItens').DataTable().destroy();
						$('#tabelaItens').empty();
					};
					$('#btnBuscarNotas').trigger('click')
					$('#txtDepositoEntrada').val('')
				}
			}
			).css({
				"margin-top": "20%",
				"width": "500px",
				"max-width": "500px"
			});

		} catch (error) {
			console.error(error);
			window.location.href = `${BASE_URI}/mercadorias`;
		}
	}

	$('#btnGravarConferencia').on('click', async function () {
		try {
			$('#btnGravarConferencia').prop('disabled', true);
			$.LoadingOverlay('show');
			try {
				await gravarConferencia();

			} catch (error) {
				console.error(error);
			}

		} finally {
			$('#btnGravarConferencia').prop('disabled', false);
			$.LoadingOverlay('hide');
		}
	});

	async function faturaNFe() {
		try {
			$.LoadingOverlay("show");

			let nota = {};
			nota.NATUREZA = pegaChave('#txtNatureza');
			nota.CLIENTE = $('#txtCliente').val();
			nota.NUMERO = numeroDocNota ? numeroDocNota : $('#txtDocumento').val();
			nota.TRANSFERENCIA = 'S';
			nota.TIPOITEM = 'M';
			nota.OPERACAO = $('#txtOperacao').val();
			nota.TABELA = tabelaPadrao;

			let jsonNota = JSON.stringify(nota);

			parent.abrirEmNovaAbaIFrame('Faturamento Geral', `${BASE_URI}/faturamento/`, btoa(jsonNota))

		} catch (error) {
			console.log(error);;
		} finally {
			$('#modalFaturarTransferencia').modal('hide');
			$.LoadingOverlay("hide");
			window.location.href = `${BASE_URI}/mercadorias`
		}
	}

	$('#btnGerarNFe').on('click', async function () {
		if ($('#tabelaEnvio').DataTable().data().length === 0) {
			throw msgAlerta('Nenhum movimento para gerar nota, verifique!')
		}
		const { codcli, nome } = await buscaEmpresaDestino(pegaChave('#txtEmpresaSaida'));
		insereValor('#txtCliente', codcli, nome);
		$('#txtCliente').attr('disabled', true)
		$('#btnCliente').attr('disabled', true)
		$('#btnLimpaCliente').attr('disabled', true)

		const operacao = (await buscaValor('TABPADRAO', 'VALOR', `TABELA = 'TRANSF_MERCADORIAS' AND CAMPO`, 'OPERACAO')).VALOR
		insereValor('#txtOperacao', operacao, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: operacao });
		if (operacao) {
			$('#txtNatureza').attr('disabled', true)
			$('#btnNatureza').attr('disabled', true)
			$('#btnLimpaNatureza').attr('disabled', true)
		} else {
			$('#txtNatureza').attr('disabled', false)
			$('#btnNatureza').attr('disabled', false)
			$('#btnLimpaNatureza').attr('disabled', false)
		}

		$('#btnConfirmarFatura').attr('disabled', false)
		$('#modalFaturarTransferencia').modal('show')
	})

	$('#modalFaturarTransferencia').on('hidden.bs.modal', function () {
		$('#txtCliente').val()
		$('#txtCliente').attr('disabled', false)
		$('#btnCliente').attr('disabled', false)
		$('#btnLimpaCliente').attr('disabled', false)
		$('#btnConfirmarFatura').attr('disabled', false)
	})

	$('#btnConfirmarFatura').on('click', async function () {
		try {
			$.LoadingOverlay('show')
			if ($('#txtCliente').val() === '') {
				return msgAlerta('Nenhum cliente informado, verifique!');
			}
			$('#btnConfirmarFatura').attr('disabled', true)
			if (numeroDocNota) {
				await faturaNFe()
			} else {
				await gravarMovimentacao(true)
			}
			numeroDocNota = ''
			$('#modalFaturarTransferencia').modal('hide')
		} finally {
			$.LoadingOverlay('hide')
		}
	})

	$('#btnBuscarNotas').on('click', async function () {
		const statusEnvio = $('#txtStatusEnvio').val()
		const statusConf = $('#txtStatusConf').val()
		await buscaNotas(statusConf, statusEnvio)
	})

	$('#txtDocumento').trigger('blur')
	$('#btnBuscarNotas').trigger('click')

	async function carregaValoresPadroes() {
		const pesquisa = {
			camposSelect: ['CAMPO', 'VALOR'],
			tabela: 'TABPADRAO',
			where: [`TABELA = 'ESTOQUE'`]
		}
		const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

		jsonStr.map(item => {
			switch (item.CAMPO) {
				case 'MERCAD_TIPO_ENTRADA': {
					if (item.VALOR != '') {
						insereValor('#txtTipoMovEntrada', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
					}
					break;
				}
				case 'MERCAD_TIPO_SAIDA': {
					if (item.VALOR != '') {
						insereValor('#txtTipoMovSaida', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
					}
					break;
				}
			}
		});
	};



})
