$(document).ready(async function () {

  $('#btnFiltrosEnvioReceber').on('click', function () {
    $('#modalFiltrosReceberEnvio').modal('show');
  });

  $('#btnFiltrosConsultaReceber').on('click', function () {
    $('#modalFiltrosReceberConsulta').modal('show');
  });

  $('#btnFiltrosObservacaoTitulos').on('click', function () {
    $('#modalFiltrosReceberObservacaoTitulos').modal('show');
  });

  $('#btnFiltrosEnvioNotaFiscalSaida').on('click', function () {
    $('#modalFiltrosNFESaida').modal('show');
  });

  $('#btnFiltrosEnvioNFCE').on('click', function () {
    $('#modalFiltrosNFCE').modal('show');
  });

  $('#btnFiltrosEnvioNotaEntrada').on('click', function () {
    $('#modalFiltrosNotaEntrada').modal('show');
  });

  $('#btnFiltrosPagarEnvio').on('click', function () {
    $('#modalFiltrosPagarEnvio').modal('show');
  });

  $('#btnFiltrosEnvioEntidade').on('click', function () {
    $('#modalFiltrosEnvioEntidade').modal('show');
  });

  $('.btnFiltrosObservacaoCliente').on('click', function () {
    $('#modalFiltrosObservacaoCliente').modal('show');
  });

  $('#btnConsultarNFE').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaNfeEnvio();
    } finally {
      $('#modalFiltrosNFESaida').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarNFCE').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaNfceEnvio();
    } finally {
      $('#modalFiltrosNFCE').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarReceberEnvio').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaReceberEnvio();
    } finally {
      $('#modalFiltrosReceberEnvio').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarReceberConsulta').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaReceberConsulta();
    } finally {
      $('#modalFiltrosReceberConsulta').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarReceberObservacaoTitulos').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaReceberObsTitulos();
    } finally {
      $('#modalFiltrosReceberObservacaoTitulos').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarNotaEntradaEnvio').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaNotaEntradaEnvio();
    } finally {
      $('#modalFiltrosNotaEntrada').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarPagarEnvio').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaPagarEnvio();
    } finally {
      $('#modalFiltrosPagarEnvio').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarEnvioEntidade').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaEntidadeEnvio();
    } finally {
      $('#modalFiltrosEnvioEntidade').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultarObservacaoCliente').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await consultaEntidadeObs();
    } finally {
      $('#modalFiltrosObservacaoCliente').modal('hide');
      $.LoadingOverlay('hide');
    }
  });

  $("#divTabs").on("click", ".abaLink", function () {
    const tabClicada = $(this).attr("id");
    ativaDesativaTabs(tabClicada);
  });

  $("#divTabsSubMenuEntidade, #divTabsSubMenuPagar, #divTabsSubMenuNotaEntrada, #divTabsSubMenuNFCE, #divTabsSubMenuNFE, #divTabsSubMenuReceber").on("click", ".abaLink", function () {
    const tabClicada = $(this).attr("id");
    ativaDesativaSubTabs(tabClicada);
  });

  function ativaDesativaTabs(tabAtivada) {
    const listaTabs = $("#divTabs .abaLink").toArray();

    listaTabs.forEach(elemento => {
      const idDiv = $(elemento).attr("aria-controls");
      if (elemento.id != tabAtivada) {
        $(`#${idDiv}`).addClass("d-none");
      } else {
        $(`#${idDiv}`).removeClass("d-none");
      }
    })
  };  

  function ativaDesativaSubTabs(tabAtivada) {
    const listaTabs = $("#divTabsSubMenu .abaLink").toArray();

    listaTabs.forEach(elemento => {
      const idDiv = $(elemento).attr("aria-controls");
      if (elemento.id != tabAtivada) {
        $(`#${idDiv}`).addClass("d-none");
      } else {
        $(`#${idDiv}`).removeClass("d-none");
      }
    })
  };

  function criaPesquisasFiltroNFEEnvio() {
    componenteFiltro('nota', true, true, 'FaturaNFE');
    componenteFiltro('venda', true, true, 'CodvenNFE');
  };

  function criaPesquisasFiltroNFCEEnvio() {
    componenteFiltro('notaNfce', true, true, 'FaturaNFCE');
    componenteFiltro('venda', true, true, 'CodvenNFCE');
  };

  function criaPesquisasFiltroReceberEnvio() {
    componenteFiltro('recSenior', true, true, 'NumeroReceberEnvio');
    componenteFiltro('faturaNfeSenior', true, true, 'FaturaNFEReceberEnvio');
    componenteFiltro('faturaNfceSenior', true, true, 'FaturaNFCEReceberEnvio');
    componenteFiltro('moeda', true, true, 'MoedaReceberEnvio');
    componenteFiltro('historico', true, true, 'HistoricoReceberEnvio');
    componenteFiltro('venda', true, true, 'CodvenReceberEnvio');
  };

  function criaPesquisasFiltroReceberConsulta() {
    componenteFiltro('recSenior', true, true, 'NumeroReceberConsulta');
  };

  function criaPesquisasFiltroReceberObservacaoTitulos() {
    componenteFiltro('recSenior', true, true, 'NumeroReceberObservacaoTitulos');
    componenteFiltro('clienteSenior', true, true, 'ClienteReceberObservacaoTitulos');
  };

  function criaPesquisasFiltroNotaEntraEnvio() {
    componenteFiltro('notaEntra', true, true, 'FaturaNotaEntradaEnvio');
  };

  function criaPesquisasFiltroPagarEnvio() {
    componenteFiltro('pagtoSenior', true, true, 'NumeroPagarEnvio');
  };

  function criaPesquisasFiltroEntidadeEnvio() {
    componenteFiltro('clienteSenior', true, true, 'EnvioEntidade');
  };

  function criaPesquisasFiltroEntidadeObservacaoCliente() {
    componenteFiltro('clienteSenior', true, true, 'ObservacaoCliente');
  };

  async function alterarStatus(idMapeamento) {
    const url = `/sisplan/senior/v1/alterarstatus?`;
    const params = `ID_MAPEAMENTO=${idMapeamento}`;
    try {

      if (idMapeamento == "") {
        throw new Error("Não é possível alterar o status desse registro, ele não se encontra na tabela de Mapeamento.");
      }

      const response = await requisicao("PUT", url, params, "", 60000);

      if (!response) {
        throw new Error("Não foi possível alterar o status do registro.");
      }

      if (response.status != 200) {
        const jsonRetorno = await response.json();
        throw new Error(jsonRetorno.mensagem);
      }

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }
  }

  async function reenviarRegistro(idMapeamento) {
    const url = `/sisplan/senior/v1/reenviarregistro?`;
    const params = `ID_MAPEAMENTO=${idMapeamento}`;
    try {

        if (idMapeamento == "") {
          throw new Error("Não é possível reenviar o registro, ele não se encontra na tabela de Mapeamento.");
        }

        const response = await requisicao("PUT", url, params, "", 60000);

        if (!response) {
          throw new Error("Não foi possível reenviar o registro.");
        }

        if (response.status != 200) {
          const jsonRetorno = await response.json();
          throw new Error(jsonRetorno.mensagem);
        }

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Alterar Status" id="btnAlterarStatus">Alterar Status</button>     ' +
      '    <button class="dropdown-item" type="button" title="Reenviar" id="btnReenviar">Reenviar</button>  ' +
      '    <button class="dropdown-item" type="button" title="Observação" id="btnObservacao">Observação</button>     ' +
      '</div>';
    return retorno;
  };

 async function direcionaConsulta(tabAtiva) {
    switch (tabAtiva) {
      case "tabNFESaida":
        await consultaNfeEnvio();
        break;
      case "tabNFCE":
        await consultaNfceEnvio();
        break;
      case "tabEnvioReceber":
        await consultaReceberEnvio();
        break;
      case "tabConsultaReceber":
        await consultaReceberConsulta();
        break;
      case "tabObservacaoTitulosReceber":
        await consultaReceberObsTitulos();
        break;
      case "tabNotaEntradaEnvio":
        await consultaNotaEntradaEnvio();
        break;
      case "tabPagarEnvio":
        await consultaPagarEnvio();
        break;
      case "tabEnvioEntidade":
        await consultaEntidadeEnvio(); 
        break;
      case "tabEnvioObservacaoCliente":
      case "tabConsultaObservacaoCliente":
        await consultaEntidadeObs();
        break;
      default:
        break;
    }
  }

  function retornaCorStatus(status) {
    switch (status) {
      case "SIM":
      case "INTEGRADO":
      case "INSERIDO":
        return "registroIntegrado";
      case "NAO":
      case "ENVIO_PENDENTE":
      case "INSERCAO_PENDENTE":
        return "registroPendente";    
      default:
        break;  
    }
  }

  function retornaTabAtiva() {
    const idDiv = $("#divTabs .active").attr("aria-controls");
    const idSubTab = $(`#${idDiv} .abaLink.active`)[0].id;
    return idSubTab;
  }

  async function consultaNfeEnvio() {
    try {
      const colunasNfeEnvio = ["FATURA", "PROTOCOLO", "EMP_ID", "EMP_FANTASIA", "STATUS",  "MAPEAMENTO", "DTH_ULT_TENTATIVA", 
                               "TABELA",  "IMPRESSO",  "CODVEN", "OPERACAO_FISCAL", "DESC_OPER_FISCAL", "CODCLI", "CNPJ", 
                               "NOME", "COD_IMPORTADO", "CODREP", "CNPJ_REP", "NOME_REP", "COD_REP_IMPORTADO", "CODTRAN", 
                               "CNPJ_TRAN", "NOME_TRAN", "CODTRAN_IMPORTADO", "DT_CADASTRO", "DT_EMISSAO", "VALOR",  
                               "OPERACAO", "OBSERVACAO", "ID_MAPEAMENTO"];

      preencheTabela('', 'tabelaNotaFiscalSaida', 'consultanfeenvio', colunasNfeEnvio, 'NFEEnvio');
     
    } catch (error) {
      console.error(error);
      msgErro('Erro ao consultar a aba de envio das notas fiscais de saída! Erro: ' + error);
    } 
  };

  async function consultaNfceEnvio() {
    const params = await retornaFiltros('NFCEEnvio');
    try {
      const response = await requisicao("GET", "/sisplan/senior/v1/consultanfceenvio?", params, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      preencheTabela(json, 'tabelaNFCE');

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }    
  };

  async function consultaReceberEnvio() {
    try {

      const colunasReceberEnvio = ["NUMERO", "COD_INTEGRA", "EMP_ID", "EMP_FANTASIA", "STATUS", "MAPEAMENTO", "DTH_ULT_TENTATIVA",
                                   "TABELA", "FATURA", "CODVEN", "CODCLI", "COD_IMPORTADO", "CNPJ", "NOME", "COD_REC_IMPORTADO",
                                   "CODREP", "COD_REP_IMPORTADO", "CNPJ_REP", "NOME_REP", "DT_EMISSAO", "MOEDA", "DESC_MOEDA", 
                                   "HISTORICO", "DESC_HISTORICO", "VALOR",  "OPERACAO", "OBSERVACAO", "ID_MAPEAMENTO"];

      await preencheTabela('', 'tabelaEnvioReceber', 'consultareceberenvio', colunasReceberEnvio, 'ReceberEnvio');
     
    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro com a pesquisa de envio do Receber! Erro:' + error);
    } 
  };

  async function consultaReceberConsulta() {
    const params = await retornaFiltros('ReceberConsulta');
    try {
      const response = await requisicao("GET", "/sisplan/senior/v1/consultareceberconsulta?", params, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      preencheTabela(json, 'tabelaConsultaReceber');
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }  
  };

  async function consultaReceberObsTitulos() {
    const params = await retornaFiltros('ReceberObsTitulos');
    try {
      const response = await requisicao("GET", "/sisplan/senior/v1/consultareceberobstitulos?", params, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      preencheTabela(json, 'tabelaObservacaoTitulosReceber');
    } catch (error) {
      console.error(error); 
      msgAlerta(error.message);
    }  
  };

  async function consultaNotaEntradaEnvio() {
    const params = await retornaFiltros('NotaEntradaEnvio');
    try {

      const response = await requisicao("GET", "/sisplan/senior/v1/consultanotaentradaenvio?", params, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }
  
      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }
  
      preencheTabela(json, 'tabelaNotaEntradaEnvio');

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }
  };

  async function consultaPagarEnvio() {
    const params = await retornaFiltros('PagarEnvio');
    try {
      const response = await requisicao("GET", "/sisplan/senior/v1/consultapagarenvio?", params, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      preencheTabela(json, 'tabelaPagarEnvio');
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }    
  };

  async function consultaEntidadeEnvio() {
    const params = await retornaFiltros('EntidadeEnvio');
    try {

      const response = await requisicao("GET", "/sisplan/senior/v1/consultaentidadeenvio?", params, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      preencheTabela(json, 'tabelaEnvioEntidade');

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }    
  };

  async function consultaEntidadeObs() {
    const params = await retornaFiltros('EntidadeObs');
    const tabAtiva = retornaTabAtiva();

    try {

      const response = await requisicao("GET", "/sisplan/senior/v1/consultaentidadeobs?", params+`&TAB_ATIVA=${tabAtiva}`, "", 900000);

      if (!response) {
        throw new Error("Não foi possível consultar os registros.");
      }

      const json = await response.json();
      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      if (tabAtiva == "tabEnvioObservacaoCliente") {
        preencheTabela(json, 'tabelaEnvioObservacaoCliente');
      } else {
        preencheTabela(json, 'tabelaConsultaObservacaoCliente');
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message);
    }

  };

  async function retornaFiltros(aba) {
    if (aba === 'EntidadeObs') {
      const cliente = await formataListas($('#txtObservacaoCliente').val().toString());
      const status = $('input[name="statusObservacaoCliente"]:checked').val();

      return `CODCLI=${cliente}&STATUS=${status}`;
    }

    if (aba === 'EntidadeEnvio') {
      const cliente = await formataListas($('#txtEnvioEntidade').val().toString());
      const status = $('input[name="statusEnvioEntidade"]:checked').val();

      return `CODCLI=${cliente}&STATUS=${status}`;
    }

    if (aba === 'PagarEnvio') {
      const numAp = await formataListas($('#txtNumeroPagarEnvio').val().toString());
      const dtEmiIni = $('#dtEmissaoPagarDeEnvio').val();
      const dtEmiFim = $('#dtEmissaoPagarAteEnvio').val();
      const mapeado = $('input[name="mapeadoPagarEnvio"]:checked').val();
      const tabela = $('input[name="tabelaPagarEnvio"]:checked').val();
      const status = $('input[name="statusPagarEnvio"]:checked').val();

      return `NUM_PAGTO=${numAp}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&MAPEADO=${mapeado}&TABELA=${tabela}&STATUS=${status}`;
    }

    if (aba === 'NotaEntradaEnvio') {
      const fatura = await formataListas($('#txtFaturaNotaEntradaEnvio').val().toString());
      const mapeado = $('input[name="mapeadoNotaEntradaEnvio"]:checked').val();
      const status = $('input[name="statusNotaEntradaEnvio"]:checked').val();
      const dtEmiIni = $('#dtEmissaoNotaEntradaDeEnvio').val();
      const dtEmiFim = $('#dtEmissaoNotaEntradaAteEnvio').val();

      return `FATURA=${fatura}&MAPEADO=${mapeado}&STATUS=${status}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}`;
    }

    if (aba === 'NFEEnvio') {
      const fatura = await formataListas($('#txtFaturaNFE').val().toString());
      const codven = await formataListas($('#txtCodvenNFE').val().toString());
      const dtEmiIni = $('#dtEmissaoDeNFE').val();
      const dtEmiFim = $('#dtEmissaoAteNFE').val();
      const protocolo = $('input[name="protocoloNFE"]:checked').val();
      const status = $('input[name="status"]:checked').val();
      const mapeado = $('input[name="mapeado"]:checked').val();
      const impresso = $('#selectImpressoNFE').val();

      return `FATURA=${fatura}&CODVEN=${codven}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&PROTOCOLO=${protocolo}&STATUS=${status}&MAPEADO=${mapeado}&IMPRESSO=${impresso}`;
    }

    if (aba === 'NFCEEnvio') {
      const fatura = await formataListas($('#txtFaturaNFCE').val().toString());
      const codven = await formataListas($('#txtCodvenNFCE').val().toString());
      const dtEmiIni = $('#dtEmissaoDeNFCE').val();
      const dtEmiFim = $('#dtEmissaoAteNFCE').val();
      const protocolo = $('input[name="protocoloNFCE"]:checked').val();
      const status = $('input[name="statusNFCE"]:checked').val();
      const mapeado = $('input[name="mapeadoNFCE"]:checked').val();
      const impresso = $('#selectImpressoNFCE').val();

      return `FATURA=${fatura}&CODVEN=${codven}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&PROTOCOLO=${protocolo}&STATUS=${status}&MAPEADO=${mapeado}&IMPRESSO=${impresso}`;
    }

    if (aba === 'ReceberObsTitulos') {
      const status = $('input[name="statusReceberObservacaoTitulos"]:checked').val();
      const cliente = await formataListas($('#txtClienteReceberObservacaoTitulos').val().toString());
      const numero = await formataListas($('#txtNumeroReceberObservacaoTitulos').val().toString());

      return `STATUS=${status}&CLIENTE=${cliente}&NUMERO=${numero}`;
    }

    if (aba === 'ReceberConsulta') {
      const numero = await formataListas($('#txtNumeroReceberConsulta').val().toString());
      const dtEmissaoIni = $('#dtEmissaoReceberDeConsulta').val();
      const dtEmissaoFim = $('#dtEmissaoReceberAteConsulta').val();
      const tabela = $('input[name="tabelaReceberConsulta"]:checked').val();
      const status = $('input[name="statusReceberConsulta"]:checked').val();

      return `NUMERO=${numero}&DT_EMI_INI=${dtEmissaoIni}&DT_EMI_FIM=${dtEmissaoFim}&TABELA=${tabela}&STATUS=${status}`;
    }

    if (aba === 'ReceberEnvio') {
      const mapeado = $('input[name="mapeadoReceberEnvio"]:checked').val();
      const status = $('input[name="statusReceberEnvio"]:checked').val();
      const dtEmiIni = $('#dtEmissaoReceberDeEnvio').val();
      const dtEmiFim = $('#dtEmissaoReceberAteEnvio').val();
      const numero = await formataListas($('#txtNumeroReceberEnvio').val().toString());
      const faturaNfe = await formataListas($('#txtFaturaNFEReceberEnvio').val().toString());
      const faturaNfce = await formataListas($('#txtFaturaNFCEReceberEnvio').val().toString());
      const moeda = await formataListas($('#txtMoedaReceberEnvio').val().toString());
      const historico = await formataListas($('#txtHistoricoReceberEnvio').val().toString());
      const venda = await formataListas($('#txtCodvenReceberEnvio').val().toString());

      return `MAPEADO=${mapeado}&STATUS=${status}&DT_EMI_INI=${dtEmiIni}&DT_EMI_FIM=${dtEmiFim}&NUMERO=${numero}&FATURA_NFE=${faturaNfe}&FATURA_NFCE=${faturaNfce}&MOEDA=${moeda}&HISTORICO=${historico}&CODVEN=${venda}`;
    }
  }

  function atribuirFuncoesBotoesGrid(idTabela) {

    $(`#${idTabela}`).off("click", '#btnAlterarStatus');
    $(`#${idTabela}`).on('click', '#btnAlterarStatus', async function () {
      $.LoadingOverlay("show");
      const tableID = $(this).parents('table')[0].id;
      const tabAtiva = retornaTabAtiva();
      const idMapeamento = $(`#${tableID}`).DataTable().row($(this).parents('tr')).data().ID_MAPEAMENTO;
      try {
        await alterarStatus(idMapeamento);
        await direcionaConsulta(tabAtiva);
      } finally {
        $.LoadingOverlay("hide");
      }
    });

    $(`#${idTabela}`).off("click", '#btnReenviar');
    $(`#${idTabela}`).on('click', '#btnReenviar', async function () {
       $.LoadingOverlay("show");
       try {
        const tableID = $(this).parents('table')[0].id;
        const tabAtiva = retornaTabAtiva();
        const idMapeamento = $(`#${tableID}`).DataTable().row($(this).parents('tr')).data().ID_MAPEAMENTO;
         await reenviarRegistro(idMapeamento);
         await direcionaConsulta(tabAtiva);
       } finally {
         $.LoadingOverlay("hide");
       }
     });
   
     $(`#${idTabela}`).off("click", '#btnObservacao');
     $(`#${idTabela}`).on('click', '#btnObservacao', async function () {
       $.LoadingOverlay("show");
       try {
        const tableID = $(this).parents('table')[0].id;
        const observacaoRegistro = $(`#${tableID}`).DataTable().row($(this).parents('tr')).data().OBSERVACAO;
        $("#txtObservacao").val(observacaoRegistro.replaceAll('&#013;', '\r\n'));
        $("#modalObservacao").modal("show");
       } finally {
         $.LoadingOverlay("hide");
       }
     });

  }

  async function preencheTabela(data, idTabela, urlPesquisa = '', camposDataTable = [], filtros = '') {

    if ($.fn.DataTable.isDataTable(`#${idTabela}`)) {
      $(`#${idTabela}`).DataTable().destroy();
      $(`#${idTabela}`).empty();
    };

    const dataSetCols = [];

    if (camposDataTable.length <= 0) {
      if (data.length === 0) {
        msgAlerta('Nenhum registro encontrado.');
        return;
      }

      const keys = Object.keys(data[0]);

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }
    } else {
      for (var k in camposDataTable) {
        dataSetCols.push({
          'title': camposDataTable[k],
          'data': camposDataTable[k]
        });
      }
    }

    if (idTabela === 'tabelaEnvioReceber' || idTabela === 'tabelaNotaFiscalSaida') {
      return new Promise((resolve, reject) => {
        setTimeout(async () => {
          var table = $(`#${idTabela}`).DataTable({
            destroy: true,
            lengthChange: true,
            autoWidth: true,
            serverSide: true,
            processing: true,
            timeout: 100000000,
            searching: false,
            ajax: async function (data, callback, settings) {
              $.ajax({
                url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/senior/v1/${urlPesquisa}?${await retornaFiltros(filtros)}`,
                type: "GET",
                headers: { 'Authorization': 'Bearer ' + getCookie('accessToken') },
                data: {
                  "EMPRESA": getCookie('empresa'),
                  "USUARIO": getCookie('usuario').toUpperCase(),
                  "JSON": '',
                  "CLIENTE": 'N',
                  "TIPO_PESQUISA": '',
                  "AUTOCOMPLETA": 'N',
                  ...data
                },
                success: function (response) {

                  const cols = camposDataTable;
                  const dadosFormatados = response.data?.map(row => {
                    return row.reduce((obj, value, index) => {
                      obj[cols[index]] = value;
                      return obj;
                    }, {});
                  }) || [];

                  callback({
                    draw: response.draw,
                    recordsTotal: response.recordsTotal,
                    recordsFiltered: response.recordsFiltered,
                    data: dadosFormatados
                  });
                },
                error: function () {
                  console.error('Erro ao carregar os dados.');
                  callback({
                    draw: data.draw,
                    recordsTotal: 0,
                    recordsFiltered: 0,
                    data: []
                  });
                }
              });
            },
            language: {
              "sEmptyTable": "Nenhum registro encontrado",
              "sInfo": "_TOTAL_ registros",
              "sInfoEmpty": " 0 registros",
              "sInfoFiltered": "(Filtrados de MAX registros)",
              "sInfoPostFix": "",
              "sInfoThousands": ".",
              "sLengthMenu": "_MENU_ resultados",
              "sLoadingRecords": "Carregando...",
              "sProcessing": "Processando...",
              "sZeroRecords": "Nenhum registro encontrado",
              "sSearch": "Pesquisar (geral): ",
              "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
              },
              "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
              }
            },
            columns: dataSetCols,
            columnDefs: [{ 
                    targets: [0], render: function (data, type, row) { 
                        return retornaBotaoOpcoes(data); 
                      } 
                  }], 
            createdRow: function (row, data, dataIndex) {
              const status = data.STATUS;
              const mapeado = data.MAPEAMENTO;

              $("td", row).eq(4).addClass(retornaCorStatus(status));
              $("td", row).eq(5).addClass(retornaCorStatus(mapeado));
            }                
          });
          resolve(table);
        }, 500);

        atribuirFuncoesBotoesGrid(idTabela);

      });
    } else {
      $(`#${idTabela}`).DataTable({
        paging: true,
        filter: true,
        info: true,
        order: false,
        destroy: true,
        colReorder: true,
        serverside: true,
        searching: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de MAX registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar (geral): ",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "data": data,
        "columns": dataSetCols,
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
        }],
        createdRow: function (row, data, dataIndex) {
          const status = data.STATUS;
          const mapeado = data.MAPEAMENTO;

          $("td", row).eq(4).addClass(retornaCorStatus(status));
          $("td", row).eq(5).addClass(retornaCorStatus(mapeado));
        }
      });

      atribuirFuncoesBotoesGrid(idTabela);

    }    

  };

  criaPesquisasFiltroReceberEnvio();
  criaPesquisasFiltroNFCEEnvio();
  criaPesquisasFiltroNFEEnvio();
  criaPesquisasFiltroReceberConsulta();
  criaPesquisasFiltroReceberObservacaoTitulos();
  criaPesquisasFiltroNotaEntraEnvio();
  criaPesquisasFiltroPagarEnvio();
  criaPesquisasFiltroEntidadeEnvio();
  criaPesquisasFiltroEntidadeObservacaoCliente();

}); 