<div id="modal-conferencia" class="modal" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 id="myModalLabel" class="modal-title">Conferência de Venda</h5>
        <input id="txtConferencia" class="d-none" />
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row justify-content-center mt-0">
          <div class="text-center p-0">
            <div class="card px-0 pb-0 mb-3">
              <div class="row">
                <div class="col-md-12 mx-0">
                  <form id="formConf">
                    <!-- progressbar -->
                    <div class="form-card">
                      <div class="card-10" id="campostour">
                        <div class="card-body">
                          <div class="row">

                            <div class="form-group col-lg-6 col-12">
                              <label data-error="wrong" data-success="right" for="txtVendaConferencia">Venda </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" required id="txtVendaConferencia" name="txtVendaConferencia" placeholder="Venda" disabled>
                                <div class="input-group-append">
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-lg-6 col-12">
                              <label data-error="wrong" data-success="right" for="txtClienteConferencia">Cliente
                              </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" required id="txtClienteConferencia" name="txtClienteConferencia" placeholder="Cliente" disabled>
                                <div class="input-group-append">
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-lg-6 col-12">
                              <label data-error="wrong" data-success="right" for="txtBarraConferencia">Código de
                                Barras</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate " id="txtBarraConferencia" name="txtBarraConferencia" placeholder="Código de Barras" autofocus>
                              </div>
                            </div>
                            <div class="form-group col-lg-6 col-12">
                              <!-- agora tem coisa -->
                              <div class="divRFID">
                                <label data-error="wrong" data-success="right" for="divRFID">Integração RFID</label>
                                <div class="input-group">
                                  <div class="d-flex align-items-center justify-content-end mb-1" title="Integração RFID">
                                    <div class="relative">
                                      <button type="button" class="btn btn-icon-normal btn-danger d-flex align-items-center justify-content-center" style="border-radius: 4px!important; text-align: center;" id="btnIniciarEPCConferencia" name="btnIniciarEPCConferencia" data-button="absolute">
                                        <i style="font-size: 20px;" class="ph-play-thin"></i>
                                      </button>
                                    </div>
                                    <div class="relative ml-2">
                                      <button type="button" class="btn btn-icon-normal btn-danger d-flex align-items-center justify-content-center" style="border-radius: 4px!important;" id="btnPararEPCConferencia" name="btnPararEPCConferencia" data-button="absolute">
                                        <i style="font-size: 20px; " class="ph-pause-circle-thin"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-lg-6 col-12">
                              <label data-error="wrong" data-success="right" for="txtProdutoConferencia">Produto</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtProdutoConferencia" name="txtProdutoConferencia" placeholder="Produto" style="cursor: not-allowed; border-color: #a9a9a9">
                                <div class="input-group-append">
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-lg-3 col-12">
                              <label data-error="wrong" data-success="right" for="txtCorConferencia">Cor</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtCorConferencia" name="txtCorConferencia" placeholder="Cor" disabled>
                                <div class="input-group-append">
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-lg-3 col-12">
                              <label data-error="wrong" data-success="right" for="txtTamanhoConferencia">Tamanho</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtTamanhoConferencia" name="txtTamanhoConferencia" placeholder="Tamanho" disabled>
                                <div class="input-group-append">
                                </div>
                              </div>
                            </div>

                          </div>
                        </div>
                      </div>
                    </div>
                </div>
                </form>
              </div>
            </div>
            <div class="row px-2">
              <div class="col-sm-12 table-responsive">
                <table width="100%" style="width: 100%" id="tabelaImportacao" class="table table-sm table-hover table-select table-condensed">
                  <thead>
                    <tr>
                      <th>Codigo</th>
                      <th>Descrição</th>
                      <th>Cor</th>
                      <th>Desc. Cor</th>
                      <th>Tam</th>
                      <th>Qtde</th>
                      <th>Qtde Bipada</th>
                      <th>Diferença</th>
                      <th>CodCorTam</th>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
            <!-- <input type="button" id="confirmar_mov" name="confirmar_mov" class="action-button" value="Gravar" />
              <input type="button" id="limpar_mov" name="limpar_mov" class="action-button-previous" value="Desistir" /> -->
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnDesistir" style="font-size:15px;" class="btn btn-success btn-sisp btn-lg" data-dismiss="modal">Desistir</button>
        <button type="button" id="btnConfirmar" style="font-size:15px;" class="btn btn-danger btn-sisp btn-lg">Confirmar</button>
      </div>
    </div>
  </div>
</div>
<script src="<?php echo BASE_URI; ?>/plugins/jquery/jquery.min.js"></script>
<script>
  $(document).ready(async function() {

    $('#tabelaImportacao').DataTable({

      paging: false,
      filter: false,
      info: false,
      order: false,
      autoWidth: true,
      scrollY: "320px",
      destroy: true,
      "columnDefs": [{
          "targets": [8],
          "visible": false
        },
        {
          targets: '_all',
          render: function(data, type, row, meta) {
            if (row[6] == row[5]) {
              $(`#tabelaImportacao tbody>tr:eq(${meta.row}) td`).addClass('textQuantidadeBipada');
            } else {
              $(`#tabelaImportacao tbody>tr:eq(${meta.row}) td`).removeClass('textQuantidadeBipada');
            }
            return data;
          }
        }
      ],

      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      }
    });

    $('#formConf').validate({
      rules: {
        txtDocumento: {
          required: true,
        },
        txtLancamento: {
          required: true,
        },
        txtNota: {
          required: true,
        },
        txtEmpresa: {
          required: true,
        },
        txtQualidade: {
          required: true,
        },
        txtDeposito: {
          required: true,
        }
      },
      messages: {
        txtDocumento: {
          required: "Informe um número de documento."
        },
        txtLancamento: {
          required: "Informe um número de lançamento."
        },
        txtNota: {
          required: "Informe uma nota."
        },
        txtEmpresa: {
          required: "Informe uma empresa."
        },
        txtQualidade: {
          required: "Informe uma qualidade."
        },
        txtDeposito: {
          required: "Informe um depósito."
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      },
      submitHandler: async function(form, event) {
        event.preventDefault();

      }
    });

    $('#txtVendaConferencia').on('blur', async function() {
      try {
        $.LoadingOverlay("show");
        try {
          const codVen = $('#txtVendaConferencia').val();

          if (codVen == '') {
            msgErro('Necessário informar código da venda');
            return;
          }

          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ 
                        "tabela":"ITVENDA", 
                        "camposSelect":["ITVENDA.CODIGO", "PRODUTO.DESCRICAO", "ITVENDA.COR", "CADCOR.DESCRICAO DESC_COR", "ITVENDA.TAM", "ITVENDA.QUANTIDADE"], 
                        "leftJoin": [{"tabela": "PRODUTO", "CONDICAO": "PRODUTO.CODIGO = ITVENDA.CODIGO"},
                                     {"tabela": "CADCOR", "CONDICAO": "CADCOR.COR = ITVENDA.COR"}],
                        "where": ["codven = '${codVen}'"]}`,
            null
          );
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $('#tabelaImportacao').DataTable().rows().remove().draw(false);

          for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
            const element = jsonStr.RESULT[0][i];
            const sCodigoValidacao = element.CODIGO + ' - ' + element.COR + ' - ' + element.TAM;
            $('#tabelaImportacao').DataTable().row.add(
              [element.CODIGO, element.DESCRICAO, element.COR, element.DESC_COR, element.TAM, element.QUANTIDADE, 0, element.QUANTIDADE, sCodigoValidacao]
            ).draw(false);
          }

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados da venda: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    })


    $('#txtBarraConferencia').on('blur', async function() {
      const barra = $(this).val();
      if (barra == '') {
        limpaValor('#txtProdutoConferencia');
        limpaValor('#txtCorConferencia');
        limpaValor('#txtTamanhoConferencia');
        return;
      }
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela":"pa_iten", "camposSelect":[ "pa_iten.codigo", "produto.descricao", "cadcor.cor", "cadcor.descricao as descCor", "pa_iten.tam"],
                            "leftjoin": [{ "tabela" : "produto", "condicao" : "pa_iten.codigo = produto.codigo " },
                                         { "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor " }],                     
                            "where": ["BARRA = '${barra}' OR BARRACLI = '${barra}' OR BARRA28 = '${barra}' OR BARRA28 = '${barra.substring(0, 6)}'"]}`;

      try {
        try {
          const response = await requisicao('GET', url, params, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }

          insereValor('#txtProdutoConferencia', jsonStr.RESULT[0][0].CODIGO, jsonStr.RESULT[0][0].DESCRICAO);
          insereValor('#txtCorConferencia', jsonStr.RESULT[0][0].COR, jsonStr.RESULT[0][0].DESCCOR);
          insereValor('#txtTamanhoConferencia', jsonStr.RESULT[0][0].TAM);

          const sCodigoValidacao = jsonStr.RESULT[0][0].CODIGO + ' - ' + jsonStr.RESULT[0][0].COR + ' - ' + jsonStr.RESULT[0][0].TAM;
          var posicaoLista = $('#tabelaImportacao').DataTable().column(8).data().indexOf(sCodigoValidacao);

          if (posicaoLista >= 0) {
            var dataOld = $('#tabelaImportacao').DataTable().row(posicaoLista).data();
            if (dataOld[6] == dataOld[5]) {
              msgAlerta('Venda com todos os itens bipados, impossível continuar.');
              return;
            }
            dataOld[6] = dataOld[6] + 1;
            dataOld[7] = dataOld[7] - 1;
            $('#tabelaImportacao').DataTable().row(posicaoLista).data(dataOld);
          } else {
            msgErro('Barra não encontrada!');
          }


        } catch (error) {
          msgErro('Barra não encontrada!');
          console.error(error);
        }
      } finally {
        limpaValor('#txtBarraConferencia');
        $('#txtBarraConferencia').focus();
      }


    });

  });
</script>