$(document).ready(async function () {
  let contaFs = 1

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false,
        onNext: () => {
          if (contaFs == 1) {
            contaFs += 1
            const currentFs = $('#fieldsetAba1')
            const nextFs = currentFs.next()
            $("#progressbar li").eq($(".abas").index(nextFs)).addClass("active")
            nextFs.show()
            currentFs.animate(
              {
                opacity: 0,
              },
              {
                step(now) {
                  opacity = 1 - now

                  currentFs.css({
                    display: "none",
                    position: "relative",
                  })
                  nextFs.css({
                    opacity,
                  })
                },
                duration: 600,
              }
            )
          }
        },
        onPrevious: () => {
          if (contaFs == 2) {
            contaFs -= 1
            currentFs = $('#fieldsetAba2')
            previousFs = currentFs.prev()
            $("#progressbar li").eq($(".abas").index(currentFs)).removeClass("active")
            previousFs.show()
            currentFs.animate(
              {
                opacity: 0,
              },
              {
                step(now) {
                  opacity = 1 - now
                  currentFs.css({
                    display: "none",
                    position: "relative",
                  })
                  previousFs.css({
                    opacity,
                  })
                },
                duration: 600,
              }
            )
          }
        },
      })
      driver.defineSteps([
        {
          element: "#divFiltrosTutorial",
          popover: {
            title: "Filtros",
            description:
              "Aqui se encontram os filtros de consulta.",
            position: "top",
          },
        },
        {
          element: "#divResultadosTutorial",
          popover: {
            title: "Filtros",
            description:
              "Aqui se encontram os resultados da consulta.",
            position: "top",
          },
        },
      ])
      driver.start()
    })
  })

  const servicosAdicionais = [
    { id: '01', text: 'Aviso de recebimento' },
    { id: '02', text: 'Mão própria nacional' },
    { id: '19', text: 'Valor declarado' },
    { id: '25', text: 'Registro nacional' },
    { id: '37', text: 'Aviso de recebimento digital' },
    { id: '49', text: 'Devolução de nota fiscal - SEDEX' },
    { id: '57', text: 'Taxa de entrega de encomenda despadronizada' },
    { id: '64', text: 'Valor declarado' },
    { id: '67', text: 'Logística reversa simultânea domiciliária' },
    { id: '69', text: 'Logística reversa simultânea em agência' },
  ]

  retornaHintRelatorio('btnImprimir', 'RelIntegracaoSigep');
  // preencherOrdenacoesRelatorio()
  preencheOrdenacaoTela('RelIntegracaoSigep');
  $('.next').click(function () {
    contaFs += 1

    let validator = $("#msform").validate()
    validator.form()
    let erros = 0
    erros = validator.numberOfInvalids()

    if (erros == 0) {
      currentFs = $(this).parent().parent().parent()
      nextFs = currentFs.next()

      $("#progressbar li").eq($(".abas").index(nextFs)).addClass("active")

      nextFs.show()
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now

            currentFs.css({
              display: "none",
              position: "relative",
            })
            nextFs.css({
              opacity,
            })
          },
          duration: 600,
        }
      )
    }
  })

  $('.previous').click(function () {
    contaFs -= 1

    currentFs = $(this).parent().parent().parent()
    previousFs = currentFs.prev()
    $("#progressbar li")
      .eq($(".abas").index(currentFs))
      .removeClass("active")
    previousFs.show()
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now
          currentFs.css({
            display: "none",
            position: "relative",
          })
          previousFs.css({
            opacity,
          })
        },
        duration: 600,
      }
    )
  })

  $('#account').on('click', function () {
    if (contaFs == 2) {
      $('.previous').trigger('click')
    }
  })

  $('#confirm').on('click', function () {
    if (contaFs == 1) {
      $('.next').trigger('click')
    }
  })

  componenteFiltro('cliente', true, true)
  componenteFiltro('representante', true, true)
  componenteFiltro('tipo', true, true, 'TipoPedido')
  componenteFiltro('pedido', true, true)
  componenteFiltro('fatura', true, true)
  componenteFiltro('tabuf', true, true, 'Uf')
  componenteFiltro('cidade', true, true)
  componenteFiltro('transportadora', true, true)
  componenteFiltro('historico', true, true)
  componenteFiltro('tabuf', false, false, 'UfRegra')

  $('#btnConsultar').on('click', function () {
    carregarDadosConsulta()
  })

  function carregarDadosConsulta() {
    retornarDados().then((dados) => {
      criarTabelaNotas(dados?.notas || [])
      preencherServicos(dados?.itensServico || [])
      preencherValoresPadroes(dados?.valoresPadroes || null)
    })
  }

  async function retornarFiltros() {
    const dataDe = $('#txtDataDe').val() || '1200-01-01'
    const dataAte = $('#txtDataAte').val() || '2500-12-31'
    const clientes = await formataListas($('#txtCliente').val().toString())
    const representantes = await formataListas($('#txtRepresentante').val().toString())
    const tiposPedido = await formataListas($('#txtTipoPedido').val().toString())
    const pedidos = await formataListas($('#txtPedido').val().toString())
    const faturas = await formataListas($('#txtFatura').val().toString())
    const ufs = await formataListas($('#txtUf').val().toString())
    const cidades = await formataListas($('#txtCidade').val().toString())
    const transportadoras = await formataListas($('#txtTransportadora').val().toString())
    const historicos = await formataListas($('#txtHistorico').val().toString())
    const observacaoPedidos = $('#txtObservacaoPedido').val()
    const chaveAcesso = $('#txtChaveAcesso').val()
    const formaEnvioPedidos = $('#txtFormaEnvio').val()
    const statusEtiqueta = $('#selectStatusEtiquetas').val()
    const tipoNotas = $('#selectTipoNotas').val()
    const statusNotas = $('#selectStatusNotas').val()

    return {
      dataDe,
      dataAte,
      clientes,
      representantes,
      tiposPedido,
      pedidos,
      faturas,
      ufs,
      cidades,
      transportadoras,
      historicos,
      observacaoPedidos,
      chaveAcesso,
      formaEnvioPedidos,
      statusEtiqueta,
      tipoNotas,
      statusNotas,
    }
  }

  async function retornarDados() {
    try {
      $.LoadingOverlay('show')
      const filtros = await retornarFiltros()

      const response = await requisicao("GET", `/sisplan/integracaosigep/v1/retornardadosconsulta?`, `&FILTROS=${JSON.stringify(filtros)}`, 1800000)

      if (!response) {
        return
      }

      const data = await response.json()

      const { mensagem, resultado } = data

      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado

    } catch (error) {
      msgErro(error)
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function criarTabelaNotas(data) {
    if ($.fn.DataTable.isDataTable('#tabelaNotas')) {
      $('#tabelaNotas').DataTable().destroy()
      $('#tabelaNotas').empty()
    }

    const columns = [
      {
        data: 'sel',
        title: `<div class="icheck-primary" style="max-width: 50px; margin-bottom: 0!important">
            <input type="checkbox" id="cbSelAll">
            <label for="cbSelAll">Sel</label>
          </div>`,
        render: function (value, _1, _2, { row }) {
          return `<div class="icheck-primary" style="max-width: 20px">
            <input type="checkbox" ${!!value && 'checked'} id="cbSel_${row}" class="cbSel">
            <label for="cbSel_${row}"></label>
          </div>`
        }
      },
      {
        data: 'fatura',
        title: 'Fatura',
      },
      {
        data: 'serie',
        title: 'Série',
      },
      {
        data: 'codigoCliente',
        title: 'Codcli',
      },
      {
        data: 'codigoRepresentante',
        title: 'Codrep',
      },
      {
        data: 'nomeCliente',
        title: 'Nome Cliente',
      },
      {
        data: 'volumes',
        title: 'Volumes',
      },
      {
        data: 'nomeRepresentante',
        title: 'Nome Representante',
      },
      {
        data: 'emissao',
        title: 'Emissão',
        render: function (data) {
          if (data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split("T")[0]} 23:59:59`)
            )
          }
        },
      },
      {
        data: 'impresso',
        title: 'Impresso'
      },
      {
        data: 'valor',
        title: 'Valor',
        className: "text-right",
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString('pt-BR', {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
            })
          }
          return parseFloat(data).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          })
        },
      },
      {
        data: 'codigoRastreio',
        title: 'Código Rastreio'
      },
      {
        data: 'servicoRastreio',
        title: 'Serviço Rastreio'
      },
      {
        data: 'plpRastreio',
        title: 'PLP Rastreio'
      },
      {
        data: 'pesoBruto',
        title: 'Peso Bruto',
        className: "text-right",
        render: function (data) {
          if (!data) {
            return parseFloat(0).toFixed(2)
          }
          return parseFloat(data).toFixed(2)
        },
      },
      {
        data: 'ddd',
        title: 'DDD'
      },
      {
        data: 'telefone',
        title: 'Telefone'
      },
      {
        data: 'dddFax',
        title: 'DDD Fax'
      },
      {
        data: 'fax',
        title: 'Fax'
      },
      {
        data: 'email',
        title: 'E-mail'
      },
      {
        data: 'endereco',
        title: 'Endereço'
      },
      {
        data: 'complemento',
        title: 'Complemento'
      },
      {
        data: 'cnpj',
        title: 'CNPJ'
      },
      {
        data: 'chaveNfe',
        title: 'Chave NFe'
      },
      {
        data: 'cepEntrega',
        title: 'CEP Entrega'
      },
      {
        data: 'enderecoEntrega',
        title: 'Endereço Entrega'
      },
      {
        data: 'numeroEntrega',
        title: 'Nº Entrega'
      },
      {
        data: 'complementoEntrega',
        title: 'Complemento Entrega'
      },
      {
        data: 'bairroEntrega',
        title: 'Bairro Entrega'
      },
      {
        data: 'ufEntrega',
        title: 'UF Entrega'
      },
      {
        data: 'cidadeEntrega',
        title: 'Cidade Entrega'
      },
      {
        data: 'numero',
        title: 'Nº'
      },
      {
        data: 'bairro',
        title: 'Bairro'
      },
      {
        data: 'cep',
        title: 'CEP'
      },
      {
        data: 'cidade',
        title: 'Cidade'
      },
      {
        data: 'uf',
        title: 'UF'
      },
      {
        data: 'etiquetaImpressa',
        title: 'Etiqueta Impressa'
      },
      {
        data: 'pedidoCliente',
        title: 'Pedido Cliente'
      },
      {
        data: 'cepNota',
        title: 'CEP Nota'
      },
      {
        data: 'enderecoNota',
        title: 'Endereço Nota'
      },
      {
        data: 'numeroNota',
        title: 'Nº Nota'
      },
      {
        data: 'complementoNota',
        title: 'Complemento Nota'
      },
      {
        data: 'bairroNota',
        title: 'Bairro Nota'
      },
      {
        data: 'cidadeNota',
        title: 'Cidade Nota'
      },
      {
        data: 'ufNota',
        title: 'UF Nota'
      },
      {
        data: 'codigoTransportadora',
        title: 'Codtrans'
      },
      {
        data: 'nomeTransportadora',
        title: 'Nome Transportadora'
      },
      {
        data: 'formaEnvio',
        title: 'Forma Envio'
      },
      {
        data: 'mensagemNota',
        title: 'Mensagem Nota'
      },
      {
        data: 'erro',
        title: 'Erro'
      },
      {
        data: 'mensagem',
        title: 'Mensagem'
      },
    ]

    $("#tabelaNotas").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      searching: false,
      lengthChange: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data,
      columns,
    })
    adicionarEventoCheckboxDatatable()
  }

  function preencherServicos(servicos) {
    const selectServico = $('#selectServico')
    selectServico.empty()
    servicos.forEach((item) => selectServico.append(`
        <option value="${item?.codigo}">${item?.codigo} - ${item?.descricao}</option>
      `)
    )
  }

  function adicionarEventoCheckboxDatatable() {
    $('#cbSelAll').on('change', function () {
      const isChecked = this.checked
      const table = $('#tabelaNotas').DataTable()
      table.rows().every(function () {
        const row = $(this.node())
        row.toggleClass('selected', isChecked)
        const checkbox = row.find('.cbSel')
        checkbox.prop('checked', isChecked)
      })
    })

    $('#tabelaNotas tbody').on('change', '.cbSel', function () {
      const row = $(this).closest('tr')
      const isChecked = $(this).prop('checked')

      row.toggleClass('selected', isChecked)
    })
  }

  $('#btnGerarEtiqueta').on('click', async function () {
    const rowsData = $('#tabelaNotas').DataTable().rows('.selected').data().toArray()
    const itemComPlpJaPreenchido = rowsData?.find((item) => !!item.plpRastreio)
    if (!!itemComPlpJaPreenchido) {
      msgErro(`Código de rastreio para a fatura ${itemComPlpJaPreenchido?.fatura} já vinculado a uma PLP, impossível continuar.`)
      return
    }

    const itemComPesoZerado = rowsData?.find((item) => item.pesoBruto <= 0)
    if (itemComPesoZerado) {
      msgErro(`Peso zerado para a fatura ${itemComPesoZerado?.fatura}, impossível continuar.`)
      return
    }

    retornarDadosGerarEtiqueta().then(async (dados) => {
      await gerarEtiquetas(dados)
    })
  })

  $('#btnGravarServicos').on('click', async function () {
    await gravaServicos();
  })

  async function gravaServicos() {
    $.LoadingOverlay('show');
    $('#btnGravarServicos').prop('disabled', true);
    try {
      await msgAguardaConfirmacao('Deseja realmente atualizar os dados da tabela serv_sigep?', callBack, () => { });

      async function callBack() {
        const options = $('#selectServico').find('option');
        const dados = [];

        options.each(function () {
          const obj = {
            CODIGO: $(this).val(),
            DESCRICAO: $(this).text().split(' - ')[1]
          }

          dados.push(obj);
        })

        const response = await requisicao('POST', '/sisplan/integracaosigep/v1/serv_sigep?', '', `JSON=${encodeURIComponent(JSON.stringify(dados))}`);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay('hide');
          msgAlerta(jsonStr.mensagem);
          return;
        }
        criaMensagemSucesso('Tabela atualizada com sucesso.');
      }
    } catch (error) {
      msgErro(error.message);
    } finally {
      $('#btnGravarServicos').prop('disabled', false);
      $.LoadingOverlay('hide');
    }
  }

  function retornarServicosAdicionais() {
    const valoresSelecionados = $('#selectServicosAdicionais').val()
    return valoresSelecionados.map((codigo) => ({
      codigo,
      descricao: servicosAdicionais.find((item) => item.id === codigo)?.text || '',
      coSegmento: '',
      descSegmento: '',
    }))
  }

  async function retornarDadosGerarEtiqueta() {
    const rowsData = $('#tabelaNotas').DataTable().rows('.selected').data().toArray()
    const selectServico = $('#selectServico option:selected')
    const servico = {
      codigo: selectServico.val(),
      descricao: selectServico.text().split(' - ')[1] || '',
      coSegmento: '',
      descSegmento: '',
    }
    if (!servico || !servico?.codigo) {
      msgErro('Serviço não informado, impossível continuar.')
      return
    }

    const notas = []
    for (const item of rowsData) {
      if (item.codigoRastreio) {
        await msgAguardaConfirmacao(`Código de rastreio para a fatura ${item?.fatura} já foi gerado, deseja gerar novamente?`, () => { notas.push(item) }, () => { })
      } else {
        notas.push(item)
      }
    }
    const tipoObjeto = $('#selectTipoObjeto').val()
    const servicosAdicionais = retornarServicosAdicionais()
    const altura = $('#txtAltura').val()
    const largura = $('#txtLargura').val()
    const comprimento = $('#txtComprimento').val()

    return {
      servico,
      notas,
      tipoObjeto,
      servicosAdicionais,
      altura,
      largura,
      comprimento,
    }
  }

  async function gerarEtiquetas(dados) {
    if (!dados || dados?.notas?.length === 0) return
    try {
      $.LoadingOverlay('show')
      const response = await requisicao("POST", `/sisplan/integracaosigep/v1/geraretiquetas?`, '', JSON.stringify(dados), 1800000)

      if (!response) {
        throw new Error()
      }

      const data = await response.json()

      const { mensagem } = data

      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          $('#btnConsultar').trigger('click')
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      msgErro(error)
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('.duasCasasDecimaisQuantityFormat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  $('.duasCasasDecimaisCurrencyFormat').maskMoney({
    decimal: ",",
    thousands: "",
    precision: 2,
  })

  $('#btnImprimir').on('click', async function () {
    if (!$('#txtOrdem').val()) {
      msgErro('Nenhuma ordenação selecionada, impossível continuar.')
      return
    }
    await imprimir()
  })

  async function imprimir() {
    try {
      $.LoadingOverlay('show')

      const filtros = await retornarFiltros()
      filtros.faturas = retornarFaturasSelecionadas()
      if (!filtros.faturas) {
        msgErro('Nenhum registro selecionado, impossível continuar.')
        return
      }
      const opcaoRelatorio = $('#txtOrdem').val()
      const imprimirAutomatico = await verificaImprimirAutomatico('RelFacPag')
      let arquivo = await GeraRelatorio(`/sisplan/impressao/v1/imprimirrelatoriosigep?&OPCAORELATORIO=${opcaoRelatorio}`, 'POST', 1800000, false, 'RelIntegracaoSigep', JSON.stringify(filtros))
      if (arquivo != undefined) {
        if (!imprimirAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank')
        }
        await limparRelatorios()
      }
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function retornarFaturasSelecionadas() {
    const data = $('#tabelaNotas').DataTable().rows('.selected').data().toArray()
    return data.map(obj => `'${obj.fatura}'`).join(', ')
  }

  
  // function preencherOrdenacoesRelatorio() {
  //   retornaOrdensRelatorio('RelIntegracaoSigep').then((opcoes) => {
  //     opcoes.forEach(function (item) {
  //       $('#txtOrdem').append(
  //         `<option value=${item.ORDEM} nome_prt=${item.NOME_PRT}>${item.NOME_ORD_TELA}</option>`
  //       )
  //     })
  //   })
  // }

  $('#selectServicosAdicionais').pesquisaVariosDadosEstaticos(0, servicosAdicionais)

  $('#btnLimpaServicosAdicionais').on('click', function () {
    $('#selectServicosAdicionais').off().removeData().select2('destroy')
    $('#selectServicosAdicionais').pesquisaVariosDadosEstaticos(0, servicosAdicionais)
  })

  $('#btnConfigurarRegra').on('click', function () {
    carregarDadosRegra().then(() => $('#modalConfigurarRegra').modal('show'))
  })

  async function carregarDadosRegra() {
    buscarDadosRegra().then(({ regras }) => {
      criarTabelaRegras(regras ?? [])
    })
  }

  async function buscarDadosRegra() {
    const response = await requisicao("GET", `/sisplan/integracaosigep/v1/retornardadosregra?`, '', '', 1800000)

    if (!response) {
      return
    }

    const data = await response.json()

    const { mensagem, resultado } = data

    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }

  function criarTabelaRegras(data) {
    if ($.fn.DataTable.isDataTable('#tabelaRegras')) {
      $('#tabelaRegras').DataTable().destroy()
      $('#tabelaRegras').empty()
    }

    const columns = [
      {
        data: 'codigo',
        title: 'Código',
        render: function retornaBotaoOpcoes(data) {
          return `<div style="text-align:start;">
                <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes botaoOpcoesRegra" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  ${data}
                </button>
                <div class="dropdown-menu">
                   <button class="dropdown-item" id="btnAlterar">Alterar</button>    
                   <button class="dropdown-item" id="btnExcluir">Excluir</button> 
            </div>`
        }
      },
      {
        data: 'descricao',
        title: 'Descrição'
      },
      {
        data: 'valor',
        title: 'Valor',
        className: "text-right",
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString('pt-BR', {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
            })
          }
          return parseFloat(data).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
          })
        },
      },
      {
        data: 'servico',
        title: 'Serviço',
      },
    ]

    $("#tabelaRegras").DataTable({
      sort: true,
      paging: true,
      destroy: true,
      colReorder: true,
      searching: false,
      lengthChange: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data,
      columns,
    })
  }

  $('#btnIncluirRegra').on('click', function () {
    habilitarInclusaoRegra()
  })

  $('#btnDesistirRegra').on('click', function () {
    limparCamposRegra()
    desabilitarInclusaoRegra()
  })

  function habilitarInclusaoRegra() {
    $('.inputRegra').prop('disabled', false)
    $('.botaoRegra').prop('disabled', false)
    $('.botaoOpcoesRegra').prop('disabled', true)
    $('#btnIncluirRegra').addClass('d-none')
    $('#btnConfirmarRegra').removeClass('d-none')
    $('#btnDesistirRegra').removeClass('d-none')
    $('#btnGravarRegra').prop('disabled', true)
    $('#btnFecharRegra').prop('disabled', true)
  }

  function desabilitarInclusaoRegra() {
    $('.inputRegra').prop('disabled', true)
    $('.botaoRegra').prop('disabled', true)
    $('.botaoOpcoesRegra').prop('disabled', false)
    $('#btnIncluirRegra').removeClass('d-none')
    $('#btnConfirmarRegra').addClass('d-none')
    $('#btnDesistirRegra').addClass('d-none')
    $("#tabelaRegras tr").removeClass("selected")
    $('#btnGravarRegra').prop('disabled', false)
    $('#btnFecharRegra').prop('disabled', false)
  }

  $('#btnConfirmarRegra').on('click', function () {
    confirmarRegra()
  })

  function confirmarRegra() {
    try {
      const data = retornarValoresRegra()
      data.valor = parseFloat(data.valor.replace(',', '.'))
      if (!data?.codigo) {
        msgErro('UF não informada, impossível continuar.')
        return
      }
      const datatable = $("#tabelaRegras").DataTable()
      const selectedRow = datatable.rows(".selected")
      const datatableData = datatable.data().toArray()
      const editingRegister = selectedRow.data().toArray()

      if (!editingRegister || editingRegister.length === 0) {
        if (datatableData.some((item) => item.codigo === data?.codigo)) {
          msgErro('UF informada já cadastrada, impossível continuar.')
          return
        }

        datatable.row.add(data).draw(false)
      } else {
        const [index] = selectedRow.indexes().toArray()

        if (datatableData.some((item, idx) => item.codigo === data?.codigo && idx !== index)) {
          msgErro('UF informada já cadastrada, impossível continuar.')
          return
        }

        if (editingRegister.length > 1) {
          throw new Error()
        }

        datatable.row(index).data(data).draw(false)
      }
      limparCamposRegra()
      desabilitarInclusaoRegra()
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao inserir/editar o registro, por favor tente novamente.')
    } finally {
    }
  }

  function retornarValoresRegra() {
    const codigo = pegaChave('#txtUfRegra')
    const descricao = pegaDescricao('#txtUfRegra')
    const valor = $('#txtValorRegra').val()
    const servico = $('#txtServicoRegra').val()

    return {
      codigo,
      descricao,
      valor,
      servico,
    }
  }

  function limparCamposRegra() {
    $('#txtUfRegra').val('')
    $('#txtServicoRegra').val('')
    $('#txtValorRegra').val('')
  }

  $('#tabelaRegras').on('click', '#btnAlterar', async function () {
    const linhaMaisProxima = $(this).closest('tr')
    $(linhaMaisProxima).addClass('selected')
    const data = $('#tabelaRegras').DataTable().row(linhaMaisProxima).data()
    habilitarAlteracaoRegra(data)
    habilitarInclusaoRegra()
  })

  $('#tabelaRegras').on('click', '#btnExcluir', async function () {
    $('#tabelaRegras').DataTable().row($(this).parents('tr')).remove().draw(false)
  })

  function habilitarAlteracaoRegra(data) {
    insereValor('#txtUfRegra', data?.codigo, data?.descricao)
    insereValor('#txtUfRegra', data?.codigo, data?.descricao)
    insereValor('#txtServicoRegra', data?.servico)
    insereValor('#txtValorRegra', parseFloat(data?.valor).toLocaleString('pt-BR', {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2,
    }))
  }

  $('#btnGravarRegra').on('click', async function () {
    msgAlerta(
      'Deseja gravar as regras?',
      () => { },
      () => { },
      () => gravarRegras()
    )
  })

  async function gravarRegras() {
    try {
      $.LoadingOverlay('show')
      const dados = $('#tabelaRegras').DataTable().data().toArray().map((item) => ({ ...item, valor: String(item?.valor ?? 0)?.replace(',', '.') }))
      const objetoGravar = {
        regras: dados,
      }
      const response = await requisicao("POST", `/sisplan/integracaosigep/v1/gravarregras?`, '', JSON.stringify(objetoGravar), 1800000)

      if (!response) {
        throw new Error()
      }

      const data = await response.json()

      const { mensagem } = data

      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          $('#modalConfigurarRegra').modal('hide')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      msgErro(error)
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function preencherValoresPadroes(data) {
    if (!data || !Array.isArray(data)) return
    data.forEach((item) => {
      switch (item.campo) {
        case 'SERVICO':
          if (item.valor) {
            $('#selectServico').val(item.valor)
          }
          break
        case 'TIPO_OBJETO':
          if (item.valor) {
            $('#selectTipoObjeto').val(item.valor)
          }
          break
        case 'ALTURA':
          if (item.valor) {
            const altura = parseFloat(item.valor).toFixed(2)
            $('#txtAltura').val(altura)
          }
          break
        case 'LARGURA':
          if (item.valor) {
            const largura = parseFloat(item.valor).toFixed(2)
            $('#txtLargura').val(largura)
          }
          break
        case 'COMPRIMENTO':
          if (item.valor) {
            const complemento = parseFloat(item.valor).toFixed(2)
            $('#txtComprimento').val(complemento)
          }
          break
        default:
          break
      }
    })
  }
})