$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#containerDivGNRE',
        popover: {
          title: 'Tabela GNRE',
          description: 'Aqui estão as guias GNRE consultadas.',
          position: 'botton'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as guias consultadas.',
          position: 'right'
        }
      },
      {
        element: '#btnGerarAP',
        popover: {
          title: 'Botão Gerar AP',
          description: 'Clique aqui para gerar AP.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  await criaPesquisaFiltros();
  await buscaDados();
  await carregaValoresPadroes();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async () => {
    $.LoadingOverlay('show')
    try {
      await buscaDados()
      $('#modal-filtros').modal('hide')
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtGuia').empty().trigger('change')
    $('#txtChaveNfe').val('')

    $('#txtDtEmissaoDe').val('1200-01-01')
    $('#txtDtEmissaoAte').val('2500-12-31')

  })

  async function buscaDados() {
    consultando = true
    if ($.fn.DataTable.isDataTable('#tabelaGNRE')) {
      $("#tabelaGNRE").DataTable().destroy();
      $("#tabelaGNRE").empty();
    };
    $.LoadingOverlay('show')
    try {
      $('#childrenInfoDataTableGNRE').addClass('d-none')
      $('#checkSelecionarTodos').prop('checked', false)
      const emissao = ` AND NOTA.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}' AND NOTA.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}'`
      const nota = $('#txtGuia').val().length > 0 ? ` AND GUIAGNRE.FATURA IN (${await formataListas($('#txtGuia').val().toString())})` : '';
      const chave = $('#txtChaveNfe').val() != '' ? ` AND NOTA.CHAVE_NFE = '${$('#txtChaveNfe').val()}'` : '';
      const empId = ` AND GUIAGNRE.EMP_ID = ${getCookie('emp_id')}`
      const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"GUIAGNRE", "camposSelect":[ "'N' AS SEL", "GUIAGNRE.FATURA", "GUIAGNRE.SERIE", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE", "(VAL_ICMS_UF_DEST [SOMA] VAL_ICMS_POBREZA) VALOR"],"leftjoin": [{ "tabela": "NOTA", "condicao": "NOTA.FATURA = GUIAGNRE.FATURA"},{ "tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = ENTIDADE.CODCLI"}], "where": ["1=1 ${emissao} ${nota} ${chave} ${empId}"]}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();

      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if (jsonStr.RESULT[0].length <= 0) {
        throw new Error('Nenhum registro encontrado!')
      }

      await montaDataTableGNRE(jsonStr.RESULT[0])
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function montaDataTableGNRE(jsonStr) {
    const dataSetCols = [];

    let keys = Object.keys(jsonStr[0]);
    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    dataSetCols[0].render = function (data, type, row, meta) {
      return '<div class="form-check pl-0">' +
        '<div class="icheck-primary">' +
        `<input style="height:20px" type="checkbox" id="check_col_${meta.col}_row_${meta.row}" class="align-self-center campoCheck"><label for="check_col_${meta.col}_row_${meta.row}"></label>` +
        '</div>' +
        '</div>';
    }

    $('#tabelaGNRE').DataTable({
      bPaginate: false,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: true,
      createdRow: function (row, data, dataIndex) {
        $(row).addClass('linhaAcesso');
      },
      language: {
        sEmptyTable: "Nenhum registro encontrado na tabela",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado na tabela",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          targets: [5],
          visible: false
        },
      ]
    });

    $('#childrenInfoDataTableGNRE').removeClass('d-none')

    $('.campoCheck').on('click', function () {
      window.event.preventDefault();
      $(this).parents('tr').trigger('click');
    });
  }

  $('#tabelaGNRE').on('click', 'tr', function () {
    selecionarLinhaTabela('#tabelaGNRE', 'campoCheck', this)

    if ($('#tabelaGNRE').DataTable().$('tr.selected').length <= 0) {
      $('#checkSelecionarTodos').prop('checked', false)
    }
  })

  $('#checkSelecionarTodos').on('change', async function () {
    if (isChecked('#checkSelecionarTodos')) {
      $('.campoCheck').prop('checked', true);
      $('.linhaAcesso').addClass('selected');
    } else {
      $('.campoCheck').prop('checked', false);
      $('.linhaAcesso').removeClass('selected');
    }
  });

  retornaHintRelatorio('btnImprimir', 'GUIA_GNRE')

  $('#btnImprimir').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      if ((!$.fn.DataTable.isDataTable('#tabelaGNRE')) || ($('#tabelaGNRE').DataTable().$('tr.selected').length <= 0)) {
        msgAlerta('Nenhuma guia selecionada para imprimir.');
        return;
      }

      let faturas = '';
      $('#tabelaGNRE').DataTable().rows($('#tabelaGNRE').DataTable().$('tr.selected')).data().map(item => {
        if (faturas == '') {
          faturas += "'" + item.FATURA + "'";
        } else {
          faturas += ",'" + item.FATURA + "'";
        }
      });

      await imprimirGNRE({ FATURA: faturas, SERIE: $('#tabelaGNRE').DataTable().rows($('#tabelaGNRE').DataTable().$('tr.selected')).data()[0].SERIE });

    } catch (error) {
      msgAlerta(error.message);
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function imprimirGNRE(item) {
    const url = `/sisplan/gnre/v1/imprimirgnre?FATURA=${item.FATURA}&SERIE=${item.SERIE}&IMPRIMIRMAISDEUMA=S`;
    const bImprimeAutomatico = await verificaImprimirAutomatico('GNRE');
    const arquivo = await GeraRelatorio(url + '&', 'PUT', 150000, false, 'GNRE');
    if (arquivo != undefined) {
      if (!bImprimeAutomatico) {
        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
      }
      await limparRelatorios();
    }
  }

  $('#txtFornecedor').on('blur', async function () {
    const codcli = pegaChave('#txtFornecedor');

    if (codcli == '') {
      return;
    }

    const pesquisaParam = {
      tabela: "ENTIDADE",
      camposSelect: [
        "ENTIDADE.CLASSE",
        "ENTIDADE.HISTORICO",
        "ENTIDADE.BANCO",
        "ENTIDADE.SIT_DUP",
        "CLASSE_GER.DESCRICAO DESC_CLASSE",
        "HISTCP.DESCRICAO DESC_HISTORICO",
        "CADBAN.NOME_BANCO DESC_BANCO",
        "TABSIT.DESCRICAO DESC_SIT",
      ],
      leftJoin: [
        { tabela: 'CLASSE_GER', condicao: `CLASSE_GER.CODIGO = ENTIDADE.CLASSE` },
        { tabela: 'HISTCP', condicao: `HISTCP.HISTORICO = ENTIDADE.HISTORICO` },
        { tabela: 'CADBAN', condicao: `CADBAN.BANCO = ENTIDADE.BANCO` },
        { tabela: 'TABSIT', condicao: `TABSIT.CODIGO = ENTIDADE.SIT_DUP` },
      ],
      where: [`ENTIDADE.CODCLI = '${codcli}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      return;
    }

    insereValor('#txtClasse', jsonStr[0].CLASSE, jsonStr[0].DESC_CLASSE);
    insereValor('#txtHistorico', jsonStr[0].HISTORICO, jsonStr[0].DESC_HISTORICO);
    insereValor('#txtBanco', jsonStr[0].BANCO, jsonStr[0].DESC_BANCO);
    insereValor('#txtSituacao', jsonStr[0].SIT_DUP, jsonStr[0].DESC_SIT);
  });

  $('#btnGerarAP').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      let faturasSel = ''
      let faturasSemValor = ''
      if ((!$.fn.DataTable.isDataTable('#tabelaGNRE')) || ($('#tabelaGNRE').DataTable().$('tr.selected').length <= 0)) {
        throw new Error('Nenhuma Guia selecionada para Gerar AP!')
      }

      for (let i = 0; i < $('#tabelaGNRE').DataTable().rows($('#tabelaGNRE').DataTable().$('tr.selected')).data().toArray().length; i++) {
        const item = $('#tabelaGNRE').DataTable().rows($('#tabelaGNRE').DataTable().$('tr.selected')).data().toArray()[i]

        faturasSel = faturasSel + item.FATURA + ','

        if (item.VALOR <= 0) {
          faturasSemValor = faturasSemValor + item.FATURA + ', '
        }
      }

      if (faturasSemValor != '') {
        throw new Error(`Existem notas selecionadas sem valor para gerar AP, verifique!`)
      }

      faturasSel = await formataListas(faturasSel.substring(0, faturasSel.length - 1))
      if (await validaPagar(faturasSel)) {
        await dadosPagar();
        $('#modal-pagar').modal('show');
      } else {
        throw new Error(`Existem notas selecionadas com AP geradas apartir da GNRE.`)
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  });

  async function validaPagar(faturasConsulta) {

    let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.NUM_AP"], "where": ["PAGTO.DOCTO IN (${faturasConsulta})"]}`, null);

    if (!response) {
      return true;
    }
    jsonStr = await response.json();
    if (response.status != 200) {
      return true;
    }
    try {
      const num_ap = jsonStr.RESULT[0][0].NUM_AP;
      if (num_ap != true) {
        return false;
      }
    } catch {
      return true;
    }

  }

  async function dadosPagar() {
    $('#txtStatus').val('DUPL');
    setarDataAtual('txtDTemissao');
    setarDataAtual('txtDTvencimento');
  };

  $('#btnGravarPagar').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      for (let i = 0; i < $('#tabelaGNRE').DataTable().rows($('#tabelaGNRE').DataTable().$('tr.selected')).data().toArray().length; i++) {
        const item = $('#tabelaGNRE').DataTable().rows($('#tabelaGNRE').DataTable().$('tr.selected')).data().toArray()[i]

        if (!await gravaPagar(item)) {
          return;
        };
      }

      $.LoadingOverlay("hide");
      toastr.success(
        'AP gerada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-pagar').modal('hide');
        }
      }
      ).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function gravaPagar(rec) {
    try {
      $.LoadingOverlay("show");
      try {

        const classe = pegaChave('#txtClasse');
        const situacao = pegaChave('#txtSituacao');
        const fornecedor = pegaChave('#txtFornecedor');
        const banco = pegaChave('#txtBanco');
        const conta = pegaChave('#txtConta');
        const historico = pegaChave('#txtHistorico');
        const valor = rec.VALOR

        if ((classe == '') || (banco == '') || (conta == '') || (situacao == '') || (fornecedor == '') || (historico == '')) {
          msgAlerta('Campos obrigatórios não informados.');
          return false;
        }
        let PagarC = {};

        PagarC.DOCTO = rec.FATURA;
        PagarC.VALOR = parseFloat(valor);
        PagarC.VAL_PAG = parseFloat(0);
        PagarC.VAL_NOTA = parseFloat(valor);
        PagarC.VALOR_ORIG = parseFloat(valor);
        PagarC.DT_VEN = `${$('#txtDTvencimento').val()}T00:00:00Z`;
        PagarC.DATA_ORIG = `${$('#txtDTvencimento').val()}T00:00:00Z`;
        PagarC.DT_EMI = `${$('#txtDTemissao').val()}T00:00:00Z`;
        PagarC.STATUS = $('#txtStatus').val();
        PagarC.OBS = `Ref. GNRE da nota de chave:${rec.CHAVE_NFE}`;
        PagarC.EMP_ID = getCookie('emp_id');
        PagarC.CODCRE = fornecedor;
        PagarC.SITUACAO = situacao;
        PagarC.NUM_OS = classe;
        PagarC.BANCO = banco;
        PagarC.CONTA = conta;
        PagarC.HISTORICO = historico;

        let response = await requisicao('POST', '/Sisplan/pagar/V1/Pagar?', '', `JSON=${encodeURIComponent(JSON.stringify(PagarC))}`);

        if (!response) {
          return false;
        }

        let jsonStr = await response.json();

        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return false;
        }
        return true;
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível gravar os dados do Pagamento: ');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'PAGTO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(async item => {
      switch (item.CAMPO) {
        case 'BANCO': {
          if (item.VALOR != '') {
            const descBanco = await buscaValor('CADBAN', 'NOME_BANCO', 'BANCO', item.VALOR);
            insereValor('#txtBanco', item.VALOR, descBanco.NOME_BANCO);
          }
          break;
        }
        case 'SITUACAO_DUP': {
          if (item.VALOR != '') {
            const descSituacao = await buscaValor('TABSIT', 'DESCRICAO', 'CODIGO', item.VALOR);
            insereValor('#txtSituacao', item.VALOR, descSituacao.DESCRICAO);
          }
          break;
        }
        case 'CLASSE_GERENCIAL': {
          if (item.VALOR != '') {
            const descClasse = await buscaValor('CLASSE_GER', 'DESCRICAO', 'CODIGO', item.VALOR);
            insereValor('#txtClasse', item.VALOR, descClasse.DESCRICAO);
          }
          break;
        }
        case 'CONTA': {
          if (item.VALOR != '') {
            const descConta = await buscaValor('CADCONTA', 'DESCRICAO', 'CONTA', item.VALOR);
            insereValor('#txtConta', item.VALOR, descConta.DESCRICAO);
          }
          break;
        }
        case 'FORNECEDOR': {
          if (item.VALOR != '') {
            const descForn = await buscaValor('ENTIDADE', 'NOME', 'CODCLI', item.VALOR);
            insereValor('#txtFornecedor', item.VALOR, descForn.NOME);
          }
          break;
        }
      }
    });
  };

  async function criaPesquisaFiltros() {
    $('#txtGuia').pesquisa_variosServerside(1, '{ "tabela":"GUIAGNRE", "camposSelect":[ "FATURA", "SERIE" ], "where": null}', 'FATURA', 'SERIE');
    $('#btnGuia').pesquisa_serversideSel('#txtGuia', `{ "tabela":"GUIAGNRE", "camposSelect":[ "FATURA", "SERIE"], "where": null}`, 'Pesquisa de Guia');
    $('#btnLimpaGuia').on('click', function () {
      $('#txtGuia').empty().trigger('change')
    })

    $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
    $('#txtConta').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao"], "where": null}`);

    $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
    $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
    $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
    $('#btn-Conta').pesquisa('#txtConta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta', 'cadconta');
    $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "HISTORICO", "descricao"]}`, 'Pesquisa Histórico', 'histcp');

    $('#btn-limpa-Classe').on('click', function () {
      $('#txtClasse').val('');
    });
    $('#btn-limpa-Fornecedor').on('click', function () {
      $('#txtFornecedor').val('');
    });
    $('#btn-limpa-Situacao').on('click', function () {
      $('#txtSituacao').val('');
    });
    $('#btn-limpa-Banco').on('click', function () {
      $('#txtBanco').val('');
    });
    $('#btn-limpa-Conta').on('click', function () {
      $('#txtConta').val('');
    });
    $('#btn-limpa-Historico').on('click', function () {
      $('#txtHistorico').val('');
    });
  }
});