$('#txtClienteGenericoCSV').autocompleta(1, `JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
$('#btnClienteGenericoCSV').pesquisa_serverside(['#txtClienteGenericoCSV'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa de Cliente');
$('#btnLimpaClienteGenericoCSV').on('click', function () {
  $('#txtClienteGenericoCSV').val('');
});

$('#txtBancoGenericoCSV').autocompleta(1, `JSON={"tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
$('#btnBancoGenericoCSV').pesquisa('#txtBancoGenericoCSV', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, 'Pesquisa de Banco', 'CADBAN');
$('#btnLimpaBancoGenericoCSV').on('click', function () {
  $('#txtBancoGenericoCSV').val('');
});

$('#txtContaGenericoCSV').autocompleta(1, `JSON={"tabela":"CADCONTA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnContaGenericoCSV').pesquisa('#txtContaGenericoCSV', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa de Conta', 'CADCONTA');
$('#btnLimpaContaGenericoCSV').on('click', function () {
  $('#txtContaGenericoCSV').val('');
});

$('#txtClasseBaixaGenericoCSV').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseBaixaGenericoCSV').pesquisa_serverside(['#txtClasseBaixaGenericoCSV'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Classe Baixa');
$('#btnLimpaClasseBaixaGenericoCSV').on('click', function () {
  $('#txtClasseBaixaGenericoCSV').val('');
});

$('#txtClasseDespesaGenericoCSV').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseDespesaGenericoCSV').pesquisa_serverside(['#txtClasseDespesaGenericoCSV'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Despesa');
$('#btnLimpaClasseDespesaGenericoCSV').on('click', function () {
  $('#txtClasseDespesaGenericoCSV').val('');
});

$('#txtHistoricoGenericoCSV').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnHistoricoGenericoCSV').pesquisa_serverside(['#txtHistoricoGenericoCSV'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
$('#btnLimpaHistoricoGenericoCSV').on('click', function () {
  $('#txtHistóricoGenericoCSV').val('');
});

async function validaConfirmacao() {
  if (!$('#txtClasseBaixaGenericoCSV').val() || !await Existe('CLASSE_GER', ['CODIGO'], [$('#txtClasseBaixaGenericoCSV').val()])) {
    throw msgAlerta('Classe/Baixa não informado ou inválido!');
  }
  if (!$('#txtHistoricoGenericoCSV').val() || !await Existe('HISTORICO', ['HISTCP'], [$('#txtHistoricoGenericoCSV').val()])) {
  }
  throw msgAlerta('Histórico não informado ou inválido!');
}

$('#btnVerBaixasGenericoCSV').on('click', async function () {
  if (!$('#txtArquivo').val()) {
    throw msgAlerta('Nenhum arquivo inserido no campo caminho, impossível visualizar as baixas!');
  }
  await verBaixasGenericoCSV();
});

async function verBaixasGenericoCSV() {
  $.LoadingOverlay('show');
  try {
    const body = {
      data: window.databody.objeto,
    }

    let response = await requisicao('POST', '/sisplan/escretorno/V1/buscagenericocsv?', `&FILE=${window.databody.file}&TAB=${'GenericoCSV'}`, JSON.stringify(body), 50000);

    if (!response) {
      return;
    }
    let jsonStr = await response.json();

    const dataSetCols = [];
    const keys = Object.keys(jsonStr[0]);
    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaGenericoCSV').DataTable({
      destroy: true,
      language: {
        sEmptyTable: 'Nenhum registro encontrado',
        sInfo: '_TOTAL_ registros',
        sInfoEmpty: ' 0 registros',
        sInfoFiltered: '(Filtrados de _MAX_ registros)',
        sInfoPostFix: '',
        sInfoThousands: '.',
        sLengthMenu: '_MENU_ resultados',
        sLoadingRecords: 'Carregando...',
        sProcessing: 'Processando...',
        sZeroRecords: 'Nenhum registro encontrado',
        sSearch: 'Pesquisar',
        oPaginate: {
          sNext: 'Próximo',
          sPrevious: 'Anterior',
          sFirst: 'Primeiro',
          sLast: 'Último',
        },
        oAria: {
          sSortAscending: ': Ordenar colunas de forma ascendente',
          sSortDescending: ': Ordenar colunas de forma descendente',
        },
      },
      data: jsonStr,
      columns: dataSetCols,
      columnDefs: [
        {
          targets: [0], render: function (_data, _type, _row, meta) {
            return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${(_row.SEL === 'S' && _row.NAOSELECIONA === 'S') ? 'checked' : 'disabled'} id="check_col_${meta.row}_row_${meta.col}">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
          },
        },
      ],
      rowCallback: function (row, data) {
        if (data.NUMERO === '') {
          $(row).css('background-color', '#B4524D');
          $(row).css('color', '#ecfdff');
        } else if (data.NAOSELECIONA === 'N') {
          $(row).css('background-color', '#3A5E44');
          $(row).css('color', '#ecfdff');
        } else if (ComparaValor(data.VALOR_DUPLICATA, data.VALOR, 2, '!=') && data.VALOR > 0) {
          $(row).css('background-color', '#04336C');
          $(row).css('color', '#ecfdff');
        }
      },
      scrollX: true,
    });

    $('.campoConsulta').on('change', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });

  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide');
  }

  function ComparaValor(vValor1, vValor2, vDecimais, sSinal) {
    let result = false;

    function roundTo(valor, decimais) {
      return Math.round(valor * Math.pow(10, decimais)) / Math.pow(10, decimais);
    }

    let valorArred1 = roundTo(vValor1, vDecimais);
    let valorArred2 = roundTo(vValor2, vDecimais);

    switch (sSinal) {
      case '<':
        result = valorArred1 < valorArred2;
        break;
      case '>':
        result = valorArred1 > valorArred2;
        break;
      case '!=':
        result = valorArred1 !== valorArred2;
        break;
      case '<=':
        result = valorArred1 <= valorArred2;
        break;
      case '>=':
        result = valorArred1 >= valorArred2;
        break;
      case '=':
        result = valorArred1 === valorArred2;
        break;
    }

    return result;
  }

  function RetornaCampos() {
    return {
      nomeArquivo: $('#txtArquivo').val(),
      cliente: pegaChave('#txtClienteGenericoCSV'),
      valorDe: $('#txtValorDe').val(),
      valorAte: $('#txtValorAte').val(),
      banco: pegaChave('#txtBancoGenericoCSV'),
      conta: pegaChave('#txtContaGenericoCSV'),
      classeBaixa: pegaChave('#txtClasseBaixaGenericoCSV'),
      classeDespesa: pegaChave('#txtClasseDespesaGenericoCSV'),
      historico: pegaChave('#txtHistoricoGenericoCSV'),
      dataPagamento: $('#dtPagamentoGenericoCSV').val(),
      NaoGeraCC: ''
    }
  }

  $('#btnConfirmarGenericoCSV').on('click', async function () {
    try {
      $.LoadingOverlay('show')
      if (!$('#txtClienteGenericoCSV').val()) {
        throw msgAlerta('Cliente não informado')
      }
      if (!$('#txtBancoGenericoCSV').val()) {
        throw msgAlerta('Banco não informado')
      }
      if (!$('#txtContaGenericoCSV').val()) {
        throw msgAlerta('Conta não informada')
      }
      if (!$('#txtClasseBaixaGenericoCSV').val()) {
        throw msgAlerta('Classe de baixa não informada')
      }
      if (!$('#txtClasseDespesaGenericoCSV').val()) {
        throw msgAlerta('Classe de despesa não informada')
      }
      if (!$('#txtHistoricoGenericoCSV').val()) {
        throw msgAlerta('Histórico não informado')
      }

      // const data = $('#tabelaGenericoCSV').DataTable().rows().data().toArray().filter(item => item.SEL == 'S')


      let data = $('#tabelaGenericoCSV').DataTable().rows().nodes().toArray().filter(row => {
        return $(row).find('td:first-child input[type="checkbox"]').is(':checked');
      }).map(row => {
        return $('#tabelaGenericoCSV').DataTable().row(row).data();
      });

      const body = {
        fields: RetornaCampos(),
        data: data
      }

      let response = await requisicao('POST', '/sisplan/escretorno/V1/confirmagenericocsv?', ``, JSON.stringify(body), 50000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Baixa realizada com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/extrato_cartao`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  })
}