$(document).ready(async function () {

    let nomeArquivo;
    let extArq;
    let tabelaBanco = 'CADBAN';
    let jsonStr;
    let listaDuplicatasExclusao = [];

    $('#tabelaDuplicatas').on('draw.dt', function () {
        $('.campoSel').on('change', async function () {
            const numeroDup = $(this).parent().parent().parent().children()[1].textContent;

            if (!listaDuplicatasExclusao.includes(numeroDup)) {
                listaDuplicatasExclusao.push(numeroDup);
            } else {
                const index = listaDuplicatasExclusao.indexOf(numeroDup);

                if (index !== -1) {
                    listaDuplicatasExclusao.splice(index, 1);
                }
            };
        });
    });

    $('#txtConta').on('focusout', async function () {
        const codban = pegaChave('#txtBanco');
        await preencheNomeBanco(codban);
    });

    $('#btnVoltar').on('click', async function () {
        await salvaBordero();
        window.location.href = `${BASE_URI}/escenvio`;
    })

    $('#txtBordero').on('focusout', async function () {
        const bordero = $(this).val();
        if (bordero.indexOf('[') == -1) {
            msgErro('Erro ao buscar borderô! Por favor, verifique e tente novamente.');
            return
        }
        await buscaDadosBordero(pegaChave(bordero));
        listaDuplicatasExclusao = [];
    });

    $('#btnGerarArquivo').on('click', async function () {
        const caminhoSaida = $('#txtArquivoSaida').val();

        let listaDuplicatas = [];

        if (caminhoSaida == '') {
            msgErro('Não existe caminho do arquivo a ser salvo, prencha o campo "arquivo saída" no cadastro do banco! Tente novamente.');
            return
        };

        const tableDuplicatas = $('#tabelaDuplicatas').DataTable().data().toArray();

        if (tableDuplicatas.length <= 0) {
            msgErro('Não existe duplicatas no borderô para gerar o arquivo! Por favor, verifique e tente novamente.');
            return
        };

        $.LoadingOverlay('show');
        try {
            let bancoDiferente = false;
            for (let i = 0; i < tableDuplicatas.length; i++) {
                const cnpj = tableDuplicatas[i].CNPJ;
                const nrBanco = tableDuplicatas[i].NRBANCO;

                let objDuplicata = {
                    contaDup: tableDuplicatas[i].CONTA,
                    bancoDup: tableDuplicatas[i].BANCO,
                    sitCarReceberDup: tableDuplicatas[i].SITUACAO,
                    numeroDup: tableDuplicatas[i].NUMERO
                };

                listaDuplicatas.push(objDuplicata);

                const response = await requisicao('GET', '/sisplan/funcoes/v1/verificaendtelefone?', `CNPJ=${cnpj}`, null, 60000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    const jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                };

                if (nrBanco == '') {
                    msgErro(`Atenção: A carteira ${$('#txtCarteira').val()} com a conta ${$('#txtConta').val()} está habilitada para fazer a geração do nosso número. A duplicata ${tableDuplicatas[i].NUMERO} ` +
                        `ainda não possui nosso número. Favor emitir o bloqueto para gerar o nosso número e poder enviar o borderô.`);
                    return;
                };

                if (tableDuplicatas[i].BANCO !== pegaChave('#txtBanco')) {
                    bancoDiferente = true;
                    break;
                };
            };

            if (!validaSituacaoReceber()) {
                msgErro('Situação do receber inválido para carteira e conta. Verifique.');
                return;
            };

            if (await buscaValor('CADCONTA', ['ATIVO'], ['CONTA'], [`${pegaChave('#txtConta')}`]) == 'N') {
                msgErro('Conta inativa, impossível continuar!');
                return;
            };

            if (bancoDiferente) {
                msgAlerta('Existem duplicatas com o banco diferente do valor informado no campo BANCO acima. Deseja alterar o banco de todas para o valor do campo BANCO acima?', async () => {
                    const numerosDuplicatas = tableDuplicatas.map((duplicata) => { return duplicata.NUMERO });

                    const objDup = {
                        bordero: pegaChave('#txtBordero'),
                        listaDuplicatas: numerosDuplicatas
                    };

                    const responseUpdate = await requisicao('PUT', '/sisplan/escenvio/v1/trocabancoduplicatas?', `PARAMS=${JSON.stringify(objDup)}&BANCO=${pegaChave('#txtBanco')}`, null, 60000);

                    if (!responseUpdate) {
                        return;
                    };

                    if (responseUpdate.status != 200) {
                        const jsonStrUpdate = await responseUpdate.json();
                        msgErro(jsonStrUpdate.mensagem);
                        return;
                    };

                    let dataTableDuplicatas = $('#tabelaDuplicatas').DataTable().data().toArray();

                    for (let i = 0; i < dataTableDuplicatas.length; i++) {
                        dataTableDuplicatas[i].BANCO = pegaChave('#txtBanco');
                    };

                    $('#tabelaDuplicatas').DataTable().clear();
                    $('#tabelaDuplicatas').DataTable().rows.add(dataTableDuplicatas);
                    $('#tabelaDuplicatas').DataTable().draw();
                });
            };

            if ($('#txtCarteira').val() != '' && $('#txtBanco').val() != '' && $('#txtBordero').val() != '') {
                const infoCarteira = await carregaCarteira(pegaChave('#txtCarteira'));
                const buscaTaxaBordero = $('#cbBuscaTaxaBordero').is(':checked');

                await buscaNomeArquivo(pegaChave('#txtBanco'), infoCarteira, pegaChave('#txtBordero'));

                const objArquivo = {
                    conta: pegaChave('#txtConta'),
                    carteira: pegaChave('#txtCarteira'),
                    ocorrencia: $('#selectOcorrencia').val(),
                    banco: pegaChave('#txtBanco'),
                    layout: $('#txtTipoArquivo').val() + '.fr3',
                    nomeTxt: $('#txtNomeArquivo').val(),
                    situacao: pegaChave('#txtSitReceber'),
                    bordero: pegaChave('#txtBordero'),
                    EmpId: getCookie('emp_id')
                };

                const responseArquivo = await requisicao('POST', '/sisplan/escenvio/v1/gerarquivocobranca?', `GERAARQUIVO=${JSON.stringify(objArquivo)}&BUSCATAXABORDERO=${buscaTaxaBordero}`, JSON.stringify({ LISTATABLEDUPS: listaDuplicatas }), 60000);

                if (!responseArquivo) {
                    return;
                };

                if (responseArquivo.status != 200) {
                    const jsonStr = await responseArquivo.json();
                    msgErro(jsonStr.mensagem);
                    return;
                };

                await msgAlerta('Arquivo gerado com sucesso! O download será feito, favor checar na sua pasta de downloads.', async () => {
                    try {
                        const url = '/sisplan/escenvio/v1/baixaarquivocobranca?';
                        const params = `CAMINHO_TXT=${await responseArquivo.text()}`;
                        const response = await requisicao('GET', url, params, '', 180000);

                        if (!response) {
                            msgAlerta("Não foi possível realizar a ação.");
                            return;
                        }

                        if (response.status != 200) {
                            const jsonStr = await response.json();
                            msgAlerta(jsonStr.mensagem);
                            return;
                        }

                        const txt = await response.text();

                        if (txt != '') {
                            const file = new Blob([txt], { type: "text/plain" });
                            const fileName = `${$('#txtNomeArquivo').val()}`;
                            saveAs(file, fileName);
                        } else {
                            msgAlerta('Arquivo de cobrança não encontrado!');
                            return;
                        };

                        localStorage.removeItem('borderoSalvo');
                        window.location.href = `${BASE_URI}/escenvio`;
                    } catch (error) {
                        console.log(error);
                    };
                }, () => { }, () => { }, () => { }, false, true);
            };
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    // $('#txtBanco').on('change', async function () {
    //     await changeBanco();
    // });

    $('#txtConta').on('change', async function () {
        await changeConta();
    });

    $('#btnExcluirDup').on('click', async function () {
        msgAlerta('Você tem certeza que deseja excluir as duplicatas selecionadas do borderô?', async () => {
            $.LoadingOverlay('show');
            try {
                if (listaDuplicatasExclusao.length <= 0) {
                    msgErro('Nenhuma duplicata selecionada. Verifique!');
                    return;
                };
                const objDuplicatasExclusao = {
                    bordero: pegaChave('#txtBordero'),
                    listaDuplicatas: listaDuplicatasExclusao
                };
                const url = '/sisplan/escenvio/v1/excluiduplicatasbordero?';

                const response = await requisicao('DELETE', url, `PARAMS=${JSON.stringify(objDuplicatasExclusao)}`, null, 60000);

                if (!response) {
                    limpaFiltros();
                    return;
                };

                if (response.status != 200) {
                    const jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    limpaFiltros();
                    return;
                };

                criaMensagemSucesso('Duplicadas excluídas do borderô com sucesso!', () => { $('#txtBordero').trigger('focusout') });
            } finally {
                $.LoadingOverlay('hide');
            }
        })
    });

    $('#btnExcluirTodas').on('click', async function () {
        msgAlerta('Você tem certeza que deseja excluir todas as duplicatas do borderô?', async () => {
            $.LoadingOverlay('show');
            try {
                const datatableDuplicatas = $('#tabelaDuplicatas').DataTable().data().toArray();
                if (datatableDuplicatas.length <= 0) {
                    msgErro('Não existem duplicatas para excluir. Verifique!');
                    return;
                };
                const listaTodasDups = datatableDuplicatas.map((registro) => { return registro.NUMERO });
                const objDuplicatasExclusao = {
                    bordero: pegaChave('#txtBordero'),
                    listaDuplicatas: listaTodasDups
                };
                const url = '/sisplan/escenvio/v1/excluiduplicatasbordero?';

                const response = await requisicao('DELETE', url, `PARAMS=${JSON.stringify(objDuplicatasExclusao)}`, null, 60000);

                if (!response) {
                    limpaFiltros();
                    return;
                };

                if (response.status != 200) {
                    const jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    limpaFiltros();
                    return;
                };

                criaMensagemSucesso('Todas duplicatas excluídas do borderô com sucesso!', () => { $('#txtBordero').trigger('focusout') });
            } finally {
                $.LoadingOverlay('hide');
            }
        })
    });

    criaPesquisas();

    await criaDataTable();

    await recarregaBordero();

    function retornaCampoSel(meta) {
        var opcoes = `<div class="icheck-danger d-inline">
        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
        <label for="check_col_${meta.row}_row_${meta.col}"></label>
        </div>`
        return opcoes
    };

    async function criaDataTable(json) {
        if ($.fn.DataTable.isDataTable('#tabelaDuplicatas')) {
            $('#tabelaDuplicatas').DataTable().destroy();
            $('#tabelaDuplicatas').empty();
        };

        if (json) {
            $('#tabelaDuplicatas').DataTable({
                paging: true,
                pageLength: 6,
                lengthChange: false,
                filter: false,
                info: false,
                order: false,
                destroy: true,
                autoWidth: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                data: json,
                columns: [
                    {
                        "title": "SEL",
                        "data": "SEL",
                    },
                    {
                        "title": "Número",
                        "data": "NUMERO",
                    },
                    {
                        "title": "Bordero",
                        "data": "BORDERO",
                    },
                    {
                        "title": "Nome",
                        "data": "NOME",
                    },
                    {
                        "title": "Emissão",
                        "data": "DT_EMISSAO",
                    },
                    {
                        "title": "Vencimento",
                        "data": "DT_VENCTO",
                    },
                    {
                        "title": "Saída",
                        "data": "DT_SAIDA",
                    },
                    {
                        "title": "Valor",
                        "data": "VALOR2",
                    },
                    {
                        "title": "Valor Original",
                        "data": "VAL_ORIGIN",
                    },
                    {
                        "title": "Desconto",
                        "data": "DESCONTO",
                    },
                    {
                        "title": "Juros",
                        "data": "JUROS",
                    },
                    {
                        "title": "Taxa",
                        "data": "TAXA",
                    },
                    {
                        "title": "Emissão Bordero",
                        "data": "DT_EMI_BORDERO",
                    },
                    {
                        "title": "Taxa Compra",
                        "data": "TXCOMPRA",
                    },
                    {
                        "title": "Taxa Venda",
                        "data": "TXVENDA",
                    },
                    {
                        "title": "Empresa",
                        "data": "EMP",
                    },
                    {
                        "title": "Banco",
                        "data": "BANCO",
                    },
                    {
                        "title": "Nosso Número",
                        "data": "NRBANCO",
                    },
                    {
                        "title": "Histórico",
                        "data": "HISTORICO",
                    },
                    {
                        "title": "Instrução",
                        "data": "INSTRUCAO",
                    },
                    {
                        "title": "Protesto",
                        "data": "PROTESTO",
                    },
                    {
                        "title": "Fatura",
                        "data": "FATURA",
                    },
                    {
                        "title": "Perc. Juros Dia Atraso",
                        "data": "PERC_JUROS_DIA_ATRASO",
                    },
                    {
                        "title": "Valor Juros Dia Atraso",
                        "data": "VALOR_JUROS_DIA_ATRASO",
                    },
                    {
                        "title": "Multa Atraso",
                        "data": "MULTA_ATRASO",
                    },
                    {
                        "title": "Valor Calc. Dia Atraso",
                        "data": "VALOR_CALC_DIA_ATRASO",
                    },
                    {
                        "title": "Histórico",
                        "data": "HISTORICO",
                    },
                    {
                        "title": "Desc. Histórico",
                        "data": "DESC_HISTORICO",
                    },
                    {
                        "title": "Fat_Loja",
                        "data": "FAT_LOJA",
                    },
                    {
                        "title": "Dias Protesto",
                        "data": "DIAS_PROTESTO",
                    },
                    {
                        "title": "Tipo Dias Classif.",
                        "data": "TIPO_DIAS_CLASSIF",
                    },
                    {
                        "title": "Desc_CondPagto",
                        "data": "DESC_CONDPAGTO",
                    },
                ],
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row, meta) {
                            return retornaCampoSel(meta);
                        },
                    },
                ],
            });
        } else {
            $('#tabelaDuplicatas').DataTable({
                paging: true,
                filter: false,
                info: false,
                pageLength: 6,
                order: false,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columns: [
                    { "title": "SEL" },
                    { "title": "Número" },
                    { "title": "Bordero" },
                    { "title": "Nome" },
                    { "title": "Emissão" },
                    { "title": "Vencimento" },
                    { "title": "Saída" },
                    { "title": "Valor" },
                    { "title": "Valor Original" },
                    { "title": "Desconto" },
                    { "title": "Juros" },
                    { "title": "Taxa" },
                    { "title": "Emissão Bordero" },
                    { "title": "Taxa Compra" },
                    { "title": "Taxa Venda" },
                    { "title": "Empresa" },
                    { "title": "Banco" },
                    { "title": "Nosso Número" },
                    { "title": "Histórico" },
                    { "title": "Instrução" },
                    { "title": "Protesto" },
                    { "title": "Fatura" },
                    { "title": "Perc. Juros Dia Atraso" },
                    { "title": "Valor Juros Dia Atraso" },
                    { "title": "Multa Atraso" },
                    { "title": "Valor Calc. Dia Atraso" },
                    { "title": "Histórico" },
                    { "title": "Desc. Histórico" },
                    { "title": "Fat_Loja" },
                    { "title": "Dias Protesto" },
                    { "title": "Tipo Dias Classif." },
                    { "title": "Desc_CondPagto" },
                ]
            });
        };
    };

    // async function changeBanco() {
        // tabelaBanco = 'CADBAN';

        // if (Existe('CADBAN_CONF', ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco')}`, parseInt(getCookie('emp_id'))])) {
        //     tabelaBanco = 'CADBAN_CONF';
        // };

        // if (Existe('CADBAN', ['BANCO'], [`${pegaChave('#txtBanco')}`])) {
            // const buscaConta = await buscaValor('CADCONTA', ['CONTA'], ['LOCAL'], [`${pegaChave('#txtConta')}`]);

            // if (buscaConta != '') {
            //     $('#txtArquivoSaida').val(buscaConta);
            // } else if (tabelaBanco == 'CADBAN') {
            //     $('#txtArquivoSaida').val(`${await buscaValor(tabelaBanco, ['LOCAL'], ['BANCO'], [`${pegaChave('#txtBanco')}`])}`);
            // } else {
            //     $('#txtArquivoSaida').val(`${await buscaValorListaWhere(tabelaBanco, ['LOCAL'], ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco')}`, parseInt(getCookie('emp_id'))])}`);
            // };

            // if (tabelaBanco == 'CADBAN') {
            //     $('#txtArquivoSaida').val(`${await buscaValor(tabelaBanco, ['LAYOUT'], ['BANCO'], [`${pegaChave('#txtBanco')}`])}`);
            // } else {
            //     $(`#txtArquivoSaida`).val(`${await buscaValorListaWhere(tabelaBanco, ['LAYOUT'], ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco')}`, parseInt(getCookie('emp_id'))])}`)
            // };

            // if (await buscaValorListaWhere('CARTEIRA', ['NOME_ARQUIVO'], ['CARTEIRA', 'CONTA'], [`${pegaChave('#txtCarteira')}`, `${pegaChave('#txtConta')}`]) != '2') {
            //     if (pegaChave('#txtBanco') == '077') {
            //         if (tabelaBanco == 'CADBAN') {
            //             $('#txtNomeArquivo').val(`${await buscaValor(tabelaBanco, ['NOME_ARQ'], ['BANCO'], [`${pegaChave('#txtBanco')}`])}` + ZeroE(7, $('#txtSequencial').val()) + '.' + extArq);
            //         } else {
            //             $('#txtNomeArquivo').val(`${await buscaValorListaWhere(tabelaBanco, ['NOME_ARQ'], ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco')}`, parseInt(getCookie('emp_id'))])}` + ZeroE(7, $('#txtSequencial').val()) + '.' + extArq);
            //         };
            //         $('#txtNomeArquivo').val(`${$('#txtNomeArquivo').val().replaceAll('.REM', '') + '.REM'}`);
            //     } else {
            //         if (tabelaBanco == 'CADBAN') {
            //             $('#txtNomeArquivo').val(`${await buscaValor(tabelaBanco, ['NOME_ARQ'], ['BANCO'], [`${pegaChave('#txtBanco')}`])}` + pegaChave('#txtBordero') + '.' + extArq);
            //         } else {
            //             $('#txtNomeArquivo').val(`${await buscaValorListaWhere(tabelaBanco, ['NOME_ARQ'], ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco')}`, parseInt(getCookie('emp_id'))])}` + pegaChave('#txtBordero') + '.' + extArq);
            //         }
            //     }
            // } else if (tabelaBanco == 'CADBAN') {
            //     $('#txtNomeArquivo').val(`${await buscaValor(tabelaBanco, ['NOME_ARQ'], ['BANCO'], [`${pegaChave('#txtBanco')}}`])}` + '.' + extArq);
            // } else {
            //     $('#txtNomeArquivo').val(`${await buscaValorListaWhere(tabelaBanco, ['NOME_ARQ'], ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco'), parseInt(getCookie('emp_id'))}`])}` + '.' + extArq)
            // };
        // };
    // };

    async function changeConta() {
        if (Existe('CADCONTA', ['CONTA'], [`${pegaChave('#txtConta')}`])) {
            const infoConta = await carregaConta(pegaChave('#txtConta'));
            if (infoConta == '') {
                msgErro('Erro ao buscar a conta! Por favor, verifique.');
                return
            };
            $('#txtBanco').val('');
            await preencheNomeBanco(infoConta.BANCO);
            tabelaBanco = 'CADBAN';
            if (Existe('CADBAN_CONF', ['BANCO', 'EMP_ID'], [`${pegaChave('#txtBanco')}`, parseInt(getCookie('emp_id'))])) {
                tabelaBanco = 'CADBAN_CONF';
            };
            const infoBanco = await carregaBanco();
            $('#txtCarteira').val('');
            $('#btnCarteira').pesquisa_serverside(['#txtCarteira'], ['CARTEIRA'], ['DESCRICAO'], `{"tabela":"CARTEIRA", "camposSelect":["CARTEIRA", "CONVENIO", "DESCRICAO", "ACEITE", "TIPO", "SITUACAO"], "where": ["CONTA = '${pegaChave('#txtConta')}' AND CARTEIRA <> 'P'"]}`, 'Pesquisa de Carteira'); // NÃO PODE TRAZER P PORQUE É INDENTIFICADOR DE CARTEIRA DE PAGAMENTO
            $('#txtCarteira').autocompleta(1, `JSON={ "tabela":"CARTEIRA", "camposSelect":[ "CARTEIRA CHAVE", "DESCRICAO DESCRICAO"], "where": ["CONTA = '${pegaChave('#txtConta')}' AND CARTEIRA <> 'P'"]}`);
            const dadosSelect = {
                tabela: 'CARTEIRA',
                camposSelect: ['CARTEIRA'],
                where: [`CONTA = '${pegaChave('#txtConta')}' AND CARTEIRA <> 'P'`]
            };
            const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

            if (retornoSelect.length > 0) {
                $('#txtCarteira').val(`${retornoSelect[0].CARTEIRA}`);
                await changeCarteira();
            };
        };
    };

    async function changeCarteira() {
        let carteira;

        if ($('#txtCarteira').val().indexOf('[') == -1) {
            carteira = $('#txtCarteira').val();
        } else {
            carteira = pegaChave('#txtCarteira')
        }
        if (Existe('CARTEIRA', ['CARTEIRA'], [`${carteira}`])) {
            const dadosSelect = {
                tabela: 'CARTEIRA',
                camposSelect: ['DESCRICAO', 'ENVIA_INSTR_1', 'ENVIA_INSTR_2', 'DESCRICAO2', 'DESCRICAO3', 'SITUA_BCO', 'DT_VENDOR', 'IMP_COBREBEM', 'TIPO_DIAS_PROT', 'TIPO_DIAS_CLASSIF'],
                where: [`CARTEIRA = '${carteira}' AND CONTA = '${pegaChave('#txtConta')}'`]
            };

            const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

            if (retornoSelect.length > 0) {
                $('#txtCarteira').val('');
                $('#txtCarteira').val(`[${carteira}] - ${retornoSelect[0].DESCRICAO}`);
                $('#cbInstrucao1').prop('checked', (retornoSelect[0].ENVIA_INSTR_1 == 'S'));
                $('#cbInstrucao2').prop('checked', (retornoSelect[0].ENVIA_INSTR_2 == 'S'));
                $('#txtInstrucaoCob1').val(`${retornoSelect[0].DESCRICAO2}`);
                $('#txtInstrucaoCob2').val(`${retornoSelect[0].DESCRICAO3}`);
                $('#txtSitReceber').val(`[${retornoSelect[0].SITUA_BCO}] - ${await buscaValor('TABSIT', ['DESCRICAO'], ['CODIGO'], [`${retornoSelect[0].SITUA_BCO}`])}`);
            };
        };
    };

    async function exitCarteira() {
        const carteira = pegaChave('#txtCarteira');

        if (carteira == 'P') {
            msgAlerta('Atenção! Carteira do tipo paramento. Não é possível selecionar carteira do tipo pagamento nesta tela.');
            $('#txtCarteira').val('');
            $('#txtCarteira').focus();
        } else if (Existe('CARTEIRA', ['CONTA', 'CARTEIRA'], [`${pegaChave('#txtConta')}`, `${pegaChave('#txtCarteira')}`])) {
            const infoCarteira = await carregaCarteira(pegaChave('#txtCarteira'));
            $('#txtSitReceber').val(`${infoCarteira.SITUA_BCO}`);

            $('#txtDiasProtestar').val(`${infoCarteira.DIASPROTESTO}`)

            $('#txtVariacao1').val(`${infoCarteira.INSTRUCAO_1}`);
            $('#txtVariacao2').val(`${infoCarteira.INSTRUCAO_2}`);

            if (!($('#cbBuscaTaxaBordero').is(':checked'))) {
                $('#txtJuros').val(`${parseFloat(infoCarteira.TAXA1).toFixed(3).replaceAll('.', ',')}%`);
                $('#txtMulta').val(`${parseFloat(infoCarteira.TAXA2).toFixed(3).replaceAll('.', ',')}`);
            };

            const nomeLayout = await buscaValorListaWhere('CARTEIRA', ['LAYOUT'], ['CONTA', 'CARTEIRA'], [`${pegaChave('#txtConta')}`, `${carteira}`]);

            if (nomeLayout != '' && nomeLayout != undefined) {
                $('#txtTipoArquivo').val(`${nomeLayout.LAYOUT}`);
            };

            const iSeq = await existeArquivoGeradoNaData(pegaChave('#txtConta'), pegaChave('#txtCarteira'), pegaChave('#txtBordero'));

            // if (iSeq <= 1 || infoCarteira.EXTENSAO_ARQ_SEQ) {
            //     extArq = infoCarteira.EXTENSAO_ARQUIVO == '' ? 'REM' : infoCarteira.EXTENSAO_ARQUIVO;
            // } else {
            //     extArq = infoCarteira.EXTENSAO_ARQ_SEQ == '' ? 'REM' : infoCarteira.EXTENSAO_ARQ_SEQ + String(iSeq);
            // }

            if (iSeq <= 1 || infoCarteira.EXTENSAO_ARQ_SEQ == '' || infoCarteira.EXTENSAO_ARQ_SEQ == undefined) {
                extArq = infoCarteira.EXTENSAO_ARQUIVO == undefined || infoCarteira.EXTENSAO_ARQUIVO.replace(' ', '') == '' ? 'REM' : infoCarteira.EXTENSAO_ARQUIVO;
            } else {
                extArq = infoCarteira.EXTENSAO_ARQ_SEQ == undefined || infoCarteira.EXTENSAO_ARQ_SEQ.replace(' ', '') == '' ? 'REM' : infoCarteira.EXTENSAO_ARQ_SEQ + String(iSeq);
            }

            await buscaNomeArquivo(pegaChave('#txtBanco'), infoCarteira, pegaChave('#txtBordero'));
            $('#txtNomeArquivo').val(`${nomeArquivo + '.' + extArq}`);
            $('#cbBancoEmiteBol').prop('checked', (infoCarteira.IMP_BOLETO == 'S'));
            await calculaTaxas();
        };
    };

    async function carregaConta(conta) {
        const dadosSelect = {
            tabela: 'CADCONTA',
            camposSelect: ['*'],
            where: [`CONTA = '${conta}'`],
        };

        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

        if (retornoSelect.length > 0) {
            return retornoSelect[0]
        } else {
            return ''
        };
    };

    async function carregaBanco(banco) {
        let retornoSelect;

        if (tabelaBanco == 'CADBAN') {
            const dadosSelect = {
                tabela: 'CADBAN',
                camposSelect: ['*'],
                where: [`BANCO = '${banco}'`],
            };

            retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

            if (retornoSelect.length > 0) {
                return retornoSelect[0]
            } else {
                return ''
            };
        } else {
            const dadosSelect = {
                tabela: 'CADBAN',
                camposSelect: ['CADBAN.NOME_BANCO', 'CADBAN_CONF.*'],
                innerJoin: [{ 'tabela': 'CADBAN_CONF', 'condicao': 'CADBAN.BANCO = CADBAN_CONF.BANCO' }],
                where: [`CADBAN.BANCO = '${banco}' AND CADBAN_CONF.EMP_ID = '${getCookie('emp_id')}'`],
            };

            retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

            if (retornoSelect.length > 0) {
                return retornoSelect[0]
            } else {
                return ''
            };
        };
    };

    async function carregaCarteira(carteira) {
        const dadosSelect = {
            tabela: 'CARTEIRA',
            camposSelect: ['*'],
            where: [`CONTA = '${pegaChave('#txtConta')}' AND CARTEIRA = '${carteira}'`]
        };

        retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

        if (retornoSelect.length > 0) {
            return retornoSelect[0];
        } else {
            return '';
        };
    };

    async function calculaTaxas() {
        const datatableBordero = $('#tabelaDuplicatas').DataTable().data().toArray();
        const buscaTaxaBordero = $('#cbBuscaTaxaBordero').is(':checked');

        for (let i = 0; i < datatableBordero.length; i++) {
            datatableBordero[i].PERC_JUROS_DIA_ATRASO = (parseFloat(!buscaTaxaBordero ? 0 : datatableBordero[i].TAXA) + parseFloat($('#txtJuros').val())) / 30;
            datatableBordero[i].VALOR_JUROS_DIA_ATRASO = (parseFloat(!buscaTaxaBordero ? 0 : datatableBordero[i].TAXA) + parseFloat($('#txtJuros').val()) / 30 / 100) * parseFloat(datatableBordero[i].VLR_TIT);
            datatableBordero[i].MULTA_ATRASO = ((parseFloat($('#txtMulta').val()) / 100) * parseFloat(datatableBordero[i].VLR_TIT));
            datatableBordero[i].VALOR_CALC_DIA_ATRASO = (parseFloat(datatableBordero[i].VALOR_JUROS_DIA_ATRASO) * parseInt(moment().diff(datatableBordero[i].DT_VENCTO, 'days')));
        };

        $('#tabelaDuplicatas').DataTable().clear();
        $('#tabelaDuplicatas').DataTable().rows.add(datatableBordero);
        $('#tabelaDuplicatas').DataTable().draw();
    };

    function criaPesquisas() {
        $('#btnBordero').pesquisa_serverside(['#txtBordero'], ['NUMERO'], ['DATA'], `{"tabela":"BORDERO", "camposSelect":["NUMERO", "DATA", "CONTA", "CARTEIRA", "VARIACAO", "OCORRENCIA"], "where": null}`, 'Pesquisa de Bordero');
        $('#txtBordero').autocompleta(1, 'JSON={ "tabela":"BORDERO", "camposSelect":[ "NUMERO CHAVE", "DATA DESCRICAO"], "where": null}');
        $('#btnLimpaBordero').on('click', function () {
            $('#txtBordero').val('');
        });

        $('#btnConta').pesquisa_serverside(['#txtConta', '#txtBanco'], ['CONTA', 'BANCO'], ['DESCRICAO', 'AGENCIA'], `{"tabela":"CADCONTA", "camposSelect":["CONTA", "DESCRICAO", "BANCO", "AGENCIA", "CNPJ", "INSCRICAO", "CONTADOR", "IMP_FLUXO", "EMPRESA", "TIPO", "CODIGO", "ATIVO"], "where": null}`, 'Pesquisa de Conta');
        $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btnLimpaConta').on('click', function () {
            $('#txtConta').val('');
        });

        $('#btnCarteira').pesquisa_serverside(['#txtCarteira'], ['CARTEIRA'], ['DESCRICAO'], `{"tabela":"CARTEIRA", "camposSelect":["CARTEIRA", "CONVENIO", "DESCRICAO", "ACEITE", "TIPO", "SITUACAO"], "where": null}`, 'Pesquisa de Carteira');
        $('#txtCarteira').autocompleta(1, 'JSON={ "tabela":"CARTEIRA", "camposSelect":[ "CARTEIRA CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btnLimpaCarteira').on('click', function () {
            $('#txtCarteira').val('');
        });
    };

    async function preencheNomeBanco(codbanco) {
        const dadosSelect = {
            tabela: 'CADBAN',
            camposSelect: ['NOME_BANCO'],
            where: [`BANCO = '${codbanco}'`],
        };

        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

        if (retornoSelect.length > 0) {
            $('#txtBanco').val(`[${codbanco}] - ${retornoSelect[0].NOME_BANCO}`);
        };

        // await changeBanco();
    };

    async function existeArquivoGeradoNaData(conta, carteira, bordero) {
        const dataAtual = new Date();

        const pesquisaArquivo = {
            tabela: 'BORDERO',
            camposSelect: ['COUNT(*) QTDE'],
            where: [`CONTA = '${conta}' AND CARTEIRA = '${carteira}' AND DATA = '${dataAtual.getFullYear() + '-' + ((dataAtual.getMonth() + 1) < 10 ? '0' + String(dataAtual.getMonth() + 1) : String(dataAtual.getMonth() + 1)) + '-' + String(dataAtual.getDate())}' AND NUMERO <> '${bordero}'`]
        };

        const retornoArquivo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaArquivo));

        if (retornoArquivo.length > 0) {
            return parseInt(retornoArquivo[0].QTDE) + 1;
        }

        return 1;
    };

    async function salvaBordero() {
        if ($('#txtBordero').val() == '') {
            return
        };

        const borderoSalvo = pegaChave('#txtBordero');
        localStorage.setItem('borderoSalvo', borderoSalvo);
    };

    async function recarregaBordero() {
        const borderoLocalStorage = localStorage.getItem('borderoSalvo');
        if (borderoLocalStorage != '' && borderoLocalStorage != null && borderoLocalStorage != undefined) {
            const pesquisaBordero = {
                tabela: 'BORDERO',
                camposSelect: ['NUMERO AS BORDERO', 'DATA'],
                where: [`NUMERO = ${borderoLocalStorage}`]
            };

            const retornoBordero = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaBordero));

            console.log(retornoBordero);

            $('#txtBordero').val(`[${retornoBordero[0].BORDERO}] - ${retornoBordero[0].DATA}`);

            $('#txtBordero').trigger('focusout');

            localStorage.removeItem('borderoSalvo');
        };
    }

    async function montaMesSicoob(dataAt) {
        switch (dataAt) {
            case 1:
                return '1';
            case 2:
                return '2';
            case 3:
                return '3';
            case 4:
                return '4';
            case 5:
                return '5';
            case 6:
                return '6';
            case 7:
                return '7';
            case 8:
                return '8';
            case 9:
                return '9';
            case 10:
                return 'O';
            case 11:
                return 'N';
            case 12:
                return 'D';
        };
    };

    async function montaMesComZero(dataAt) {
        switch (dataAt) {
            case 1:
                return '01';
            case 2:
                return '02';
            case 3:
                return '03';
            case 4:
                return '04';
            case 5:
                return '05';
            case 6:
                return '06';
            case 7:
                return '07';
            case 8:
                return '08';
            case 9:
                return '09';
            case 10:
                return '10';
            case 11:
                return '11';
            case 12:
                return '12';
        };
    };

    async function buscaNomeArquivo(banco, carteira, bordero) {
        const pesquisaNomeArquivo = {
            tabela: 'CARTEIRA',
            camposSelect: ['NOME_ARQUIVO'],
            where: [`CARTEIRA = '${carteira.CARTEIRA}' AND CONTA = '${carteira.CONTA}'`]
        };

        const jsonStrNomeArquivo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNomeArquivo));

        let sequencial = await existeArquivoGeradoNaData(carteira.CONTA, carteira.CARTEIRA, bordero);

        const month = new Date();

        const dataAtual = month.getMonth() + 1;

        const diaAtual = new Date().getDate();

        if (jsonStrNomeArquivo.length > 0) {
            if (jsonStrNomeArquivo[0].NOME_ARQUIVO == 'S') {
                switch (dataAtual) {
                    case '01':
                        nomeArquivo = '1' + nomeArquivo;
                    case '02':
                        nomeArquivo = '2' + nomeArquivo;
                    case '03':
                        nomeArquivo = '3' + nomeArquivo;
                    case '04':
                        nomeArquivo = '4' + nomeArquivo;
                    case '05':
                        nomeArquivo = '5' + nomeArquivo;
                    case '06':
                        nomeArquivo = '6' + nomeArquivo;
                    case '07':
                        nomeArquivo = '7' + nomeArquivo;
                    case '08':
                        nomeArquivo = '8' + nomeArquivo;
                    case '09':
                        nomeArquivo = '9' + nomeArquivo;
                    case '10':
                        nomeArquivo = 'A' + nomeArquivo;
                    case '11':
                        nomeArquivo = 'B' + nomeArquivo;
                    case '12':
                        nomeArquivo = 'C' + nomeArquivo;
                };
            } else if (jsonStrNomeArquivo[0].NOME_ARQUIVO == '2') {
                let contaStr;
                if (carteira.CONTA.indexOf('-') != -1) {
                    contaStr = carteira.CONTA.substring(0, carteira.CONTA.indexOf('-'))
                } else {
                    contaStr = carteira.CONTA
                };

                if ((sequencial <= 1) || (extensaoArqSeq == '')) {
                    extArq = (carteira.EXTENSAO_ARQUIVO == '' ? 'REM' : carteira.EXTENSAO_ARQUIVO).trim();
                } else {
                    extArq = (carteira.EXTENSAO_ARQ_SEQ == '' ? 'REM' : carteira.EXTENSAO_ARQ_SEQ).trim() + String(sequencial);
                };

                nomeArquivo = contaStr + await montaMesSicoob(dataAtual) + String(new Date().getDate());
                nomeArquivo = nomeArquivo.replaceAll('.' + extArq, '') + '.' + extArq; //// NÃO FAÇO IDEIA DO PQ TA ASSIM, MAS NO ERP TA, ENTÃO EU MANTIVE POR VIA DAS DUVIDAS PORÉM SENTIDO NAO FAZ - BRUNO 15/02/2024
            } else if (jsonStrNomeArquivo[0].NOME_ARQUIVO == '3') {

                if ((sequencial <= 1) || (carteira.EXTENSAO_ARQ_SEQ == '')) {
                    extArq = carteira.EXTENSAO_ARQUIVO == '' ? 'REM' : carteira.EXTENSAO_ARQUIVO;
                } else {
                    extArq = carteira.EXTENSAO_ARQ_SEQ == '' ? 'REM' : carteira.EXTENSAO_ARQ_SEQ;
                };

                nomeArquivo = carteira.CONVENIO + await montaMesSicoob(dataAtual) + (diaAtual <= 9 ? '0' + String(diaAtual) : String(diaAtual));
                nomeArquivo = (nomeArquivo.replaceAll('.' + extArq, '')) + '.' + extArq; //// NÃO FAÇO IDEIA DO PQ TA ASSIM, MAS NO ERP TA, ENTÃO EU MANTIVE POR VIA DAS DUVIDAS PORÉM SENTIDO NAO FAZ - BRUNO 15/02/2024
            } else if (jsonStrNomeArquivo[0].NOME_ARQUIVO == '9') {

                if ((sequencial <= 1) || (carteira.EXTENSAO_ARQ_SEQ == '')) {
                    extArq = carteira.EXTENSAO_ARQUIVO == '' ? 'REM' : carteira.EXTENSAO_ARQUIVO;
                } else {
                    extArq = carteira.EXTENSAO_ARQ_SEQ == '' ? 'REM' : carteira.EXTENSAO_ARQ_SEQ;
                };

                nomeArquivo = carteira.CONVENIO + await montaMesComZero(dataAtual) + (diaAtual <= 9 ? '0' + String(diaAtual) : String(diaAtual));
                nomeArquivo = (nomeArquivo.replaceAll('.' + extArq, '')) + '.' + extArq; //// NÃO FAÇO IDEIA DO PQ TA ASSIM, MAS NO ERP TA, ENTÃO EU MANTIVE POR VIA DAS DUVIDAS PORÉM SENTIDO NAO FAZ - BRUNO 15/02/2024
            } else if ((jsonStrNomeArquivo[0].NOME_ARQUIVO == '4') || (jsonStrNomeArquivo[0].NOME_ARQUIVO == '5') || (jsonStrNomeArquivo[0].NOME_ARQUIVO == '6') || (jsonStrNomeArquivo[0].NOME_ARQUIVO == '7') || (jsonStrNomeArquivo[0].NOME_ARQUIVO == '8')) {
                let sequencial;

                if ((jsonStrNomeArquivo[0].NOME_ARQUIVO == '4') || (jsonStrNomeArquivo[0].NOME_ARQUIVO == '8')) {
                    sequencial = String(bordero);
                };

                if (jsonStrNomeArquivo[0].NOME_ARQUIVO == '5') {
                    sequencial = String(carteira.SEQUENCIAL);
                };

                if ((jsonStrNomeArquivo[0].NOME_ARQUIVO == '6') || (jsonStrNomeArquivo[0].NOME_ARQUIVO == '7')) {
                    sequencial = parseInt(sequencial);
                };

                nomeArquivo = carteira.NOME_ARQ;

                if (nomeArquivo == '') {
                    const buscaValor = {
                        tabela: 'CADBAN',
                        camposSelect: ['NOME_ARQ'],
                        where: [`BANCO = '${banco}'`]
                    };

                    const jsonStrBuscaValor = await retornaJsonPesquisaPadrao(JSON.stringify(buscaValor));

                    nomeArquivo = jsonStrBuscaValor[0].NOME_ARQ;
                };

                if (jsonStrNomeArquivo[0].NOME_ARQUIVO == '7') {
                    if (carteira.CONTA.indexOf('-') > 0) {
                        nomeArquivo = carteira.CONTA.substring(1, carteira.CONTA.indexOf('-') - 1);
                    } else {
                        nomeArquivo = carteira.CONTA;
                    };
                };

                if (carteira.EXTENSAO_ARQ_SEQ == '') {
                    extArq = carteira.EXTENSAO_ARQUIVO == '' ? 'REM' : carteira.EXTENSAO_ARQUIVO;
                };

                const dtHoje = new Date();

                if (jsonStrNomeArquivo[0].NOME_ARQUIVO != '8') {
                    nomeArquivo = nomeArquivo + String(dtHoje.getDate()) + String(dtHoje.getMonth() + 1) + String(dtHoje.getFullYear() % 100) + String(sequencial);
                    nomeArquivo = nomeArquivo.replaceAll('.' + extArq, '') + '.' + extArq; //// NÃO FAÇO IDEIA DO PQ TA ASSIM, MAS NO ERP TA, ENTÃO EU MANTIVE POR VIA DAS DUVIDAS PORÉM SENTIDO NAO FAZ - BRUNO 15/02/2024
                } else {
                    nomeArquivo = nomeArquivo + String(dtHoje.getDate()) + String(dtHoje.getMonth() + 1) + String(dtHoje.getFullYear() % 100) + '_' + String(sequencial);
                    nomeArquivo = nomeArquivo.replaceAll('.' + extArq, '') + '.' + extArq; //// NÃO FAÇO IDEIA DO PQ TA ASSIM, MAS NO ERP TA, ENTÃO EU MANTIVE POR VIA DAS DUVIDAS PORÉM SENTIDO NAO FAZ - BRUNO 15/02/2024
                };

            } else if (banco == '077') {
                const buscaNomeArquivo = {
                    tabela: 'CARTEIRA',
                    camposSelect: ['NOME_ARQUIVO'],
                    where: [`BANCO = '${banco}'`]
                };

                const jsonStrBuscaNomeArquivo = await retornaJsonPesquisaPadrao(JSON.stringify(buscaNomeArquivo));

                if (jsonStrBuscaNomeArquivo[0].NOME_ARQUIVO != '2') {
                    if (carteira.EXTENSAO_ARQ_SEQ == '') {
                        extArq = carteira.EXTENSAO_ARQUIVO == '' ? 'REM' : carteira.EXTENSAO_ARQUIVO;
                    } else {
                        extArq = carteira.EXTENSAO_ARQ_SEQ == '' ? 'REM' : carteira.EXTENSAO_ARQ_SEQ;
                    };

                    if (tabelaBanco == 'CADBAN') {
                        const buscaNomeArquivo = {
                            tabela: 'CADBAN',
                            camposSelect: ['NOME_ARQ'],
                            where: [`BANCO = '${banco}'`]
                        };

                        const jsonStrBuscaNomeArquivo = await retornaJsonPesquisaPadrao(JSON.stringify(buscaNomeArquivo));

                        nomeArquivo = jsonStrBuscaNomeArquivo[0].NOME_ARQ + ZeroE(7, $('#txtSequencial').val());
                    } else {
                        const buscaNomeArquivo2 = {
                            tabela: 'CADBAN',
                            camposSelect: ['NOME_ARQ'],
                            where: [`BANCO = '${banco}' AND EMP_ID = '${getCookie('emp_id')}'`]
                        }

                        const jsonStrBuscaNomeArquivo2 = await retornaJsonPesquisaPadrao(JSON.stringify(buscaNomeArquivo2));

                        nomeArquivo = jsonStrBuscaNomeArquivo2[0].NOME_ARQ + ZeroE(7, $('#txtSequencial').val());
                    }
                };
            };

            nomeArquivo == '' || nomeArquivo == undefined ? nomeArquivo = '' : nomeArquivo = nomeArquivo.replaceAll('.' + extArq, '');
        } else {
            msgErro('Não foi encontrado o nome do arquivo! Favor verificar e tentar novamente.');
            return;
        };
    };

    async function buscaDadosBordero(bordero) {
        try {
            $.LoadingOverlay('show');

            if (bordero == '' || bordero == null || bordero == undefined) {
                msgErro('Campo borderô vazio, por favor verifique!');
                limpaFiltros();
                return
            };

            // const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            //     : [getCookie('emp_id')];

            const url = '/sisplan/escenvio/v1/buscadadosbordero?';

            // const response = await requisicao('GET', url, `BORDERO=${bordero}&EMP_IDS=${empresas}`, null, 60000);
            const response = await requisicao('GET', url, `BORDERO=${bordero}`, null, 60000);

            if (!response) {
                limpaFiltros();
                return;
            };

            jsonStr = await response.json();

            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                limpaFiltros();
                $('#txtBordero').val('');
                return;
            };

            if (jsonStr.length <= 0) {
                msgErro('Não foi encontrado duplicatas neste borderô! Por favor, verifique e tente novamente.');
                limpaFiltros();
                $('#txtBordero').val('');
                return
            };

            await criaDataTable(jsonStr);

            const infoCarteira = await buscaDadosCarteira(jsonStr[0].CARTEIRA, jsonStr[0].CONTA);

            $('#txtCarteira').val(`[${infoCarteira.CARTEIRA}] - ${infoCarteira.DESCRICAO}`);
            $('#txtDataVendor').val(`${infoCarteira.DT_VENDOR}`);
            $('#txtInstrucaoCob1').val(`${infoCarteira.DESCRICAO2}`);
            $('#txtInstrucaoCob2').val(`${infoCarteira.DESCRICAO3}`);
            $('#txtDiasProtestar').val(`${infoCarteira.DIASPROTESTO}`);
            $('#txtConta').val('');
            $('#txtConta').val(`[${infoCarteira.CONTA}] - ${infoCarteira.DESC_CONTA}`);
            await changeConta();
            // await changeBanco();
            await changeCarteira();
            await exitCarteira();
            $('#txtBanco').val(`[${jsonStr[0].BANCO}] - ${jsonStr[0].NOME_BANCO}`);
            $('#txtSequencial').val(`${infoCarteira.SEQUENCIAL}`);
            $('#txtJuros').val(`${parseFloat(infoCarteira.JUROS).toFixed(3).replace('.', ',')}%`);
            $('#txtMulta').val(`${parseFloat(infoCarteira.MULTA).toFixed(3).replace('.', ',')}`);

            const infoOcorrencias = await buscaOcorrencia(jsonStr[0].BANCO);

            infoOcorrencias.forEach((ocorrencia) => {
                $('#selectOcorrencia').append(
                    `<option value="${ocorrencia.CODIGO}">${ocorrencia.CODIGO}| ${ocorrencia.DESCRICAO}</option>`
                );
            });

            $('#txtSitReceber').val(`[${infoCarteira.SITUACAO_RECEBER}] - ${infoCarteira.DESC_SITUACAO_RECEBER}`);
            $('#txtVariacao1').val(`${infoCarteira.INSTRUCAO_1}`);
            $('#txtVariacao2').val(`${infoCarteira.INSTRUCAO_2}`);
            $('#txtTipoArquivo').val(`${infoCarteira.LAYOUT}`)

            infoCarteira.IMP_BOLETO == 'S' ? $('#cbBancoEmiteBol').prop('checked', true) : $('#cbBancoEmiteBol').prop('checked', false);
            infoCarteira.ENVIA_INSTR_1 == 'S' ? $('#cbInstrucao1').prop('checked', true) : $('#cbInstrucao1').prop('checked', false);
            infoCarteira.ENVIA_INSTR_2 == 'S' ? $('#cbInstrucao2').prop('checked', true) : $('#cbInstrucao2').prop('checked', false);

            // $('.campoSel').on('change', async function () {
            //     const numeroDup = $(this).parent().parent().parent().children()[1].textContent;
            //     if (!listaDuplicatasExclusao.includes(numeroDup)) {
            //         listaDuplicatasExclusao.push(numeroDup);
            //     } else {
            //         const index = listaDuplicatasExclusao.indexOf(numeroDup);

            //         if (index !== -1) {
            //             listaDuplicatasExclusao.splice(index, 1);
            //         };
            //     };
            // });

        } catch (error) {
            console.error(error);
            limpaFiltros();
            return
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    async function buscaDadosCarteira(carteira, conta) {
        const pesquisaParam = {
            tabela: 'CARTEIRA',
            camposSelect: ['CARTEIRA.CARTEIRA',
                'CARTEIRA.DESCRICAO',
                'CARTEIRA.CONTA',
                'CARTEIRA.TAXA1 JUROS',
                'CARTEIRA.TAXA2 MULTA',
                'CADCONTA.DESCRICAO DESC_CONTA',
                'CADCONTA.LOTE_SERVICO SEQUENCIAL',
                'CARTEIRA.SITUA_BCO SITUACAO_RECEBER',
                'TABSIT.DESCRICAO DESC_SITUACAO_RECEBER',
                'CARTEIRA.CONVENIO',
                'CARTEIRA.DIASPROTESTO',
                'CARTEIRA.DT_VENDOR',
                'CARTEIRA.DESCRICAO2',
                'CARTEIRA.DESCRICAO3',
                'CARTEIRA.INSTRUCAO_1',
                'CARTEIRA.INSTRUCAO_2',
                'CARTEIRA.NR_BANCO',
                'CARTEIRA.EXTENSAO_ARQUIVO',
                'CARTEIRA.IMP_BOLETO',
                'CARTEIRA.ENVIA_INSTR_1',
                'CARTEIRA.ENVIA_INSTR_2',
                'CARTEIRA.LAYOUT',
                'CARTEIRA.EXTENSAO_ARQ_SEQ',
                'CARTEIRA.EXTENSAO_ARQUIVO',
                'CARTEIRA.CONVENIO',
                'CARTEIRA.NOME_ARQ'
            ],
            innerJoin: [
                { tabela: 'CADCONTA', condicao: 'CARTEIRA.CONTA = CADCONTA.CONTA' },
                { tabela: 'TABSIT', condicao: 'CARTEIRA.SITUA_BCO = TABSIT.CODIGO' }
            ],
            where: [`CARTEIRA.CARTEIRA = '${carteira}' AND CARTEIRA.CONTA = '${conta}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        return jsonStr[0];
    };

    async function buscaOcorrencia(codban) {
        const pesquisaOcorrencia = {
            tabela: 'OCORRENCIA',
            camposSelect: ['*'],
            where: [`BANCO = '${codban}' AND TIPO = 'S' AND OPERACAO = 'C'`]
        };

        const jsonStrOcorrencia = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaOcorrencia));

        return jsonStrOcorrencia;
    };

    async function validaSituacaoReceber() {
        let completaWhere = '';

        const dados = {
            tabela: 'CARTEIRA',
            camposSelect: ['*'],
            where: [`CARTEIRA = '${$('#txtCarteira').val()}' AND CONTA = '${$('#txtConta').val()}' ${completaWhere}`]
        };

        if ($('#txtSitReceber').val() == '') {
            completaWhere = `AND ((SITUA_BCO = '${$('#txtSitReceber').val()}') OR (SITUA_BCO IS NULL))`;
        } else {
            completaWhere = `AND SITUA_BCO = '${$('#txtSitReceber').val()}'`
        };

        const jsonStrDados = await retornaJsonPesquisaPadrao(JSON.stringify(dados));

        return jsonStrDados.length > 0
    };

    function limpaFiltros() {
        $('#txtBordero').val('');
        $('#txtConta').val('');
        $('#txtBanco').val('');
        $('#txtSequencial').val('');
        $('#txtJuros').val('%');
        $('#txtMulta').val('');
        $('#selectOcorrencia').empty();
        $('#txtDiasProtestar').val('0');
        $('#txtInstrucaoCob2').val('');
        $('#txtInstrucaoCob1').val('');
        $('#txtDataVendor').val('1899-01-01');
        $('#txtCarteira').val('');
        $('#txtVariacao1').val('');
        $('#txtVariacao2').val('');
        $('#txtNomeArquivo').val('');
        $('#txtTipoArquivo').val('');
        $('#cbInstrucao1').prop('checked', true);
        $('#cbInstrucao2').prop('checked', true);
        $('#cbBancoEmiteBol').prop('checked', true);
        $('#txtSitReceber').val('');
        $('#tabelaDuplicatas').DataTable().clear().draw(false);
    };
});