/* eslint-disable no-param-reassign */
/* eslint-disable no-bitwise */
/* eslint-disable no-restricted-syntax */
/* eslint-disable no-continue */
/* eslint-disable no-inner-declarations */
/* eslint-disable no-shadow */
/* eslint-disable camelcase */
$(document).ready(async function () {

    componenteFiltro('material', true, true, '', ["GRUPO IN ('14','11')"]);
    componenteFiltro('cor', true);
    componenteFiltro('depositoCru', true);
    componenteFiltro('depositoFio', true);
    const defaultCru = localStorage.getItem(`web@btnDepositoCruFixo`);
    const defaultFio = localStorage.getItem(`web@btnDepositoFioFixo`);
    await preencheSemanaAtual();



    if (defaultCru) {
        preencheFiltroDeposito('txtDepositoCru', JSON.parse(defaultCru));
    }
    if (defaultFio) {
        preencheFiltroDeposito('txtDepositoFio', JSON.parse(defaultFio));
    }

    function preencheValores(seletor, valor) {
        insereValor(seletor, valor);
        $(seletor).trigger('change');
    }

    async function preencheProximaSemana(prz) {
        const pesquisa = {
            tabela: 'TABPRZ',
            camposSelect: ['PRAZO', 'DESCRICAO'],
            where: [`PRAZO = ${prz}`]
        };

        const prazo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if ((!prazo) || (prazo.length == 0)) {
            return;
        };

        return prazo[0];

    }

    async function preencheSemanaAtual() {
        const pesquisa = {
            tabela: 'TABPRZ',
            camposSelect: ['PRAZO', 'DESCRICAO'],
            where: ['LENGTH(PRAZO) = 4 AND (CURRENT_DATE BETWEEN DT_INICIO AND DT_FIM)']
        };

        const prazo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if ((!prazo) || (prazo.length == 0)) {
            return;
        };

        insereValor('#txtPeriodo1', prazo[0].PRAZO, prazo[0].DESCRICAO);
        const periodo2 = await preencheProximaSemana(+(prazo[0]).PRAZO + 1);
        const periodo3 = await preencheProximaSemana(+(prazo[0]).PRAZO + 2);
        if (periodo2) {
            insereValor('#txtPeriodo2', periodo2.PRAZO, periodo2.DESCRICAO);
        }
        if (periodo3) {
            insereValor('#txtPeriodo3', periodo3.PRAZO, periodo3.DESCRICAO);
        }
    }

    async function preencheFiltroDeposito(id, depositos) {
        if (depositos != '') {
            const pesquisaDescricaoDepositos = {
                tabela: 'DEPOSITO',
                camposSelect: ['CODIGO', 'DESCRICAO'],
                where: [`CODIGO IN (${depositos})`]
            };

            const retornoDescricoes = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDescricaoDepositos));

            if (!retornoDescricoes) {
                return;
            };

            insereValorPesquisaVarios(id, 'CODIGO', 'DESCRICAO', retornoDescricoes);
        }
    };

    $('#txtPeriodo1').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('#txtPeriodo2').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('#txtPeriodo3').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('#txtPeriodo4').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('#txtOTPeriodo').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);

    // insereValorPesquisaVarios('txtMaterial', 'CODIGO', 'DESCRICAO', [{ CODIGO: '14.TCLS.001291', DESCRICAO: 'INTERLOK SIMPLES' }]);
    // insereValorPesquisaVarios('txtCor', 'CODIGO', 'DESCRICAO', [{ CODIGO: '010001', DESCRICAO: '010001' }]);
    // $('#txtPeriodo1').val('[2350] - SEMANA-10/12/2023 ATÉ 16/12/2023');
    // $('#txtPeriodo2').val('[2351] - SEMANA-17/12/2023 ATÉ 23/12/2023');
    // $('#txtPeriodo3').val('[2352] - SEMANA-24/12/2023 ATÉ 30/12/2023');
    async function retornaFiltros() {
        const result = {};
        result.materiais = (await formataListas($('#txtMaterial').val().toString()));
        result.cores = (await formataListas($('#txtCor').val().toString()));
        result.depositosCrus = (await formataListas($('#txtDepositoCru').val().toString()));
        result.depositosFios = (await formataListas($('#txtDepositoFio').val().toString()));
        result.periodo1 = pegaChave('#txtPeriodo1');
        result.periodo2 = pegaChave('#txtPeriodo2');
        result.periodo3 = pegaChave('#txtPeriodo3');
        result.periodo4 = pegaChave('#txtPeriodo4');
        result.somenteProdPendente = $('#cbSomenteProducaoPendente').prop('checked') ? 'S' : 'N';
        result.somenteComQuantidade = $('#cbSomenteComQuantidade').prop('checked') ? 'S' : 'N';
        return result;
    }

    const separaCodigo = (codigo) => codigo.split('-')[0].trim();

    const formataDataTabela = (data, bApenasData = false) => {
        if (!data) {
            return '';
        }
        const [dataParte, horaParte] = data.split(' ');
        const [ano, mes, dia] = dataParte.split('-');
        const dataFormatada = bApenasData ? `${dia}/${mes}/${ano}` : `${dia}/${mes}/${ano} ${horaParte != '00:00:00' ? horaParte : ''}`;
        return dataFormatada;
    };

    function retornaBotaoOpcoes(data, row) {
        return `<div style="text-align:left;"> ` +
            `   <div> ` +
            `    <button class="btn btn-info btn-sm btnDadosTecnicosMaquina" data-grupo="${row[8]}" data-sub-grupo="${row[9]}" data-maquina="${row[0]}" data-codigo="${row[1]}" data-cor="${row[2]}" type="button"> ` +
            `   ${row[8]}.${row[9]}.${data} ` +
            `    </button> ` +
            `  </div>` +
            `</div>`;
    }

    $('#check_todos').on('click', function () {
        $('.cbEtiquetaSel').prop('checked', $(this).prop('checked'));
    });

    async function retornaTabelaTecido(data) {

        return `<table class="table table-sm table-hover"> ` +
            ` <thead> ` +
            ` </thead> ` +
            ` <tbody> ` +
            ` <tr> ` +
            ` <th colspan="50">Alimentadores</th> ` +
            ` <th colspan="50">Diâmetro</th> ` +
            ` <th colspan="50">Finura</th> ` +
            ` <th colspan="50">Velocidade</th> ` +
            ` </tr> ` +
            ` <tr> ` +
            ` <td colspan="50">${data.alimentadores}</td> ` +
            ` <td colspan="50">${data.diametro}</td> ` +
            ` <td colspan="50">${data.finura}</td> ` +
            ` <td colspan="50">${data.velocidade}</td>` +
            ` </tr>` +
            ` <tr>` +
            ` <th colspan="100">Platina</th>` +
            ` <th colspan="50">Saída do Tecido</th>` +
            ` <th colspan="50">Histórico</th>` +
            ` </tr>` +
            `  <tr>` +
            `  <td colspan="100">${data.platina}</td>` +
            `  <td colspan="50">${data.saida_tecido}</td>` +
            `  <td colspan="50"><button class="btn btn-info btn-sm btnHistoricoMaquinaTecido">Histórico</button></td>` +
            `  </tr>` +
            `  <tr>` +
            `   <th colspan="100">Limite de Falhas Tecido Acabado</th>` +
            `  <th colspan="100">Limite de Falhas Tecido Acabado Mini</th>` +
            `  </tr>` +
            `  <tr>` +
            `  <td colspan="100">${data.limite_falhas_tecido_acabado}%</td>` +
            `  <td colspan="100">${data.limite_falhas_tecido_mini}%</td>` +
            `  </tr>` +
            ` </tbody>` +
            `  </table>`;
    }

    async function retornaTabelaMaquinas(data) {
        const dadosTecnicos = `<tr>` +
            `<td>${data.malha}</td>` +
            `<td>${data.platina}</td>` +
            `<td>${data.finura}</td>` +
            `<td>${data.alimentadores}</td>` +
            `<td>${data.diametro}</td>` +
            `<td>${data.velocidade}</td>` +
            `<td><button class="btn btn-info btn-sm btnHistoricoMaquina">Histórico</button></td>` +
            `</tr>`;

        return `<table class="table table-sm table-hover">` +
            `<thead>` +
            `<tr>` +
            `<th> Num Prog.</th>` +
            `<th> Platina</th>` +
            `<th> Finura</th>` +
            `<th> Alimentadores</th>` +
            `<th> Diametro</th>` +
            `<th> Velocidade</th>` +
            `<th> Consulta</th>` +
            `</tr>` +
            `</thead>` +
            `<tbody>${dadosTecnicos}</tbody>` +
            `</table>`;
    }

    async function retornaTabelaFios(data) {
        const dados = data.fios;
        const registros = dados && dados.length > 0 ? dados.map(fio => `<tr><td>${fio.codigo}</td><td>${fio.descricao}</td></tr>`).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : [];
        return `<table class="table table-sm table-hover"><thead><tr><th>Fio</th><th> Descrição</th></tr></thead><tbody>${registros}</tbody></table>`;
    }

    async function retornaTabelaHistoricoTecido(codigo, cor) {
        const url = `/sisplan/disponibilidadetecidos/v1/buscahistoricotecido?`;
        const response = await requisicao("GET", url, `&CODIGO=${codigo}&COR=${cor}`, '', 1800000);

        if (!response) {
            return;
        }

        const data = await response.json();
        const dados = data && data.length > 0 ? data.map(hist => (`<tr>` +
            ` <td>${hist.TIPO}.${hist.SUBGRUPO}.${hist.MAQUINA} - ${hist.DESCRICAO}</td>` +
            `<td>${formataDataTabela(hist.DT_EMISSAO, true)}</td>` +
            `<td>${hist.OBSERVACAO}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';

        return `<table class="table table-sm table-hover">` +
            `<thead>` +
            `<tr>` +
            `     <th>Máquina</th>` +
            `     <th>Data Produção</th>` +
            `     <th>Observação</th>` +
            `</tr>` +
            `</thead>` +
            `<tbody>${dados}` +
            `</tbody>` +
            `</table>`;
    }


    async function retornaTabelaHistorico(maquina) {
        const url = `/sisplan/disponibilidadetecidos/v1/buscahistoricomaquina?`;
        const response = await requisicao("GET", url, `&MAQUINA=${maquina}`, '', 1800000);

        if (!response) {
            return;
        }

        const data = await response.json();
        const dados = data && data.length > 0 ? data.map(hist => (`<tr>` +
            ` <td>${hist.CODIGO} - ${hist.DESCRICAO}</td>` +
            ` <td>${hist.COR} - ${hist.DESC_COR}</td>` +
            ` <td>${formataDataTabela(hist.DT_EMISSAO)}</td>` +
            ` </tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';

        return `<table class="table table-sm table-hover">` +
            `<thead>` +
            `<tr>` +
            `     <th>Referência</th>` +
            `     <th>Cor</th>` +
            `     <th>Última Data Produção</th>` +
            `</tr>` +
            `</thead>` +
            `<tbody>${dados}` +
            `</tbody>` +
            `</table>`;
    }

    async function criaTabelaAgulha(data, novaJanela) {
        const dados = data.formacaoAgulha;
        const table = document.createElement("table");
        const numerosColunasDisco = dados.blocoDisco ? dados.blocoDisco.map(item => item.coluna) : [];
        const maiorNumeroColunaDisco = Math.max(...numerosColunasDisco);
        const numerosColunasCilindro = dados.blocoCilindro ? dados.blocoCilindro.map(item => item.coluna) : [];
        const maiorNumeroColunaCilindro = Math.max(...numerosColunasCilindro);
        const numerosColunasPedra = dados.blocoPedra ? dados.blocoPedra.map(item => item.coluna) : [];
        const maiorNumeroColunaPedra = Math.max(...numerosColunasPedra);

        table.classList.add('table');
        table.classList.add('table-hover');
        table.classList.add('table-sm');
        const thead = document.createElement('thead');
        const headRow = document.createElement('tr');
        const headCell = document.createElement('th');
        thead.appendChild(headRow);
        headRow.appendChild(headCell);
        headCell.textContent = 'Formação de Agulhas';
        headCell.colSpan = '100';
        headCell.style = 'text-align: center';

        const discoRow = document.createElement('tr');
        const discoCell = document.createElement('th');
        discoCell.colSpan = '3';
        const discoCell2 = document.createElement('td');
        discoCell.textContent = 'Agulha Disco';
        discoCell2.textContent = dados.agulhasDisco;
        discoCell2.colSpan = '100';
        discoRow.appendChild(discoCell);
        discoRow.appendChild(discoCell2);
        thead.appendChild(discoRow);

        const cilindroRow = document.createElement('tr');
        const cilindroCell = document.createElement('th');
        cilindroCell.colSpan = '3';

        const cilindroCell2 = document.createElement('td');
        cilindroCell.textContent = 'Agulha Cilindro';
        cilindroCell2.textContent = dados.agulhasCilindro;
        cilindroCell2.colSpan = '100';
        cilindroRow.appendChild(cilindroCell);
        cilindroRow.appendChild(cilindroCell2);
        thead.appendChild(cilindroRow);


        const blocoDiscoRow = document.createElement('tr');
        const blocoDiscoCell = document.createElement('th');
        blocoDiscoCell.colSpan = '3';
        blocoDiscoCell.textContent = "Bloco Disco";
        blocoDiscoCell.style = "text-align: center";
        blocoDiscoRow.appendChild(blocoDiscoCell);
        for (let i = 0; i < maiorNumeroColunaDisco; i++) {
            const celula = document.createElement('th');
            celula.textContent = i + 1;
            blocoDiscoRow.appendChild(celula);
        }
        thead.appendChild(blocoDiscoRow);
        table.appendChild(thead);
        const tbody = document.createElement("tbody");

        // Iterar sobre os dados e criar as linhas e células na tabela
        // const fixedRow = document.createElement('tr');
        // tbody.appendChild()
        if (dados.blocoDisco) {
            dados.blocoDisco.forEach(data => {
                let row = tbody.querySelector(`tr[data-row="${data.linha}"]`);
                if (!row) {
                    row = document.createElement("tr");
                    row.setAttribute("data-row", data.linha);
                    fixedCell = document.createElement('td');
                    fixedCell.colSpan = "3";
                    fixedCell.textContent = data.linha;
                    fixedCell.style = "text-align: center";
                    row.appendChild(fixedCell);
                    tbody.appendChild(row);
                }
                const cell = document.createElement("td");
                cell.textContent = data.valor;
                row.appendChild(cell);
            });
        }

        const blocoCilindroRow = document.createElement('tr');
        const blocoCilindroCell = document.createElement('th');
        blocoCilindroCell.colSpan = '3';
        blocoCilindroCell.textContent = "Bloco Cilindro";
        blocoCilindroCell.style = "text-align: center";
        blocoCilindroRow.appendChild(blocoCilindroCell);
        for (let i = 0; i < maiorNumeroColunaCilindro; i++) {
            const celula = document.createElement('th');
            celula.textContent = i + 1;
            blocoCilindroRow.appendChild(celula);
        }
        tbody.appendChild(blocoCilindroRow);

        dados.blocoCilindro.forEach(data => {
            let row = tbody.querySelector(`tr[data-cilindro-row="${data.linha}"]`);
            if (!row) {
                row = document.createElement("tr");
                row.setAttribute("data-cilindro-row", data.linha);
                fixedCell = document.createElement('td');
                fixedCell.colSpan = "3";
                fixedCell.textContent = data.linha;
                fixedCell.style = "text-align: center";
                row.appendChild(fixedCell);
                tbody.appendChild(row);
            }
            const cell = document.createElement("td");
            cell.textContent = data.valor;
            row.appendChild(cell);
        });

        const blocoPedraRow = document.createElement('tr');
        const blocoPedraCell = document.createElement('th');
        blocoPedraCell.colSpan = '3';
        blocoPedraCell.textContent = "Bloco Pedra";
        blocoPedraCell.style = "text-align: center";
        blocoPedraRow.appendChild(blocoPedraCell);
        for (let i = 0; i < maiorNumeroColunaPedra; i++) {
            const celula = document.createElement('th');
            celula.textContent = i + 1;
            blocoPedraRow.appendChild(celula);
        }
        tbody.appendChild(blocoPedraRow);

        dados.blocoPedra.forEach(data => {
            let row = tbody.querySelector(`tr[data-cilindro-pedra-row="${data.linha}"]`);
            if (!row) {
                row = document.createElement("tr");
                row.setAttribute("data-cilindro-pedra-row", data.linha);
                fixedCell = document.createElement('td');
                fixedCell.colSpan = "3";
                fixedCell.textContent = data.linha;
                fixedCell.style = "text-align: center";
                row.appendChild(fixedCell);
                tbody.appendChild(row);
            }
            const cell = document.createElement("td");
            cell.textContent = data.valor;
            row.appendChild(cell);
        });

        // Adicionar o tbody à tabela
        table.appendChild(tbody);
        // Adicionar a tabela ao corpo do documento
        novaJanela.document.querySelector('#divTabelaFormacaoAgulhas').appendChild(table);

    }

    setTimeout(() => {
        $('#txtMaterial').focus();
        $('.select2-selection__rendered').scrollTop(0);
    }, 500);


    async function criaTabelaAgulhaProdDiaria(data, novaJanela, bAdicionaTitulo = false) {
        const dados = data.formacao_agulhas;
        const table = document.createElement("table");
        const numerosColunasDisco = dados.blocoDisco ? dados.blocoDisco.map(item => item.coluna) : [];
        const maiorNumeroColunaDisco = Math.max(...numerosColunasDisco);
        const numerosColunasCilindro = dados.blocoCilindro ? dados.blocoCilindro.map(item => item.coluna) : [];
        const maiorNumeroColunaCilindro = Math.max(...numerosColunasCilindro);
        const numerosPedraCilindro = dados.blocoPedra ? dados.blocoPedra.map(item => item.coluna) : [];
        const maiorNumeroColunaPedra = Math.max(...numerosPedraCilindro);

        table.classList.add('table');
        table.classList.add('table-hover');
        table.classList.add('table-sm');
        const thead = document.createElement('thead');
        const headRow = document.createElement('tr');
        thead.appendChild(headRow);
        if (bAdicionaTitulo) {
            const headCell = document.createElement('th');
            headRow.appendChild(headCell);
            headCell.textContent = 'Formação de Agulhas';
            headCell.colSpan = '100';
            headCell.style = 'text-align: center';
        }

        const prodRow = document.createElement('tr');
        const prodCell = document.createElement('th');
        prodRow.appendChild(prodCell);
        prodCell.colSpan = '100';
        prodCell.style = "background-color: #ffffc3; padding-top: 5px; padding-bottom: 5px;padding-left: 5px";
        prodCell.textContent = `${data.subgrupo} - Produção diária: ${data.prod_diaria}`;
        thead.appendChild(prodCell);

        const discoRow = document.createElement('tr');
        const discoCell = document.createElement('td');
        discoCell.colSpan = '3';
        const discoCell2 = document.createElement('td');
        discoCell.textContent = 'Agulha Disco';
        discoCell.style = "background-color: #8ecaed42";
        discoCell2.textContent = dados.agulhasDisco;
        discoCell2.colSpan = '100';
        discoRow.appendChild(discoCell);
        discoRow.appendChild(discoCell2);
        thead.appendChild(discoRow);

        const cilindroRow = document.createElement('tr');
        const cilindroCell = document.createElement('td');
        cilindroCell.colSpan = '3';

        const cilindroCell2 = document.createElement('td');
        cilindroCell.textContent = 'Agulha Cilindro';
        cilindroCell.style = "background-color: #8ecaed42";
        cilindroCell2.textContent = dados.agulhasCilindro;
        cilindroCell2.colSpan = '100';
        cilindroRow.appendChild(cilindroCell);
        cilindroRow.appendChild(cilindroCell2);
        thead.appendChild(cilindroRow);


        const blocoDiscoRow = document.createElement('tr');
        const blocoDiscoCell = document.createElement('td');
        blocoDiscoCell.colSpan = '3';
        blocoDiscoCell.textContent = "Bloco Disco";
        blocoDiscoCell.style = "background-color: #8ecaed42; text-align: center";
        blocoDiscoRow.appendChild(blocoDiscoCell);
        for (let i = 0; i < maiorNumeroColunaDisco; i++) {
            const celula = document.createElement('th');
            celula.textContent = i + 1;
            blocoDiscoRow.appendChild(celula);
        }
        thead.appendChild(blocoDiscoRow);
        table.appendChild(thead);
        const tbody = document.createElement("tbody");

        if (dados.blocoDisco) {
            dados.blocoDisco.forEach(data => {
                let row = tbody.querySelector(`tr[data-row="${data.linha}"]`);
                if (!row) {
                    row = document.createElement("tr");
                    row.setAttribute("data-row", data.linha);
                    fixedCell = document.createElement('td');
                    fixedCell.colSpan = "3";
                    fixedCell.textContent = data.linha;
                    fixedCell.style = "text-align: center";
                    row.appendChild(fixedCell);
                    tbody.appendChild(row);
                }
                const cell = document.createElement("td");
                cell.textContent = data.valor;
                row.appendChild(cell);
            });
        }

        const blocoCilindroRow = document.createElement('tr');
        const blocoCilindroCell = document.createElement('td');
        blocoCilindroCell.colSpan = '3';
        blocoCilindroCell.textContent = "Bloco Cilindro";
        blocoCilindroCell.style = "background-color: #8ecaed42; text-align: center";
        blocoCilindroRow.appendChild(blocoCilindroCell);
        for (let i = 0; i < maiorNumeroColunaCilindro; i++) {
            const celula = document.createElement('th');
            celula.textContent = i + 1;
            blocoCilindroRow.appendChild(celula);
        }
        tbody.appendChild(blocoCilindroRow);

        dados.blocoCilindro.forEach(data => {
            let row = tbody.querySelector(`tr[data-cilindro-row="${data.linha}"]`);
            if (!row) {
                row = document.createElement("tr");
                row.setAttribute("data-cilindro-row", data.linha);
                fixedCell = document.createElement('td');
                fixedCell.colSpan = "3";
                fixedCell.textContent = data.linha;
                fixedCell.style = "text-align: center";
                row.appendChild(fixedCell);
                tbody.appendChild(row);
            }
            const cell = document.createElement("td");
            cell.textContent = data.valor;
            row.appendChild(cell);
        });


        const pedraCilindroRow = document.createElement('tr');
        const pedraCilindroCell = document.createElement('td');
        pedraCilindroCell.colSpan = '3';
        pedraCilindroCell.textContent = "Pedra Cilindro";
        pedraCilindroCell.style = "background-color: #8ecaed42; text-align: center";
        pedraCilindroRow.appendChild(pedraCilindroCell);
        for (let i = 0; i < maiorNumeroColunaPedra; i++) {
            const celula = document.createElement('th');
            celula.textContent = i + 1;
            pedraCilindroRow.appendChild(celula);
        }
        tbody.appendChild(pedraCilindroRow);

        dados.blocoPedra.forEach(data => {
            let row = tbody.querySelector(`tr[data-pedra-cilindro-row="${data.linha}"]`);
            if (!row) {
                row = document.createElement("tr");
                row.setAttribute("data-pedra-cilindro-row", data.linha);
                fixedCell = document.createElement('td');
                fixedCell.colSpan = "3";
                fixedCell.textContent = data.linha;
                fixedCell.style = "text-align: center";
                row.appendChild(fixedCell);
                tbody.appendChild(row);
            }
            const cell = document.createElement("td");
            cell.textContent = data.valor;
            row.appendChild(cell);
        });


        // Adicionar o tbody à tabela
        table.appendChild(tbody);
        // Adicionar a tabela ao corpo do documento
        novaJanela.document.querySelector('#divTabelaFormacaoAgulhas').appendChild(table);
    }

    async function retornaTabelaFormacaoAgulhas(data, novaJanela) {
        if (data.prod_diaria) {
            for (let i = 0; i < data.prod_diaria.length; i++) {
                const prod = data.prod_diaria[i];
                await criaTabelaAgulhaProdDiaria(prod, novaJanela, i == 0);
            }
        } else {
            await criaTabelaAgulha(data, novaJanela);
        }

    }


    function setCurrentDateTime(hora) {
        const now = new Date();

        const year = now.getFullYear();
        const month = String(now.getMonth() + 1).padStart(2, '0'); // Janeiro é 0!
        const day = String(now.getDate()).padStart(2, '0');

        const currentDateTime = `${year}-${month}-${day}T${hora}`;

        return currentDateTime;
    }

    async function retornaMaquinasRelacionamento(codigo, cor) {
        try {
            const pesquisa = {
                camposSelect: ['RAPORT_MAQ.MAQUINA', 'MAQUINA.DESCRICAO', 'RAPORT_MAQ.ID_MAQCONFIG', 'MAQUINA.TIPO', 'MAQUINA.SUBGRUPO'],
                tabela: 'RAPORT_MAQ',
                leftJoin: [{ tabela: 'MAQUINA', condicao: 'MAQUINA.MAQUINA = RAPORT_MAQ.MAQUINA' }],
                where: [`RAPORT_MAQ.CODIGO = '${codigo}'`, `RAPORT_MAQ.COR = '${cor}'`]
            };
            const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
            if (!response) {
                return;
            }
            return response;
        } catch (error) {
            console.log(error);
            return [];
        }
    };

    async function criaBotoesAuxiliares(dados) {


        const { id, id_cor, codigo, cor, descricao, desc_cor, periodos, fios } = dados;
        const listaKg = fios && fios.length > 0 ? fios.map(fio => fio.kgFiosRolo) : [];
        const listaKgComAlternativo = fios && fios.length > 0 ? fios.map(fio => fio.kgFiosRoloComAlternativo) : [];
        const kgFiosRolo = Math.min(...listaKg);
        const kgFiosRoloComAlternativo = Math.min(...listaKgComAlternativo);
        const necessidade = periodos.reduce((soma, curr) => soma += curr.a_programar, 0);
        const html = `<fieldset>` +
            `<button data-codigo="${codigo}" data-cor="${cor}" data-descricao="${descricao}" data-desc-cor="${desc_cor}" data-kg-fios-rolo="${kgFiosRolo}" data-kg-fios-rolo-com-alternativo="${kgFiosRoloComAlternativo}" data-necessidade="${necessidade}" class="btn-etiqueta btn btn-danger btn-sm mt-2 float-right">Etiqueta</button>` +
            `<button data-codigo="${codigo}" data-cor="${cor}" data-descricao="${descricao}" data-desc-cor="${desc_cor}" class="btn-relacionamento btn btn-danger btn-sm mt-2 mr-2 float-right">Relação</button>` +
            `<button data-codigo="${codigo}" data-cor="${cor}" data-descricao="${descricao}" data-desc-cor="${desc_cor}" class="btn-ref-fios btn btn-danger btn-sm mt-2 mr-2 float-right">Ref. Fios</button>` +
            `</fieldset>`;
        $(`#dados-${`${id}-${id_cor}`}`).append(html);

        $('.btn-ref-fios').off();
        $('.btn-ref-fios').on('click', async function () {
            const codigo = $(this).attr('data-codigo');
            const cor = $(this).attr('data-cor');
            const depositos = (await formataListas($('#txtDepositoFio').val().toString()));
            const url = `/sisplan/disponibilidadetecidos/v1/buscareferenciafio?`;
            const response = await requisicao("GET", url, `&CODIGO=${codigo}&COR=${cor}&DEPOSITOS=${depositos}`, '', 1800000);

            if (!response) {
                return;
            }

            const dados = await response.json();
            const { lista } = dados;
            $('#div-tabela-ref-fios').html('');
            for (let i = 0; i < lista.length; i++) {
                await montaDadosReferencia(lista[i], i);
            }

            $('#modal-ref-fios').modal('show');
        });


        $('.btn-relacionamento').off();
        $('.btn-relacionamento').on('click', async function () {
            const codigo = $(this).attr('data-codigo');
            const descricao = $(this).attr('data-descricao');
            const cor = $(this).attr('data-cor');
            const desc_cor = $(this).attr('data-desc-cor');
            $('#txt-rel-tecido').attr('data-codigo', codigo);
            $('#txt-rel-tecido').val(`${codigo} - ${descricao}`);
            $('#txt-rel-cor').attr('data-cor', cor);
            $('#txt-rel-cor').val(`${cor} - ${desc_cor}`);

            // buscar as maquinas e popular o select
            const dados = await retornaMaquinasRelacionamento(codigo, cor);
            $('#txt-rel-maquina').empty();
            for (let i = 0; i < dados.length; i++) {
                const maquina = dados[i];
                const apenasMaquina = maquina.MAQUINA;
                const optionText = `${maquina.TIPO}.${maquina.SUBGRUPO}.${maquina.MAQUINA}`;
                const optionValue = maquina.ID_MAQCONFIG;
                $('#txt-rel-maquina').append(`<option data-maquina="${apenasMaquina}" value="${optionValue}">
                                                  ${optionText}
                                              </option>`);
            }

            $('#modal-relacionamento').modal('show');

            $('#btn-relacionar').off();
            $('#btn-relacionar').on('click', async function () {
                const permissao = await permissaoAcessos("DISPONIBILIDADE_TECIDOS");
                if (permissao.ALTERA == 'N') {
                    msgAlerta('Usuário sem permissão.');
                    return;
                }
                msgAlerta(`Tem certeza que deseja fazer o relacionamento?`, async () => {
                    const codigo = $('#txt-rel-tecido').attr('data-codigo');
                    const cor = $('#txt-rel-cor').attr('data-cor');
                    const maquina = $('#txt-rel-maquina option:selected').attr('data-maquina');
                    const obs = $('#txt-rel-obs').val();

                    if (codigo == '' || cor == '' || maquina == '') {
                        msgErro('Não é possível gravar sem os campos principais informados, verifique.');
                        return;
                    }

                    const obj = {
                        codigo,
                        cor,
                        maquina,
                        situacao: 1, // significa APOS
                        obs
                    };

                    try {
                        const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/gravarelacionamento?", `JSON=${JSON.stringify(obj)}`, "", 300000);

                        if (!response) {
                            throw msgAlerta("Não foi possível relacionar a máquina x tecido.");
                        }

                        if (response.status != 200) {
                            throw msgAlerta("Não foi possível relacionar a máquina x tecido.");
                        }

                        // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

                        criaMensagemSucesso("Relacionamento efetuado com sucesso", async () => {
                            $('#btn-consultar-relacionamento').trigger('click');
                            $('#txt-rel-obs').val('');
                        });

                    } catch (error) {
                        console.error(error);
                    }
                });
            });



            $('#btn-consultar-relacionamento').off();
            $('#btn-consultar-relacionamento').on('click', async function () {

                const url = `/sisplan/disponibilidadetecidos/v1/buscadadosrelacionamento?`;
                const response = await requisicao("GET", url, `&CODIGO=${codigo}&COR=${cor}`, '', 1800000);

                if (!response) {
                    return;
                }

                const dados = await response.json();
                const obj = {
                    "0": 'PARADA',
                    "1": 'APÓS',
                    "2": 'ATIVA',
                    "3": 'TROCA DE REFERÊNCIA',
                    "4": 'TRANSFORMAÇÃO',
                    "5": 'MANUTENÇÃO',
                    "6": 'AMOSTRAGEM'
                };
                const dadosTratados = dados.map(dt => [dt.MATERIAL, dt.COR, `${dt.TIPO}.${dt.SUBGRUPO}.${dt.MAQUINA}`, dt.ID, obj[dt.SITUACAO], dt.OBS, '']);

                $('#tabela-relacionamento').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    info: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    data: dadosTratados,
                    "columnDefs": [
                        {
                            targets: [5],
                            render(data, type, row) {
                                return `<div class="input-group">
                                    <input value="${data}" data-id="${row[3]}" type="text" class="input-default focus form-control txt-tabela-rel-obs" id="txt-rel-cor" name="txt-rel-cor" class="form-control" placeholder="Obs">
                                    <div class="input-group-append">
                                    <button data-id="${row[3]}" class="btn bg-danger btn-rel-altera-obs" title="Alterar Observação" id="btn-rel-altera-obs" name="btn-rel-altera-obs"><i class="m-0 p-0 fas fa-check"></i></button>
                                </div>
                                     </div>`;
                            }
                        },
                        {
                            targets: [6],
                            render(data, type, row) {
                                if (row[4] == 'APÓS') {
                                    return ` <button data-id="${row[3]}" class="btn btn-sm btn-danger btn-excluir-relacionamento"> ` +
                                        ` Excluir <i class=" fas fa-trash"></i>` +
                                        ` </button>`;
                                }
                                return '';
                            }
                        }
                    ]
                });
                $('.btn-rel-altera-obs').off();
                $('.btn-rel-altera-obs').on('click', async function () {
                    const id = $(this).attr('data-id');
                    const obs = $(`input[data-id="${id}"]`).val();
                    try {
                        const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/alteraobsrelacionamento?", `ID=${id}&OBS=${obs}`, "", 300000);

                        if (!response) {
                            throw msgAlerta("Não foi possível alterar a observação do relacionamento.");
                        }

                        if (response.status != 200) {
                            throw msgAlerta("Não foi possível alterar a observação do relacionamento.");
                        }


                        criaMensagemSucesso("Observação alterada com sucesso", async () => {
                            $('#btn-consultar-relacionamento').trigger('click');
                        });

                    } catch (error) {
                        console.error(error);
                    }
                });
                $('.btn-excluir-relacionamento').off();
                $('.btn-excluir-relacionamento').on('click', async function () {
                    const permissao = await permissaoAcessos("DISPONIBILIDADE_TECIDOS");
                    if (permissao.EXCLUI == 'N') {
                        msgAlerta('Usuário sem permissão para Excluir.');
                        return;
                    }

                    msgAlerta(`Tem certeza que deseja excluir o relacionamento?`, async () => {
                        const id = $(this).attr('data-id');

                        try {
                            const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/deletarelacionamento?", `ID=${id}`, "", 300000);

                            if (!response) {
                                throw msgAlerta("Não foi possível excluir o relacionamento máquina x tecido.");
                            }

                            if (response.status != 200) {
                                throw msgAlerta("Não foi possível excluir o relacionamento máquina x tecido.");
                            }

                            // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

                            criaMensagemSucesso("Relacionamento excluído com sucesso", async () => {
                                $('#btn-consultar-relacionamento').trigger('click');
                            });

                        } catch (error) {
                            console.error(error);
                        }
                    });
                });
            });

            $('#btn-consultar-relacionamento').trigger('click');
        });

        function atualizaTotaisRolo() {
            const inputsLength = $('.input-rolos').length;
            let totalRolosMultiplo = 0;
            let totalRolos = 0;
            for (let i = 0; i < inputsLength; i++) {
                const input = $($('.input-rolos')[i]);
                const inputMultiplo = $($('.input-multiplo')[i]);
                const valor = +input.val();
                const multiplo = +inputMultiplo.val();
                if ($($('.cbEtiquetaSel')[i]).prop('checked')) {
                    totalRolosMultiplo += valor;
                    totalRolos += (valor * multiplo);
                }
            }

            $('#txtEtqTotalRolo').html(totalRolos);
            $('#txtEtqTotalRoloMultiplo').html(totalRolosMultiplo);
        }


        $('.btn-etiqueta').off();
        $('.btn-etiqueta').on('click', async function () {
            const codigo = $(this).attr('data-codigo');
            const cor = $(this).attr('data-cor');

            if (await materialBloqueado(codigo, cor)) {
                msgAlerta(`Existe um bloqueio cadastrado para essa referência, verifique.`);
                return;
            };

            const kgFiosRolo = $(this).attr('data-kg-fios-rolo');
            const kgFiosRoloComAlternativo = $(this).attr('data-kg-fios-rolo-com-alternativo');
            const necessidade = $(this).attr('data-necessidade');
            const base64 = btoa(`${codigo}###${cor}###${necessidade}###${kgFiosRolo}###${kgFiosRoloComAlternativo}`);
            const url = `./tela_etiquetas/${base64}`;
            window.open(url, "_blank", "width=1200,height=800");
        });
    }

    async function materialBloqueado(codigo, cor) {
        try {
            $.LoadingOverlay('show');
            const pesquisa = {
                tabela: 'BLOQUEIOMAT',
                camposSelect: ['OBS'],
                where: [`MATERIAL = '${codigo}' AND (COR = '${cor}' OR COR IS NULL) AND TIPO = 0 AND STATUS = 0`]
            };

            const retorno = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
            return retorno.length > 0;
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function montaDadosReferencia(dados, i) {
        const { codigo, cor, descricao, desc_cor, estoque, empenho_total, estoque_alternativo, lista_referencias } = dados;
        const html = `<fieldset class="tecidos">` +
            `       <div class="card card-body" id="div-${i}-ref-card">` +
            `           <div class="form-row">` +
            `               <div class="col-12 table-responsive">` +
            `<table class="table table-sm table-hover"> ` +
            `<thead>` +
            `  <tr>` +
            `  	<th >Fio</th>` +
            `    <th >Cor</th>` +
            `    <th >Estoque</th>` +
            `    <th >Estoque com Alternativo</th>` +
            `    <th >Empenho Total</th>` +
            `   </tr>` +
            `</thead>` +
            `<tbody>` +
            `	<tr>` +
            `    	<td>${codigo} - ${descricao}</td>` +
            `        <td>${cor} - ${desc_cor}</td>` +
            `        <td>${estoque}</td>` +
            `        <td>${estoque_alternativo}</td>` +
            `        <td>${parseFloat(empenho_total).toFixed(3)}</td>` +
            `    </tr>` +
            `</tbody>` +
            `</table>` +
            `               </div>` +
            `           </div>` +
            `       </div>` +
            `   </fieldset> `;

        const referencias = lista_referencias && lista_referencias.length > 0 ? lista_referencias.map(ref => `<tr>` +
            `<td>${ref}</td>` +
            `</tr>`
        ) : '';
        const htmlReferencias = `<div class="form-row">` +
            `<div class="col-12 table-responsive">` +
            `<table class="table table-sm table-hover">` +
            `<thead>` +
            `<tr>` +
            `   <th >Referência</th>` +
            `</tr>` +
            `</thead>` +
            `<tbody>` +
            `   ${referencias.toString().replaceAll('</tr>,<tr>', '</tr><tr>')}` +
            `</tbody>` +
            `</table>` +
            `</div>` +
            `</div>`;

        $('#div-tabela-ref-fios').append(`<div id = "ref-${i}" class="borda" ></div>`);
        $(`#ref-${i}`).html(html);
        $(`#div-${i}-ref-card`).append(htmlReferencias);
    }

    async function buscaOrdensAgrupadas(numero, aEmitir = false) {
        const url = aEmitir ? `/sisplan/disponibilidadetecidos/v1/buscaordensaemitiragrupadas?` : `/sisplan/disponibilidadetecidos/v1/buscaordensemitidasagrupadas?`;
        const response = await requisicao("GET", url, `&NUMERO=${separaCodigo(numero)}`, '', 1800000);
        if (!response) {
            return;
        }

        const data = await response.json();
        const dadosTratados = data.map((item => [item.CODIGO, item.ROTEIRO, item.ORIGEM_CASADO, item.AGRUPAMENTO]));
        $('#tabela-ordens-agrupamento').DataTable({
            bPaginate: false,
            destroy: true,
            colReorder: false,
            reoder: false,
            order: false,
            search: false,
            filter: false,
            info: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: dadosTratados,
            columnDefs: [
                {
                    targets: [1],
                    render: (data) => `<button data-roteiro="${data}" class="btn btn-secondary btn-sm btn-roteiro">${data}</button>`
                }
            ]
        });

        $('.btn-roteiro').off();
        $('.btn-roteiro').on('click', async function () {
            const roteiro = $(this).attr('data-roteiro');
            const url = `/sisplan/disponibilidadetecidos/v1/buscaroteiro?`;
            const response = await requisicao("GET", url, `&ROTEIRO=${separaCodigo(roteiro)}`, '', 1800000);

            if (!response) {
                return;
            }

            $('#modal-roteiro-roteiro').html(roteiro);
            const data = await response.json();
            const dadosTratados = data.map((item => [item.CODIGO, item.DESCRICAO]));
            $('#tabela-roteiro').DataTable({
                bPaginate: false,
                destroy: true,
                colReorder: false,
                reoder: false,
                order: false,
                search: false,
                filter: false,
                info: false,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: dadosTratados
            });

            $('#modal-roteiro-operacoes').modal('show');
        });
    }

    const formatarValor = (valor) => new Intl.NumberFormat('pt-BR', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2,
    }).format(valor);

    async function montaDadosTecidos(dados) {
        try {
            const estaResumido = $('#cbResumido').prop('checked');
            const resumido = estaResumido ? 'd-none' : '';
            const { id, id_cor, codigo, cor, descricao, desc_cor, estoque, pre_baixa, estoque_fix, periodos } = dados;
            const listaPeriodos = [];
            for (let i = 1; i < periodos.length; i++) {
                const periodoAtual = periodos[i];
                listaPeriodos.push(`<tr>` +
                    `<td>${periodoAtual.periodo}</td>` +
                    `<td data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" data-prazo="${periodoAtual.periodo}" title="OTS Pendentes" class="btnPendenteOT clicavel">${periodoAtual.pendente_ot}</td>` +
                    `<td data-semana="${periodoAtual.periodo}" data-codigo="${codigo}" class="${resumido} btn-fixado-op clicavel">${periodoAtual.fixado_ob}</td>` +
                    `<td data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" data-prazo="${periodoAtual.periodo}" title="Ordens Emitidas" class="btnOrdensEmitidas clicavel"><span style="${periodoAtual.temOrdemComPrevisaoMenorQueAAtual == 'S' ? 'color: red' : ''}">${periodoAtual.emitido_ob}</span></td>` +
                    `<td>${formatarValor(periodoAtual.saldo_prog)}</td>` +
                    `<td data-prazo="${periodoAtual.periodo}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="Ordens a Emitir" class="btnOrdensAEmitir clicavel">${periodoAtual.a_emitir_ob}</td>` +
                    `<td>${formatarValor(periodoAtual.a_programar)}</td>` +
                    `</tr>`);
            }

            const html = `<fieldset class="tecidos">` +
                `       <div class="card card-body">` +
                `           <div class="form-row">` +
                `               <div class="col-12 table-responsive">` +
                `                   <table id="tabelaTecidos" class="table table-sm table-select table-hover" width="100%" style="width: 100%;">` +
                `                        <thead >` +
                `                           <tr>` +
                `                               <th width="300px">Tecido</th>` +
                `                               <th width="250px">Cor</th>` +
                `                               <th width="300px">Descrição</th>` +
                `                               <th>Estoque</th>` +
                `                               <th class="${resumido}">Pré Baixa</th>` +
                `                               <th class="${resumido}">Estoque Fix.</th>` +
                `                               <th>Período</th>` +
                `                               <th>Pendente OT</th>` +
                `                               <th class="${resumido}">Fixado OP</th>` +
                `                               <th>Emitido OP</th>` +
                `                               <th>Saldo Prog.</th>` +
                `                               <th>A Emitir OP</th>` +
                `                               <th>A Programar</th>` +
                `                           </tr>` +
                `                       </thead>` +
                `                       <tbody style="background: var(--table-border); text-align: center">` +
                `                           <tr>` +
                `                               <td rowspan="${periodos.length}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="Quadro de Máquinas do Tecido" class="btnQuadroMaquinasTecido clicavel ${codigo.substring(0, 2) == '11' ? 'comecaComOnze' : ''}">${codigo}</td>` +
                `                               <td rowspan="${periodos.length}">${cor} - ${desc_cor}</td>` +
                `                               <td rowspan="${periodos.length}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="Quadro de Agulhas do Tecido" class="btnQuadroAgulhasTecido clicavel">${descricao}</td>` +
                `                               <td rowspan="${periodos.length}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="Ver Estoque dos Rolos" class="btnEstoqueRolo clicavel">${estoque}</td>` +
                `                               <td rowspan="${periodos.length}" data-codigo="${codigo}" data-cor="${cor}" class="${resumido} clicavel btn-pre-baixa">${pre_baixa}</td>` +
                `                               <td rowspan="${periodos.length}" data-codigo="${codigo}" data-cor="${cor}" class="${resumido} clicavel btn-estoque-fix">${estoque_fix}</td>` +
                `                               <td>${periodos[0].temValoresAnterioresAoPeriodo == 'S' ? '** ' : ''}${periodos[0].periodo}</td>` +
                `                               <td data-prazo="${periodos[0].periodo}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="OTS Pendentes" class="btnPendenteOT clicavel">${periodos[0].pendente_ot}</td>` +
                `                               <td data-semana="${periodos[0].periodo}" data-codigo="${codigo}" class="${resumido} btn-fixado-op clicavel">${periodos[0].fixado_ob}</td>` +
                `                               <td data-prazo="${periodos[0].periodo}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="Ordens Emitidas" class="btnOrdensEmitidas clicavel"><span style="${periodos[0].temOrdemComPrevisaoMenorQueAAtual == 'S' ? 'color: red' : ''}">${periodos[0].emitido_ob}</span></td>` +
                `                               <td>${formatarValor(periodos[0].saldo_prog)}</td>` +
                `                               <td data-prazo="${periodos[0].periodo}" data-codigo="${codigo}" data-descricao="${descricao}" data-cor="${cor}" data-desc-cor="${desc_cor}" title="Ordens a Emitir" class="btnOrdensAEmitir clicavel">${periodos[0].a_emitir_ob}</td>` +
                `                               <td>${formatarValor(periodos[0].a_programar)}</td>` +
                `                           </tr>` +
                `                           ${listaPeriodos.toString().replaceAll('</tr>,<tr>', '</tr><tr>')}` +
                `                   </tbody>` +
                `                   </table>` +
                `               </div>` +
                `           </div>` +
                `       </div>` +
                `   </fieldset> `;

            $('#dados').append(`<div id="dados-${`${id}-${id_cor}`}" class="borda"></div>`);
            $(`#dados-${`${id}-${id_cor}`}`).html(html);
            $('.btnQuadroAgulhasTecido').off();
            $('.btnQuadroAgulhasTecido').on('click', async function () {
                try {
                    const titulo = 'Quadro de Agulhas do Tecido';
                    const codigo = $(this).attr('data-codigo');
                    const descricao = $(this).attr('data-descricao');
                    const cor = $(this).attr('data-cor');
                    const desc_cor = $(this).attr('data-desc-cor');

                    const url = `/sisplan/disponibilidadetecidos/v1/buscadadostecnicostecido?`;
                    const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}`, '', 1800000);

                    if (!response) {
                        return;
                    }

                    const data = await response.json();

                    const tabelaTecido = await retornaTabelaTecido(data);

                    const htmlCompleto = `<div class="wrapper">` +
                        `<div class="content-wrapper">` +
                        `<div class="content-header">` +
                        `<div class="container-fluid">` +
                        `<div class="row">` +
                        `<div class="col-12 d-flex align-items-center justify-content-evenly">` +
                        `<h5>Referência: ${codigo} ${descricao}- ${cor} ${desc_cor}</h5>` +
                        `</div>` +
                        `<div class="col-12">${tabelaTecido}` +
                        `</div>` +
                        `<div class="col-12" id="divTabelaFormacaoAgulhas">` +
                        `</div>` +
                        ` </div></div>` +
                        `</div></div></div>`;

                    const novaJanela = window.open("about:blank", "_blank", "width=800,height=600");
                    novaJanela.document.title = titulo;
                    const head = `<html lang=pt-BR"><head><meta charset="UTF - 8"><meta name="viewport" content="width = device - width, initial - scale=1.0"><title>${titulo}</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>`;
                    novaJanela.document.write(`${head}<body>${htmlCompleto}</body></html>`);
                    const botaoHistorico = novaJanela.document.querySelector('.btnHistoricoMaquinaTecido');
                    botaoHistorico.addEventListener('click', async function () {
                        const novaJanelaHist = window.open("about:blank", "_blank", "width=800,height=600");
                        novaJanelaHist.document.title = `Histórico das máquinas que fizeram a referência ${codigo} no último ano.`;
                        const tabelaHistorico = await retornaTabelaHistoricoTecido(codigo, cor);
                        const htmlCompletoHist = `<div class="wrapper">` +
                            `<div class="content-wrapper">` +
                            `<div class="content-header">` +
                            `<div class="container-fluid">` +
                            `<div class="row">` +
                            `<div class="col-12 d-flex align-items-center">` +
                            `<h5>Referência: ${codigo} - ${descricao} - ${cor} ${desc_cor}</h5>` +
                            `</div>` +
                            `<div class="col-12">${tabelaHistorico}` +
                            `</div>` +
                            ` </div></div>` +
                            `</div></div></div>`;
                        const head = `<html lang=pt-BR"><head><meta charset="UTF - 8"><meta name="viewport" content="width = device - width, initial - scale=1.0"><title>${novaJanelaHist.document.title}</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>`;
                        novaJanelaHist.document.write(`${head}<body>${htmlCompletoHist}</body></html>`);
                    });

                    await retornaTabelaFormacaoAgulhas(data, novaJanela);
                } catch (error) {
                    console.log(error);
                }
            });


            function retornaBotaoTec(data, row) {
                return `<div style="text-align:left;"> ` +
                    `   <div> ` +
                    `    <button class="btn btn-info btn-sm btnDadosTecelagem" data-numero="${row[0]}" data-etiqueta="${row[1]}" type="button"> ` +
                    `   ${data} ` +
                    `    </button> ` +
                    `  </div>` +
                    `</div>`;
            }

            function retornaBotaoFixado(data, row) {
                return `<div style="text-align:left;"> ` +
                    `   <div> ` +
                    `    <button class="btn btn-info btn-sm btnDadosFixado" data-numero="${row[0]}" data-codigo="${row[2]}" type="button"> ` +
                    `   ${data} ` +
                    `    </button> ` +
                    `  </div>` +
                    `</div>`;
            }


            $('.btnOrdensAEmitir').off();
            $('.btnOrdensAEmitir').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const cor = $(this).attr('data-cor');
                // const descricao = $(this).attr('data-descricao');
                // const desc_cor = $(this).attr('data-desc-cor');
                const periodo = $(this).attr('data-prazo');
                const base64 = btoa(`aemitir###${codigo}###${cor}###${periodo}`);
                const url = `./tela_ops/${base64}`;
                window.open(url, "_blank", "width=800,height=600");
            });


            $('.btn-pre-baixa').off();
            $('.btn-pre-baixa').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const cor = $(this).attr('data-cor');
                const url = `/sisplan/disponibilidadetecidos/v1/buscadadosprebaixa?`;
                const response = await requisicao("GET", url, `&CODIGO=${codigo}&COR=${cor}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dadosTratados = data.map((item => [`${item.TIPO}.${item.SUBGRUPO}.${item.MAQUINA}`, item.LOTE, item.DATA_HORA, item.ROLOS_PRE_BAIXADOS, item.PESO]));
                $('#tabela-pre-baixa').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    data: dadosTratados,
                    "columnDefs": [
                        {
                            targets: [2],
                            render(data) {
                                return formataDataTabela(data);
                            },
                        }]
                });

                $('#modal-pre-baixa').modal('show');
            });

            $('.btn-estoque-fix').off();
            $('.btn-estoque-fix').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const cor = $(this).attr('data-cor');
                const depositos = (await formataListas($('#txtDepositoCru').val().toString()));
                const url = `/sisplan/disponibilidadetecidos/v1/buscadadosestoquefix?`;
                const response = await requisicao("GET", url, `&CODIGO=${codigo}&COR=${cor}&DEPOSITOS=${depositos}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dadosTratados = data.map((item => [item.ORDEM, item.ROLOS, item.PESO]));
                $('#tabela-estoque-fix').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    data: dadosTratados
                });

                $('#modal-estoque-fix').modal('show');
            });

            $('.btn-fixado-op').off();
            $('.btn-fixado-op').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const semana = $(this).attr('data-semana');
                const url = `/sisplan/disponibilidadetecidos/v1/buscadadosfixadoop?`;
                const response = await requisicao("GET", url, `&CODIGO=${codigo}&SEMANA=${semana}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dadosTratados = data.map((item => [item.NUMERO, item.ROLOS, codigo]));

                if ($.fn.DataTable.isDataTable('#tabela-fixado-op')) {
                    $("#tabela-fixado-op").empty();
                    $("#tabela-fixado-op").DataTable().destroy();
                };

                $('#tabela-fixado-op').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    data: dadosTratados,
                    "columnDefs": [
                        {
                            targets: [2],
                            visible: false
                        },
                        {
                            targets: [0],
                            render(data, type, row) {
                                return retornaBotaoFixado(data, row);
                            },
                        }]
                });

                $('.btnDadosFixado').off();
                $('.btnDadosFixado').on('click', async function () {
                    const numero = $(this).attr('data-numero');
                    const codigo = $(this).attr('data-codigo');
                    const url = `/sisplan/disponibilidadetecidos/v1/buscadetalhesfixadoop?`;
                    const response = await requisicao("GET", url, `&NUMERO=${numero}&CODIGO=${codigo}`, '', 1800000);

                    if (!response) {
                        return;
                    }

                    const data = await response.json();
                    const dadosTratados = data.map((item => [item.ROLO, item.LOTE, formataDataTabela(item.DT_VAL), item.PESO, item.MAQUINA]));
                    $('#tabela-fixado-detalhamento').DataTable({
                        bPaginate: false,
                        destroy: true,
                        colReorder: false,
                        reoder: false,
                        order: false,
                        search: false,
                        filter: false,
                        language: {
                            sEmptyTable: "Nenhum registro encontrado",
                            sInfo: "_TOTAL_ registros",
                            sInfoEmpty: " 0 registros",
                            sInfoFiltered: "(Filtrados de _MAX_ registros)",
                            sInfoPostFix: "",
                            sInfoThousands: ".",
                            sLengthMenu: "_MENU_ resultados",
                            sLoadingRecords: "Carregando...",
                            sProcessing: "Processando...",
                            sZeroRecords: "Nenhum registro encontrado",
                            sSearch: "Pesquisar",
                            oPaginate: {
                                sNext: "Próximo",
                                sPrevious: "Anterior",
                                sFirst: "Primeiro",
                                sLast: "Último",
                            },
                            oAria: {
                                sSortAscending: ": Ordenar colunas de forma ascendente",
                                sSortDescending: ": Ordenar colunas de forma descendente",
                            },
                        },
                        autoWidth: true,
                        data: dadosTratados
                    });

                    $('#modal-fixado-detalhamento-numero').html(` ${numero}`);
                    $('#modal-fixado-detalhamento').modal('show');
                });
                $('#modal-fixado-op').modal('show');
            });



            $('.btnOrdensEmitidas').off();
            $('.btnOrdensEmitidas').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const cor = $(this).attr('data-cor');
                const periodo = $(this).attr('data-prazo');
                const base64 = btoa(`emitidas###${codigo}###${cor}###${periodo}`);
                const url = `./tela_ops/${base64}`;
                window.open(url, "_blank", "width=800,height=600");
            });

            $('.btnPendenteOT').off();
            $('.btnPendenteOT').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const cor = $(this).attr('data-cor');
                const descricao = $(this).attr('data-descricao');
                const desc_cor = $(this).attr('data-desc-cor');
                const periodo = $(this).attr('data-prazo');
                const url = `/sisplan/disponibilidadetecidos/v1/buscaotspendentes?`;
                const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}&PERIODO=${periodo}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dadosTratados = data.map((item => [item.NUMERO, item.ETIQUETA, `${item.TIPO}.${item.SUBGRUPO}.${item.MAQUINA}`, item.DT_PREV_INI ?? '', item.ROLO_DIA ?? 0, item.KG_ROLO, item.ROLOS_PROGRAMADOS, item.SALDO_ROLOS, item.OBSERVACAO]));
                $('#tabela-ots-pendentes').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    data: dadosTratados,
                    "columnDefs": [
                        {
                            targets: [0],
                            render(data, type, row) {
                                return retornaBotaoTec(data, row);
                            },
                        },
                        {
                            targets: [3],
                            render(data) {
                                return formataDataTabela(data);
                            },
                        },
                        {
                            targets: [1],
                            render(data) {
                                return data == 'S' ? '<i class="text-center fas fa-check" style="width: 100%; color: green;"></i>' : '';
                            }
                        }]
                });

                $('#modal-ots-pendentes #modal-ots-referencia').html(`${codigo} - ${descricao}`);
                $('#modal-ots-pendentes #modal-ots-cor').html(`${cor} - ${desc_cor}`);
                $('#modal-ots-pendentes').modal('show');

                $('.btnDadosTecelagem').off();
                $('.btnDadosTecelagem').on('click', async function () {
                    const numero = $(this).attr('data-numero');
                    const etiqueta = $(this).attr('data-etiqueta');
                    if (etiqueta == 'S') {
                        $('#pnlControleOTRolos').removeClass('d-none');
                        $('#pnlControleOTEdicao').addClass('d-none');
                        // tornar inputs disabled
                        $('#txtOTPeriodo').attr('disabled', true);
                        $('#txtOTDataPrevista').attr('disabled', true);
                        $('#txtOTOBS').attr('disabled', true);
                    } else {
                        $('#pnlControleOTEdicao').removeClass('d-none');
                        $('#pnlControleOTRolos').addClass('d-none');
                        // tornar os inputs digitáveis tambem
                        $('#txtOTPeriodo').attr('disabled', false);
                        $('#txtOTDataPrevista').attr('disabled', false);
                        $('#txtOTOBS').attr('disabled', false);
                    }
                    const url = `/sisplan/disponibilidadetecidos/v1/buscainfotecelagem?`;
                    const response = await requisicao("GET", url, `&NUMERO=${separaCodigo(numero)}`, '', 1800000);

                    if (!response) {
                        return;
                    }

                    const data = await response.json();
                    const transformDate = (dataString) => {
                        if (!dataString) {
                            return '';
                        }
                        const partes = dataString.split(' ');
                        const data = partes[0].split('/').reverse().join('-');
                        const hora = partes[1] ? partes[1].substring(0, 5) : '00:00:00'; // Para obter apenas a hora e os minutos

                        const userLang = navigator.language || navigator.userLanguage;
                        if (userLang == 'es') {
                            const esPartes = data.split('-');
                            return `${esPartes[0]}-${esPartes[1].padStart(2, '0')}-${esPartes[2].padStart(2, '0')} ${hora}`;
                        }
                        return `${data} ${hora}`;
                    };

                    $('.etiquetas').attr('data-codigo', data.codigo);
                    $('.etiquetas').attr('data-descricao', data.descricao);
                    $('.etiquetas').attr('data-cor', data.cor);
                    $('.etiquetas').attr('data-desc-cor', data.desc_cor);
                    $('.etiquetas').attr('data-deposito', data.deposito);
                    $('.etiquetas').attr('data-desc-deposito', data.desc_deposito);
                    $('.etiquetas').attr('data-maquina', data.maquina);
                    $('.etiquetas').attr('data-desc-maquina', data.desc_maquina);
                    $('.etiquetas').attr('data-qtde-pecas', data.qtde_rolos_prog);

                    $('#txtOTPeriodo').val(`[${data.periodo}] - ${data.desc_periodo}`);
                    $('#txtOTDataPrevista').val(transformDate(data.data_prevista));
                    $('#txtOTQtdeRolosProg').val(data.qtde_rolos_prog);
                    $('#txtOTQtdeRolosProgNovo').val('');
                    $('#txtOTOBS').val(data.observacao);
                    const dadosTratados = data.rolos && etiqueta == 'S' ? data.rolos.map(rolo => [rolo]) : [];
                    $('#tabela-rolos-pendentes').DataTable({
                        bPaginate: false,
                        destroy: true,
                        colReorder: false,
                        reoder: false,
                        order: false,
                        search: false,
                        filter: false,
                        language: {
                            sEmptyTable: "Nenhum registro encontrado",
                            sInfo: "_TOTAL_ registros",
                            sInfoEmpty: " 0 registros",
                            sInfoFiltered: "(Filtrados de _MAX_ registros)",
                            sInfoPostFix: "",
                            sInfoThousands: ".",
                            sLengthMenu: "_MENU_ resultados",
                            sLoadingRecords: "Carregando...",
                            sProcessing: "Processando...",
                            sZeroRecords: "Nenhum registro encontrado",
                            sSearch: "Pesquisar",
                            oPaginate: {
                                sNext: "Próximo",
                                sPrevious: "Anterior",
                                sFirst: "Primeiro",
                                sLast: "Último",
                            },
                            oAria: {
                                sSortAscending: ": Ordenar colunas de forma ascendente",
                                sSortDescending: ": Ordenar colunas de forma descendente",
                            },
                        },
                        autoWidth: true,
                        data: dadosTratados,
                        "columnDefs": [
                            {
                                targets: [1],
                                render(data, type, row) {
                                    return ` <div class="form-check" style="display: flex;justify-content: center;align-items: center;"> ` +
                                        `     <input data-lote="${row[0]}" class="form-check-input cbRoloRemover" type="checkbox" />` +
                                        ` </div>`;
                                },
                            }]
                    });

                    $('#modal-ot-edicao #modal-ot-edicao-numero').html(`${numero}`);
                    $('#modal-ot-edicao').modal('show');
                    $('.todos').off();
                    $('.todos').on('click', async function () {
                        const cbRemoverList = $('.cbRoloRemover').toArray();
                        const jaEstaoChecados = $($('.cbRoloRemover')[0]).prop('checked');
                        for (let i = 0; i < cbRemoverList.length; i++) {
                            $($('.cbRoloRemover')[i]).prop('checked', !jaEstaoChecados);
                        }
                    });

                    $('.reimprimir').off();
                    $('.reimprimir').on('click', async function () {
                        try {
                            $.LoadingOverlay("show");
                            try {
                                const numero = $('#modal-ot-edicao-numero').html();
                                const url = `/sisplan/impressao/v1/imprimiretiquetatecido?`;
                                const bImprimeAutomatico = await verificaImprimirAutomatico('RelEtiquetaTecido');
                                const arquivo = await GeraRelatorio(`${url}&NUMERO=${numero}&`, "GET", 100000, false, 'RelEtiquetaTecido');
                                if (arquivo != undefined) {
                                    if (!bImprimeAutomatico) {
                                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                                    }
                                    await limparRelatorios();
                                }

                                $('#modal-etiquetas-ot').modal('hide');
                                $('#modal-ot-edicao').modal('hide');
                                $('#modal-ots-pendentes').modal('hide');
                            } catch (error) {
                                console.error(error);
                            }
                        } finally {
                            $.LoadingOverlay("hide");
                        }
                    });



                    $('.cancelar').off();
                    $('.cancelar').on('click', async function () {
                        const permissao = await permissaoAcessos("DISPONIBILIDADE_TECIDOS");
                        if (permissao.EXCLUI == 'N') {
                            msgAlerta('Usuário sem permissão para Excluir a ordem.');
                            return;
                        }
                        msgAlerta(`Tem certeza que deseja excluir a ordem de tecelagem?`, async () => {
                            const numero = $('#modal-ot-edicao-numero').html();

                            try {
                                const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/deletainfotecelagem?", `NUMERO=${numero}`, "", 300000);

                                if (!response) {
                                    throw msgAlerta("Não foi possível excluir a ordem.");
                                }

                                if (response.status != 200) {
                                    throw msgAlerta("Não foi possível excluir a ordem.");
                                }

                                criaMensagemSucesso("Ordem excluída com sucesso", async () => {
                                    $('#modal-ot-edicao').modal('hide');
                                    $('#modal-ots-pendentes').modal('hide');
                                });

                            } catch (error) {
                                console.error(error);
                            }
                        });
                    });

                    $('.etiquetas').off();
                    $('.etiquetas').on('click', async function () {
                        const numero = $('#modal-ot-edicao-numero').html();
                        const codigo = $(this).attr('data-codigo');
                        const descricao = $(this).attr('data-descricao');
                        const cor = $(this).attr('data-cor');
                        const desc_cor = $(this).attr('data-desc-cor');
                        const deposito = $(this).attr('data-deposito');
                        const desc_deposito = $(this).attr('data-desc-deposito');
                        const maquina = $(this).attr('data-maquina');
                        const desc_maquina = $(this).attr('data-desc-maquina');


                        $('#btn-etq-gerar').attr('data-numero', numero);

                        $('#modal-etiquetas-ot-referencia').html(`${codigo} - ${descricao}`);
                        $('#modal-etiquetas-ot-cor').html(`${cor} - ${desc_cor}`);
                        $('#modal-etiquetas-ot-maquina').html(`${maquina} - ${desc_maquina}`);
                        $('#modal-etiquetas-ot-deposito').html(`${deposito} - ${desc_deposito}`);


                        if ($.fn.DataTable.isDataTable('#tabela-etq-lotes')) {
                            $("#tabela-etq-lotes").DataTable().destroy();
                            $("#tabela-etq-lotes").empty();
                        };
                        $('#modal-etiquetas-ot').modal('show');
                    });

                    $('#btn-etq-gerar').off();
                    $('#btn-etq-gerar').on('click', async function () {
                        // gerar os seq e jogar na datable
                        const numero = $(this).attr('data-numero');
                        const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/validaegeralotes?", `NUMERO=${numero}`, "", 30000);

                        if (!response) {
                            throw msgAlerta("Não foi possível gerar as etiquetas.");
                        }

                        if (response.status != 200) {
                            throw msgAlerta("Não foi possível gerar as etiquetas.");
                        }

                        const data = await response.json();
                        const dados = data.lista && data.lista.length > 0 ? data.lista.map(dt => ({ numero: dt.numero, etiqueta: dt.etiqueta, sequencial: dt.seq, peso: 0, id: 0, gerado: 'N' }))
                            : [];

                        const dataSetCols = [
                            {
                                data: 'numero',
                                title: 'Número'
                            },
                            {
                                data: 'etiqueta',
                                title: 'Etiqueta'
                            },
                            {
                                data: 'sequencial',
                                title: 'Sequencial'
                            },
                            {
                                data: 'peso',
                                title: 'Peso'
                            },
                            {
                                data: 'id',
                                title: 'Id'
                            },
                            {
                                data: 'gerado',
                                title: 'Gerado'
                            },
                        ];

                        $('#tabela-etq-lotes').DataTable({
                            bPaginate: false,
                            destroy: true,
                            colReorder: false,
                            reoder: false,
                            order: false,
                            search: false,
                            filter: false,
                            language: {
                                sEmptyTable: "Nenhum registro encontrado",
                                sInfo: "_TOTAL_ registros",
                                sInfoEmpty: " 0 registros",
                                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                                sInfoPostFix: "",
                                sInfoThousands: ".",
                                sLengthMenu: "_MENU_ resultados",
                                sLoadingRecords: "Carregando...",
                                sProcessing: "Processando...",
                                sZeroRecords: "Nenhum registro encontrado",
                                sSearch: "Pesquisar",
                                oPaginate: {
                                    sNext: "Próximo",
                                    sPrevious: "Anterior",
                                    sFirst: "Primeiro",
                                    sLast: "Último",
                                },
                                oAria: {
                                    sSortAscending: ": Ordenar colunas de forma ascendente",
                                    sSortDescending: ": Ordenar colunas de forma descendente",
                                },
                            },
                            autoWidth: true,
                            data: dados,
                            columns: dataSetCols
                        });
                    });

                    $('#btn-etq-gravar').off();
                    $('#btn-etq-gravar').on('click', async function () {
                        const permissao = await permissaoAcessos("DISPONIBILIDADE_TECIDOS");
                        if (permissao.ALTERA == 'N') {
                            msgAlerta('Usuário sem permissão para gravar.');
                            return;
                        }

                        if (!$.fn.DataTable.isDataTable('#tabela-etq-lotes')) {
                            msgAlerta('Nenhum registro gerado, impossível gravar.');
                            return;
                        }

                        if ($('#tabela-etq-lotes').DataTable().data().toArray().length == 0) {
                            msgAlerta('Nenhum registro gerado, impossível gravar.');
                            return;
                        }

                        msgAlerta(`Tem certeza que deseja gravar as informações?`, async () => {
                            try {
                                $.LoadingOverlay('show');
                                const dados = {
                                    lista: $('#tabela-etq-lotes').DataTable().data().toArray()
                                };
                                const numero = $('#modal-ot-edicao-numero').html();

                                try {
                                    const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/gravaetiqueta?", `NUMERO=${numero}&JSON=${JSON.stringify(dados)}`, "", 300000);

                                    if (!response) {
                                        throw msgAlerta("Não foi possível gravar as informações.");
                                    }

                                    if (response.status != 200) {
                                        throw msgAlerta("Não foi possível gravar as informações.");
                                    }

                                    // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

                                    criaMensagemSucesso("Informações gravadas com sucesso", async () => {
                                        try {
                                            $.LoadingOverlay("show");
                                            try {
                                                const url = `/sisplan/impressao/v1/imprimiretiquetatecido?`;
                                                const bImprimeAutomatico = await verificaImprimirAutomatico('RelEtiquetaTecido');
                                                const arquivo = await GeraRelatorio(`${url}&NUMERO=${numero}&`, "GET", 100000, false, 'RelEtiquetaTecido');
                                                if (arquivo != undefined) {
                                                    if (!bImprimeAutomatico) {
                                                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                                                    }
                                                    await limparRelatorios();
                                                }

                                                $('#modal-etiquetas-ot').modal('hide');
                                                $('#modal-ot-edicao').modal('hide');
                                                $('#modal-ots-pendentes').modal('hide');
                                            } catch (error) {
                                                console.error(error);
                                            }
                                        } finally {
                                            $.LoadingOverlay("hide");
                                        }
                                    });

                                } catch (error) {
                                    console.error(error);
                                }
                            } finally {
                                $.LoadingOverlay('hide');
                            }
                        });
                    });


                    $('.gravar').off();
                    $('.gravar').on('click', async function () {
                        const permissao = await permissaoAcessos("DISPONIBILIDADE_TECIDOS");
                        if (permissao.ALTERA == 'N') {
                            msgAlerta('Usuário sem permissão para gravar.');
                            return;
                        }
                        msgAlerta(`Tem certeza que deseja gravar as informações?`, async () => {
                            const temRolosPendentes = $('#tabela-rolos-pendentes').DataTable().data().toArray().length > 0;
                            const numero = $('#modal-ot-edicao-numero').html();
                            const periodo = pegaChave('#txtOTPeriodo');
                            const datahora = $('#txtOTDataPrevista').val();
                            const obs = $('#txtOTOBS').val();
                            const qtdeRolosNovos = $('#txtOTQtdeRolosProgNovo').val();
                            if (!temRolosPendentes) {
                                if (periodo == '') {
                                    msgErro('Campo Período é obrigatório, verifique.');
                                    return;
                                }
                                if (datahora == '') {
                                    msgErro('Campo Data/Hora Prevista é obrigatório, verifique.');
                                    return;
                                }
                                if (qtdeRolosNovos <= 0) {
                                    msgErro('Quantidade de Rolos Novos deve ser maior que 0, verifique.');
                                    return;
                                }
                            }

                            const objeto = {
                                numero,
                                periodo,
                                data_prevista: datahora,
                                qtde_rolos_novos: qtdeRolosNovos,
                                observacao: obs,
                                rolos: $('.cbRoloRemover:checked').toArray().map(input => $(input).attr('data-lote')),
                                permitindoRemoverRolos : !$('#pnlControleOTRolos').hasClass('d-none')
                            };

                            try {
                                const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/gravainfotecelagem?", `JSON=${JSON.stringify(objeto)}`, "", 300000);

                                if (!response) {
                                    throw msgAlerta("Não foi possível gravar as informações.");
                                }

                                if (response.status != 200) {
                                    throw msgAlerta("Não foi possível gravar as informações.");
                                }

                                // criaMensagemSucesso("Desdobramento do lote gravado com sucesso", () => { window.location.reload(); });

                                criaMensagemSucesso("Informações gravadas com sucesso", async () => {
                                    $('#modal-ot-edicao').modal('hide');
                                    $('#modal-ots-pendentes').modal('hide');
                                });

                            } catch (error) {
                                console.error(error);
                            }
                        });
                    });

                });

            });

            $('.btnEstoqueRolo').off();
            $('.btnEstoqueRolo').on('click', async function () {
                const codigo = $(this).attr('data-codigo');
                const cor = $(this).attr('data-cor');
                const descricao = $(this).attr('data-descricao');
                const desc_cor = $(this).attr('data-desc-cor');
                const depositos_crus = (await formataListas($('#txtDepositoCru').val().toString()));
                const url = `/sisplan/disponibilidadetecidos/v1/buscaestoquerolos?`;
                const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}&DEPOSITOS_CRUS=${depositos_crus}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dadosTratados = data.map((item => [`${item.TIPO}.${item.SUBGRUPO}.${item.MAQUINA}`, item.LOTE_MAIS_USADO, item.ROLOS, item.NOME, item.NOME_FABRICANTE]));
                $('#tabela-estoque-rolos').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    data: dadosTratados
                });

                $('#modal-estoque-rolos #modal-estoque-referencia').html(`${codigo} - ${descricao}`);
                $('#modal-estoque-rolos #modal-estoque-cor').html(`${cor} - ${desc_cor}`);
                $('#modal-estoque-rolos').modal('show');
            });

            $('#btnDetalhesEstoque').off();
            $('#btnDetalhesEstoque').on('click', async function () {
                const codigo = $('#modal-estoque-referencia').html().split('-')[0].trim();
                const cor = $('#modal-estoque-cor').html().split('-')[0].trim();
                const descricao = $('#modal-estoque-referencia').html().split('-')[1].trim();
                const desc_cor = $('#modal-estoque-cor').html().split('-')[1].trim();
                const depositos_crus = (await formataListas($('#txtDepositoCru').val().toString()));
                const url = `/sisplan/disponibilidadetecidos/v1/buscaestoquedetalhadorolos?`;
                const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}&DEPOSITOS_CRUS=${depositos_crus}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dadosTratados = data.map((item => [item.ROLO, item.LOTE, item.DT_HORA, item.PESO, `${item.TIPO}.${item.SUBGRUPO}.${item.MAQUINA}`, item.NOME, item.NOME_FABRICANTE]));
                $('#tabela-estoque-rolos-detalhado').DataTable({
                    bPaginate: false,
                    destroy: true,
                    colReorder: false,
                    reoder: false,
                    order: false,
                    search: false,
                    filter: false,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    data: dadosTratados,
                    "columnDefs": [
                        {
                            targets: [2],
                            render(data) {
                                return formataDataTabela(data);
                            },
                        }]
                });

                $('#modal-estoque-rolos-detalhado #modal-estoque-referencia-detalhado').html(`${codigo} - ${descricao}`);
                $('#modal-estoque-rolos-detalhado #modal-estoque-cor-detalhado').html(`${cor} - ${desc_cor}`);
                $('#modal-estoque-rolos-detalhado').modal('show');
            });


            $('.btnQuadroMaquinasTecido').off();
            $('.btnQuadroMaquinasTecido').on('click', async function () {
                try {
                    const codigo = $(this).attr('data-codigo');
                    const cor = $(this).attr('data-cor');
                    const descricao = $(this).attr('data-descricao');
                    const desc_cor = $(this).attr('data-desc-cor');
                    const url = `/sisplan/disponibilidadetecidos/v1/buscaquadrosmaquina?`;
                    const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}`, '', 1800000);

                    if (!response) {
                        return;
                    }

                    const data = await response.json();
                    const dadosTratados = data.map((item => [item.MAQUINA, item.REF_ATUAL, item.COR, item.SITUACAO, item.OBS, item.ROLOS_PROGRAMADOS, item.ROLOS_BAIXADOS, item.SALDO, item.TIPO, item.SUBGRUPO]));
                    $('#tabela-maquina-tecido').DataTable({
                        bPaginate: false,
                        destroy: true,
                        colReorder: false,
                        reoder: false,
                        order: false,
                        search: false,
                        filter: false,
                        language: {
                            sEmptyTable: "Nenhum registro encontrado",
                            sInfo: "_TOTAL_ registros",
                            sInfoEmpty: " 0 registros",
                            sInfoFiltered: "(Filtrados de _MAX_ registros)",
                            sInfoPostFix: "",
                            sInfoThousands: ".",
                            sLengthMenu: "_MENU_ resultados",
                            sLoadingRecords: "Carregando...",
                            sProcessing: "Processando...",
                            sZeroRecords: "Nenhum registro encontrado",
                            sSearch: "Pesquisar",
                            oPaginate: {
                                sNext: "Próximo",
                                sPrevious: "Anterior",
                                sFirst: "Primeiro",
                                sLast: "Último",
                            },
                            oAria: {
                                sSortAscending: ": Ordenar colunas de forma ascendente",
                                sSortDescending: ": Ordenar colunas de forma descendente",
                            },
                        },
                        autoWidth: true,
                        data: dadosTratados,
                        "columnDefs": [
                            {
                                targets: [0],
                                render(data, type, row) {
                                    return retornaBotaoOpcoes(data, row);
                                },
                            },
                            {
                                targets: [8, 9],
                                visible: false
                            }
                        ]
                    });


                    $('.btnDadosTecnicosMaquina').off();
                    $('.btnDadosTecnicosMaquina').on('click', async function () {
                        try {
                            const titulo = 'Dados Técnicos por Máquina';
                            const maquina = $(this).attr('data-maquina');
                            const codigo = $(this).attr('data-codigo');
                            const cor = $(this).attr('data-cor');
                            const grupo = $(this).attr('data-grupo');
                            const subGrupo = $(this).attr('data-sub-grupo');

                            const url = `/sisplan/disponibilidadetecidos/v1/buscadadostecnicosmaquina?`;
                            const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}&MAQUINA=${maquina}`, '', 1800000);

                            if (!response) {
                                return;
                            }

                            const data = await response.json();

                            const tabelaMaquina = await retornaTabelaMaquinas(data);
                            const tabelaFios = await retornaTabelaFios(data);

                            const htmlCompleto = `<div class="wrapper">` +
                                `<div class="content-wrapper">` +
                                `<div class="content-header">` +
                                `<div class="container-fluid">` +
                                `<div class="row">` +
                                `<div class="col-12 d-flex align-items-center justify-content-evenly">` +
                                `<h5>Referência: ${codigo} - ${cor}</h5>` +
                                `<h5>Máquina: ${grupo}.${subGrupo}.${maquina}</h5>` +
                                `</div>` +
                                `<div class="col-12">${tabelaMaquina}` +
                                `</div>` +
                                `<div class="col-12">${tabelaFios}` +
                                `</div>` +
                                `<div class="col-12" id="divTabelaFormacaoAgulhas">` +
                                `</div>` +
                                ` </div></div>` +
                                `</div></div></div>`;

                            const novaJanela = window.open("about:blank", "_blank", "width=800,height=600");
                            novaJanela.document.title = titulo;
                            // novaJanela.document.write(conteudo);
                            const head = `<html lang=pt-BR"><head><meta charset="UTF - 8"><meta name="viewport" content="width = device - width, initial - scale=1.0"><title>${titulo}</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>`;
                            novaJanela.document.write(`${head}<body>${htmlCompleto}</body></html>`);
                            const botaoHistorico = novaJanela.document.querySelector('.btnHistoricoMaquina');
                            botaoHistorico.addEventListener('click', async function () {
                                const novaJanelaHist = window.open("about:blank", "_blank", "width=800,height=600");

                                novaJanelaHist.document.title = `Histórico de referências produzidas pela máquina ${maquina} no último ano`;
                                const tabelaHistorico = await retornaTabelaHistorico(maquina);
                                const htmlCompletoHist = `<div class="wrapper">` +
                                    `<div class="content-wrapper">` +
                                    `<div class="content-header">` +
                                    `<div class="container-fluid">` +
                                    `<div class="row">` +
                                    `<div class="col-12 d-flex align-items-center">` +
                                    `<h5>Máquina: ${grupo}.${subGrupo}.${maquina}</h5>` +
                                    `</div>` +
                                    `<div class="col-12">${tabelaHistorico}` +
                                    `</div>` +
                                    ` </div></div>` +
                                    `</div></div></div>`;
                                const head = `<html lang=pt-BR"><head><meta charset="UTF - 8"><meta name="viewport" content="width = device - width, initial - scale=1.0"><title>${novaJanelaHist.document.title}</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"></head>`;
                                novaJanelaHist.document.write(`${head}<body>${htmlCompletoHist}</body></html>`);
                            });
                            await retornaTabelaFormacaoAgulhas(data, novaJanela);
                        } catch (error) {
                            console.log(error);
                        }
                    });


                    $('#modal-quadro-maquinas').modal('show');
                    $('#modal-quadro-maquinas #modal-quadro-referencia').html(`${codigo} - ${descricao}`);
                    $('#modal-quadro-maquinas #modal-quadro-cor').html(`${cor} - ${desc_cor}`);
                    // $('#modal-quadro-maquinas .conteudo').html();
                } catch (error) {
                    console.log(error);
                }
            });

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }
    async function montaDadosPrioridadeEFichaTecnica(dados) {
        if (!dados || dados.length == 0) {
            return;
        }

        const { id, id_cor, prioridades, ficha_tecnica } = dados;

        const dadosPrioridade = prioridades && prioridades.length > 0 ? prioridades.map(prio => (`<tr>` +
            ` <td>${prio.prioridade}</td>` +
            `<td>${prio.quantidade}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';
        const dadosFicha = ficha_tecnica && ficha_tecnica.length > 0 ? ficha_tecnica.map(ficha => (`<tr>` +
            `<td>${ficha.peso_cru}</td>` +
            `<td>${ficha.peso_acabado}</td>` +
            `<td>${ficha.quebra}</td>` +
            `<td>${ficha.programa}</td>` +
            `<td>${ficha.finura}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';
        const html = `<fieldset class="prioridade">` +
            `  <div class="card card-body">` +
            `      <div class="form-row">` +
            `          <div class="col-xl-6 col-12 table-responsive">` +
            `              <table id="tabelaPrioridade" class="table table-sm table-select table-hover" width="100%" style="width: 100%">` +
            `                  <thead style="background-color: inherit!important; color: inherit!important;">` +
            `                      <tr>` +
            `                          <th>Prioridade</th>` +
            `                          <th>Quantidade</th>` +
            `                      </tr>` +
            `                  </thead>` +
            `                  <tbody>` +
            `${dadosPrioridade}` +
            `                  </tbody>` +
            `              </table>` +
            `          </div>` +
            `          <div class="col-xl-6 col-12 table-responsive">` +
            `              <table id="tabelaFichaTecnica" class="table table-sm table-select table-hover" width="100%" style="width: 100%">` +
            `                  <thead style="background-color: inherit!important; color: inherit!important;">` +
            `                      <tr>` +
            `                          <th>Peso Cru</th>` +
            `                          <th>Peso Acabado</th>` +
            `                          <th>Quebra</th>` +
            `                          <th>Programa</th>` +
            `                          <th>Finura</th>` +
            `                      </tr>` +
            `                  </thead>` +
            `                  <tbody>` +
            `${dadosFicha}` +
            `                  </tbody>` +
            `              </table>` +
            `          </div>` +
            `      </div>` +
            `  </div>` +
            `</fieldset>`;
        $(`#dados-${`${id}-${id_cor}`}`).append(html);
    }
    async function montaDadosFiosEMaquinas(dados) {
        const { codigo, cor, id, id_cor, fios, maquinas } = dados;

        const dadosFios = fios && fios.length > 0 ? fios.map(fio => (`<tr>` +
            `<td>${fio.codigo}</td>` +
            `<td>${`${fio.cor} - ${fio.desc_cor}`}</td>` +
            `<td>${fio.descricao}</td>` +
            `<td>${fio.rocas}</td>` +
            `<td>${fio.percentual_consumo}</td>` +
            `<td>${parseFloat(fio.empenho).toFixed(3)}</td>` +
            `<td>${parseFloat(fio.empenhoTecido).toFixed(3)}</td>` +
            `<td>${parseFloat(fio.necessidade).toFixed(3)}</td>` +
            `<td style="${fio.tem_contratipo == 'S' ? 'background-color: green; color: white;' : ''} ${fio.estoque_disp <= 0 ? 'color: red' : ''}">${parseFloat(fio.estoque_disp).toFixed(3)}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';

        const dadosMaquinas = maquinas && maquinas.length > 0 ? maquinas.map(maquina => {
            const obj = {
                "0": 'PARADA',
                "1": 'APÓS',
                "2": 'ATIVA',
                "3": 'TROCA DE REFERÊNCIA',
                "4": 'TRANSFORMAÇÃO',
                "5": 'MANUTENÇÃO',
                "6": 'AMOSTRAGEM'
            };
            const situacao = obj[maquina.situacao];
            return (
                `<tr>
                <td><span title="Imprimir Ficha Técnica" class="btn-imprimir-ficha" style="color: #3582d5;cursor: pointer" data-codigo="${codigo}" data-cor="${cor}" data-maquina="${maquina.maquina}">${maquina.temApos == 'S' ? '** ' : ''}${`${maquina.tipo}.${maquina.subgrupo}.${maquina.maquina}`}</span><button data-maquina="${maquina.maquina}" title="Fios atrelados a máquina" class="ml-2 btn btn-primary btn-xs btn-fios-maq"><i class="fas fa-file-invoice" style=""></i></button></td>
                <td>${maquina.descricao}</td>
                <td>${parseFloat(maquina.rolos).toFixed(2)}</td>
                <td>${maquina.grupo}</td>
                <td>${maquina.finura}</td>
                <td>${situacao}</td>
                <td>${maquina.obs}</td>
            </tr>`);
        }).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';

        const totalAtivas = maquinas && maquinas.length > 0 ? maquinas.filter(maq => maq.situacao == 2).length : 0;
        const html = `
        <fieldset class="fios">
            <div class="card card-body">
                <div class="form-row">
                    <div class="col-xl-6 col-12 table-responsive">
                        <table id="tabelaFios" class="table table-sm table-select table-hover" width="100%" style="width: 100%">
                            <thead style="background-color: inherit!important; color: inherit!important;">
                                <tr>
                                    <th>Código</th>
                                    <th>Cor</th>
                                    <th>Descrição</th>
                                    <th>Rocas</th>
                                    <th>% Cons.</th>
                                    <th>Empenho Total</th>
                                    <th>Empenho Tecido</th>
                                    <th>Necessidade</th>
                                    <th>Estoque Disp.</th>
                                </tr>
                            </thead>
                            <tbody>
                            ${dadosFios}
                            </tbody>
                        </table>
                    </div>
                    <div class="col-xl-6 col-12 table-responsive">
                        <table id="tabelaMaquinas" class="table table-sm table-select table-hover" width="100%" style="width: 100%">
                            <thead style="background-color: inherit!important; color: inherit!important;">
                                <tr>
                                    <th>Máquina</th>
                                    <th>Descrição</th>
                                    <th>Rolos</th>
                                    <th>Grupo</th>
                                    <th>Finura</th>
                                    <th>Situação</th>
                                    <th>Obs</th>
                                </tr>
                            </thead>
                            <tbody>
                               ${dadosMaquinas}
                            </tbody>
                        </table>
                        <p class="text-md">Máquinas Ativas: ${totalAtivas}</p>
                    </div>
                </div>
            </div>
        </fieldset>`;
        $(`#dados-${`${id}-${id_cor}`}`).append(html);
    }

    $('#btnImprimirTela').on('click', function () {
        printCurrentPage();
    });


    $('#btnLimparTela').on('click', function () {
        // $('#txtReferencia').val('');
        $('#txtMaterial').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtDepositoCru').empty().trigger('change');
        $('#txtDepositoFio').empty().trigger('change');
        // $('#txtCor').val('');
        $('#txtPeriodo1').val('');
        $('#txtPeriodo2').val('');
        $('#txtPeriodo3').val('');
        $('#txtPeriodo4').val('');
        // $('#txtDepositoCru').val('');
        // $('#txtDepositoFio').val('');
        $('#tecidos').html('');
        $('#prioridade').html('');
        $('#dados').html('');
    });


    function filtrosInvalidos() {
        if (($('#txtPeriodo1').val() == '') || ($('#txtPeriodo2').val() == '') || ($('#txtPeriodo3').val() == '')) {
            msgAlerta('Períodos obrigatórios, verifique.');
            return true;
        }


        if ($('#txtDepositoCru').val() == '') {
            msgAlerta('Depósito Cru obrigatório, verifique.');
            return true;
        }

        if ($('#txtDepositoFio').val() == '') {
            msgAlerta('Depósito Fio obrigatório, verifique.');
            return true;
        }
        return false;
    }


    $('#btnConsultar').on('click', async function () {



        try {
            try {
                $('.select2-selection__rendered').scrollTop(0);
                $.LoadingOverlay("show");
                if (filtrosInvalidos()) {
                    return;
                }
                $('#dados').html('');
                const filtros = await retornaFiltros();
                const url = `/sisplan/disponibilidadetecidos/v1/buscadados?`;
                const response = await requisicao("GET", url, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dados = data.lista;

                // const referencias = $('#txtMaterial').val();
                for (let i = 0; i < dados.length; i++) {
                    if (dados[i] == null) {
                        continue;
                    }
                    await montaDadosTecidos(dados[i]);
                    await montaDadosPrioridadeEFichaTecnica(dados[i]);
                    await montaDadosFiosEMaquinas(dados[i]);
                    await criaBotoesAuxiliares(dados[i]);

                    // $('#input-default-semana').off();
                    // $('#input-default-semana').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
                }

                $('.btn-fios-maq').off();
                $('.btn-fios-maq').on('click', async function () {
                    try {
                        $.LoadingOverlay("show");
                        try {
                            const maquina = $(this).attr('data-maquina');
                            const pesquisa = {
                                tabela: 'MAT_ITEN',
                                camposSelect: ['MAT_ITEN.CODIGO', 'MATERIAL.DESCRICAO', 'MAT_ITEN.LOTE'],
                                leftJoin: [{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = MAT_ITEN.CODIGO' }],
                                where: [`MAT_ITEN.DEPOSITO IN (SELECT DEPOSITO FROM [MAQUINA] WHERE MAQUINA='${maquina}') AND MATERIAL.GRUPO <> '14'`],
                                groupBy: ['MAT_ITEN.CODIGO', 'MATERIAL.DESCRICAO', 'MAT_ITEN.LOTE'],
                                having: ['SUM(MAT_ITEN.QTDE) >0']
                            };

                            const retorno = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

                            const dadosTratados = retorno.map(dt => [dt.CODIGO, dt.DESCRICAO, dt.LOTE]);

                            $('#tabela-maq-fios').DataTable({
                                bPaginate: false,
                                destroy: true,
                                colReorder: false,
                                reoder: false,
                                order: false,
                                search: false,
                                filter: false,
                                info: false,
                                language: {
                                    sEmptyTable: "Nenhum registro encontrado",
                                    sInfo: "_TOTAL_ registros",
                                    sInfoEmpty: " 0 registros",
                                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                                    sInfoPostFix: "",
                                    sInfoThousands: ".",
                                    sLengthMenu: "_MENU_ resultados",
                                    sLoadingRecords: "Carregando...",
                                    sProcessing: "Processando...",
                                    sZeroRecords: "Nenhum registro encontrado",
                                    sSearch: "Pesquisar",
                                    oPaginate: {
                                        sNext: "Próximo",
                                        sPrevious: "Anterior",
                                        sFirst: "Primeiro",
                                        sLast: "Último",
                                    },
                                    oAria: {
                                        sSortAscending: ": Ordenar colunas de forma ascendente",
                                        sSortDescending: ": Ordenar colunas de forma descendente",
                                    },
                                },
                                autoWidth: true,
                                data: dadosTratados,
                                "columnDefs": []
                            });

                            $('#modal-maq-fios').modal('show');
                            $('#modal-maq-maquina').html(maquina);


                        } catch (error) {
                            console.error(error);
                        }
                    } finally {
                        $.LoadingOverlay("hide");
                    }

                });

                $('.btn-imprimir-ficha').off();
                $('.btn-imprimir-ficha').on('click', async function (e) {
                    if ($(e.target).is("#btn-fios-maq")) {
                        return;
                    }
                    try {
                        $.LoadingOverlay("show");
                        try {
                            const codigo = $(this).attr('data-codigo');
                            const cor = $(this).attr('data-cor');
                            const maquina = $(this).attr('data-maquina');
                            const url = `/sisplan/impressao/v1/imprimirfichatecnicatecido?`;
                            const filtros = `CODIGO=${codigo}&COR=${cor}&MAQUINA=${maquina}`;
                            const bImprimeAutomatico = await verificaImprimirAutomatico('relFichaTecnicaTecido');
                            const arquivo = await GeraRelatorio(`${url}${filtros}&`, "GET", 100000, false, 'relFichaTecnicaTecido');
                            if (arquivo != undefined) {
                                if (!bImprimeAutomatico) {
                                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                                }
                                await limparRelatorios();
                            }
                        } catch (error) {
                            console.error(error);
                        }
                    } finally {
                        $.LoadingOverlay("hide");
                    }
                });
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });
    // $("#btnGravar").on("click", async function () {
    //     $.LoadingOverlay("show");
    //     $("#btnGravar").prop("disabled", true);
    //     try {
    //         let bZeraLote = false;
    //         const saldo = $("#txtSaldo").val();

    //         if (saldo < 0) {
    //             throw msgAlerta("Não é possível realizar a operação, saldo negativo.");
    //         } else {
    //             await gravaDesdobraLote(bZeraLote);
    //         }

    //     } finally {
    //         $.LoadingOverlay("hide");
    //         $("#btnGravar").prop("disabled", false);
    //     }
    // });

    $('#btnDepositoFioFixo, #btnDepositoCruFixo').on('click', function (e) {
        e.preventDefault();
        const botaoClicado = $(this).attr('id');
        const valores = botaoClicado == 'btnDepositoFioFixo' ? $('#txtDepositoFio').val() : $('#txtDepositoCru').val();
        localStorage.setItem(`web@${botaoClicado}`, JSON.stringify(valores));
    });


    function abrirNovaTela(titulo, conteudo) {
        const novaJanela = window.open("about:blank", "_blank", "width=800,height=600");
        const conteudoInicial = `<!DOCTYPE html><html><head><title>${titulo}</title></head><body></body></html>`;
        novaJanela.document.write(conteudoInicial);
        novaJanela.document.title = titulo;
        novaJanela.document.write(conteudo);
    }

    function printCurrentPage() {
        // Obtém todo o conteúdo da página atual
        const originalContent = document.documentElement.outerHTML;

        // Abre uma nova janela em branco
        const printWindow = window.open('', '_blank', 'width=800,height=600');

        // Escreve o conteúdo da página no novo documento
        printWindow.document.open();
        printWindow.document.write(`
            <!DOCTYPE html>
            <html>
                <head>
                    <title>Imprimir Página</title>
                    <style>
                        /* Estilos opcionais para impressão podem ser adicionados aqui */
                        @media print {
                            body * {
                                visibility: visible;
                            }

                            body {
                                margin: 0;
                                padding: 20px;
                                color: #000000!important;
                            }
                            
                            * {
                                color: #000000!important;
                            }
                        }
                    </style>
                </head>
                <body>
                    ${originalContent}
                </body>
            </html>
        `);
        printWindow.document.close(); // Fechar o stream de escrita do documento

        // Espera o conteúdo carregar e imprime
        printWindow.onload = function () {
            printWindow.focus(); // Foca na janela de impressão
            printWindow.print(); // Abre o diálogo de impressão
            printWindow.close(); // Fecha a janela após a impressão
        };
    }



});
