$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Aqui, adicionamos o código da composição.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição da composição.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a composição.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let composicao = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('COMPOSICAOMATERIAL', getCookie('usuario'), composicao);
        window.location.href = `${BASE_URI}/composicaomaterial`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'COMPOSICAO_MAT', 'CODIGO', 3)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código."
                },
                txtDescricao: {
                    required: "Informe uma descrição."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (composicao != '' && composicao != 'create') {

        if (await liberarRegistro('COMPOSICAOMATERIAL', composicao) == false) {
            window.location.href = '../composicaomaterial';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"COMPOSICAO_MAT", 
                    "camposSelect":["CODIGO", "CODIGO2", "DESCRICAO", "DESCRICAO2", "DESCRICAO3"], 
                    "where": ["CODIGO = '${composicao}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtCodigo2').val(jsonStr.RESULT[0][0].CODIGO2);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtDescricao2').val(jsonStr.RESULT[0][0].DESCRICAO2);
                    $('#txtDescricao3').val(jsonStr.RESULT[0][0].DESCRICAO3);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da composição: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(
        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    if (composicao == 'create') {
                        if (await buscaValor('COMPOSICAO_MAT', 'CODIGO', 'CODIGO', $('#txtCodigo').val())) {
                            throw msgAlerta('Código já existe para outra composição, verifique!')
                        }

                        if (await buscaValor('COMPOSICAO_MAT', 'DESCRICAO', 'DESCRICAO', $('#txtDescricao').val())) {
                            throw msgAlerta('Descrição já existe para outra composição, verifique!')
                        }
                    }

                    composicaoClasse = {};

                    composicaoClasse.CODIGO = $('#txtCodigo').val()
                    composicaoClasse.CODIGO2 = $('#txtCodigo2').val()
                    composicaoClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    composicaoClasse.DESCRICAO2 = $('#txtDescricao2').val().toUpperCase();
                    composicaoClasse.DESCRICAO3 = $('#txtDescricao3').val().toUpperCase();

                    let response = await requisicao('POST', '/sisplan/cadastros/v1/composicaomaterial?', `JSON=${encodeURIComponent(JSON.stringify(composicaoClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/composicaomaterial`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});