$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#totalclientes",
        popover: {
          title: "Total de Clientes",
          description: "Aqui você poderá ver seu número total de clientes.",
          position: "right",
        },
      },
      {
        element: "#totalativos",
        popover: {
          title: "Clientes Ativos",
          description: "Aqui você poderá ver a quantidade de clientes ativos.",
          position: "right",
        },
      },
      {
        element: "#totalbloqueados",
        popover: {
          title: "Clientes Bloqueados",
          description:
            "Aqui você poderá ver a quantidade de clientes bloqueados.",
          position: "left",
        },
      },
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta dos clientes/fornecedores.",
          position: "right",
        },
      },
      {
        element: "#btn-novoClientes",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um cliente/fornecedor.",
          position: "right",
        },
      },
      {
        element: "#tabelaClientesForne",
        popover: {
          title: "Tabela Clientes/Fornecedores",
          description: "Aqui estão os dados dos clientes/fornecedores.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('#txtPercDesconto').on('keypress', function (event) {
    let regex = new RegExp("^[0-9]+$");
    let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
  });

  const arrSelecionados = []

  let ordenacaoAnterior = {
    indice: '',
    orientacao: 'asc'
  }

  const classificacoes = [
    { id: '0', text: 'Sem classificação' },
    { id: '    A', text: 'A' },
    { id: '    B', text: 'B' },
    { id: '    C', text: 'C' }, //VERIFICAR SE O MAIS CERTO NÃO SERIA PEGAR A 5 POSIÇÃO DO CAMPO NA TABELA
    { id: '    D', text: 'D' },
    { id: '    E', text: 'E' },
    { id: '    F', text: 'F' },
    { id: '    G', text: 'G' },
    { id: '    H', text: 'H' },
    { id: '    I', text: 'I' },
    { id: '    J', text: 'J' }
  ]

  $('#selectClassificacao').pesquisaVariosDadosEstaticos(0, classificacoes)

  $('#btnLimpaSelectClassificacao').on('click', function () {
    $('#selectClassificacao').off().removeData().select2('destroy')
    $('#selectClassificacao').pesquisaVariosDadosEstaticos(0, classificacoes)
  })

  const permissaoUsuarioLogado = await permissaoAcessos("ENTIDADE");
  const buscaRegiao = await CopiaParametro('VENDA', 77);

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btn-novoClientes").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cliente/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#txtRamoAtividadeSel').autocompleta(1, `JSON={ "tabela":"SITCLI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#btnRamoAtividadeSel").pesquisa("#txtRamoAtividadeSel", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITCLI", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Ramo de Atividade", "sitcli");

  $('#txtGrupoEntidadeSel').autocompleta(1, `JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#btnGrupoEntidadeSel").pesquisa("#txtGrupoEntidadeSel", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Grupo", "GRUPO_CLI");

  $('#txtPerfilSel').autocompleta(1, `JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnPerfilSel').pesquisa('#txtPerfilSel', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Perfil', 'PERFIL');

  $('#btnLimpaPerfilSel').on('click', function () {
    $('#txtPerfilSel').val('')
  })
  $('#btnLimpaRamoAtividadeSel').on('click', function () {
    $('#txtRamoAtividadeSel').val('')
  })
  $('#btnLimpaGrupoEntidadeSel').on('click', function () {
    $('#txtGrupoEntidadeSel').val('')
  })

  componenteFiltro('entidade', true)
  componenteFiltro("representante", true, false);
  componenteFiltro("grupoCli", true);
  componenteFiltro("situacao", true);
  componenteFiltro("historico", true);
  componenteFiltro("classe", true);
  componenteFiltro("perfil", true);
  componenteFiltro("ramoAtividade", true);
  componenteFiltro("regEstado", true);
  componenteFiltro("regFrete", true);
  componenteFiltro("tabPreco", true);
  componenteFiltro("transportadora", true);
  if (await apenasClientesVinculadosAoRepresentante()) {
    await bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentante', '#btnRepresentante', '#btnLimpaRepresentante');
  }

  if (buscaRegiao == '1') {
    await preencheRegiao('#txtRegEstado');
  }

  $("#tabelaClientes").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaClientes').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[1], data[2], 'ENTIDADE');
  });

  $("#tabelaClientes").on('click', "#btnMapa", async function () {
    const data = $('#tabelaClientes').DataTable().row($(this).parents('tr')).data();
    const codcli = data[1];
    await buscaEndereco(codcli);
  });

  async function buscaEndereco(codcli) {
    const url = "/Sisplan/Funcoes/v1/pesquisa?";
    try {
      const pesquisa = {
        tabela: 'ENTIDADE',
        camposSelect: ['ENTIDADE.CODCLI', 'ENTIDADE.ENDERECO', 'ENTIDADE.NUM_ENT', 'CIDADE.NOME', 'CIDADE.COD_UF'],
        leftJoin: [{ tabela: 'CADCEP', condicao: 'CADCEP.CEP = ENTIDADE.CEP' },
        { tabela: 'CIDADE', condicao: 'CIDADE.CODIGO = CADCEP.CODMUN' }],
        where: [`ENTIDADE.CODCLI = '${codcli}'`]
      }

      const response = await requisicao("GET", url, `JSON=${JSON.stringify(pesquisa)}`);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        return error;
      }
      jsonStr = await response.json();
      const endereco = jsonStr.RESULT[0][0].ENDERECO;
      const numero = jsonStr.RESULT[0][0].NUM_ENT;
      const cidade = jsonStr.RESULT[0][0].NOME;
      const estado = jsonStr.RESULT[0][0].COD_UF;

      window.open(
        `http://maps.google.com.br/maps?q=${endereco + ',' + numero},${cidade}-${estado}`,
        '_blank' // <- This is what makes it open in a new window.
      );

    } catch (error) {
      console.error(error);
    }
  }

  async function atualizaTotais() {
    let url = "/Sisplan/Funcoes/v1/pesquisa?";
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"entidade", 
                "camposSelect":["count(codcli) CODCLI", "count(CASE WHEN ATIVO = 'S' THEN 1 ELSE null end) ATIVO", "count(CASE WHEN bloqueio = 'S' THEN 1 ELSE NULL end) BLOQUEIO"], 
                "where": ["1=1"] }`
      );
      if (!response) {
        return;
      }
      if (response.status != 200) {
        return error;
      }
      jsonStr = await response.json();
      $("#txt_val_total").html(jsonStr.RESULT[0][0].CODCLI);
      $("#txt_val_ativos").html(jsonStr.RESULT[0][0].ATIVO);
      $("#txt_val_bloqueados").html(jsonStr.RESULT[0][0].BLOQUEIO);
    } catch (error) {
      console.error(error);
    }
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      `    <button class="dropdown-item" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout Cliente.FR3"' : 'title="Imprimir"'}id="btn-imprimir">Imprimir</button>     ` +
      '    <button class="dropdown-item"" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
      '    <button class="dropdown-item"" title="Mapa" id="btnMapa">Mapa</button>     ' +
      '</div>';
    return retorno;
  };

  await consultaClientes();
  atualizaTotais();

  $("#tabelaClientes").on("click", "#btn-imprimir", async function () {
    try {
      $.LoadingOverlay("show");

      let data = $("#tabelaClientes")
        .DataTable()
        .row($(this).parents("tr"))
        .data();
      let url = `/sisplan/impressao/v1/cliente?codcli=${data[1]}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('Cliente');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Cliente');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnConsultar").on("click", async function () {
    await consultaClientes();
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtDataDe").val("1200-01-01");
    $("#txtDataAniverDe").val("1200-01-01");
    $("#txtDataAte").val("2500-12-01");
    $("#txtDataAniverAte").val("2500-12-01");
    $("#txtAtivo").val("");
    $("#txtBloqueado").val("");
    $('#txtEntidade').empty().trigger('change');
    if (!$('#txtRepresentante').attr('disabled')) {
      $('#txtRepresentante').empty().trigger('change');
    }
    $('#txtGrupoCli').empty().trigger('change');
    $('#txtSituacao').empty().trigger('change');
    $('#txtHistorico').empty().trigger('change');
    $('#txtClasse').empty().trigger('change');
    $('#txtPerfil').empty().trigger('change');
    $('#txtRamoAtividade').empty().trigger('change');
    $('#txtRegEstado').empty().trigger('change');
    $('#txtRegFrete').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#txtTransportadora').empty().trigger('change');

  });

  async function retornaWhere() {
    const formataParams = async (txt, nomeColuna) => {
      const listaFiltro = await formataListas($(txt).val().toString());
      return listaFiltro === "" ? "" : nomeColuna === 'CLASSIFICA' ? `AND ${nomeColuna} IN (${listaFiltro == "'0'" ? "''" : listaFiltro})` : `AND ${nomeColuna} IN (${listaFiltro})`;
    };

    const formataDataParams = (dataDe, dataAte, colunaTabela) =>
      dataDe !== "1200-01-01" || dataAte !== "2500-12-31"
        ? ` and ${colunaTabela} >= '${dataDe}' and ${colunaTabela} <= '${dataAte}'`
        : '';


    const dataCadastro = formataDataParams(
      $("#txtDataDe").val(),
      $("#txtDataAte").val(),
      "DATA_CAD"
    );

    const dataAniver = formataDataParams(
      $("#txtDataAniverDe").val(),
      $("#txtDataAniverAte").val(),
      "DT_NASC"
    );

    let params = ''
    params += await formataParams("#txtEntidade", "CODCLI");
    params += await formataParams("#txtAtivo", "ATIVO");
    params += await formataParams("#txtBloqueado", "BLOQUEIO");
    params += await formataParams("#txtGrupoCli", "GRUPO");
    params += await formataParams("#txtRepresentante", "CODREP");
    params += await formataParams("#txtSituacao", "SIT_DUP");
    params += await formataParams("#txtHistorico", "HISTORICO");
    params += await formataParams("#txtClasse", "CLASSE");
    params += await formataParams("#txtPerfil", "PERFIL");
    params += await formataParams("#txtRamoAtividade", "SIT_CLI");
    params += await formataParams("#txtRegEstado", "REG_ESTADO");
    params += await formataParams("#txtRegFrete", "FRETE");
    params += await formataParams("#txtTabPreco", "TABELA");
    params += await formataParams("#txtTransportadora", "TRANSPORTE");
    params += await formataParams("#selectClassificacao", "CLASSIFICA");
    params += dataCadastro;
    params += dataAniver;
    // params = `["1=1 ${codcliente}, ${ativo}, ${bloqueado}, ${dataCadastro == "" ? "" : dataCadastro}, ${dataAniver == "" ? "" : dataAniver} "]`;

    return params
  }

  $('#btnLimparCamposSelecionados').on('click', function () {
    limpaCamposModal()
  })

  async function consultaClientes(ordenacao = { indice: '', orientacao: '' }) {
    try {
      // let response;
      $.LoadingOverlay("show");

      ordenacaoAnterior = ordenacao

      const params = await retornaWhere()
      const { indice, orientacao } = ordenacao;
      const orderby = indice !== '' ? `${(parseInt(indice) || 0) + 1} ${orientacao}` : '';
      const tipoBanco = await retornaDatabase();
      const objTipoBanco = {
        'FIREBIRD': `((CODCLI IS NOT NULL) AND (CODCLI <> ''))`,
        'ORACLE': `((CODCLI IS NOT NULL) OR (CODCLI <> ''))`,
        'POSTGRES': `((CODCLI IS NOT NULL) AND (CODCLI <> ''))`,
        'SQLSERVER': `((CODCLI IS NOT NULL) AND (CODCLI <> ''))`
      };
      const whereInicial = objTipoBanco[tipoBanco];
      const objPesquisa = {
        "tabela": "entidade",
        "camposSelect": ["'' SEL", "CODCLI", "NOME", "FANTASIA", "CNPJ", "ATIVO"],
        "camposWhereServerSide": ["CODCLI", "NOME", "FANTASIA", "CNPJ", "ATIVO"],
        "where": [`${`${whereInicial} ${params}`}`],
        // "orderBy": ['CODCLI ASC']
        "orderBy": [orderby == '' ? 'CODCLI ASC' : orderby]
      };

      $("#tabelaClientes").DataTable({
        destroy: true,
        lengthChange: true,
        serverSide: true,
        processing: true,
        sortable: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: JSON.stringify(objPesquisa),
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (_data, _type, _row, meta) {
              return `<div class="icheck-primary d-inline">
                      <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="checkSel">
                      <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`;
            },
          },
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
        ],
      });

      $('#tabelaClientes').on('click', '.checkSel', function () {
        const table = $('#tabelaClientes').DataTable();
        const dados = table.row($(this).closest('tr')).data();

        if ($(this).is(':checked')) {
          if (!arrSelecionados.some(item => item.codcli === dados[1])) {
            arrSelecionados.push({ codcli: dados[1] });
          }
        } else {
          const index = arrSelecionados.findIndex(item => item.codcli === dados[1]);
          if (index !== -1) {
            arrSelecionados.splice(index, 1);
          }
        }
      });

      $('#tabelaClientes').on('draw.dt', function () {
        const table = $('#tabelaClientes').DataTable();
        const dados = table.rows().data();

        dados.each((item, index) => {
          const selecionado = arrSelecionados.find((data) => item[1] === data.codcli);

          if (selecionado) {
            const row = table.row(index).node();
            $(row).find('input[type="checkbox"]').prop('checked', true);
          }
        });
      });

      $('#tabelaClientes th').off()
      $('#tabelaClientes th').on('click', async function () {
        const arrayColunas = ['SEL', 'Cliente', 'Nome', 'Fantasia', 'CPF/CNPJ', 'Ativo']
        const nomeColuna = $(this).html().trim()
        const index = arrayColunas.indexOf(nomeColuna)
        let orientacao
        if (String(index) === ordenacaoAnterior.indice) {
          orientacao = ordenacaoAnterior.orientacao === 'asc' ? 'desc' : 'asc'
        } else {
          orientacao = 'asc'
        }

        await consultaClientes({ indice: String(index), orientacao: orientacao })
      })

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível buscar os dados do cliente: ${error}`);
    }
  }

  $('#btnAlterarSelecionados').on('click', function () {
    if (arrSelecionados.length === 0) {
      return msgAlerta('Nenhum registro selecionado, impossível alterar.')
    }
    $('#modalAlterarSelecionados').modal('show')
  })

  function retornaClassificacao() {
    let tamanhoVazio = ''
    while ($('#txtClassificacao').val().length < 4) {
      tamanhoVazio += ' ';
      $('#txtClassificacao').val(tamanhoVazio);
    }
    let classificacaoAtual = $('#rgClassificacao').val() != null ? $('#rgClassificacao').val() == '0' ? '0' : $('#txtClassificacao').val() + $('#rgClassificacao').val() : '';
    if (classificacaoAtual == '    ') {
      classificacaoAtual = ''
    }

    $('#txtClassifica').val(classificacaoAtual);

    return classificacaoAtual
  }

  function limpaCamposModal() {
    $('#txtRamoAtividadeSel').val('')
    $('#txtGrupoEntidadeSel').val('')
    $('#rgClassificacao').val(null)
    $('#txtPercDesconto').val(0)
    $('#txtPerfilSel').val('')
  }

  function buscaCamposAlteracao() {
    return {
      ramoAtividade: pegaChave('#txtRamoAtividadeSel'),
      grupoEntidade: pegaChave('#txtGrupoEntidadeSel'),
      classificacao: retornaClassificacao(),
      percDesconto: $('#txtPercDesconto').val(),
      perfil: pegaChave('#txtPerfilSel'),
    }
  }

  $('#btnConfirmarSelecionados').on('click', async function () {
    try {
      $.LoadingOverlay("show")
      const body = {
        data: arrSelecionados,
        fields: buscaCamposAlteracao()
      }

      const response = await requisicao("POST", "/Sisplan/Cliente/V1/alteraselecionados?", '', JSON.stringify(body));

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr
        .success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#selecionaTodos').prop('checked', false)
            arrSelecionados.splice(0)
            $('#btnConsultar').trigger('click')
            $('#modalAlterarSelecionados').modal('hide')
            limpaCamposModal()
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide")
    }
  })

  $('#selecionaTodos').on('click', async function () {
    const url = "/Sisplan/Funcoes/v1/pesquisa?";
    try {
      if ($(this).is(':checked')) {
        const where = await retornaWhere()

        const pesquisa = {
          "tabela": 'ENTIDADE',
          "camposSelect": ['CODCLI'],
          "where": [`1=1 ${where}`]
        }

        const response = await requisicao("GET", url, `JSON=${JSON.stringify(pesquisa)}`);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          return
        }

        const jsonStr = await response.json();

        jsonStr.RESULT[0].map((item) => {
          arrSelecionados.push({ codcli: item.CODCLI })
        })


        const table = $('#tabelaClientes').DataTable();
        const dados = table.rows().data();

        dados.each((item, index) => {
          const selecionado = arrSelecionados.find((data) => item[1] === data.codcli);

          if (selecionado) {
            const row = table.row(index).node();
            $(row).find('input[type="checkbox"]').prop('checked', true);
          }
        });
      } else {
        const table = $('#tabelaClientes').DataTable();
        const dados = table.rows().data();

        dados.each((item, index) => {
          const selecionado = arrSelecionados.find((data) => item[1] === data.codcli);

          if (selecionado) {
            const row = table.row(index).node();
            $(row).find('input[type="checkbox"]').prop('checked', false);
          }
        });
        arrSelecionados.splice(0)
      }

    } catch (error) {
      console.error(error);
    }
  })

  $("#tabelaClientes").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClientes")
        .DataTable()
        .row($(this).parents("tr"))
        .data();
      let clienteLiberado = await liberarRegistro("ENTIDADE", data[1]);
      if (clienteLiberado) {
        window.location.href = `cliente/${data[1]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaClientes").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClientes").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("ENTIDADE", data[1]);
      if (clienteLiberado) {
        window.location.href = `cliente/${data[1]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // $("input[type='search']").on("keydown", function () {
  //   if (window.event.which === 13) {
  //     $("#btn-editar").trigger("click");
  //   }
  // });

  $("#tabelaClientes").on("click", "#btnExcluir", async function () {
    $.LoadingOverlay("show");
    try {
      if (permissaoUsuarioLogado.EXCLUI == "S") {
        const data = $("#tabelaClientes").DataTable().row($(this).parents("tr")).data();
        await deletaEntidade(data[1]);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  async function deletaEntidade(codcli) {
    try {
      const response = await requisicao("DELETE", "/Sisplan/Cliente/V1/Entidade?", `CODCLI=${codcli}`);

      if (!response) {
        throw msgAlerta("Não foi possível deletar a entidade, tente novamente.");
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        throw msgAlerta(jsonStr.mensagem);
      } else {
        criaMensagemSucesso(`Entidade ${codcli} deletada com sucesso.`, () => { window.location.reload() });
      }

    } catch (error) {
      console.log(error);
    }
  }

});
