$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos bloqueados não podem ser alterados.",
          position: "top",
        },
      },
      {
        element: "#codigoTutorial",
        popover: {
          title: "Código",
          description: "O código é preenchido automaticamente após a gravação.",
          position: "top",
        },
      },
      {
        element: "#descricaoTutorial",
        popover: {
          title: "Descrição",
          description: "Adicione aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#idTutorial",
        popover: {
          title: "ID",
          description: "Adicione aqui um ID para esse cadastro, ou deixe vazio para preencher automaticamente.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o regristro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtDescricao: {
        required: "Insira uma descrição.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro('CENTROCUSTOVALOR', getCookie('usuario'), ccusto);
    window.location.href = `${BASE_URI}/centrocustovalor`;
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let ccusto = parametros[parametros.length - 1];

  if (ccusto != '' && ccusto != 'create') {
    await fazConsulta();
  };

  async function fazConsulta() {
    try {
      $.LoadingOverlay("show");
      let response;
      let codigo = ccusto;

      response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?',
        `JSON=
        {
          "tabela":"CONT_RATEIO", 
          "camposSelect":["CONT_RATEIO.*", "CONTA_CONT.DESCRICAO", "CONTA_CONT.CONTA"], 
          "leftJoin":[
            {
              "tabela": "CONTA_CONT", "condicao": "CONT_RATEIO.CONTA = CONTA_CONT.CODIGO"
            }
          ],
          "where": ["CONT_RATEIO.CCUSTO = '${codigo}'"]}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaValores").DataTable({
        destroy: true,
        filter: false,
        lengthChange: false,
        order: false,
        ordering: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            title: "Código Conta",
            data: "CONTA",
          },
          {
            title: "Conta Contábil",
            data: "CONTA_1",
          },
          {
            title: "Descrição da Conta",
            data: "DESCRICAO",
          },
          {
            title: "Valor",
            data: "VALOR",
          },

        ],
        columnDefs: [
          {
            targets: [3],
            render: function (data, v2, v3, index) {
              return carregaInput(v3, index);
            }
          }
        ],
        drawCallback: function () {
          for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
            $('#txtPreco_' + i).maskMoney({
              decimal: '.',
              thousands: '',
              precision: 2
            });
          }
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  function carregaInput(registro, e) {
    const tipoCC = registro.TIPO === 'CC';
    const atributoDisabled = tipoCC ? '' : 'disabled';

    if (registro.VALOR === null || registro.VALOR === undefined) {
      registro.VALOR = "";
    }

    return `<input style="width: 100px;" type="text" id="txtPreco_${e.row}"
              class="input-preco inputedit input-default focus form-control text-right"
              value="${registro.VALOR}" ${atributoDisabled}>`;
  }


  $('#btnGravar').click(async function () {
    let listaValores = {};
    try {
      $.LoadingOverlay("show");

      const tabelaValores = $("#tabelaValores").DataTable();
      listaValores = tabelaValores.rows().data().toArray().map((row, e) => {
        if (row.TIPO === 'CC') {
          const ccusto = row.CCUSTO;
          const codigo = row.CODIGO;
          const conta = row.CONTA;
          const conta_1 = row.CONTA_1;
          const valor = parseFloat($(`#txtPreco_${e}`).val());
          const tipo = row.TIPO;
          const tipo_val = row.TIPO_VAL;
          const perc_ccusto = row.PERC_CCUSTO;
          const perc_conta = row.PERC_CONTA;

          return {
            CCUSTO: ccusto,
            CONTA: conta,
            CONTA_1: conta_1,
            VALOR: valor,
            CODIGO: codigo,
            TIPO: tipo,
            TIPO_VAL: tipo_val,
            PERC_CCUSTO: perc_ccusto,
            PERC_CONTA: perc_conta,
          };
        }
        return null;
      }).filter(Boolean);

      let CentroCustoValor = { listaValores };

      let response = await requisicao(
        "POST",
        "/Sisplan/Cadastros/v1/centrocustovalor?",
        `JSON=${encodeURIComponent(JSON.stringify(CentroCustoValor))}`,
        null
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };
      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/centrocustovalor` })
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados: ${error}`);
    }
  })


})

